/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences;

import java.util.Map;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.preferences.PreferenceConstantValues;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public final void initializeDefaultPreferences() {
        String licenseFile;
        final IPreferenceStore preferenceStore = this.getPreference();
        String ttcn3Dir = System.getenv("TTCN3_DIR");
        if (ttcn3Dir != null) {
            preferenceStore.setDefault("org.eclipse.titan.designer.TTCN3_INSTALL_DIR", ttcn3Dir);
        }
        if ((licenseFile = System.getenv("TTCN3_LICENSE_FILE")) != null) {
            preferenceStore.setDefault("org.eclipse.titan.designer.LICENSE_FILE", licenseFile);
        }
        preferenceStore.setDefault("org.eclipse.titan.designer.compilerMarkersAfterAnalyzation", "Become outdated");
        preferenceStore.setDefault("org.eclipse.titan.designer.ontheflyMarkersAfterCompiler", "Stay");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportProgramErrorWithMarker", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.treatOnTheFlyErrorsasFatalForBuild", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.checkForLowMemory", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.useOnTheFlyParsing", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.useIncrementalParsing", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.delaySemantiCheckingTillSave", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.reconcilerTimeout", 1);
        preferenceStore.setDefault("org.eclipse.titan.designer.enableRealtimeExtension", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.enableOOPExtension", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.enableDocumentCommentOnTheFlyCheck", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.processingUnitsToUse", PreferenceConstantValues.AVAILABLEPROCESSORS);
        preferenceStore.setDefault("org.eclipse.titan.designer.limitAllThreadCreation", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.consoleActionBeforeBuild", "Print delimiter");
        preferenceStore.setDefault("org.eclipse.titan.designer.singleProposalInsertion", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.commonPrefixInsertion", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.proposalSorting", "by relevance");
        preferenceStore.setDefault("org.eclipse.titan.designer.proposalListSize", 0);
        preferenceStore.setDefault("org.eclipse.titan.designer.autoActivation", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.autoActivationDelay", 100);
        preferenceStore.setDefault("org.eclipse.titan.designer.hoverWindowContent", HoverContentType.getDefault().toString());
        preferenceStore.setDefault("org.eclipse.titan.designer.enableHoverWindowPopups", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.excludeWorkingDirectoryContents", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.excludeDotResources", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.excludeLinkedContents", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.saveDefaultValues", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.packAllProjectsIntoOne", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.useTpdName", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.origTpdURI", "");
        preferenceStore.setDefault("org.eclipse.titan.designer.automaticExport", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.requestLocation", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.foldingEnabledPreference", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.foldComments", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.foldStatementBlocks", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.foldParenthesis", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.distance", 3);
        preferenceStore.setDefault("org.eclipse.titan.designer.matchingBracketEnabled", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.indentation.indentationTabPolicy", "Spaces");
        preferenceStore.setDefault("org.eclipse.titan.designer.indentation.indentationSize", "2");
        preferenceStore.setDefault("org.eclipse.titan.designer.typing.close_apostrophe", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.typing.close_parantheses", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.typing.close_square", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.typing.close_braces", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.typing.automatically_move_on_new_line_braces", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.typing.automatically_insert_star", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.color.matchingBracket", StringConverter.asString((RGB)PreferenceConstantValues.GREY20));
        preferenceStore.setDefault("org.eclipse.titan.designer.excludedResources", "");
        preferenceStore.setDefault("org.eclipse.titan.designer.enableSemanticHighlighting", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.color.ast_constant.enabled", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.color.ast_deftype.enabled", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.color.ast_deprecated.enabled", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.color.ast_unused.enabled", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.color.ast_variable.enabled", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.enableBreadcrumb", false);
        preferenceStore.setDefault(".enableCodeMinings", false);
        this.markOccurrences(preferenceStore);
        this.onTheFlyChecker(preferenceStore);
        this.titanActions(preferenceStore);
        this.outline(preferenceStore);
        this.namingConventionPreferences(preferenceStore);
        this.color(preferenceStore);
        this.debug(preferenceStore);
        this.findDefinition(preferenceStore);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.css.swt.theme");
        prefs.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                Map colorMap = PreferenceInitializer.this.getColorMap();
                for (Map.Entry entry : colorMap.entrySet()) {
                    if (entry.getValue() instanceof RGB) {
                        preferenceStore.setDefault((String)entry.getKey(), StringConverter.asString((RGB)((RGB)entry.getValue())));
                        preferenceStore.setValue((String)entry.getKey(), StringConverter.asString((RGB)((RGB)entry.getValue())));
                        continue;
                    }
                    if (!(entry.getValue() instanceof Boolean)) continue;
                    preferenceStore.setDefault((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                    preferenceStore.setValue((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                }
            }
        });
    }

    private void markOccurrences(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("org.eclipse.titan.designer.markOccurrencesEnabled", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.markOccurrencesDelay", 300);
        preferenceStore.setDefault("org.eclipse.titan.designer.markOccurrencesKeepMarks", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.markOccurrencesAsn1Assignments", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.markOccurrencesTtcn3Assignments", true);
    }

    private void onTheFlyChecker(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("org.eclipse.titan.designer.reportUnsupportedConstructs", "warning");
        preferenceStore.setDefault("org.eclipse.titan.designer.defaultAsOptional", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.reportIgnoredPreprocessorDirectives", "warning");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportTypeCompatibility", "warning");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportErrorsInExtensionSyntax", "warning");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportStrictConstants", "warning");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportDocCommentInconsistency", "warning");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportModuleNameReuse", "error");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportDuplicatedUniqueFieldValue", "ignore");
    }

    private void titanActions(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("org.eclipse.titan.designer.TITANActions.processExcludedResources", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.TITANActions.default_as_omit", false);
    }

    private void outline(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("org.eclipse.titan.designer.outline.sortAlphabetically", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.outline.useCategories", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.outline.useGroups", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.outline.hideFunctions", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.outline.hideTemplates", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.outline.hideTypes", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.enableOutlineSemanticHighlighting", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.enableOutlineHoverTooltip", true);
    }

    private void namingConventionPreferences(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionProblems", "ignore");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionTTCN3Module", ".*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionASN1Module", ".*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionAltstep", "as_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionGlobalConstant", "cg_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionExternalConstant", "ec_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionFunction", "f_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionExternalFunction", "ef_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionModuleParameter", "tsp.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionGlobalPort", ".*_PT");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionGlobalTemplate", "t.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionTestcase", "tc_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionGlobalTimer", "T.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionType", ".*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionGroup", "[A-Z].*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionLocalConstant", "cl.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionLocalVariable", "vl.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionlocalTemplate", "t.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionLocalVariableTemplate", "vt.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionLocalTimer", "TL_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionFormalParameter", "pl_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionComponentConstant", "c_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionComponentVariable", "v_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportNamingConventionComponentTimer", "T_.*");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportModuleNameInDefinition", "ignore");
        preferenceStore.setDefault("org.eclipse.titan.designer.reportVisibilityInDefinition", "ignore");
    }

    private void color(IPreferenceStore preferenceStore) {
        String markColor;
        Map<String, Object> colorMap = this.getColorMap();
        for (Map.Entry<String, Object> entry : colorMap.entrySet()) {
            if (entry.getValue() instanceof RGB) {
                preferenceStore.setDefault(entry.getKey(), StringConverter.asString((RGB)((RGB)entry.getValue())));
                continue;
            }
            if (!(entry.getValue() instanceof Boolean)) continue;
            preferenceStore.setDefault(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors");
        switch (ColorManager.getColorTheme()) {
            case Dark: {
                markColor = StringConverter.asString((RGB)PreferenceConstantValues.MARK_OCCURRENCE_COLOR_DARK);
                break;
            }
            default: {
                markColor = StringConverter.asString((RGB)PreferenceConstantValues.MARK_OCCURRENCE_COLOR);
            }
        }
        preferences.put("occurrenceMarkColor", markColor);
    }

    private void debug(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("org.eclipse.titan.designer.displayDebugInformation", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.debug.preferencePage.enabled", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.debug.console.timestamp", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.debug.console.astelem", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.debug.console.parsetree", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.debug.console.logtosysout", false);
        preferenceStore.setDefault("org.eclipse.titan.designer.debug.load.tokensToProcessInARow", 100);
        preferenceStore.setDefault("org.eclipse.titan.designer.debug.load.sleepBetweenFiles", 10);
        preferenceStore.setDefault("org.eclipse.titan.designer.debug.load.yieldBetweenChecks", true);
    }

    private void findDefinition(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("org.eclipse.titan.designer.finddef.ws", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.finddef.function", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.finddef.global", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.finddef.modules", true);
        preferenceStore.setDefault("org.eclipse.titan.designer.finddef.types", true);
    }

    public IPreferenceStore getPreference() {
        return Activator.getDefault().getPreferenceStore();
    }

    private Map<String, Object> getColorMap() {
        switch (ColorManager.getColorTheme()) {
            case Dark: {
                return PreferenceConstantValues.DarkColorMap;
            }
        }
        return PreferenceConstantValues.DefaultColorMap;
    }
}

