/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcnppeditor.actions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.actions.AbstractIndentAction;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.ui.IEditorPart;

public final class IndentAction
extends AbstractIndentAction {
    @Override
    protected IDocument getDocument() {
        IEditorPart editorPart = this.getTargetEditor();
        if (editorPart instanceof TTCNPPEditor) {
            return ((TTCNPPEditor)editorPart).getDocument();
        }
        return null;
    }

    @Override
    protected int lineIndentationLevel(IDocument document, int realStartOffset, int lineEndOffset, Interval startEnclosingInterval) throws BadLocationException {
        if (realStartOffset + 1 == lineEndOffset) {
            return 0;
        }
        if (Interval.interval_type.MULTILINE_COMMENT.equals((Object)startEnclosingInterval.getType()) || startEnclosingInterval.getStartOffset() == realStartOffset || Interval.interval_type.SINGLELINE_COMMENT.equals((Object)startEnclosingInterval.getType())) {
            return Math.max(0, startEnclosingInterval.getDepth() - 2);
        }
        if (startEnclosingInterval.getEndOffset() < lineEndOffset && !this.containsNonWhiteSpace(document.get(realStartOffset, Math.max(startEnclosingInterval.getEndOffset() - realStartOffset - 1, 0)))) {
            return Math.max(0, startEnclosingInterval.getDepth() - 2);
        }
        return Math.max(0, startEnclosingInterval.getDepth() - 1);
    }

    @Override
    protected void performEdits(RewriteSessionEditProcessor processor) throws BadLocationException {
        MonoReconciler reconciler = ((TTCNPPEditor)this.getTargetEditor()).getReconciler();
        reconciler.setIsIncrementalReconciler(false);
        processor.performEdits();
        IPreferencesService prefs = Platform.getPreferencesService();
        reconciler.setIsIncrementalReconciler(prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useIncrementalParsing", false, null));
    }

    @Override
    protected ISelection getSelection() {
        IEditorPart editorPart = this.getTargetEditor();
        if (editorPart == null || !(editorPart instanceof TTCNPPEditor)) {
            return null;
        }
        return ((TTCNPPEditor)editorPart).getSelectionProvider().getSelection();
    }
}

