/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.testportpar;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.titan.common.parsers.cfg.indices.TestportParameterSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParameterTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParametersSectionPage;

public final class TestportParameterSectionDragSourceListener
implements DragSourceListener {
    private final TableViewer viewer;
    private final TestportParametersSectionPage testportParSubPage;

    public TestportParameterSectionDragSourceListener(TestportParametersSectionPage testportParSubPage, TableViewer viewer) {
        this.testportParSubPage = testportParSubPage;
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            this.viewer.getTable().setRedraw(false);
            if (event.detail == 2) {
                this.testportParSubPage.removeSelectedParameters();
            }
            this.viewer.getTable().setRedraw(true);
            this.viewer.refresh();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (TestportParameterTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            ArrayList<TestportParameterSectionHandler.TestportParameter> items = new ArrayList<TestportParameterSectionHandler.TestportParameter>();
            if (!selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof TestportParameterSectionHandler.TestportParameter)) continue;
                    items.add((TestportParameterSectionHandler.TestportParameter)element);
                }
                event.data = items.toArray(new TestportParameterSectionHandler.TestportParameter[items.size()]);
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof TestportParameterSectionHandler.TestportParameter;
    }
}

