/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.editors.CompletionProposal;
import org.eclipse.titan.designer.editors.TITANTemplateContext;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public final class ProposalCollector {
    private ProjectSourceParser projectSourceParser;
    private String contextId;
    private Identifier.Identifier_type targetIdentifierType;
    private TemplateContext templatecontext;
    private final Reference reference;
    private final String lastPrefix;
    private int replacementOffset;
    private List<ICompletionProposal> proposalList;
    private int lastMarkedPosition = 0;

    public ProposalCollector(Identifier.Identifier_type targetIdentifierType, IDocument doc, int offset) {
        this.proposalList = new ArrayList<ICompletionProposal>();
        this.reference = null;
        this.lastPrefix = null;
        this.targetIdentifierType = targetIdentifierType;
        this.replacementOffset = offset;
    }

    public ProposalCollector(TemplateContextType contextType, Identifier.Identifier_type targetIdentifierType, IDocument doc, String prefix, int offset) {
        this.proposalList = new ArrayList<ICompletionProposal>();
        this.reference = null;
        this.lastPrefix = prefix;
        this.targetIdentifierType = targetIdentifierType;
        this.replacementOffset = offset;
        this.templatecontext = new TITANTemplateContext(contextType, doc, this.replacementOffset, 0);
        this.contextId = contextType.getId();
    }

    public ProposalCollector(Identifier.Identifier_type targetIdentifierType, IDocument doc, Reference ref, int offset) {
        this(targetIdentifierType, null, null, null, doc, ref, offset);
    }

    public ProposalCollector(Identifier.Identifier_type targetIdentifierType, String contextId, TemplateContextType contextType, IDocument doc, Reference ref, int offset) {
        this(targetIdentifierType, null, contextId, contextType, doc, ref, offset);
    }

    public ProposalCollector(Identifier.Identifier_type targetIdentifierType, ProjectSourceParser projectSourceParser, String contextId, TemplateContextType contextType, IDocument doc, Reference ref, int offset) {
        this.targetIdentifierType = targetIdentifierType;
        this.projectSourceParser = projectSourceParser;
        this.contextId = contextId;
        this.reference = ref;
        List<ISubReference> subreferences = ref.getSubreferences();
        if (!subreferences.isEmpty()) {
            this.replacementOffset = offset + ref.getLocation().getEndOffset();
            Location location = subreferences.get(subreferences.size() - 1).getLocation();
            this.replacementOffset -= location.getEndOffset() - location.getOffset();
            this.lastPrefix = subreferences.get(subreferences.size() - 1).getId().getDisplayName().toLowerCase(Locale.ENGLISH);
        } else {
            this.replacementOffset = offset;
            this.lastPrefix = this.reference.getModuleIdentifier().getDisplayName().toLowerCase(Locale.ENGLISH);
        }
        this.templatecontext = new TITANTemplateContext(contextType, doc, this.replacementOffset, 0);
        this.proposalList = new ArrayList<ICompletionProposal>();
    }

    public void setProjectParser(ProjectSourceParser projectSourceParser) {
        this.projectSourceParser = projectSourceParser;
    }

    public ProjectSourceParser getProjectParser() {
        return this.projectSourceParser;
    }

    public String getContextIdentifier() {
        return this.contextId;
    }

    public ICompletionProposal[] getCompletitions() {
        return this.proposalList.toArray(new ICompletionProposal[this.proposalList.size()]);
    }

    public ICompletionProposal[] getCompletitions(int limit) {
        int size = this.proposalList.size();
        if (limit > 0 && limit < size) {
            return this.proposalList.subList(0, limit).toArray(new ICompletionProposal[limit]);
        }
        return this.proposalList.toArray(new ICompletionProposal[size]);
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void markPosition() {
        this.lastMarkedPosition = this.proposalList.size();
    }

    public void sortTillMarked() {
        if (this.lastMarkedPosition < this.proposalList.size() - 1) {
            List<ICompletionProposal> orderable = this.proposalList.subList(this.lastMarkedPosition, this.proposalList.size() - 1);
            Collections.sort(orderable, new ProposalComperator());
        }
    }

    public void sortAll() {
        Collections.sort(this.proposalList, new ProposalComperator());
    }

    public void addProposal(CompletionProposal proposal) {
        this.proposalList.add(proposal);
    }

    private int prefixLength(String string) {
        if (string == null) {
            return -1;
        }
        if (this.reference == null) {
            return 0;
        }
        List<ISubReference> subreferences = this.reference.getSubreferences();
        if (subreferences.isEmpty()) {
            if (this.reference.getModuleIdentifier() != null && string.toLowerCase(Locale.ENGLISH).startsWith(this.lastPrefix)) {
                return this.lastPrefix.length();
            }
            return 0;
        }
        if (string.toLowerCase(Locale.ENGLISH).startsWith(this.lastPrefix)) {
            return this.lastPrefix.length();
        }
        return -1;
    }

    public void addProposal(String candidate, String visibleString, Image image) {
        this.addProposal(candidate, visibleString, image, "");
    }

    public void addProposal(String candidate, String visibleString, Image image, String info) {
        int prefixLength = this.prefixLength(candidate);
        if (prefixLength != -1) {
            CompletionProposal proposal = new CompletionProposal(candidate, this.replacementOffset, prefixLength, candidate.length(), image, visibleString, null, info);
            this.proposalList.add(proposal);
        }
    }

    public void addProposal(Identifier identifier, Image image, String info) {
        this.addProposal(identifier, "", image, info);
    }

    public void addProposal(Identifier identifier, Image image, Ttcn3HoverContent info) {
        this.addProposal(identifier, "", image, info, 0);
    }

    public void addProposal(Identifier identifier, String postfix, Image image, String info) {
        this.addProposal(identifier, postfix, image, new Ttcn3HoverContent(info), 0);
    }

    public void addProposal(Identifier identifier, String postfix, Image image, Ttcn3HoverContent info, int relevance) {
        int prefixLength;
        String candidate;
        if (identifier == null) {
            return;
        }
        if (this.targetIdentifierType != null) {
            switch (this.targetIdentifierType) {
                case ID_ASN: {
                    candidate = identifier.getAsnName();
                    break;
                }
                case ID_NAME: {
                    candidate = identifier.getName();
                    break;
                }
                default: {
                    candidate = identifier.getTtcnName();
                    break;
                }
            }
        } else {
            candidate = identifier.getDisplayName();
        }
        int n = prefixLength = this.reference != null ? this.prefixLength(candidate) : 0;
        if (prefixLength != -1) {
            CompletionProposal proposal = new CompletionProposal(candidate, this.replacementOffset, prefixLength, candidate.length(), image, new StyledString(candidate + postfix), null, info, relevance);
            this.proposalList.add(proposal);
        }
    }

    public void addProposal(String[] candidates, Image image, String info) {
        for (String element : candidates) {
            int prefixLength = this.prefixLength(element);
            if (prefixLength == -1) continue;
            CompletionProposal proposal = new CompletionProposal(element, this.replacementOffset, prefixLength, element.length(), image, element, null, info);
            this.proposalList.add(proposal);
        }
    }

    public void addProposal(String prefixString, String replacementString, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        int prefixLength = this.prefixLength(prefixString);
        if (prefixLength != -1) {
            CompletionProposal proposal = new CompletionProposal(replacementString, this.replacementOffset, prefixLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            this.proposalList.add(proposal);
        }
    }

    public void addTemplateProposal(String prefixString, Template candidate, Image image) {
        int prefixLength = this.prefixLength(prefixString);
        if (prefixLength != -1) {
            Region region = new Region(this.replacementOffset, this.lastPrefix.length());
            this.proposalList.add((ICompletionProposal)new TemplateProposal(candidate, this.templatecontext, (IRegion)region, image));
        }
    }

    public static final class ProposalComperator
    implements Comparator<ICompletionProposal>,
    ICompletionProposalSorter {
        private boolean fOrderAlphabetically = false;

        public void setOrderAlphabetically(boolean orderAlphabetically) {
            this.fOrderAlphabetically = orderAlphabetically;
        }

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            if (!this.fOrderAlphabetically) {
                int r1 = this.getRelevance(o1);
                int r2 = this.getRelevance(o2);
                int relevanceDif = r2 - r1;
                if (relevanceDif != 0) {
                    return relevanceDif;
                }
            }
            String s1 = o1.getDisplayString();
            String s2 = o2.getDisplayString();
            return s1.compareToIgnoreCase(s2);
        }

        private int getRelevance(ICompletionProposal obj) {
            if (obj instanceof CompletionProposal) {
                CompletionProposal cp = (CompletionProposal)obj;
                return cp.getRelevance();
            }
            if (obj instanceof TemplateProposal) {
                TemplateProposal tp = (TemplateProposal)obj;
                return tp.getRelevance();
            }
            return 0;
        }
    }
}

