/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.controls.MarkerHoverContent;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverInfoControl;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public final class AnnotationHover
implements IAnnotationHover,
IAnnotationHoverExtension {
    @Deprecated
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return null;
    }

    protected List<IMarker> getMarkerForLine(ISourceViewer sourceViewer, int lineNumber) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        if (annotationModel == null) {
            return markers;
        }
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof MarkerAnnotation)) continue;
            MarkerAnnotation actuaMarkerl = (MarkerAnnotation)o;
            try {
                int actualLine = sourceViewer.getDocument().getLineOfOffset(annotationModel.getPosition((Annotation)actuaMarkerl).getOffset());
                if (actualLine != lineNumber) continue;
                markers.add(actuaMarkerl.getMarker());
            }
            catch (BadLocationException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        return markers;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new Ttcn3HoverInfoControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public boolean canHandleMouseCursor() {
        return false;
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleNumberOfLines) {
        List<IMarker> markers = this.getMarkerForLine(sourceViewer, lineRange.getStartLine());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < markers.size(); ++i) {
            String message = markers.get(i).getAttribute("message", (String)null);
            if (message == null || (message = message.trim()).length() <= 0) continue;
            builder.append(message);
        }
        return new MarkerHoverContent(builder.toString(), null);
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        return new LineRange(lineNumber, 1);
    }
}

