/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.finddefinition.DefinitionListSelectionDialog;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class FindDefinitionAction
extends AbstractHandler
implements IEditorActionDelegate {
    private IEditorPart targetEditor = null;
    private ISelection selection = TextSelection.emptySelection();

    public void run(IAction action) {
        this.doFindDefinition();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.doFindDefinition();
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    private void doFindDefinition() {
        DefinitionListSelectionDialog dialog = new DefinitionListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new DefinitionLabelProvider(), this.getCurrentProject());
        dialog.setTitle("Find Definition");
        dialog.setMessage("Type the name of a definition");
        dialog.setHelpAvailable(false);
        if (this.targetEditor instanceof TTCN3Editor) {
            this.selection = ((TTCN3Editor)this.targetEditor).getSelectionProvider().getSelection();
        }
        if (this.selection instanceof TextSelection && !this.selection.isEmpty()) {
            IPreferencesService prefs = Platform.getPreferencesService();
            boolean reportDebugInformation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
            if (reportDebugInformation) {
                TITANDebugConsole.println("text selected: " + ((TextSelection)this.selection).getText());
            }
            TextSelection tSelection = (TextSelection)this.selection;
            dialog.setFilter(tSelection.getText());
        }
        dialog.init();
        if (dialog.open() == 1 || dialog.getFirstResult() == null) {
            return;
        }
        Object result = dialog.getFirstResult();
        if (!(result instanceof ILocateableNode)) {
            return;
        }
        this.showInEditor((ILocateableNode)result);
    }

    private IProject getCurrentProject() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)activePart;
            IResource resource = (IResource)editorPart.getEditorInput().getAdapter(IResource.class);
            return resource.getProject();
        }
        return null;
    }

    private void showInEditor(ILocateableNode node) {
        Location location = node.getLocation();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(location.getFile().getName());
        if (desc == null) {
            TITANDebugConsole.println("Cannot find the editor");
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IEditorPart editorPart = activePage.openEditor((IEditorInput)new FileEditorInput((IFile)location.getFile()), desc.getId());
            if (editorPart != null && editorPart instanceof AbstractTextEditor) {
                ((AbstractTextEditor)editorPart).selectAndReveal(location.getOffset(), location.getEndOffset() - location.getOffset());
            }
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while opening the editor", (Throwable)e);
        }
    }

    private static class DefinitionLabelProvider
    extends LabelProvider {
        private DefinitionLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IOutlineElement) {
                String text = ((IOutlineElement)element).getOutlineText();
                if (text == null || text.isEmpty()) {
                    return ((IOutlineElement)element).getIdentifier().getDisplayName();
                }
                return text;
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof IOutlineElement) {
                String icon = ((IOutlineElement)element).getOutlineIcon();
                return ImageCache.getImage(icon);
            }
            return null;
        }
    }
}

