/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ValueofExpression
extends Expression_Value {
    private static final String OPERANDERROR = "Cannot determine the argument type of `valueof' operation";
    private final TemplateInstance templateInstance;

    public ValueofExpression(TemplateInstance templateInstance) {
        this.templateInstance = templateInstance;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.VALUEOF_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.templateInstance != null && this.templateInstance.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("valueof(");
        builder.append(this.templateInstance.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.templateInstance != null) {
            this.templateInstance.setCodeSection(codeSection);
        }
    }

    public TemplateInstance getTemplateInstance() {
        return this.templateInstance;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.templateInstance != null) {
            return this.templateInstance.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        }
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType governor = super.getMyGovernor();
        if (governor != null) {
            return governor;
        }
        if (this.templateInstance == null) {
            return null;
        }
        IType tempType = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? this.templateInstance.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE) : this.templateInstance.getExpressionGovernor(timestamp, expectedValue);
        if (tempType != null) {
            tempType = tempType.getTypeRefdLast(timestamp);
        }
        return tempType;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance == null) {
            return true;
        }
        if (this.templateInstance.getDerivedReference() != null) {
            return true;
        }
        ITTCN3Template temp = this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
        return temp == null || !temp.isValue(timestamp) || temp.getValue().isUnfoldable(timestamp);
    }

    @Override
    public IValue setLoweridToReference(CompilationTimeStamp timestamp) {
        if (this.templateInstance != null && this.templateInstance.getType() != null && this.templateInstance.getDerivedReference() != null) {
            this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
        }
        return this;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance == null) {
            this.setIsErroneous(true);
            return;
        }
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        ITTCN3Template template = this.templateInstance.getTemplateBody();
        template.setMyGovernor(null);
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.templateInstance.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (governor == null) {
            template = template.setLoweridToReference(timestamp);
            governor = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (governor == null) {
            if (!template.getIsErroneous(timestamp)) {
                this.templateInstance.getLocation().reportSemanticError(OPERANDERROR);
            }
            this.setIsErroneous(true);
            return;
        }
        IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance, governor, referenceChain, expectedValue);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        this.templateInstance.getTemplateBody().checkSpecificValue(timestamp, false);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        if (this.templateInstance.getDerivedReference() == null && this.templateInstance.getTemplateBody().isValue(timestamp)) {
            this.lastValue = this.templateInstance.getTemplateBody().getValue();
            this.lastValue = this.lastValue.setLoweridToReference(timestamp);
            this.lastValue = this.lastValue.getValueRefdLast(timestamp, expectedValue, referenceChain);
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.templateInstance != null) {
            referenceChain.markState();
            this.templateInstance.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance == null) {
            return;
        }
        this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.templateInstance == null || this.templateInstance.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.templateInstance != null) {
            this.templateInstance.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        if (this.templateInstance != null) {
            this.templateInstance.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
            expression.expression.append(".valueof()");
        }
    }
}

