/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Unichar2OctExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "The operand of the `unichar2oct' operation should be a universal charstring value";
    private static final String OPERANDERROR2 = "Second operand of the `unichar2oct' operation should be a charstring value";
    private final Value value;
    private final Value code_string;

    public Unichar2OctExpression(Value value, Value code_string) {
        this.value = value;
        this.code_string = code_string;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (code_string != null) {
            code_string.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.UNICHAR2OCT_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.value != null && this.value.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.code_string != null && this.code_string.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("unichar2oct(").append(this.value.createStringRepresentation());
        if (this.code_string != null) {
            builder.append(',').append(this.code_string.createStringRepresentation());
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.code_string != null) {
            this.code_string.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
        if (this.code_string != null) {
            this.code_string.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand1>");
        }
        if (this.code_string == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_OCTETSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value != null) {
            this.value.setLoweridToReference(timestamp);
            IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType) {
                case TYPE_CHARSTRING: {
                    this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    this.set_needs_conversion();
                    break;
                }
                case TYPE_UCHARSTRING: {
                    this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    if (this.value.getIsErroneous(timestamp)) break;
                    this.location.reportSemanticError(OPERANDERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.code_string != null) {
            this.code_string.setLoweridToReference(timestamp);
            IType.Type_type tempType2 = this.code_string.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_CHARSTRING: {
                    this.code_string.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    return;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    return;
                }
            }
            if (!this.code_string.getIsErroneous(timestamp)) {
                this.location.reportSemanticError(OPERANDERROR2);
                this.setIsErroneous(true);
            }
            return;
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.value != null) {
            referenceChain.markState();
            this.value.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
        if (this.code_string != null) {
            referenceChain.markState();
            this.code_string.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.code_string != null) {
            this.code_string.updateSyntax(reparser, false);
            reparser.updateLocation(this.code_string.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
        if (this.code_string != null) {
            this.code_string.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.code_string == null || this.code_string.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.code_string != null) {
            this.code_string.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addCommonLibraryImport("AdditionalFunctions");
        expression.expression.append("AdditionalFunctions.unichar2oct(");
        if (this.get_needs_conversion()) {
            aData.addBuiltinTypeImport("TitanUniversalCharString");
            expression.expression.append("TitanUniversalCharString.convert_to_UniversalCharString(");
            this.value.generateCodeExpressionMandatory(aData, expression, true);
            expression.expression.append(')');
        } else {
            this.value.generateCodeExpressionMandatory(aData, expression, true);
        }
        if (this.code_string != null) {
            expression.expression.append(',');
            this.code_string.generateCodeExpressionMandatory(aData, expression, true);
        }
        expression.expression.append(')');
    }
}

