/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.BitString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.CharString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.HexString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.LengthRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.OctetString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.PatternString;
import org.eclipse.titan.designer.AST.TTCN3.templates.RangeLenghtRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.SingleLenghtRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.SubsetMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SupersetMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.UnivCharString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Integer_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.BooleanListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.CharLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.IntegerLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.Length_ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.Pattern_ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.Range_ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RealLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RealRangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.Single_ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SizeLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringPatternConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringSetConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringSizeAndValueListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringSubtypeTreeElement;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringValueConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.UCharLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.UStringValueConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.ValueListAndSizeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.ValueListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.VerdicttypeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Verdict_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SubType
implements IIncrementallyUpdateable {
    private static final SubtypeConstraint BIT_SC = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.BITSTRING, new SizeLimit(1L));
    private static final SubtypeConstraint HEX_SC = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.HEXSTRING, new SizeLimit(1L));
    private static final SubtypeConstraint OCTET_SC = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.OCTETSTRING, new SizeLimit(1L));
    private static final SubtypeConstraint CHAR_SC = new StringSetConstraint(StringSubtypeTreeElement.StringType.CHARSTRING, StringSetConstraint.ConstraintType.SIZE_CONSTRAINT, new RangeListConstraint(new SizeLimit(1L)));
    private static final SubtypeConstraint UCHAR_SC = new StringSetConstraint(StringSubtypeTreeElement.StringType.UNIVERSAL_CHARSTRING, StringSetConstraint.ConstraintType.SIZE_CONSTRAINT, new RangeListConstraint(new SizeLimit(1L)));
    private final SubType_type subtypeType;
    private final IType myOwner;
    private final List<ParsedSubType> parsedRestrictions;
    private final SubType parentSubtype;
    private SubtypeConstraint subtypeConstraint = null;
    private RangeListConstraint lengthRestriction = null;
    private final Set<SubType> myParents = new HashSet<SubType>();
    private CompilationTimeStamp lastTimeChecked = null;
    private boolean isErroneous = false;

    public boolean getIsErroneous(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.isErroneous;
        }
        return false;
    }

    public SubType(SubType_type subtypeType, IType myOwner, List<ParsedSubType> parsedRestrictions, SubType parentSubtype) {
        this.subtypeType = subtypeType;
        this.myOwner = myOwner;
        this.parsedRestrictions = parsedRestrictions;
        this.parentSubtype = parentSubtype;
    }

    public boolean isCompatible(CompilationTimeStamp timestamp, SubType other) {
        if (other == null) {
            return true;
        }
        if (this.getIsErroneous(timestamp) || other.getIsErroneous(timestamp)) {
            return true;
        }
        if (this.subtypeType != other.subtypeType) {
            return false;
        }
        if (this.subtypeConstraint == null || other.subtypeConstraint == null) {
            return true;
        }
        SubtypeConstraint intersectionSet = this.subtypeConstraint.intersection(other.subtypeConstraint);
        return intersectionSet.isEmpty() != TernaryBool.TTRUE;
    }

    public boolean isCompatibleWithElem(CompilationTimeStamp timestamp) {
        SubtypeConstraint sc;
        if (this.getIsErroneous(timestamp)) {
            return true;
        }
        if (this.subtypeConstraint == null) {
            return true;
        }
        switch (this.subtypeType) {
            case ST_BITSTRING: {
                sc = BIT_SC;
                break;
            }
            case ST_HEXSTRING: {
                sc = HEX_SC;
                break;
            }
            case ST_OCTETSTRING: {
                sc = OCTET_SC;
                break;
            }
            case ST_CHARSTRING: {
                sc = CHAR_SC;
                break;
            }
            case ST_UNIVERSAL_CHARSTRING: {
                sc = UCHAR_SC;
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)"not string type");
                return true;
            }
        }
        return this.subtypeConstraint.intersection(sc).isEmpty() != TernaryBool.TTRUE;
    }

    private boolean checkRecursion(IReferenceChain refch) {
        if (!refch.add(this.myOwner)) {
            return false;
        }
        for (SubType st : this.myParents) {
            refch.markState();
            if (!st.checkRecursion(refch)) {
                return false;
            }
            refch.previousState();
        }
        return true;
    }

    private boolean addParentSubtype(SubType st) {
        if (this.myParents.contains(st)) {
            return true;
        }
        ReferenceChain refch = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        refch.add(this.myOwner);
        if (!st.checkRecursion(refch)) {
            refch.release();
            return false;
        }
        this.myParents.add(st);
        refch.release();
        return true;
    }

    private boolean addTtcnSingle(CompilationTimeStamp timestamp, Value value, int restrictionIndex) {
        SubtypeConstraint sc;
        value.setMyScope(this.myOwner.getMyScope());
        value.setMyGovernor(this.myOwner);
        BridgingNamedNode bridge = new BridgingNamedNode(this.myOwner, this.myOwner.getTypename() + ".<single_restriction_" + restrictionIndex + ">");
        value.setFullNameParent(bridge);
        IValue last = this.myOwner.checkThisValueRef(timestamp, value);
        IValue refValue = value.setLoweridToReference(timestamp);
        if (refValue.getValuetype() == IValue.Value_type.REFERENCED_VALUE) {
            Reference ref = ((Referenced_Value)refValue).getReference();
            Assignment ass = ref.getRefdAssignment(timestamp, false);
            if (ass == null) {
                return false;
            }
            if (ass.getAssignmentType() == Assignment.Assignment_type.A_TYPE) {
                IType t = ass.getType(timestamp);
                t.check(timestamp);
                if (t.getIsErroneous(timestamp)) {
                    return false;
                }
                List<ISubReference> subrefs = ref.getSubreferences();
                if (subrefs.size() > 1) {
                    if ((t = t.getFieldType(timestamp, ref, 1, Expected_Value_type.EXPECTED_CONSTANT, false)) == null || t.getIsErroneous(timestamp)) {
                        return false;
                    }
                    t.check(timestamp);
                    if (t.getIsErroneous(timestamp)) {
                        return false;
                    }
                }
                if (!t.isIdentical(timestamp, this.myOwner)) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Reference `{0}'' must refer to a type which has the same root type as this type", ref.getDisplayName()));
                    return false;
                }
                SubType tSt = t.getSubtype();
                if (tSt == null || tSt.subtypeConstraint == null) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Type referenced by `{0}'' does not have a subtype", ref.getDisplayName()));
                    return false;
                }
                if (this.subtypeType == SubType_type.ST_ENUM) {
                    value.getLocation().reportSemanticError("Type references are not allowed in the template list of enumerated types");
                    return false;
                }
                if (!this.addParentSubtype(tSt)) {
                    return false;
                }
                if (tSt.getIsErroneous(timestamp)) {
                    return false;
                }
                if (tSt.subtypeType != this.subtypeType) {
                    ErrorReporter.INTERNAL_ERROR();
                    return false;
                }
                this.subtypeConstraint = this.subtypeConstraint == null ? tSt.subtypeConstraint : this.subtypeConstraint.union(tSt.subtypeConstraint);
                return true;
            }
        }
        this.myOwner.checkThisValue(timestamp, last, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, false, false, false, true));
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        last = last.getValueRefdLast(timestamp, chain);
        chain.release();
        if (last.getIsErroneous(timestamp) || last.isUnfoldable(timestamp)) {
            return false;
        }
        block0 : switch (this.subtypeType) {
            case ST_INTEGER: {
                sc = new RangeListConstraint(new IntegerLimit(((Integer_Value)last).getValueValue()));
                break;
            }
            case ST_FLOAT: {
                sc = new RealRangeListConstraint(((Real_Value)last).getValue());
                break;
            }
            case ST_BOOLEAN: {
                sc = new BooleanListConstraint(((Boolean_Value)last).getValue());
                break;
            }
            case ST_VERDICTTYPE: {
                sc = new VerdicttypeListConstraint(((Verdict_Value)last).getValue());
                break;
            }
            case ST_BITSTRING: {
                sc = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.BITSTRING, ((Bitstring_Value)last).getValue());
                break;
            }
            case ST_HEXSTRING: {
                sc = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.HEXSTRING, ((Hexstring_Value)last).getValue());
                break;
            }
            case ST_OCTETSTRING: {
                sc = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.OCTETSTRING, ((Octetstring_Value)last).getValue());
                break;
            }
            case ST_CHARSTRING: {
                if (last.getValuetype() != IValue.Value_type.CHARSTRING_VALUE) {
                    return false;
                }
                sc = new StringSetConstraint(StringSubtypeTreeElement.StringType.CHARSTRING, StringSetConstraint.ConstraintType.VALUE_CONSTRAINT, new StringValueConstraint(((Charstring_Value)last).getValue()));
                break;
            }
            case ST_UNIVERSAL_CHARSTRING: {
                switch (last.getValuetype()) {
                    case CHARSTRING_VALUE: {
                        sc = new StringSetConstraint(StringSubtypeTreeElement.StringType.UNIVERSAL_CHARSTRING, StringSetConstraint.ConstraintType.VALUE_CONSTRAINT, new UStringValueConstraint(new UniversalCharstring(((Charstring_Value)last).getValue(), last.getLocation())));
                        break block0;
                    }
                    case UNIVERSALCHARSTRING_VALUE: {
                        sc = new StringSetConstraint(StringSubtypeTreeElement.StringType.UNIVERSAL_CHARSTRING, StringSetConstraint.ConstraintType.VALUE_CONSTRAINT, new UStringValueConstraint(((UniversalCharstring_Value)last).getValue()));
                        break block0;
                    }
                }
                return false;
            }
            case ST_OBJID: 
            case ST_ENUM: 
            case ST_UNION: 
            case ST_RECORD: 
            case ST_SET: 
            case ST_FUNCTION: 
            case ST_ALTSTEP: 
            case ST_TESTCASE: {
                sc = new ValueListConstraint(last);
                break;
            }
            case ST_RECORDOF: 
            case ST_SETOF: {
                sc = new ValueListAndSizeConstraint(last);
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
                return false;
            }
        }
        this.subtypeConstraint = this.subtypeConstraint == null ? sc : this.subtypeConstraint.union(sc);
        return true;
    }

    private boolean addTtcnRange(CompilationTimeStamp timestamp, Value min, boolean minExclusive, Value max, boolean maxExclusive, int restrictionIndex) {
        SubtypeConstraint rangeConstraint;
        switch (this.subtypeType) {
            case ST_CHARSTRING: 
            case ST_UNIVERSAL_CHARSTRING: 
            case ST_INTEGER: 
            case ST_FLOAT: {
                break;
            }
            default: {
                this.myOwner.getLocation().reportSemanticError(MessageFormat.format("Range subtyping is not allowed for type `{0}''", this.myOwner.getTypename()));
                return false;
            }
        }
        if (min == null || max == null) {
            return false;
        }
        IValue vmin = null;
        IValue vmax = null;
        min.setMyScope(this.myOwner.getMyScope());
        min.setMyGovernor(this.myOwner);
        BridgingNamedNode bridge = new BridgingNamedNode(this.myOwner, this.myOwner.getFullName() + ".<range_restriction_" + restrictionIndex + "_lower>");
        min.setFullNameParent(bridge);
        IValue last = this.myOwner.checkThisValueRef(timestamp, min);
        IType lastOwner = this.myOwner.getTypeRefdLast(timestamp);
        if (lastOwner instanceof Integer_Type) {
            ((Integer_Type)lastOwner).checkThisValueLimit(timestamp, last, Expected_Value_type.EXPECTED_CONSTANT, false, false, false, false);
        } else {
            this.myOwner.checkThisValue(timestamp, last, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, false, false, false));
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        vmin = last.getValueRefdLast(timestamp, chain);
        chain.release();
        max.setMyScope(this.myOwner.getMyScope());
        max.setMyGovernor(this.myOwner);
        bridge = new BridgingNamedNode(this.myOwner, this.myOwner.getFullName() + ".<range_restriction_" + restrictionIndex + "_upper>");
        max.setFullNameParent(bridge);
        last = this.myOwner.checkThisValueRef(timestamp, max);
        lastOwner = this.myOwner.getTypeRefdLast(timestamp);
        if (lastOwner instanceof Integer_Type) {
            ((Integer_Type)lastOwner).checkThisValueLimit(timestamp, last, Expected_Value_type.EXPECTED_CONSTANT, false, false, false, false);
        } else {
            this.myOwner.checkThisValue(timestamp, last, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, false, false, false));
        }
        chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        vmax = last.getValueRefdLast(timestamp, chain);
        chain.release();
        if (vmin.getIsErroneous(timestamp) || vmin.isUnfoldable(timestamp)) {
            return false;
        }
        if (vmax.getIsErroneous(timestamp) || vmax.isUnfoldable(timestamp)) {
            return false;
        }
        switch (this.subtypeType) {
            case ST_INTEGER: {
                Real_Value real;
                Real_Value real2;
                IntegerLimit minLimit = IValue.Value_type.REAL_VALUE.equals((Object)vmin.getValuetype()) ? ((real2 = (Real_Value)vmin).isNegativeInfinity() ? IntegerLimit.MINIMUM : IntegerLimit.MAXIMUM) : new IntegerLimit(((Integer_Value)vmin).getValueValue());
                IntegerLimit maxLimit = IValue.Value_type.REAL_VALUE.equals((Object)vmax.getValuetype()) ? ((real = (Real_Value)vmax).isPositiveInfinity() ? IntegerLimit.MAXIMUM : IntegerLimit.MINIMUM) : new IntegerLimit(((Integer_Value)vmax).getValueValue());
                if (minExclusive) {
                    if (minLimit.compareTo(IntegerLimit.MINIMUM) == 0) {
                        this.myOwner.getLocation().reportSemanticError("invalid lower boundary, -infinity cannot be excluded from an integer subtype range");
                        return false;
                    }
                    if (minLimit.compareTo(IntegerLimit.MAXIMUM) == 0) {
                        this.myOwner.getLocation().reportSemanticError("!infinity is not a valid lower boundary");
                        return false;
                    }
                    minLimit = (IntegerLimit)minLimit.increment();
                }
                if (maxExclusive) {
                    if (maxLimit.compareTo(IntegerLimit.MAXIMUM) == 0) {
                        this.myOwner.getLocation().reportSemanticError("invalid upper boundary, infinity cannot be excluded from an integer subtype range");
                        return false;
                    }
                    if (maxLimit.compareTo(IntegerLimit.MINIMUM) == 0) {
                        this.myOwner.getLocation().reportSemanticError("!-infinity is not a valid upper boundary");
                        return false;
                    }
                    maxLimit = (IntegerLimit)maxLimit.decrement();
                }
                if (maxLimit.compareTo(minLimit) < 0) {
                    Location.interval(min.getLocation(), max.getLocation()).reportSemanticError("lower boundary is bigger than upper boundary in integer subtype range");
                    return false;
                }
                rangeConstraint = new RangeListConstraint(minLimit, maxLimit);
                break;
            }
            case ST_FLOAT: {
                if (Double.isNaN(((Real_Value)vmin).getValue())) {
                    min.getLocation().reportSemanticError("lower boundary cannot be not_a_number in float subtype range");
                    return false;
                }
                if (Double.isNaN(((Real_Value)vmax).getValue())) {
                    max.getLocation().reportSemanticError("upper boundary cannot be not_a_number in float subtype range");
                    return false;
                }
                RealLimit minLimit = new RealLimit(((Real_Value)vmin).getValue());
                RealLimit maxLimit = new RealLimit(((Real_Value)vmax).getValue());
                if (minExclusive) {
                    if (minLimit.compareTo(RealLimit.MAXIMUM) == 0) {
                        this.myOwner.getLocation().reportSemanticError("!infinity is not a valid lower boundary");
                        return false;
                    }
                    minLimit = (RealLimit)minLimit.increment();
                }
                if (maxExclusive) {
                    if (maxLimit.compareTo(RealLimit.MINIMUM) == 0) {
                        this.myOwner.getLocation().reportSemanticError("!-infinity is not a valid upper boundary");
                        return false;
                    }
                    maxLimit = (RealLimit)maxLimit.decrement();
                }
                if (maxLimit.compareTo(minLimit) < 0) {
                    Location.interval(min.getLocation(), max.getLocation()).reportSemanticError("lower boundary is bigger than upper boundary in float subtype range");
                    return false;
                }
                rangeConstraint = new RealRangeListConstraint(minLimit, maxLimit);
                break;
            }
            case ST_CHARSTRING: {
                String maxString;
                String minString;
                boolean erroneous = false;
                if (IValue.Value_type.REAL_VALUE.equals((Object)vmin.getValuetype()) && ((Real_Value)vmin).isNegativeInfinity()) {
                    this.getParsedLocation().reportSemanticError("lower boundary of a charstring subtype range cannot be -infinity");
                    erroneous = true;
                }
                if (IValue.Value_type.REAL_VALUE.equals((Object)vmax.getValuetype()) && ((Real_Value)vmax).isPositiveInfinity()) {
                    this.getParsedLocation().reportSemanticError("upper boundary of a charstring subtype range cannot be infinity");
                    erroneous = true;
                }
                if (erroneous) {
                    return false;
                }
                switch (vmin.getValuetype()) {
                    case CHARSTRING_VALUE: {
                        minString = ((Charstring_Value)vmin).getValue();
                        break;
                    }
                    case UNIVERSALCHARSTRING_VALUE: {
                        UniversalCharstring ustr = ((UniversalCharstring_Value)vmin).getValue();
                        if (ustr.length() < 1 || !ustr.get(0).isValidChar()) {
                            min.getLocation().reportSemanticError("lower boundary of charstring subtype range is not a valid char");
                            return false;
                        }
                        minString = String.valueOf((char)ustr.get(0).cell());
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                switch (vmax.getValuetype()) {
                    case CHARSTRING_VALUE: {
                        maxString = ((Charstring_Value)vmax).getValue();
                        break;
                    }
                    case UNIVERSALCHARSTRING_VALUE: {
                        UniversalCharstring ustr = ((UniversalCharstring_Value)vmax).getValue();
                        if (ustr.length() < 1 || !ustr.get(0).isValidChar()) {
                            max.getLocation().reportSemanticError("upper boundary of charstring subtype range is not a valid char");
                            return false;
                        }
                        maxString = String.valueOf((char)ustr.get(0).cell());
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (minString.length() != 1) {
                    min.getLocation().reportSemanticError("lower boundary of charstring subtype range must be a single element string");
                    return false;
                }
                if (maxString.length() != 1) {
                    max.getLocation().reportSemanticError("upper boundary of charstring subtype range must be a single element string");
                    return false;
                }
                CharLimit minLimit = new CharLimit(minString.charAt(0));
                CharLimit maxLimit = new CharLimit(maxString.charAt(0));
                if (minExclusive) {
                    if (minLimit.compareTo(CharLimit.MAXIMUM) == 0) {
                        min.getLocation().reportSemanticError("exclusive lower boundary is not a legal charstring character");
                        return false;
                    }
                    minLimit = (CharLimit)minLimit.increment();
                }
                if (maxExclusive) {
                    if (maxLimit.compareTo(CharLimit.MINIMUM) == 0) {
                        max.getLocation().reportSemanticError("exclusive upper boundary is not a legal charstring character");
                        return false;
                    }
                    maxLimit = (CharLimit)maxLimit.decrement();
                }
                if (maxLimit.compareTo(minLimit) < 0) {
                    Location.interval(min.getLocation(), max.getLocation()).reportSemanticError("lower boundary is bigger than upper boundary in charstring subtype range");
                    return false;
                }
                rangeConstraint = new StringSetConstraint(StringSubtypeTreeElement.StringType.CHARSTRING, StringSetConstraint.ConstraintType.ALPHABET_CONSTRAINT, new RangeListConstraint(minLimit, maxLimit));
                break;
            }
            case ST_UNIVERSAL_CHARSTRING: {
                UniversalCharstring maxString;
                UniversalCharstring minString;
                boolean erroneous = false;
                if (IValue.Value_type.REAL_VALUE.equals((Object)vmin.getValuetype()) && ((Real_Value)vmin).isNegativeInfinity()) {
                    min.getLocation().reportSemanticError("lower boundary of a universal charstring subtype range cannot be -infinity");
                    erroneous = true;
                }
                if (IValue.Value_type.REAL_VALUE.equals((Object)vmax.getValuetype()) && ((Real_Value)vmax).isPositiveInfinity()) {
                    max.getLocation().reportSemanticError("upper boundary of a universal charstring subtype range cannot be infinity");
                    erroneous = true;
                }
                if (erroneous) {
                    return false;
                }
                switch (vmin.getValuetype()) {
                    case CHARSTRING_VALUE: {
                        minString = new UniversalCharstring(((Charstring_Value)vmin).getValue(), vmin.getLocation());
                        break;
                    }
                    case UNIVERSALCHARSTRING_VALUE: {
                        minString = ((UniversalCharstring_Value)vmin).getValue();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                switch (vmax.getValuetype()) {
                    case CHARSTRING_VALUE: {
                        maxString = new UniversalCharstring(((Charstring_Value)vmax).getValue(), vmax.getLocation());
                        break;
                    }
                    case UNIVERSALCHARSTRING_VALUE: {
                        maxString = ((UniversalCharstring_Value)vmax).getValue();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (minString.length() != 1) {
                    min.getLocation().reportSemanticError("lower boundary of universal charstring subtype range must be a single element string");
                    return false;
                }
                if (maxString.length() != 1) {
                    max.getLocation().reportSemanticError("upper boundary of universal charstring subtype range must be a single element string");
                    return false;
                }
                UCharLimit minLimit = new UCharLimit(minString.get(0));
                UCharLimit maxLimit = new UCharLimit(maxString.get(0));
                if (minExclusive) {
                    if (minLimit.compareTo(UCharLimit.MAXIMUM) == 0) {
                        min.getLocation().reportSemanticError("exclusive lower boundary is not a legal universal charstring character");
                        return false;
                    }
                    minLimit = (UCharLimit)minLimit.increment();
                }
                if (maxExclusive) {
                    if (maxLimit.compareTo(UCharLimit.MINIMUM) == 0) {
                        max.getLocation().reportSemanticError("exclusive upper boundary is not a legal universal charstring character");
                        return false;
                    }
                    maxLimit = (UCharLimit)maxLimit.decrement();
                }
                if (maxLimit.compareTo(minLimit) < 0) {
                    Location.interval(min.getLocation(), max.getLocation()).reportSemanticError("lower boundary is bigger than upper boundary in universal charstring subtype range");
                    return false;
                }
                rangeConstraint = new StringSetConstraint(StringSubtypeTreeElement.StringType.UNIVERSAL_CHARSTRING, StringSetConstraint.ConstraintType.ALPHABET_CONSTRAINT, new RangeListConstraint(minLimit, maxLimit));
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
                return false;
            }
        }
        this.subtypeConstraint = this.subtypeConstraint == null ? rangeConstraint : this.subtypeConstraint.union(rangeConstraint);
        return true;
    }

    private boolean checkBoundaryValid(IValue boundary, String boundaryName) {
        BigInteger lowerInt = ((Integer_Value)boundary).getValueValue();
        if (lowerInt.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
            boundary.getLocation().reportSemanticError(MessageFormat.format("The {0} should be less than `{1}'' instead of `{2}''", boundaryName, Integer.MAX_VALUE, lowerInt));
            return false;
        }
        return true;
    }

    private boolean setTtcnLength(SizeLimit min, SizeLimit max) {
        SubtypeConstraint sc;
        switch (this.subtypeType) {
            case ST_BITSTRING: {
                sc = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.BITSTRING, min, max);
                break;
            }
            case ST_HEXSTRING: {
                sc = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.HEXSTRING, min, max);
                break;
            }
            case ST_OCTETSTRING: {
                sc = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.OCTETSTRING, min, max);
                break;
            }
            case ST_CHARSTRING: {
                sc = new StringSetConstraint(StringSubtypeTreeElement.StringType.CHARSTRING, StringSetConstraint.ConstraintType.SIZE_CONSTRAINT, new RangeListConstraint(min, max));
                break;
            }
            case ST_UNIVERSAL_CHARSTRING: {
                sc = new StringSetConstraint(StringSubtypeTreeElement.StringType.UNIVERSAL_CHARSTRING, StringSetConstraint.ConstraintType.SIZE_CONSTRAINT, new RangeListConstraint(min, max));
                break;
            }
            case ST_RECORDOF: 
            case ST_SETOF: {
                sc = new ValueListAndSizeConstraint(min, max);
                break;
            }
            default: {
                this.myOwner.getLocation().reportSemanticError(MessageFormat.format("Length subtyping is not allowed for type `{0}''", this.myOwner.getTypename()));
                return false;
            }
        }
        this.subtypeConstraint = this.subtypeConstraint == null ? sc : this.subtypeConstraint.intersection(sc);
        RangeListConstraint lr = new RangeListConstraint(min, max);
        this.lengthRestriction = this.lengthRestriction == null ? lr : this.lengthRestriction.intersection(lr);
        return true;
    }

    private boolean addTtcnLength(CompilationTimeStamp timestamp, LengthRestriction lengthRestriction, int restrictionIndex) {
        lengthRestriction.setMyScope(this.myOwner.getMyScope());
        BridgingNamedNode bridge = new BridgingNamedNode(this.myOwner, this.myOwner.getFullName() + ".<length_restriction_" + restrictionIndex + ">");
        lengthRestriction.setFullNameParent(bridge);
        lengthRestriction.check(timestamp, Expected_Value_type.EXPECTED_CONSTANT);
        IValue lower = null;
        IValue upper = null;
        if (lengthRestriction instanceof SingleLenghtRestriction) {
            lower = ((SingleLenghtRestriction)lengthRestriction).getRestriction(timestamp);
            if (lower == null || lower.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)lower.getValuetype()) || lower.isUnfoldable(timestamp)) {
                return false;
            }
            if (!this.checkBoundaryValid(lower, "length restriction value")) {
                return false;
            }
            SizeLimit boundaryLimit = new SizeLimit(((Integer_Value)lower).getValueValue());
            return this.setTtcnLength(boundaryLimit, boundaryLimit);
        }
        lower = ((RangeLenghtRestriction)lengthRestriction).getLowerValue(timestamp);
        if (lower == null || lower.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)lower.getValuetype()) || lower.isUnfoldable(timestamp)) {
            return false;
        }
        if (!this.checkBoundaryValid(lower, "lower boundary")) {
            return false;
        }
        upper = ((RangeLenghtRestriction)lengthRestriction).getUpperValue(timestamp);
        if (upper != null) {
            if (upper.getMyScope() == null) {
                upper.setMyScope(this.myOwner.getMyScope());
            }
            if (upper.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)upper.getValuetype()) || upper.isUnfoldable(timestamp)) {
                return false;
            }
            if (!this.checkBoundaryValid(upper, "upper boundary")) {
                return false;
            }
            return this.setTtcnLength(new SizeLimit(((Integer_Value)lower).getValueValue()), new SizeLimit(((Integer_Value)upper).getValueValue()));
        }
        return this.setTtcnLength(new SizeLimit(((Integer_Value)lower).getValueValue()), SizeLimit.MAXIMUM);
    }

    private boolean addTtcnPattern(CompilationTimeStamp timestamp, PatternString pattern, int restrictionIndex) {
        StringSetConstraint sc;
        pattern.setMyScope(this.myOwner.getMyScope());
        pattern.setFullNameParent(new BridgingNamedNode(this.myOwner, ".<pattern_restriction_" + restrictionIndex + ">"));
        switch (this.subtypeType) {
            case ST_CHARSTRING: {
                sc = new StringSetConstraint(StringSubtypeTreeElement.StringType.CHARSTRING, StringSetConstraint.ConstraintType.PATTERN_CONSTRAINT, new StringPatternConstraint(pattern));
                break;
            }
            case ST_UNIVERSAL_CHARSTRING: {
                sc = new StringSetConstraint(StringSubtypeTreeElement.StringType.UNIVERSAL_CHARSTRING, StringSetConstraint.ConstraintType.PATTERN_CONSTRAINT, new StringPatternConstraint(pattern));
                break;
            }
            default: {
                this.myOwner.getLocation().reportSemanticError(MessageFormat.format("Pattern subtyping of type `{0}'' is not allowed", this.myOwner.getTypename()));
                return false;
            }
        }
        this.subtypeConstraint = this.subtypeConstraint == null ? sc : this.subtypeConstraint.intersection(sc);
        return true;
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.parsedRestrictions != null) {
            int addedCount = 0;
            boolean hasSingle = false;
            boolean hasRange = false;
            int size = this.parsedRestrictions.size();
            for (int i = 0; i < size; ++i) {
                boolean added = false;
                ParsedSubType parsed = this.parsedRestrictions.get(i);
                switch (parsed.getSubTypetype()) {
                    case SINGLE_PARSEDSUBTYPE: {
                        hasSingle = true;
                        added = this.addTtcnSingle(timestamp, ((Single_ParsedSubType)parsed).getValue(), i);
                        break;
                    }
                    case RANGE_PARSEDSUBTYPE: {
                        hasRange = true;
                        Range_ParsedSubType rpst = (Range_ParsedSubType)parsed;
                        added = this.addTtcnRange(timestamp, rpst.getMin(), rpst.getMinExclusive(), rpst.getMax(), rpst.getMaxExclusive(), i);
                        break;
                    }
                    case LENGTH_PARSEDSUBTYPE: {
                        added = this.addTtcnLength(timestamp, ((Length_ParsedSubType)parsed).getLength(), i);
                        break;
                    }
                    case PATTERN_PARSEDSUBTYPE: {
                        added = this.addTtcnPattern(timestamp, ((Pattern_ParsedSubType)parsed).getPattern(), i);
                        break;
                    }
                    default: {
                        ErrorReporter.INTERNAL_ERROR();
                    }
                }
                if (!added) continue;
                ++addedCount;
            }
            switch (this.subtypeType) {
                case ST_CHARSTRING: 
                case ST_UNIVERSAL_CHARSTRING: {
                    if (!hasSingle || !hasRange) break;
                    this.myOwner.getLocation().reportSemanticError(MessageFormat.format("Mixing of value list and range subtyping is not allowed for type `{0}''", this.myOwner.getTypename()));
                    this.isErroneous = true;
                    return;
                }
            }
            if (addedCount < this.parsedRestrictions.size()) {
                this.isErroneous = true;
                return;
            }
            if (this.getIsErroneous(timestamp)) {
                return;
            }
        }
        if (this.parentSubtype != null && !this.parentSubtype.getIsErroneous(timestamp)) {
            if (!this.addParentSubtype(this.parentSubtype)) {
                this.isErroneous = true;
                return;
            }
            if (this.parentSubtype.subtypeType != this.subtypeType) {
                ErrorReporter.INTERNAL_ERROR();
                return;
            }
            if (this.parentSubtype.subtypeConstraint != null) {
                if (this.subtypeConstraint == null) {
                    this.subtypeConstraint = this.parentSubtype.subtypeConstraint;
                } else {
                    if (this.subtypeConstraint.isSubset(this.parentSubtype.subtypeConstraint) == TernaryBool.TFALSE) {
                        String message = MessageFormat.format("The subtype restriction is not a subset of the restriction on the parent type. Subtype {0} is not subset of subtype {1}", this.subtypeConstraint.toString(), this.parentSubtype.subtypeConstraint.toString());
                        this.getParsedLocation().reportSemanticError(message);
                        this.isErroneous = true;
                        return;
                    }
                    this.subtypeConstraint = this.subtypeConstraint.intersection(this.parentSubtype.subtypeConstraint);
                }
            }
            if (this.parentSubtype.lengthRestriction != null) {
                this.lengthRestriction = this.lengthRestriction == null ? this.parentSubtype.lengthRestriction : this.lengthRestriction.intersection(this.parentSubtype.lengthRestriction);
            }
        }
        if (this.subtypeConstraint != null) {
            if (this.subtypeConstraint.isEmpty() == TernaryBool.TTRUE) {
                this.getParsedLocation().reportSemanticError("The subtype is an empty set");
                this.isErroneous = true;
                return;
            }
            if (this.subtypeConstraint.isFull() == TernaryBool.TTRUE) {
                this.getParsedLocation().reportSemanticWarning(MessageFormat.format("The subtype of type `{0}'' is a full set, it does not constrain the root type.", this.myOwner.getTypename()));
                this.subtypeConstraint = null;
            }
        }
        if (this.lengthRestriction != null && this.lengthRestriction.isFull() == TernaryBool.TTRUE) {
            this.lengthRestriction = null;
        }
    }

    public boolean lengthAllowed(int length) {
        if (this.lengthRestriction == null) {
            return true;
        }
        return this.lengthRestriction.isElement(new SizeLimit(length));
    }

    public void checkThisValue(CompilationTimeStamp timestamp, IValue value) {
        if (this.getIsErroneous(timestamp) || this.subtypeConstraint == null) {
            return;
        }
        if (value.getIsErroneous(timestamp)) {
            return;
        }
        IValue last = value.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        if (last.getIsErroneous(timestamp)) {
            return;
        }
        boolean isValid = true;
        block0 : switch (last.getValuetype()) {
            case INTEGER_VALUE: {
                if (this.subtypeType != SubType_type.ST_INTEGER) {
                    ErrorReporter.INTERNAL_ERROR();
                    return;
                }
                isValid = this.subtypeConstraint.isElement(new IntegerLimit(((Integer_Value)last).getValueValue()));
                break;
            }
            case REAL_VALUE: {
                if (this.subtypeType == SubType_type.ST_FLOAT) {
                    isValid = this.subtypeConstraint.isElement(((Real_Value)last).getValue());
                    break;
                }
                if (this.subtypeType == SubType_type.ST_INTEGER) {
                    Real_Value real = (Real_Value)last;
                    if (real.isNegativeInfinity()) {
                        isValid = this.subtypeConstraint.isElement(IntegerLimit.MINIMUM);
                        break;
                    }
                    if (real.isPositiveInfinity()) {
                        isValid = this.subtypeConstraint.isElement(IntegerLimit.MAXIMUM);
                        break;
                    }
                }
                ErrorReporter.INTERNAL_ERROR();
                return;
            }
            case BOOLEAN_VALUE: {
                if (this.subtypeType != SubType_type.ST_BOOLEAN) {
                    ErrorReporter.INTERNAL_ERROR();
                    return;
                }
                isValid = this.subtypeConstraint.isElement(((Boolean_Value)last).getValue());
                break;
            }
            case VERDICT_VALUE: {
                if (this.subtypeType != SubType_type.ST_VERDICTTYPE) {
                    ErrorReporter.INTERNAL_ERROR();
                    return;
                }
                isValid = this.subtypeConstraint.isElement((Object)((Verdict_Value)last).getValue());
                break;
            }
            case BITSTRING_VALUE: {
                if (this.subtypeType != SubType_type.ST_BITSTRING) {
                    ErrorReporter.INTERNAL_ERROR();
                    return;
                }
                isValid = this.subtypeConstraint.isElement(((Bitstring_Value)last).getValue());
                break;
            }
            case HEXSTRING_VALUE: {
                if (this.subtypeType != SubType_type.ST_HEXSTRING) {
                    ErrorReporter.INTERNAL_ERROR();
                    return;
                }
                isValid = this.subtypeConstraint.isElement(((Hexstring_Value)last).getValue());
                break;
            }
            case OCTETSTRING_VALUE: {
                if (this.subtypeType != SubType_type.ST_OCTETSTRING) {
                    ErrorReporter.INTERNAL_ERROR();
                    return;
                }
                isValid = this.subtypeConstraint.isElement(((Octetstring_Value)last).getValue());
                break;
            }
            case CHARSTRING_VALUE: {
                switch (this.subtypeType) {
                    case ST_CHARSTRING: {
                        isValid = this.subtypeConstraint.isElement(((Charstring_Value)last).getValue());
                        break block0;
                    }
                    case ST_UNIVERSAL_CHARSTRING: {
                        isValid = this.subtypeConstraint.isElement(new UniversalCharstring(((Charstring_Value)last).getValue(), last.getLocation()));
                        break block0;
                    }
                }
                ErrorReporter.INTERNAL_ERROR();
                return;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                switch (this.subtypeType) {
                    case ST_CHARSTRING: {
                        isValid = this.subtypeConstraint.isElement(Charstring_Value.convert(timestamp, (UniversalCharstring_Value)last).getValue());
                        break block0;
                    }
                    case ST_UNIVERSAL_CHARSTRING: {
                        isValid = this.subtypeConstraint.isElement(((UniversalCharstring_Value)last).getValue());
                        break block0;
                    }
                }
                ErrorReporter.INTERNAL_ERROR();
                return;
            }
            case SEQUENCEOF_VALUE: 
            case SETOF_VALUE: 
            case OBJECTID_VALUE: 
            case ENUMERATED_VALUE: 
            case CHOICE_VALUE: 
            case SEQUENCE_VALUE: 
            case SET_VALUE: 
            case FUNCTION_REFERENCE_VALUE: 
            case ALTSTEP_REFERENCE_VALUE: 
            case TESTCASE_REFERENCE_VALUE: {
                if (value.isUnfoldable(timestamp)) {
                    return;
                }
                isValid = this.subtypeConstraint.isElement(last);
                break;
            }
            default: {
                return;
            }
        }
        if (!isValid) {
            value.getLocation().reportSemanticError(MessageFormat.format("{0} is not a valid value for type `{1}'' which has subtype {2}", last.createStringRepresentation(), this.myOwner.getTypename(), this.subtypeConstraint.toString()));
        }
    }

    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, ITTCN3Template template) {
        if (this.getIsErroneous(timestamp) || this.subtypeConstraint == null) {
            return;
        }
        if (template.getIsErroneous(timestamp)) {
            return;
        }
        TTCN3Template t = template.getTemplateReferencedLast(timestamp);
        if (t.getIsErroneous(timestamp)) {
            return;
        }
        switch (t.getTemplatetype()) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: 
            case ANY_VALUE: 
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: 
            case SPECIFIC_VALUE: 
            case TEMPLATE_REFD: 
            case TEMPLATE_INVOKE: {
                break;
            }
            case TEMPLATE_LIST: {
                if (this.subtypeType != SubType_type.ST_RECORDOF && this.subtypeType != SubType_type.ST_SETOF || this.lengthRestriction == null || this.lengthRestriction.isEmpty() == TernaryBool.TTRUE) break;
                SizeLimit minLimit = (SizeLimit)this.lengthRestriction.getMinimal();
                SizeLimit maxLimit = (SizeLimit)this.lengthRestriction.getMaximal();
                Template_List list = (Template_List)template;
                int fixComponents = list.getNofTemplatesNotAnyornone(timestamp);
                if (!list.templateContainsAnyornone() && fixComponents < minLimit.getSize().intValue()) {
                    template.getLocation().reportSemanticError(MessageFormat.format("At least {0} elements must be present in the list", minLimit.getSize().intValue()));
                    return;
                }
                if (maxLimit.getInfinity() || fixComponents <= maxLimit.getSize().intValue()) break;
                template.getLocation().reportSemanticError(MessageFormat.format("There must not be more than {0} elements in the list", maxLimit.getSize().intValue()));
                return;
            }
            case INDEXED_TEMPLATE_LIST: 
            case NAMED_TEMPLATE_LIST: 
            case VALUE_RANGE: 
            case ALL_FROM: 
            case DECODE_MATCH: {
                break;
            }
            case SUPERSET_MATCH: {
                if (this.subtypeType != SubType_type.ST_SETOF) {
                    template.getLocation().reportSemanticError("'superset' template matching mechanism can be used only with 'set of' types");
                }
                SupersetMatch_Template temp = (SupersetMatch_Template)template;
                int size = temp.getNofTemplates();
                for (int i = 0; i < size; ++i) {
                    this.checkThisTemplateGeneric(timestamp, temp.getTemplateByIndex(i));
                }
                break;
            }
            case SUBSET_MATCH: {
                if (this.subtypeType != SubType_type.ST_SETOF) {
                    template.getLocation().reportSemanticError("'subset' template matching mechanism can be used only with 'set of' types");
                }
                SubsetMatch_Template temp = (SubsetMatch_Template)template;
                int size = temp.getNofTemplates();
                for (int i = 0; i < size; ++i) {
                    this.checkThisTemplateGeneric(timestamp, temp.getTemplateByIndex(i));
                }
                break;
            }
            case BSTR_PATTERN: {
                this.checkThisTemplatePattern(template, "bitstring", ((BitString_Pattern_Template)template).getMinLengthOfPattern(), ((BitString_Pattern_Template)template).containsAnyornoneSymbol());
                break;
            }
            case HSTR_PATTERN: {
                this.checkThisTemplatePattern(template, "hexstring", ((HexString_Pattern_Template)template).getMinLengthOfPattern(), ((HexString_Pattern_Template)template).containsAnyornoneSymbol());
                break;
            }
            case OSTR_PATTERN: {
                this.checkThisTemplatePattern(template, "octetstring", ((OctetString_Pattern_Template)template).getMinLengthOfPattern(), ((OctetString_Pattern_Template)template).containsAnyornoneSymbol());
                break;
            }
            case CSTR_PATTERN: {
                this.checkThisTemplatePattern(template, "charstring", ((CharString_Pattern_Template)template).getMinLengthOfPattern(), ((CharString_Pattern_Template)template).patternContainsAnyornoneSymbol());
                break;
            }
            case USTR_PATTERN: {
                this.checkThisTemplatePattern(template, "universal charstring", ((UnivCharString_Pattern_Template)template).getMinLengthOfPattern(), ((UnivCharString_Pattern_Template)template).patternContainsAnyornoneSymbol());
                break;
            }
        }
        this.checkThisTemplateLengthRestriction(timestamp, t);
    }

    private void checkThisTemplateLengthRestriction(CompilationTimeStamp timestamp, TTCN3Template template) {
        SubtypeConstraint tmplConstraint;
        SizeLimit tmplMaxLen;
        SizeLimit tmplMinLen;
        LengthRestriction realRestriction;
        LengthRestriction lengthRestriction = template.getLengthRestriction();
        if (lengthRestriction == null || this.subtypeConstraint == null) {
            return;
        }
        lengthRestriction.check(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (lengthRestriction instanceof SingleLenghtRestriction) {
            realRestriction = (SingleLenghtRestriction)lengthRestriction;
            IValue lower = ((SingleLenghtRestriction)realRestriction).getRestriction(timestamp);
            if (lower.getIsErroneous(timestamp)) {
                return;
            }
            ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IValue last = lower.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, chain);
            chain.release();
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) {
                return;
            }
            BigInteger length = ((Integer_Value)last).getValueValue();
            tmplMaxLen = tmplMinLen = new SizeLimit(length);
        } else {
            realRestriction = (RangeLenghtRestriction)lengthRestriction;
            IValue lower = ((RangeLenghtRestriction)realRestriction).getLowerValue(timestamp);
            ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IValue lastLower = lower.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, chain);
            chain.release();
            if (lastLower.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)lastLower.getValuetype())) {
                return;
            }
            IValue upper = ((RangeLenghtRestriction)realRestriction).getUpperValue(timestamp);
            if (upper == null) {
                return;
            }
            chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IValue lastUpper = upper.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, chain);
            chain.release();
            if (lastUpper.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)lastUpper.getValuetype())) {
                return;
            }
            tmplMinLen = new SizeLimit(((Integer_Value)lastLower).getValueValue());
            tmplMaxLen = new SizeLimit(((Integer_Value)lastUpper).getValueValue());
        }
        switch (this.subtypeType) {
            case ST_BITSTRING: {
                tmplConstraint = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.BITSTRING, tmplMinLen, tmplMaxLen);
                break;
            }
            case ST_HEXSTRING: {
                tmplConstraint = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.HEXSTRING, tmplMinLen, tmplMaxLen);
                break;
            }
            case ST_OCTETSTRING: {
                tmplConstraint = new StringSizeAndValueListConstraint(StringSizeAndValueListConstraint.Type.OCTETSTRING, tmplMinLen, tmplMaxLen);
                break;
            }
            case ST_CHARSTRING: {
                tmplConstraint = new StringSetConstraint(StringSubtypeTreeElement.StringType.CHARSTRING, StringSetConstraint.ConstraintType.SIZE_CONSTRAINT, new RangeListConstraint(tmplMinLen, tmplMaxLen));
                break;
            }
            case ST_UNIVERSAL_CHARSTRING: {
                tmplConstraint = new StringSetConstraint(StringSubtypeTreeElement.StringType.UNIVERSAL_CHARSTRING, StringSetConstraint.ConstraintType.SIZE_CONSTRAINT, new RangeListConstraint(tmplMinLen, tmplMaxLen));
                break;
            }
            case ST_RECORDOF: 
            case ST_SETOF: {
                tmplConstraint = new ValueListAndSizeConstraint(tmplMinLen, tmplMaxLen);
                break;
            }
            default: {
                return;
            }
        }
        if (this.subtypeConstraint.intersection(tmplConstraint).isEmpty() == TernaryBool.TTRUE) {
            template.getLocation().reportSemanticWarning(MessageFormat.format("Template's length restriction {0} is outside of the type's subtype constraint {1}", new RangeListConstraint(tmplMinLen, tmplMaxLen).toString(), this.subtypeConstraint.toString()));
        }
    }

    private void checkThisTemplatePattern(ITTCN3Template template, String pattType, int pattMinLength, boolean pattHasAnyornone) {
        if (this.lengthRestriction == null || this.lengthRestriction.isEmpty() == TernaryBool.TTRUE) {
            return;
        }
        SizeLimit minLimit = (SizeLimit)this.lengthRestriction.getMinimal();
        SizeLimit maxLimit = (SizeLimit)this.lengthRestriction.getMaximal();
        if (pattMinLength < minLimit.getSize().intValue() && !pattHasAnyornone) {
            template.getLocation().reportSemanticError(MessageFormat.format("At least {0} string elements must be present in the {1}", minLimit.getSize().intValue(), pattType));
        } else if (!maxLimit.getInfinity() && pattMinLength > maxLimit.getSize().intValue()) {
            template.getLocation().reportSemanticError(MessageFormat.format("There must not be more than {0} string elements in the {1}", maxLimit.getSize().intValue(), pattType));
        }
    }

    public int get_length_restriction() {
        if (this.parsedRestrictions == null) {
            return -1;
        }
        if (this.lengthRestriction == null) {
            return -1;
        }
        if (this.lengthRestriction.isEmpty() == TernaryBool.TTRUE) {
            return -1;
        }
        if (this.lengthRestriction.getMinimal() == this.lengthRestriction.getMaximal()) {
            return ((SizeLimit)this.lengthRestriction.getMinimal()).getSize().intValue();
        }
        return -1;
    }

    public String toString() {
        if (this.isErroneous) {
            return "<erroneous>";
        }
        if (this.subtypeConstraint != null) {
            return this.subtypeConstraint.toString();
        }
        return "";
    }

    public Location getParsedLocation() {
        if (this.parsedRestrictions == null || this.parsedRestrictions.isEmpty()) {
            return this.myOwner.getLocation();
        }
        if (this.parsedRestrictions.size() == 1) {
            Location loc = this.parsedRestrictions.get(0).getLocation();
            return loc == null ? this.myOwner.getLocation() : loc;
        }
        Location startLoc = this.parsedRestrictions.get(0).getLocation();
        Location endLoc = this.parsedRestrictions.get(this.parsedRestrictions.size() - 1).getLocation();
        if (startLoc == null || endLoc == null) {
            return this.myOwner.getLocation();
        }
        return Location.interval(startLoc, endLoc);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.parsedRestrictions != null) {
            int size = this.parsedRestrictions.size();
            for (int i = 0; i < size; ++i) {
                ParsedSubType parsed = this.parsedRestrictions.get(i);
                parsed.updateSyntax(reparser, isDamaged);
            }
        }
    }

    public void generateCode(JavaGenData aData, StringBuilder source) {
    }

    public List<ParsedSubType> getSubtypeParsed() {
        return this.parsedRestrictions;
    }

    public static enum SubType_type {
        ST_NONE,
        ST_INTEGER,
        ST_FLOAT,
        ST_BOOLEAN,
        ST_OBJID,
        ST_VERDICTTYPE,
        ST_BITSTRING,
        ST_HEXSTRING,
        ST_OCTETSTRING,
        ST_CHARSTRING,
        ST_UNIVERSAL_CHARSTRING,
        ST_RECORD,
        ST_RECORDOF,
        ST_SET,
        ST_SETOF,
        ST_ENUM,
        ST_UNION,
        ST_FUNCTION,
        ST_ALTSTEP,
        ST_TESTCASE;

    }
}

