/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SignatureFormalParameter
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".<type>";
    private final ParamaterDirection parameterDirection;
    private final Identifier identifier;
    private final Type type;
    private Location location;

    public SignatureFormalParameter(ParamaterDirection parameterDirection, Type type, Identifier identifier) {
        this.parameterDirection = parameterDirection;
        this.type = type;
        this.identifier = identifier;
        if (type != null) {
            type.setOwnertype(IType.TypeOwner_type.OT_SIG_PAR, this);
            type.setFullNameParent(this);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Type getType() {
        return this.type;
    }

    public ParamaterDirection getDirection() {
        return this.parameterDirection;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        return this.type == null || this.type.accept(v);
    }

    public static enum ParamaterDirection {
        PARAM_IN,
        PARAM_OUT,
        PARAM_INOUT;

    }
}

