/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entry;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Variable_Entries
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".ve_";
    private final List<Variable_Entry> entries = new ArrayList<Variable_Entry>();

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).setCodeSection(codeSection);
        }
    }

    public void add(Variable_Entry entry) {
        if (entry != null) {
            this.entries.add(entry);
            entry.setFullNameParent(this);
        }
    }

    public int getNofEntries() {
        return this.entries.size();
    }

    public Variable_Entry getEntryByIndex(int index) {
        return this.entries.get(index);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (Variable_Entry entry : this.entries) {
            entry.updateSyntax(reparser, isDamaged);
            reparser.updateLocation(entry.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.entries == null) {
            return;
        }
        for (Variable_Entry ve : this.entries) {
            ve.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.entries != null) {
            for (Variable_Entry ve : this.entries) {
                if (ve.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

