/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectUnionCases;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectUnionCase_Statement
extends Statement {
    private static final String UNDETERMINABLETYPE = "Cannot determine the type of the expression";
    private static final String TYPE_MUST_BE_UNION_OR_ANYTYPE = "The type of the expression must be union or anytype";
    private static final String CASENOTCOVERED = "Cases not covered for the following fields: ";
    private static final String FULLNAMEPART1 = ".expression";
    private static final String FULLNAMEPART2 = ".selectunioncases";
    private static final String STATEMENT_NAME = "select-union-case";
    private final Value expression;
    private final SelectUnionCases selectUnionCases;

    public SelectUnionCase_Statement(Value expression, SelectUnionCases aSelectUnionCases) {
        this.expression = expression;
        this.selectUnionCases = aSelectUnionCases;
        if (expression != null) {
            expression.setFullNameParent(this);
        }
        this.selectUnionCases.setFullNameParent(this);
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_SELECT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.expression == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.selectUnionCases == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.expression != null) {
            this.expression.setMyScope(scope);
        }
        this.selectUnionCases.setMyScope(scope);
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.expression != null) {
            this.expression.setCodeSection(codeSection);
        }
        this.selectUnionCases.setCodeSection(codeSection);
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        this.selectUnionCases.setMyStatementBlock(statementBlock, index);
    }

    @Override
    public void setMyDefinition(Definition definition) {
        this.selectUnionCases.setMyDefinition(definition);
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        this.selectUnionCases.setMyAltguards(altGuards);
    }

    @Override
    protected void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        this.selectUnionCases.setMyLaicStmt(pAltGuards, pLoopStmt);
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        return this.selectUnionCases.hasReturn(timestamp);
    }

    @Override
    public boolean hasReceivingStatement() {
        if (this.selectUnionCases != null) {
            return this.selectUnionCases.hasReceivingStatement();
        }
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.expression == null) {
            return;
        }
        IValue temp = this.expression.setLoweridToReference(timestamp);
        IType governor = temp.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (governor == null) {
            if (!temp.getIsErroneous(timestamp)) {
                this.expression.getLocation().reportSemanticError(UNDETERMINABLETYPE);
            }
            return;
        }
        temp = governor.checkThisValueRef(timestamp, this.expression);
        governor.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
        IType refd = governor.getTypeRefdLast(timestamp);
        if (refd instanceof TTCN3_Choice_Type) {
            TTCN3_Choice_Type unionType = (TTCN3_Choice_Type)refd;
            this.checkUnionType(timestamp, unionType);
        } else if (refd instanceof Anytype_Type) {
            Anytype_Type anytypeType = (Anytype_Type)refd;
            this.checkAnytypeType(timestamp, anytypeType);
        } else if (refd instanceof ASN1_Choice_Type) {
            ASN1_Choice_Type anytypeType = (ASN1_Choice_Type)refd;
            this.checkChoiceType(timestamp, anytypeType);
        } else {
            this.expression.getLocation().reportSemanticError(TYPE_MUST_BE_UNION_OR_ANYTYPE);
            for (int i = 0; i < this.selectUnionCases.getSize(); ++i) {
                this.selectUnionCases.getSelectUnionCase(i).checkStatementBlock(timestamp);
            }
            return;
        }
    }

    private void checkUnionType(CompilationTimeStamp aTimestamp, TTCN3_Choice_Type aUnionType) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < aUnionType.getNofComponents(); ++i) {
            String compName = aUnionType.getComponentIdentifierByIndex(i).getName();
            fieldNames.add(compName);
        }
        this.selectUnionCases.check(aTimestamp, aUnionType, fieldNames);
        if (!fieldNames.isEmpty()) {
            StringBuilder sb = new StringBuilder(CASENOTCOVERED);
            for (int i = 0; i < fieldNames.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((String)fieldNames.get(i));
            }
            this.location.reportSemanticWarning(sb.toString());
        }
    }

    private void checkChoiceType(CompilationTimeStamp aTimestamp, ASN1_Choice_Type aChoiceType) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < aChoiceType.getNofComponents(); ++i) {
            String compName = aChoiceType.getComponentIdentifierByIndex(i).getName();
            fieldNames.add(compName);
        }
        this.selectUnionCases.check(aTimestamp, aChoiceType, fieldNames);
        if (!fieldNames.isEmpty()) {
            StringBuilder sb = new StringBuilder(CASENOTCOVERED);
            for (int i = 0; i < fieldNames.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((String)fieldNames.get(i));
            }
            this.location.reportSemanticWarning(sb.toString());
        }
    }

    private void checkAnytypeType(CompilationTimeStamp aTimestamp, Anytype_Type aAnytypeType) {
        ArrayList<String> typesCovered = new ArrayList<String>();
        for (int i = 0; i < aAnytypeType.getNofComponents(); ++i) {
            String compName = aAnytypeType.getComponentByIndex(i).getIdentifier().getName();
            typesCovered.add(compName);
        }
        this.selectUnionCases.check(aTimestamp, aAnytypeType, typesCovered);
    }

    @Override
    public void checkAllowedInterleave() {
        this.selectUnionCases.checkAllowedInterleave();
    }

    @Override
    public void postCheck() {
        this.selectUnionCases.postCheck();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.expression != null) {
            this.expression.updateSyntax(reparser, false);
            reparser.updateLocation(this.expression.getLocation());
        }
        if (this.selectUnionCases != null) {
            this.selectUnionCases.updateSyntax(reparser, false);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.expression != null) {
            this.expression.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.selectUnionCases != null) {
            this.selectUnionCases.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.expression != null && !this.expression.accept(v)) {
            return false;
        }
        return this.selectUnionCases == null || this.selectUnionCases.accept(v);
    }

    public Value getExpression() {
        return this.expression;
    }

    public SelectUnionCases getSelectUnionCases() {
        return this.selectUnionCases;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expressionStruct = new ExpressionStruct();
        this.expression.generateCodeExpressionMandatory(aData, expressionStruct, true);
        source.append((CharSequence)expressionStruct.preamble);
        source.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", expressionStruct.expression));
        this.selectUnionCases.generateCode(aData, source);
        source.append("}\n");
        source.append((CharSequence)expressionStruct.postamble);
    }
}

