/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clauses;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class If_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".ifclauses";
    private static final String FULLNAMEPART2 = ".elseblock";
    private static final String STATEMENT_NAME = "if";
    private final If_Clauses ifClauses;
    private final StatementBlock statementblock;

    public If_Statement(If_Clauses ifClauses, StatementBlock statementblock) {
        this.ifClauses = ifClauses;
        this.statementblock = statementblock;
        if (ifClauses != null) {
            ifClauses.setFullNameParent(this);
        }
        if (statementblock != null) {
            statementblock.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_IF;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.ifClauses == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.statementblock == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    public If_Clauses getIfClauses() {
        return this.ifClauses;
    }

    public StatementBlock getStatementBlock() {
        return this.statementblock;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.ifClauses != null) {
            this.ifClauses.setMyScope(scope);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.ifClauses != null) {
            this.ifClauses.setCodeSection(codeSection);
        }
        if (this.statementblock != null) {
            this.statementblock.setCodeSection(codeSection);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        if (this.ifClauses != null) {
            this.ifClauses.setMyStatementBlock(statementBlock, index);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.ifClauses != null) {
            this.ifClauses.setMyDefinition(definition);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyDefinition(definition);
        }
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        if (this.ifClauses != null) {
            this.ifClauses.setMyAltguards(altGuards);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyAltguards(altGuards);
        }
    }

    @Override
    protected void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        this.ifClauses.setMyLaicStmt(pAltGuards, pLoopStmt);
        if (this.statementblock != null) {
            this.statementblock.setMyLaicStmt(pAltGuards, pLoopStmt);
        }
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.ifClauses != null) {
            return this.ifClauses.hasReturn(timestamp, this.statementblock);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    @Override
    public boolean hasReceivingStatement() {
        boolean result = false;
        if (this.ifClauses != null) {
            result = this.ifClauses.hasReceivingStatement();
        }
        if (this.statementblock != null) {
            result = result || this.statementblock.hasReceivingStatement(0);
        }
        return result;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        boolean unreachable = false;
        if (this.ifClauses != null) {
            unreachable = this.ifClauses.check(timestamp, unreachable);
        }
        if (this.statementblock != null) {
            this.statementblock.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        if (this.ifClauses != null) {
            this.ifClauses.checkAllowedInterleave();
        }
        if (this.statementblock != null) {
            this.statementblock.checkAllowedInterleave();
        }
    }

    @Override
    public void postCheck() {
        if (this.ifClauses != null) {
            this.ifClauses.postCheck();
        }
        if (this.statementblock != null) {
            this.statementblock.postCheck();
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.statementblock != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(44);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.ifClauses != null) {
            this.ifClauses.updateSyntax(reparser, false);
        }
        if (this.statementblock != null) {
            this.statementblock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementblock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.ifClauses != null) {
            this.ifClauses.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.ifClauses != null && !this.ifClauses.accept(v)) {
            return false;
        }
        return this.statementblock == null || this.statementblock.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        AtomicInteger blockCount = new AtomicInteger(0);
        AtomicBoolean unReachable = new AtomicBoolean(false);
        AtomicBoolean eachFalse = new AtomicBoolean(true);
        this.ifClauses.generateCode(aData, source, blockCount, unReachable, eachFalse);
        if (this.statementblock != null && !unReachable.get()) {
            if (!eachFalse.get()) {
                source.append("else ");
            }
            eachFalse.set(false);
            source.append("{\n");
            blockCount.incrementAndGet();
            this.statementblock.generateCode(aData, source);
        }
        for (int i = 0; i < blockCount.get(); ++i) {
            source.append("}\n");
        }
        if (eachFalse.get()) {
            source.append("/* never occurs */;\n");
        }
    }
}

