/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public class Def_Constructor
extends Def_FunctionBase {
    private static final String KIND = "constructor";
    private static final String DOESNOTHAVESUPERCLASS = "Class type `{0}'' does not have a superclass";
    private static final String CONSTRUCTORREFERENCEEXPECTED = "Reference to constructor was expected instead of {0}";
    private static final String CONSTRUCTORCALLEXPECTED = "Expected call to constructor of class type `{0}'', instead of class type `{1}''";
    private static final String MISSINGSUPERCONSTRUCTORCALL = "Missing super-constructor call";
    private static final String EXTERNALWITHBODY = "The constructor of an external class cannot have a body";
    private static final String MISSINGBODY = "Missing constructor body";
    private Map<Identifier, Boolean> uninitializedMembers = new HashMap<Identifier, Boolean>();
    private Reference baseRef;

    public Def_Constructor(Identifier identifier, FormalParameterList fpl, Reference baseCall, StatementBlock sb) {
        super(identifier, sb, false, false, false, false, fpl, null);
        this.baseRef = baseCall;
    }

    public Def_Constructor(Identifier identifier, FormalParameterList fpl, Type baseCall, StatementBlock sb) {
        this(identifier, fpl, baseCall != null && baseCall instanceof Referenced_Type ? ((Referenced_Type)baseCall).getReference() : null, sb);
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.formalParameterList != null) {
            this.formalParameterList.setMyScope(this.bridgeScope);
            this.formalParameterList.setMyDefinition(this);
            this.bridgeScope.addSubScope(this.formalParameterList.getLocation(), this.formalParameterList);
        }
        if (this.baseRef != null) {
            this.baseRef.setMyScope(this.formalParameterList);
        }
        if (this.statementBlock != null) {
            this.statementBlock.setMyScope(this.formalParameterList);
        }
    }

    public synchronized void addUninitializedMember(Identifier identifier, boolean isTemplate) {
        this.uninitializedMembers.put(identifier, isTemplate);
    }

    @Override
    public String getProposalKind() {
        return null;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_CONSTRUCTOR;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        Def_Constructor baseConstructor;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.removeSyntaxDecoration();
        Class_Type myClass = this.getMyScope().getScopeClass();
        this.formalParameterList.check(timestamp, this.getAssignmentType());
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter fp = this.formalParameterList.getParameterByIndex(i);
            if (!fp.hasDefaultValue()) continue;
        }
        Class_Type baseClass = myClass.getBaseClass();
        if (this.baseRef != null) {
            if (baseClass == null) {
                this.baseRef.getLocation().reportSemanticError(MessageFormat.format(DOESNOTHAVESUPERCLASS, myClass.getTypeRefdLast(timestamp).getTypename()));
            } else {
                Assignment baseCallAssignment = this.baseRef.getRefdAssignment(timestamp, true);
                if (baseCallAssignment != null) {
                    if (baseCallAssignment.getAssignmentType() != Assignment.Assignment_type.A_CONSTRUCTOR) {
                        this.baseRef.getLocation().reportSemanticError(MessageFormat.format(CONSTRUCTORREFERENCEEXPECTED, baseCallAssignment.getAssignmentName()));
                    } else {
                        Class_Type baseCallClass = baseCallAssignment.getMyScope().getScopeClass();
                        if (baseCallClass != baseClass) {
                            this.baseRef.getLocation().reportSemanticError(MessageFormat.format(CONSTRUCTORCALLEXPECTED, myClass.getTypename(), baseCallClass.getTypename()));
                        }
                    }
                }
            }
        } else if (baseClass != null && !myClass.isExternal() && (baseConstructor = baseClass.getConstructor(timestamp)) != null && !baseConstructor.getFormalParameterList().hasOnlyDefaultValues()) {
            this.signatureLocation.reportSemanticError(MISSINGSUPERCONSTRUCTORCALL);
        }
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter fp = this.formalParameterList.getParameterByIndex(i);
            if (!fp.hasDefaultValue()) continue;
            fp.reset();
        }
        if (this.statementBlock != null) {
            if (myClass.isExternal()) {
                this.statementBlock.getLocation().reportSemanticError(EXTERNALWITHBODY);
            }
            this.statementBlock.check(timestamp);
        } else if (!myClass.isExternal()) {
            this.signatureLocation.reportSemanticError(MISSINGBODY);
        }
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
    }

    @Override
    public FormalParameterList.IsIdenticalResult isIdentical(CompilationTimeStamp timestamp, Def_FunctionBase other) {
        return null;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.formalParameterList == null || this.formalParameterList.accept(v);
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        this.hoverContent.addIcon(this.getOutlineIcon()).addStyledText(KIND, 1).addText(" ").addStyledText(this.getFullName(), 1).addText("(");
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter fp = this.formalParameterList.getParameterByIndex(i);
            if (i > 0) {
                this.hoverContent.addText(", ");
            }
            this.hoverContent.addText(fp.getFormalParamType()).addText(" ").addText(fp.getType(this.lastTimeChecked).getTypename()).addText(" ").addText(fp.getIdentifier().getDisplayName());
        }
        this.hoverContent.addText(")");
        this.hoverContent.closeHeader();
        this.getHoverContentFromComment(this.hoverContent, dc, this.formalParameterList);
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        return this.generateCommonDocComment(indentation, this.formalParameterList, null);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParameterList != null) {
            this.formalParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementBlock != null) {
            this.statementBlock.findReferences(referenceFinder, foundIdentifiers);
        }
    }
}

