/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Scope;

class ScopeTreeNode {
    Scope scope;
    List<ScopeTreeNode> children = new ArrayList<ScopeTreeNode>();
    List<Assignment> assignments = new ArrayList<Assignment>();

    public ScopeTreeNode(Scope scope) {
        this.scope = scope;
    }

    public void add(Scope s, Assignment a) {
        ArrayList<Scope> scopePath = new ArrayList<Scope>();
        for (Scope tempScope = s; tempScope != null; tempScope = tempScope.getParentScope()) {
            scopePath.add(tempScope);
        }
        this.addPath(scopePath, a);
    }

    void addPath(List<Scope> scopePath, Assignment a) {
        if (scopePath.isEmpty()) {
            if (a != null) {
                this.assignments.add(a);
            }
            return;
        }
        Scope lastParent = scopePath.remove(scopePath.size() - 1);
        for (ScopeTreeNode stn : this.children) {
            if (stn.scope != lastParent) continue;
            stn.addPath(scopePath, a);
            lastParent = null;
            break;
        }
        if (lastParent != null) {
            ScopeTreeNode newChild = new ScopeTreeNode(lastParent);
            this.children.add(newChild);
            newChild.addPath(scopePath, a);
        }
    }

    public void printTreeAsHTML(StringBuilder sb) {
        if (this.scope != null) {
            sb.append("<li><b>").append(this.scope.getClass().getSimpleName()).append("</b> <i>").append(this.scope.getFullName()).append("</i>");
        }
        if (!this.assignments.isEmpty()) {
            sb.append("<ul>");
            for (Assignment a : this.assignments) {
                sb.append("<li><font color='blue'>").append(a.getClass().getSimpleName()).append(" : <u>").append(a.getIdentifier()).append("</u></font></li>");
            }
            sb.append("</ul>");
        }
        if (!this.children.isEmpty()) {
            sb.append("<ul>");
            for (ScopeTreeNode stn : this.children) {
                stn.printTreeAsHTML(sb);
            }
            sb.append("</ul>");
        }
    }
}

