/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.DocumentTracker;
import org.eclipse.titan.designer.editors.controls.PeekSource;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ProjectStructureDataCollector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public abstract class Module
extends Scope
implements IOutlineElement,
ILocateableNode,
IReferencingElement,
IPositionUpdater {
    public static final String MODULE = "module";
    protected IProject project;
    protected Identifier identifier;
    protected String name;
    protected Location location;
    private boolean isSkippedFromSemanticChecking = false;
    protected CompilationTimeStamp lastCompilationTimeStamp;
    protected CompilationTimeStamp lastImportCheckTimeStamp;
    private TTCN3Editor editor;
    private boolean canBeCheckRoot = true;

    public Module(Identifier identifier, IProject project) {
        this.project = project;
        this.identifier = identifier;
        this.name = identifier == null ? null : this.identifier.getName();
        this.scopeName = identifier == null ? "unknown module" : identifier.getDisplayName();
        this.setScopeMacroName(identifier == null ? "unknown module" : identifier.getDisplayName());
        AbstractDecoratedTextEditor editor = DocumentTracker.get(this);
        if (editor != null && editor instanceof TTCN3Editor) {
            this.editor = (TTCN3Editor)editor;
        }
    }

    public abstract module_type getModuletype();

    public String getName() {
        return this.name;
    }

    public final IProject getProject() {
        return this.project;
    }

    public final CompilationTimeStamp getLastImportationCheckTimeStamp() {
        return this.lastImportCheckTimeStamp;
    }

    public final CompilationTimeStamp getLastCompilationTimeStamp() {
        return this.lastCompilationTimeStamp;
    }

    public final boolean isCheckRoot() {
        return this.canBeCheckRoot;
    }

    public final void checkRoot() {
        this.canBeCheckRoot = true;
    }

    public final void notCheckRoot() {
        this.canBeCheckRoot = false;
    }

    public final void setSkippedFromSemanticChecking(boolean state) {
        this.isSkippedFromSemanticChecking = state;
    }

    public final boolean getSkippedFromSemanticChecking() {
        return this.isSkippedFromSemanticChecking;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Module getModuleScope() {
        return this;
    }

    @Override
    public Module getModuleScopeGen() {
        return this;
    }

    public abstract Assignments getAssignments();

    public abstract Def_Type getAnytype();

    public abstract void check(CompilationTimeStamp var1);

    public abstract void checkImports(CompilationTimeStamp var1, ModuleImportationChain var2, List<Module> var3);

    public abstract List<Module> getImportedModules();

    public abstract boolean hasUnhandledImportChanges();

    public abstract boolean hasImportedAssignmentWithID(CompilationTimeStamp var1, Identifier var2);

    public abstract Assignment importAssignment(CompilationTimeStamp var1, Identifier var2, Reference var3);

    public abstract boolean isVisible(CompilationTimeStamp var1, Identifier var2, Assignment var3);

    public abstract void postCheck();

    public String chainedDescription() {
        if (this.identifier != null) {
            return "`" + this.identifier.getDisplayName() + '\'';
        }
        return this.toString();
    }

    @Override
    public int category() {
        return 0;
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    public abstract void extractStructuralInformation(ProjectStructureDataCollector var1);

    protected boolean memberAccept(ASTVisitor v) {
        return this.identifier == null || this.identifier.accept(v);
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (!this.memberAccept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }

    @Override
    public Declaration getDeclaration() {
        return Declaration.createInstance(this);
    }

    public abstract boolean shouldBeGenerated();

    public abstract void generateCode(JavaGenData var1);

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        this.hoverContent = new Ttcn3HoverContent();
        if (editor != null) {
            PeekSource.addStyledSource(PeekSource.getPeekSource(editor, this.getLocation()), this.hoverContent);
        }
        return this.hoverContent;
    }

    public void update(DocumentEvent event) {
    }

    public static enum module_type {
        ASN_MODULE,
        TTCN3_MODULE;

    }
}

