/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Governed;
import org.eclipse.titan.designer.AST.IGovernedSimple;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;

public abstract class GovernedSimple
extends Governed
implements IGovernedSimple {
    private String genNamePrefix;
    private CodeSectionType codeSection = CodeSectionType.CS_UNKNOWN;
    protected BuildTimestamp lastTimeGenerated = null;
    protected boolean needs_conversion = false;

    @Override
    public void setGenNamePrefix(String prefix) {
        this.genNamePrefix = prefix;
    }

    @Override
    public CodeSectionType getCodeSection() {
        return this.codeSection;
    }

    @Override
    public void setCodeSection(CodeSectionType codeSection) {
        this.codeSection = codeSection;
    }

    @Override
    public BuildTimestamp getLastTimeBuilt() {
        return this.lastTimeGenerated;
    }

    @Override
    public boolean get_needs_conversion() {
        return this.needs_conversion;
    }

    @Override
    public void set_needs_conversion() {
        this.needs_conversion = true;
    }

    @Override
    public String get_lhs_name() {
        StringBuilder builder = new StringBuilder();
        if (this.genNamePrefix != null) {
            builder.append(this.genNamePrefix);
        }
        builder.append(this.getGenNameOwn());
        return builder.toString();
    }

    public boolean needsInitPrecede(JavaGenData aData, IGovernedSimple refd) {
        if (refd.getLastTimeBuilt() != null && !refd.getLastTimeBuilt().isLess(aData.getBuildTimstamp())) {
            return false;
        }
        if (this.codeSection == CodeSectionType.CS_UNKNOWN || refd.getCodeSection() == CodeSectionType.CS_UNKNOWN) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for value `" + this.getFullName() + "'', reached needsInitPreccede with `" + refd.getFullName() + "''"));
            return false;
        }
        if (this.codeSection != refd.getCodeSection()) {
            return false;
        }
        return this.getMyScope().getModuleScopeGen() == refd.getMyScope().getModuleScopeGen();
    }

    @Override
    public boolean isTopLevel() {
        String name = this.getGenNameOwn();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static enum CodeSectionType {
        CS_UNKNOWN,
        CS_PRE_INIT,
        CS_POST_INIT,
        CS_INIT_COMP,
        CS_INLINE;

    }
}

