/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.types.CTs_EE_CTs;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class ASN1_Set_Seq_Choice_BaseType
extends ASN1Type
implements ITypeWithComponents,
IReferenceableElement {
    protected Block mBlock;
    protected CTs_EE_CTs components;
    private boolean insideCanHaveCoding = false;

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    public CompField getComponentByName(Identifier identifier) {
        if (null == this.components) {
            return null;
        }
        return this.components.getCompByName(identifier);
    }

    public abstract int getNofComponents();

    public boolean hasComponentWithName(Identifier identifier) {
        if (null == this.components) {
            return false;
        }
        return this.components.hasCompWithName(identifier);
    }

    public int getComponentIndexByName(Identifier identifier) {
        for (int i = 0; i < this.components.getNofComps(); ++i) {
            if (!this.components.getCompByIndex(i).getIdentifier().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    public CompField getComponentByIndex(int index) {
        return this.components.getCompByIndex(index);
    }

    public Identifier getComponentIdentifierByIndex(int index) {
        return this.components.getCompByIndex(index).getIdentifier();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.components) {
            this.components.setMyScope(scope);
        }
    }

    @Override
    public Location getLikelyLocation() {
        if (this.mBlock != null) {
            return this.mBlock.getLocation();
        }
        return this.location;
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.components == null) {
            return;
        }
        this.components.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.components != null) {
            this.components.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.components == null || this.components.accept(v);
    }

    @Override
    public Identifier getComponentIdentifierByName(Identifier identifier) {
        CompField cf = this.getComponentByName(identifier);
        return cf == null ? null : cf.getIdentifier();
    }

    @Override
    public Declaration resolveReference(Reference reference, int subRefIdx, ISubReference lastSubreference) {
        int actualIndex;
        List<ISubReference> subreferences = reference.getSubreferences();
        for (actualIndex = subRefIdx; actualIndex < subreferences.size() && subreferences.get(actualIndex) instanceof ArraySubReference; ++actualIndex) {
        }
        if (actualIndex == subreferences.size()) {
            return null;
        }
        Identifier fieldID = subreferences.get(actualIndex).getId();
        if (subreferences.get(actualIndex) == lastSubreference) {
            return Declaration.createInstance(this.getDefiningAssignment(), fieldID);
        }
        CompField compField = this.getComponentByName(fieldID);
        IType compFieldType = compField.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (compFieldType instanceof IReferenceableElement) {
            Declaration decl = ((IReferenceableElement)((Object)compFieldType)).resolveReference(reference, actualIndex + 1, lastSubreference);
            return decl != null ? decl : Declaration.createInstance(this.getDefiningAssignment(), compField.getIdentifier());
        }
        return null;
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.components.getCompByName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addDeclaration(declarationCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.components.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    declarationCollector.addDeclaration(compField.getIdentifier().getDisplayName(), compField.getIdentifier().getLocation(), this);
                }
            }
        }
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            type.checkMapParameter(timestamp, refChain, errorLocation);
        }
    }

    @Override
    public Object[] getOutlineChildren() {
        if (this.components == null) {
            return new Object[0];
        }
        return this.components.getOutlineChildren();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i || this.components == null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.components.getCompByName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addProposal(propCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.components.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    String proposalKind = compField.getType().getProposalDescription(new StringBuilder()).toString();
                    propCollector.addProposal(compField.getIdentifier(), " - " + proposalKind, ImageCache.getImage(this.getOutlineIcon()), proposalKind);
                }
            }
        }
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                typeArray.add(this);
                return fieldType.getFieldTypesAsArray(reference, actualSubReference + 1, typeArray);
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        int i;
        if (this.insideCanHaveCoding) {
            return true;
        }
        this.insideCanHaveCoding = true;
        for (i = 0; i < this.codingTable.size(); ++i) {
            IType.Coding_Type tempCodingType = (IType.Coding_Type)this.codingTable.get(i);
            if (!tempCodingType.builtIn || !tempCodingType.builtInCoding.equals((Object)coding)) continue;
            this.insideCanHaveCoding = false;
            return true;
        }
        if (this.components == null) {
            this.insideCanHaveCoding = false;
            return false;
        }
        for (i = 0; i < this.components.getNofComps(); ++i) {
            CompField compField = this.components.getCompByIndex(i);
            if (compField.getType().getTypeRefdLast(timestamp).canHaveCoding(timestamp, coding)) continue;
            this.insideCanHaveCoding = false;
            return false;
        }
        this.insideCanHaveCoding = false;
        return true;
    }

    @Override
    public void setGenerateCoderFunctions(CompilationTimeStamp timestamp, IType.MessageEncoding_type encodingType) {
        switch (encodingType) {
            case RAW: 
            case JSON: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.getGenerateCoderFunctions(encodingType)) {
            return;
        }
        this.codersToGenerate.add(encodingType);
        for (int i = 0; i < this.components.getNofComps(); ++i) {
            CompField compField = this.components.getCompByIndex(i);
            compField.getType().getTypeRefdLast(timestamp).setGenerateCoderFunctions(timestamp, encodingType);
        }
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "_json_";
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        boolean nextOptional;
        ISubReference subReference;
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        StringBuilder closingBrackets = new StringBuilder();
        if (isTemplate) {
            boolean anyvalueReturnValue = true;
            if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                anyvalueReturnValue = this.isPresentAnyvalueEmbeddedField(expression, subreferences, subReferenceIndex);
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION || optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                anyvalueReturnValue = false;
            }
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", externalId));
            expression.expression.append("case UNINITIALIZED_TEMPLATE:\n");
            expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
            expression.expression.append("break;\n");
            expression.expression.append("case ANY_VALUE:\n");
            expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, anyvalueReturnValue ? "true" : "false"));
            expression.expression.append("break;\n");
            expression.expression.append("case SPECIFIC_VALUE:{\n");
            closingBrackets.append("break;}\n");
            closingBrackets.append("default:\n");
            closingBrackets.append(MessageFormat.format("{0} = false;\n", globalId));
            closingBrackets.append("break;\n");
            closingBrackets.append("}\n");
            closingBrackets.append("}\n");
        }
        if (!((subReference = subreferences.get(subReferenceIndex)) instanceof FieldSubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        Identifier fieldId = ((FieldSubReference)subReference).getId();
        CompField compField = this.getComponentByName(fieldId);
        Type nextType = compField.getType();
        String nextTypeGenName = isTemplate ? nextType.getGenNameTemplate(aData, expression.expression) : nextType.getGenNameValue(aData, expression.expression);
        boolean bl = nextOptional = !isTemplate && compField.isOptional();
        if (nextOptional) {
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            closingBrackets.insert(0, "}\n");
            String temporalId = aData.getTemporaryVariableName();
            aData.addBuiltinTypeImport("Optional");
            expression.expression.append(MessageFormat.format("final Optional<{0}> {1} = {2}.get_field_{3}();\n", nextTypeGenName, temporalId, externalId, FieldSubReference.getJavaGetterName(fieldId.getName())));
            if (subReferenceIndex == subreferences.size() - 1) {
                expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", temporalId));
                expression.expression.append("case OPTIONAL_UNBOUND:\n");
                expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
                expression.expression.append("break;\n");
                expression.expression.append("case OPTIONAL_OMIT:\n");
                expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, optype == Expression_Value.Operation_type.ISBOUND_OPERATION ? "true" : "false"));
                expression.expression.append("break;\n");
                expression.expression.append("default:\n");
                expression.expression.append("{\n");
                String temporalId2 = aData.getTemporaryVariableName();
                expression.expression.append(MessageFormat.format("final {0} {1} = {2}.constGet();\n", nextTypeGenName, temporalId2, temporalId));
                if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId2, isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
                } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_present({2});\n", globalId, temporalId2, isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
                } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId2, field));
                }
                expression.expression.append("break;}\n");
                expression.expression.append("}\n");
                nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
            } else {
                expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", temporalId));
                expression.expression.append("case OPTIONAL_UNBOUND:\n");
                expression.expression.append("case OPTIONAL_OMIT:\n");
                expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
                expression.expression.append("break;\n");
                expression.expression.append("default:\n");
                expression.expression.append("break;\n");
                expression.expression.append("}\n");
                expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
                closingBrackets.insert(0, "}\n");
                String temporalId2 = aData.getTemporaryVariableName();
                expression.expression.append(MessageFormat.format("final {0} {1} = {2}.constGet();\n", nextTypeGenName, temporalId2, temporalId));
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
            }
        } else {
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            closingBrackets.insert(0, "}\n");
            String temporalId = aData.getTemporaryVariableName();
            String temporalId2 = aData.getTemporaryVariableName();
            String currentTypeGenName = isTemplate ? this.getGenNameTemplate(aData, expression.expression) : this.getGenNameValue(aData, expression.expression);
            expression.expression.append(MessageFormat.format("final {0} {1} = {2};\n", currentTypeGenName, temporalId, externalId));
            expression.expression.append(MessageFormat.format("final {0} {1} = {2}.get_field_{3}();\n", nextTypeGenName, temporalId2, temporalId, FieldSubReference.getJavaGetterName(fieldId.getName())));
            if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
            }
            if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId2));
            } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.{2}({3});\n", globalId, temporalId2, subReferenceIndex != subreferences.size() - 1 ? "is_bound" : "is_present", subReferenceIndex == subreferences.size() - 1 && isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                if (subReferenceIndex == subreferences.size() - 1) {
                    expression.expression.append(MessageFormat.format("if ({0}) '{'\n", globalId));
                    expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId2, field));
                    expression.expression.append("}\n");
                }
            }
            nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
        }
        expression.expression.append((CharSequence)closingBrackets);
    }

    protected String generateConversionTTCNSetSeqToASNSetSeq(JavaGenData aData, TTCN3_Set_Seq_Choice_BaseType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            for (int i = 0; i < this.getNofComponents(); ++i) {
                CompField toComp = this.getComponentByIndex(i);
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier toFieldName = toComp.getIdentifier();
                Identifier fromFieldName = fromComp.getIdentifier();
                IType toFieldType = toComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                String tempId2 = aData.getTemporaryVariableName();
                String fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_field_{2}(){3};\n", fromFieldTypeName, tempId2, FieldSubReference.getJavaGetterName(fromFieldName.getName()), forValue && fromComp.isOptional() ? ".constGet()" : ""));
                conversionFunctionBody.append(MessageFormat.format("\t\tif({0}.is_bound()) '{'\n", tempId2));
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = toFieldType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\tto.get_field_{0}().operator_assign({1});\n", FieldSubReference.getJavaGetterName(toFieldName.getName()), tempId3));
                conversionFunctionBody.append("\t\t}\n");
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    protected String generateConversionASNSetSeqToASNSetSeq(JavaGenData aData, ASN1_Set_Seq_Choice_BaseType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            for (int i = 0; i < this.getNofComponents(); ++i) {
                CompField toComp = this.getComponentByIndex(i);
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier toFieldName = toComp.getIdentifier();
                Identifier fromFieldName = fromComp.getIdentifier();
                IType toFieldType = toComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                String tempId2 = aData.getTemporaryVariableName();
                String fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_field_{2}(){3};\n", fromFieldTypeName, tempId2, FieldSubReference.getJavaGetterName(fromFieldName.getName()), forValue && fromComp.isOptional() ? ".constGet()" : ""));
                conversionFunctionBody.append(MessageFormat.format("\t\tif({0}.is_bound()) '{'\n", tempId2));
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = toFieldType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\tto.get_field_{0}().operator_assign({1});\n", FieldSubReference.getJavaGetterName(toFieldName.getName()), tempId3));
                conversionFunctionBody.append("\t\t}\n");
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }
}

