/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Symbols
implements IVisitableNode {
    public static final String DUPLICATESYMBOLFIRST = "Duplicate symbol with name `{0}'' was first declared here";
    public static final String DUPLICATESYMBOLREPEATED = "Duplicate symbol with name `{0}'' was declared here again";
    private final ArrayList<Identifier> symbols_v = new ArrayList();
    private final HashMap<String, Identifier> symbols_map = new HashMap();
    private CompilationTimeStamp lastTimeChecked;

    public void addSymbol(Identifier id) {
        if (null != id && null != id.getName()) {
            this.symbols_v.add(id);
        }
    }

    public int size() {
        return this.symbols_v.size();
    }

    public Identifier getNthElement(int index) {
        return this.symbols_v.get(index);
    }

    public boolean hasSymbol(String name) {
        if (null == this.lastTimeChecked) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.symbols_map.containsKey(name);
    }

    public void checkUniqueness(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.symbols_map.clear();
        this.symbols_v.trimToSize();
        for (Identifier id : this.symbols_v) {
            String name = id.getName();
            if (this.symbols_map.containsKey(name)) {
                Location location = this.symbols_map.get(name).getLocation();
                location.reportSingularSemanticError(MessageFormat.format(DUPLICATESYMBOLFIRST, id.getDisplayName()));
                id.getLocation().reportSemanticError(MessageFormat.format(DUPLICATESYMBOLREPEATED, id.getDisplayName()));
                continue;
            }
            this.symbols_map.put(name, id);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.symbols_v != null) {
            for (Identifier id : this.symbols_v) {
                if (id.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }
}

