/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;
import org.eclipse.titan.designer.parsers.asn1parser.FormalParameter_Helper;

public final class Ass_pard
implements IIdentifierContainer,
IVisitableNode {
    private final Block mParameterList;
    private ArrayList<FormalParameter_Helper> mParameters;
    private final Map<Module, Integer> instance_counters = new HashMap<Module, Integer>();
    private CompilationTimeStamp lastTimeChecked;
    private boolean isErroneous = false;
    private static final Set<Ass_pard> INSTANCED_PARAMETERIZED_ASSIGNMENTS = new HashSet<Ass_pard>();

    public Ass_pard(Block aParameterListV4) {
        this.mParameterList = aParameterListV4;
    }

    public int newInstanceNumber(Module module) {
        int value = 0;
        if (this.instance_counters.containsKey(module)) {
            value = this.instance_counters.get(module);
        }
        this.instance_counters.put(module, ++value);
        INSTANCED_PARAMETERIZED_ASSIGNMENTS.add(this);
        return value;
    }

    public void resetInstanceCounter() {
        this.instance_counters.clear();
    }

    public static void resetAllInstanceCounters() {
        for (Ass_pard pard : INSTANCED_PARAMETERIZED_ASSIGNMENTS) {
            pard.resetInstanceCounter();
        }
        INSTANCED_PARAMETERIZED_ASSIGNMENTS.clear();
    }

    public List<FormalParameter_Helper> getFormalParameters(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (null == this.mParameters) {
            return new ArrayList<FormalParameter_Helper>();
        }
        return this.mParameters;
    }

    public void check(CompilationTimeStamp timestamp) {
        if (!(null == this.lastTimeChecked || this.isErroneous && this.lastTimeChecked.isLess(timestamp))) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        if (null == this.mParameterList) {
            this.isErroneous = true;
            return;
        }
        if (null != this.mParameters) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mParameterList);
        this.mParameters = parser.pr_special_FormalParameterList().parameters;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.mParameters = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mParameterList.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (null == this.mParameters) {
            this.isErroneous = true;
        } else {
            this.mParameters.trimToSize();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return v.leave(this) != 2;
    }
}

