/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.semicolon;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titanium.refactoring.semicolon.ChangeCreator;

public class AddSemicolonRefactoring
extends Refactoring {
    private static final String ONTHEFLYANALAYSISDISABLED = "The on-the-fly analysis is disabled, there is semantic information present to work on";
    public static final String PROJECTCONTAINSERRORS = "The project `{0}'' contains errors, which might corrupt the result of the refactoring";
    private static final String PROJECTCONTAINSTTCNPPFILES = "The project `{0}'' contains .ttcnpp files, which might corrupt the result of the refactoring";
    private Object[] affectedObjects;
    private final IStructuredSelection selection;
    private final Set<IProject> projects = new HashSet<IProject>();

    public AddSemicolonRefactoring(IStructuredSelection selection) {
        this.selection = selection;
        for (Object o : selection) {
            if (!(o instanceof IResource)) continue;
            IProject temp = ((IResource)o).getProject();
            this.projects.add(temp);
        }
    }

    public Object[] getAffectedObjects() {
        return this.affectedObjects;
    }

    public String getName() {
        return "Add semicolon modifiers";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            pm.beginTask("Checking preconditions...", 2);
            IPreferencesService prefs = Platform.getPreferencesService();
            if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", false, null)) {
                result.addError(ONTHEFLYANALAYSISDISABLED);
            }
            for (IProject project : this.projects) {
                if (!GlobalParser.hasTtcnppFiles((IResource)project)) continue;
                result.addError(MessageFormat.format(PROJECTCONTAINSTTCNPPFILES, project));
            }
            pm.worked(1);
            block6: for (IProject project : this.projects) {
                IMarker[] markers;
                for (IMarker marker : markers = project.findMarkers(null, true, 2)) {
                    if (2 != marker.getAttribute("severity", 2)) continue;
                    result.addError(MessageFormat.format(PROJECTCONTAINSERRORS, project));
                    continue block6;
                }
            }
            pm.worked(1);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            result.addFatalError(e.getMessage());
        }
        finally {
            pm.done();
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.selection != null) {
            CompositeChange cchange = new CompositeChange("AddSemicolonRefactoring");
            for (Object o : this.selection) {
                if (!(o instanceof IResource)) continue;
                IResource res = (IResource)o;
                ResourceVisitor vis = new ResourceVisitor();
                res.accept((IResourceVisitor)vis);
                cchange.add((Change)vis.getChange());
            }
            this.affectedObjects = cchange.getAffectedObjects();
            return cchange;
        }
        return null;
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private final CompositeChange change = new CompositeChange("AddSemicolonRefactoring");

        private CompositeChange getChange() {
            return this.change;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                ChangeCreator chCreator = new ChangeCreator((IFile)resource);
                chCreator.perform();
                Change ch = chCreator.getChange();
                if (ch != null) {
                    this.change.add(ch);
                }
            }
            return true;
        }
    }
}

