/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.preferences.pages;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titanium.Activator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GraphClusterPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Settings for the module graph clustering tools\n\nThe preferences of the clustering algorithms can be set on the sub-pages.\n\nClustering by folder name \nModules in the same folder will belong to the same cluster.\n\nClustering using regular expressions \nModules, whose name match a given regular expression will belong to the same cluster.\n\nClustering by module names \nModule names are split, and a nested sequence of clusters is created.\nA module will belong to the narrowest cluster forming a hierarchy.\n\nClustering automatically \nTriest to improve the clustering of the existing tools.\nA clustering is consdered better if there are more edges inside clusters, and less between.";

    public GraphClusterPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
        this.noDefaultAndApplyButton();
    }

    protected Composite setupLabel(Composite page, String text, String hint) {
        Group header = new Group(page, 0);
        header.setText(text);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        header.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, false);
        header.setLayoutData((Object)gridData);
        header.setToolTipText(hint);
        Composite composite = new Composite((Composite)header, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 3;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    protected void setupBooleanEditor(Composite comp, String pref, String text, String hint) {
        BooleanFieldEditor editor = new BooleanFieldEditor(pref, text, comp);
        editor.getDescriptionControl(comp).setToolTipText(hint);
        editor.fillIntoGrid(comp, 2);
        this.addField((FieldEditor)editor);
    }

    protected void setupIntegerEditor(Composite comp, String pref, String text, String hint) {
        IntegerFieldEditor editor = new IntegerFieldEditor(pref, text, comp);
        editor.getLabelControl(comp).setToolTipText(hint);
        this.addField((FieldEditor)editor);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void createFieldEditors() {
    }
}

