/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanExternal_identification;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanExternal
extends Base_Type {
    public static final Base_Type.TTCN_Typedescriptor TitanExternal_descr_ = new Base_Type.TTCN_Typedescriptor("EXTERNAL");
    public static final Base_Type.TTCN_Typedescriptor TitanExternal_data__value__descriptor_descr_ = new Base_Type.TTCN_Typedescriptor("EXTERNAL.data-value-descriptor");
    public static final Base_Type.TTCN_Typedescriptor TitanExternal_data__value_descr_ = new Base_Type.TTCN_Typedescriptor("EXTERNAL.data-value", null, TitanOctetString.TitanOctetString_raw_, TitanOctetString.TitanOctetString_json_);
    public static final TitanUniversalCharString TitanExternal_data__value_default_coding = new TitanUniversalCharString("JSON");
    private final TitanExternal_identification identification;
    private final Optional<TitanUniversalCharString> data__value__descriptor;
    private final TitanOctetString data__value;

    public TitanExternal() {
        this.identification = new TitanExternal_identification();
        this.data__value__descriptor = new Optional<TitanUniversalCharString>(TitanUniversalCharString.class);
        this.data__value = new TitanOctetString();
    }

    public TitanExternal(TitanExternal_identification identification, Optional<TitanUniversalCharString> data__value__descriptor, TitanOctetString data__value) {
        this.identification = new TitanExternal_identification(identification);
        this.data__value__descriptor = new Optional<TitanUniversalCharString>(TitanUniversalCharString.class);
        this.data__value__descriptor.operator_assign((Optional)data__value__descriptor);
        this.data__value = new TitanOctetString(data__value);
    }

    public TitanExternal(TitanExternal otherValue) {
        otherValue.must_bound("Copying of an unbound value of type EXTERNAL.");
        this.identification = new TitanExternal_identification();
        this.data__value__descriptor = new Optional<TitanUniversalCharString>(TitanUniversalCharString.class);
        this.data__value = new TitanOctetString();
        this.operator_assign(otherValue);
    }

    public TitanExternal operator_assign(TitanExternal otherValue) {
        otherValue.must_bound("Assignment of an unbound value of type EXTERNAL");
        if (otherValue != this) {
            if (otherValue.get_field_identification().is_bound()) {
                this.identification.operator_assign(otherValue.get_field_identification());
            } else {
                this.identification.clean_up();
            }
            if (otherValue.get_field_data__value__descriptor().is_bound()) {
                this.data__value__descriptor.operator_assign((Optional)otherValue.get_field_data__value__descriptor());
            } else {
                this.data__value__descriptor.clean_up();
            }
            if (otherValue.get_field_data__value().is_bound()) {
                this.data__value.operator_assign(otherValue.get_field_data__value());
            } else {
                this.data__value.clean_up();
            }
        }
        return this;
    }

    @Override
    public TitanExternal operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanExternal) {
            return this.operator_assign((TitanExternal)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to EXTERNAL", otherValue));
    }

    @Override
    public void clean_up() {
        this.identification.clean_up();
        this.data__value__descriptor.clean_up();
        this.data__value.clean_up();
    }

    @Override
    public boolean is_bound() {
        return this.identification.is_bound() || Optional.optional_sel.OPTIONAL_OMIT.equals((Object)this.data__value__descriptor.get_selection()) || this.data__value__descriptor.is_bound() || this.data__value.is_bound();
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_value() {
        return this.identification.is_value() && (Optional.optional_sel.OPTIONAL_OMIT.equals((Object)this.data__value__descriptor.get_selection()) || this.data__value__descriptor.is_value()) && this.data__value.is_value();
    }

    public boolean operator_equals(TitanExternal other_value) {
        return this.identification.operator_equals(other_value.identification) && this.data__value__descriptor.operator_equals(other_value.data__value__descriptor) && this.data__value.operator_equals(other_value.data__value);
    }

    @Override
    public boolean operator_equals(Base_Type other_value) {
        if (other_value instanceof TitanExternal) {
            return this.operator_equals((TitanExternal)other_value);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to EXTERNAL", other_value));
    }

    public boolean operator_not_equals(TitanExternal other_value) {
        return !this.operator_equals(other_value);
    }

    public TitanExternal_identification get_field_identification() {
        return this.identification;
    }

    public TitanExternal_identification constGet_field_identification() {
        return this.identification;
    }

    public Optional<TitanUniversalCharString> get_field_data__value__descriptor() {
        return this.data__value__descriptor;
    }

    public Optional<TitanUniversalCharString> constGet_field_data__value__descriptor() {
        return this.data__value__descriptor;
    }

    public TitanOctetString get_field_data__value() {
        return this.data__value;
    }

    public TitanOctetString constGet_field_data__value() {
        return this.data__value;
    }

    public TitanInteger size_of() {
        int sizeof = 2;
        if (this.data__value__descriptor.ispresent()) {
            ++sizeof;
        }
        return new TitanInteger(sizeof);
    }

    @Override
    public void log() {
        if (!this.is_bound()) {
            TTCN_Logger.log_event_unbound();
            return;
        }
        TTCN_Logger.log_char('{');
        TTCN_Logger.log_event_str(" identification := ");
        this.identification.log();
        TTCN_Logger.log_char(',');
        TTCN_Logger.log_event_str(" data-value-descriptor := ");
        this.data__value__descriptor.log();
        TTCN_Logger.log_char(',');
        TTCN_Logger.log_event_str(" data-value := ");
        this.data__value.log();
        TTCN_Logger.log_event_str(" }");
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "set value");
        block0 : switch (param.get_type()) {
            case MP_Value_List: {
                if (param.get_size() > 3) {
                    param.error(MessageFormat.format("set value of type EXTERNAL has 3 fields but list value has {0} fields.", param.get_size()), new Object[0]);
                }
                if (param.get_size() > 0 && param.get_elem(0).get_type() != Param_Types.Module_Parameter.type_t.MP_NotUsed) {
                    this.get_field_identification().set_param(param.get_elem(0));
                }
                if (param.get_size() > 1 && param.get_elem(1).get_type() != Param_Types.Module_Parameter.type_t.MP_NotUsed) {
                    this.get_field_data__value__descriptor().set_param(param.get_elem(1));
                }
                if (param.get_size() <= 2 || param.get_elem(2).get_type() == Param_Types.Module_Parameter.type_t.MP_NotUsed) break;
                this.get_field_data__value().set_param(param.get_elem(2));
                break;
            }
            case MP_Assignment_List: {
                Param_Types.Module_Parameter curr_param;
                int val_idx;
                boolean[] value_used = new boolean[param.get_size()];
                for (val_idx = 0; val_idx < param.get_size(); ++val_idx) {
                    curr_param = param.get_elem(val_idx);
                    if (!"identification".equals(curr_param.get_id().get_name())) continue;
                    if (curr_param.get_type() != Param_Types.Module_Parameter.type_t.MP_NotUsed) {
                        this.get_field_identification().set_param(curr_param);
                    }
                    value_used[val_idx] = true;
                }
                for (val_idx = 0; val_idx < param.get_size(); ++val_idx) {
                    curr_param = param.get_elem(val_idx);
                    if (!"data-value-descriptor".equals(curr_param.get_id().get_name())) continue;
                    if (curr_param.get_type() != Param_Types.Module_Parameter.type_t.MP_NotUsed) {
                        this.get_field_data__value__descriptor().set_param(curr_param);
                    }
                    value_used[val_idx] = true;
                }
                for (val_idx = 0; val_idx < param.get_size(); ++val_idx) {
                    curr_param = param.get_elem(val_idx);
                    if (!"data-value".equals(curr_param.get_id().get_name())) continue;
                    if (curr_param.get_type() != Param_Types.Module_Parameter.type_t.MP_NotUsed) {
                        this.get_field_data__value().set_param(curr_param);
                    }
                    value_used[val_idx] = true;
                }
                for (val_idx = 0; val_idx < param.get_size(); ++val_idx) {
                    if (value_used[val_idx]) continue;
                    curr_param = param.get_elem(val_idx);
                    curr_param.error(MessageFormat.format("Non existent field name in type EXTERNAL: {0}", curr_param.get_id().get_name()), new Object[0]);
                    break block0;
                }
                break;
            }
            default: {
                param.type_error("set value", "EXTERNAL");
            }
        }
    }

    @Override
    public void set_implicit_omit() {
        if (this.identification.is_bound()) {
            this.identification.set_implicit_omit();
        }
        if (this.data__value__descriptor.is_bound()) {
            this.data__value__descriptor.set_implicit_omit();
        } else {
            this.data__value__descriptor.operator_assign(Base_Template.template_sel.OMIT_VALUE);
        }
        if (this.data__value.is_bound()) {
            this.data__value.set_implicit_omit();
        }
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.identification.encode_text(text_buf);
        this.data__value__descriptor.encode_text(text_buf);
        this.data__value.encode_text(text_buf);
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.identification.decode_text(text_buf);
        this.data__value__descriptor.decode_text(text_buf);
        this.data__value.decode_text(text_buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(false, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    int rawr = this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order);
                    if (rawr >= 0) return;
                    TTCN_EncDec.error_type temp = TTCN_EncDec.error_type.values()[-rawr];
                    switch (temp) {
                        case ET_INCOMPL_MSG: 
                        case ET_LEN_ERR: {
                            TTCN_EncDec_ErrorContext.error(temp, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                            return;
                        }
                        default: {
                            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                            return;
                        }
                    }
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    return;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    public static void TitanExternal_data__value_encoder(TitanOctetString input_value, TitanOctetString output_stream, TitanUniversalCharString coding_name) {
        AtomicInteger extra_options = new AtomicInteger(0);
        TTCN_EncDec.coding_type codingType = TTCN_EncDec.get_coding_from_str(coding_name, extra_options, true);
        if (codingType != TTCN_EncDec.coding_type.CT_JSON) {
            TTCN_Logger.begin_event_log2str();
            coding_name.log();
            throw new TtcnError(MessageFormat.format("Type `octetstring' does not support {0} encoding", TTCN_Logger.end_event_log2str()));
        }
        TTCN_Buffer ttcnBuffer = new TTCN_Buffer();
        input_value.encode(TitanOctetString.TitanOctetString_descr_, ttcnBuffer, codingType, extra_options.get());
        ttcnBuffer.get_string(output_stream);
    }

    public static int TitanExternal_data__value_decoder(TitanOctetString input_stream, TitanOctetString output_value, TitanUniversalCharString coding_name) {
        AtomicInteger extra_options = new AtomicInteger(0);
        TTCN_EncDec.coding_type codingType = TTCN_EncDec.get_coding_from_str(coding_name, extra_options, false);
        if (codingType != TTCN_EncDec.coding_type.CT_JSON) {
            TTCN_Logger.begin_event_log2str();
            coding_name.log();
            throw new TtcnError(MessageFormat.format("Type `octetstring' does not support {0} encoding", TTCN_Logger.end_event_log2str()));
        }
        TTCN_Buffer ttcnBuffer = new TTCN_Buffer(input_stream);
        output_value.decode(TitanOctetString.TitanOctetString_descr_, ttcnBuffer, codingType, extra_options.get());
        switch (TTCN_EncDec.get_last_error_type()) {
            case ET_NONE: {
                ttcnBuffer.cut();
                ttcnBuffer.get_string(input_stream);
                return 0;
            }
            case ET_INCOMPL_MSG: 
            case ET_LEN_ERR: {
                return 2;
            }
        }
        return 1;
    }
}

