/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Index_Redirect;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Runtime;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanComponent
extends Base_Type {
    public static final Base_Type.TTCN_Typedescriptor TitanComponent_descr_ = new Base_Type.TTCN_Typedescriptor("component", null, null, null, null);
    public static final int NULL_COMPREF = 0;
    public static final int MTC_COMPREF = 1;
    public static final int SYSTEM_COMPREF = 2;
    public static final int FIRST_PTC_COMPREF = 3;
    public static final int ANY_COMPREF = -1;
    public static final int ALL_COMPREF = -2;
    public static final int UNBOUND_COMPREF = -3;
    public static final int CONTROL_COMPREF = -4;
    public static final ThreadLocal<TitanComponent> self = new ThreadLocal<TitanComponent>(){

        @Override
        protected TitanComponent initialValue() {
            return new TitanComponent();
        }
    };
    private static final ThreadLocal<ArrayList<ComponentNameStruct>> componentNames = new ThreadLocal<ArrayList<ComponentNameStruct>>(){

        @Override
        protected ArrayList<ComponentNameStruct> initialValue() {
            return new ArrayList<ComponentNameStruct>();
        }
    };
    int componentValue;

    public TitanComponent() {
        this.componentValue = -3;
    }

    public TitanComponent(int otherValue) {
        this.componentValue = otherValue;
    }

    public TitanComponent(TitanComponent otherValue) {
        otherValue.must_bound("Copying an unbound component reference.");
        this.componentValue = otherValue.componentValue;
    }

    public TitanComponent operator_assign(int otherValue) {
        this.componentValue = otherValue;
        return this;
    }

    public TitanComponent operator_assign(TitanComponent otherValue) {
        otherValue.must_bound("Copying an unbound component reference.");
        this.componentValue = otherValue.componentValue;
        return this;
    }

    @Override
    public TitanComponent operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanComponent) {
            return this.operator_assign((TitanComponent)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to component reference", otherValue));
    }

    public boolean operator_equals(int otherValue) {
        this.must_bound("The left operand of comparison is an unbound component reference.");
        if (otherValue == -3) {
            throw new TtcnError("The right operand of comparison is an unbound component reference.");
        }
        return this.componentValue == otherValue;
    }

    public boolean operator_equals(TitanComponent otherValue) {
        this.must_bound("The left operand of comparison is an unbound component reference.");
        otherValue.must_bound("The right operand of comparison is an unbound component reference.");
        return this.componentValue == otherValue.componentValue;
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanComponent) {
            return this.operator_equals((TitanComponent)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to component reference", otherValue));
    }

    public boolean operator_not_equals(int otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanComponent otherValue) {
        return !this.operator_equals(otherValue);
    }

    public int get_component() {
        if (this.componentValue == -3) {
            throw new TtcnError("Using the value of an unbound component reference.");
        }
        return this.componentValue;
    }

    @Override
    public void clean_up() {
        this.componentValue = -3;
    }

    @Override
    public boolean is_present() {
        return this.componentValue != -3;
    }

    @Override
    public boolean is_bound() {
        return this.componentValue != -3;
    }

    @Override
    public boolean is_value() {
        return this.componentValue != -3;
    }

    @Override
    public void log() {
        if (this.componentValue == -3) {
            TTCN_Logger.log_event_unbound();
        } else {
            TitanComponent.log_component_reference(this.componentValue);
        }
    }

    public TitanAlt_Status done(TitanVerdictType value_redirect, Index_Redirect index_redirection) {
        this.must_bound("Performing done operation on an unbound component reference.");
        AtomicReference<TitanVerdictType.VerdictTypeEnum> ptc_verdict = new AtomicReference<TitanVerdictType.VerdictTypeEnum>(TitanVerdictType.VerdictTypeEnum.NONE);
        TitanAlt_Status status = TTCN_Runtime.component_done(this.componentValue, ptc_verdict);
        if (value_redirect != null) {
            value_redirect.operator_assign(ptc_verdict.get());
        }
        return status;
    }

    public TitanAlt_Status killed(Index_Redirect index_redirection) {
        this.must_bound("Performing killed operation on an unbound component reference.");
        return TTCN_Runtime.component_killed(this.componentValue);
    }

    public boolean running(Index_Redirect index_redirection) {
        this.must_bound("Performing running operation on an unbound component reference.");
        return TTCN_Runtime.component_running(this.componentValue);
    }

    public boolean alive(Index_Redirect index_redirection) {
        this.must_bound("Performing alive operation on an unbound component reference.");
        return TTCN_Runtime.component_alive(this.componentValue);
    }

    public void stop() {
        this.must_bound("Performing stop operation on an unbound component reference.");
        TTCN_Runtime.stop_component(this.componentValue);
    }

    public void kill() {
        this.must_bound("Performing kill operation on an unbound component reference.");
        TTCN_Runtime.kill_component(this.componentValue);
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "component reference (integer or null) value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Integer: {
                this.componentValue = param.get_integer().get_int();
                break;
            }
            case MP_Ttcn_Null: {
                this.componentValue = 0;
                break;
            }
            case MP_Ttcn_mtc: {
                this.componentValue = 1;
                break;
            }
            case MP_Ttcn_system: {
                this.componentValue = 2;
                break;
            }
            default: {
                param.type_error("component reference (integer or null) value");
            }
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Ttcn_Null();
    }

    public static void log_component_reference(int component_reference) {
        switch (component_reference) {
            case 0: {
                TTCN_Logger.log_event_str("null");
                break;
            }
            case 1: {
                TTCN_Logger.log_event_str("mtc");
                break;
            }
            case 2: {
                TTCN_Logger.log_event_str("system");
                break;
            }
            default: {
                String component_name = TitanComponent.get_component_name(component_reference);
                if (component_name == null) {
                    TTCN_Logger.log_event_str(MessageFormat.format("{0}", component_reference));
                    break;
                }
                TTCN_Logger.log_event_str(MessageFormat.format("{0}({1})", component_name, component_reference));
                break;
            }
        }
    }

    public static String get_component_string(int component_reference) {
        switch (component_reference) {
            case 0: {
                return "null";
            }
            case 1: {
                return "mtc";
            }
            case 2: {
                return "system";
            }
        }
        String component_name = TitanComponent.get_component_name(component_reference);
        if (component_name == null) {
            return MessageFormat.format("{0}", component_reference);
        }
        return MessageFormat.format("{0}({1})", component_name, component_reference);
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound component reference.");
        text_buf.push_int(this.componentValue);
        switch (this.componentValue) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                text_buf.push_string(TitanComponent.get_component_name(this.componentValue));
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.componentValue = text_buf.pull_int().get_int();
        switch (this.componentValue) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                String componentName = text_buf.pull_string();
                TitanComponent.register_component_name(this.componentValue, componentName);
            }
        }
    }

    public static void register_component_name(int component_reference, String component_name) {
        if (TitanComponent.self.get().componentValue == component_reference) {
            String local_name = TTCN_Runtime.get_component_name();
            if (component_name == null || component_name.length() == 0) {
                if (local_name != null) {
                    throw new TtcnError(MessageFormat.format("Internal error: Trying to register the component reference of this PTC without any name, but this component has name {0}.", local_name));
                }
            } else {
                if (local_name == null) {
                    throw new TtcnError(MessageFormat.format("Internal error: Trying to register the component reference of this PTC with name {0}, but this component does not have name.", component_name));
                }
                if (!component_name.equals(local_name)) {
                    throw new TtcnError(MessageFormat.format("Internal error: Trying to register the component reference of this PTC with name {0}, but this component has name {1}.", component_name, local_name));
                }
            }
            return;
        }
        int min = 0;
        ArrayList<ComponentNameStruct> localComponentNames = componentNames.get();
        if (!localComponentNames.isEmpty()) {
            int max = localComponentNames.size() - 1;
            while (min < max) {
                int mid = min + (max - min) / 2;
                if (localComponentNames.get((int)mid).componentReference < component_reference) {
                    min = mid + 1;
                    continue;
                }
                if (localComponentNames.get((int)mid).componentReference == component_reference) {
                    min = mid;
                    break;
                }
                max = mid;
            }
            if (localComponentNames.get((int)min).componentReference == component_reference) {
                String stored_name = localComponentNames.get((int)min).componentName;
                if (component_name == null || component_name.length() == 0) {
                    if (stored_name != null) {
                        throw new TtcnError(MessageFormat.format("Internal error: Trying to register component reference {0} without any name, but this component reference is already registered with name {1}.", component_reference, stored_name));
                    }
                } else {
                    if (stored_name == null) {
                        throw new TtcnError(MessageFormat.format("Internal error: Trying to register component reference {0} with name {1}, but this component reference is already registered without name.", component_reference, component_name));
                    }
                    if (!component_name.equals(stored_name)) {
                        throw new TtcnError(MessageFormat.format("Internal error: Trying to register component reference {0} with name {1}, but this component reference is already registered with a different name ({2}).", component_reference, component_name, stored_name));
                    }
                }
                return;
            }
            if (localComponentNames.get((int)min).componentReference < component_reference) {
                ++min;
            }
        }
        ComponentNameStruct tempElement = new ComponentNameStruct();
        tempElement.componentReference = component_reference;
        tempElement.componentName = component_name == null || component_name.length() == 0 ? null : component_name;
        localComponentNames.add(min, tempElement);
    }

    public static String get_component_name(int component_reference) {
        ArrayList<ComponentNameStruct> localComponentNames = componentNames.get();
        if (TitanComponent.self.get().componentValue == component_reference) {
            return TTCN_Runtime.get_component_name();
        }
        if (!localComponentNames.isEmpty()) {
            int min = 0;
            int max = localComponentNames.size() - 1;
            while (min < max) {
                int mid = min + (max - min) / 2;
                if (localComponentNames.get((int)mid).componentReference < component_reference) {
                    min = mid + 1;
                    continue;
                }
                if (localComponentNames.get((int)mid).componentReference == component_reference) {
                    return localComponentNames.get((int)mid).componentName;
                }
                max = mid;
            }
            if (localComponentNames.get((int)min).componentReference != component_reference) {
                throw new TtcnError(MessageFormat.format("Internal error: Trying to get the name of PTC with component reference {0}, but the name of the component is not registered.", component_reference));
            }
            return localComponentNames.get((int)min).componentName;
        }
        throw new TtcnError(MessageFormat.format("Internal error: Trying to get the name of PTC with component reference {0}, but there are no component names registered.", component_reference));
    }

    public static void clear_component_names() {
        componentNames.get().clear();
    }

    public static boolean operator_equals(int left_value, TitanComponent right_value) {
        right_value.must_bound("Unbound right operand of float comparison.");
        return right_value.operator_equals(left_value);
    }

    public static boolean operator_not_equals(int left_value, TitanComponent right_value) {
        right_value.must_bound("Unbound right operand of float comparison.");
        return right_value.operator_not_equals(left_value);
    }

    private static class ComponentNameStruct {
        public int componentReference;
        public String componentName;

        private ComponentNameStruct() {
        }
    }
}

