/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.runtime.core.AdditionalFunctions;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.IDecode_Match;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.Restricted_Length_Template;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanBitString;
import org.eclipse.titan.runtime.core.TitanBitString_Element;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TitanString_Utils;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanBitString_template
extends Restricted_Length_Template {
    private static final char[] patterns = new char[]{'0', '1', '?', '*'};
    private TitanBitString single_value;
    private List<TitanBitString_template> value_list;
    private int[] pattern_value;
    private IDecode_Match dec_match;

    public TitanBitString_template() {
    }

    public TitanBitString_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanBitString_template.check_single_selection(otherValue);
    }

    public TitanBitString_template(int[] other_value, int nof_bits) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanBitString(other_value, nof_bits);
    }

    public TitanBitString_template(TitanBitString otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound bitstring value.");
        this.single_value = new TitanBitString(otherValue);
    }

    public TitanBitString_template(TitanBitString_Element otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanBitString((byte)(otherValue.get_bit() ? 1 : 0));
    }

    public TitanBitString_template(Optional<TitanBitString> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanBitString(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a bitstring template from an unbound optional field.");
            }
        }
    }

    public TitanBitString_template(TitanBitString_template otherValue) {
        this.copy_template(otherValue);
    }

    public TitanBitString_template(int[] pattern_elements) {
        super(Base_Template.template_sel.STRING_PATTERN);
        this.pattern_value = TitanString_Utils.copy_integer_list(pattern_elements);
    }

    public TitanBitString_template(String patternString) {
        super(Base_Template.template_sel.STRING_PATTERN);
        this.pattern_value = TitanBitString_template.pattern_string_2_list(patternString);
    }

    private static int[] pattern_string_2_list(String patternString) {
        if (patternString == null) {
            throw new TtcnError("Internal error: bitstring pattern is null.");
        }
        int[] result = new int[patternString.length()];
        for (int i = 0; i < patternString.length(); ++i) {
            char patternChar = patternString.charAt(i);
            result[i] = TitanBitString_template.pattern_char_2_byte(patternChar);
        }
        return result;
    }

    private static int pattern_char_2_byte(char patternChar) {
        for (int j = 0; j < patterns.length; ++j) {
            if (patternChar != patterns[j]) continue;
            return j;
        }
        throw new TtcnError("Internal error: invalid element in bitstring pattern.");
    }

    private static String pattern_list_2_string(int[] list) {
        if (list == null) {
            throw new TtcnError("Internal error: bitstring pattern list is null.");
        }
        StringBuilder result = new StringBuilder(list.length);
        for (int i = 0; i < list.length; ++i) {
            result.append(patterns[list[i]]);
        }
        return result.toString();
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
            case STRING_PATTERN: {
                this.pattern_value = null;
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanBitString_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanBitString) {
            return this.operator_assign((TitanBitString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to bitstring", otherValue));
    }

    @Override
    public TitanBitString_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanBitString_template) {
            return this.operator_assign((TitanBitString_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to bitstring", otherValue));
    }

    @Override
    public TitanBitString_template operator_assign(Base_Template.template_sel otherValue) {
        TitanBitString_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanBitString_template operator_assign(int[] other_value, int nof_bits) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanBitString(other_value, nof_bits);
        return this;
    }

    public TitanBitString_template operator_assign(TitanBitString otherValue) {
        otherValue.must_bound("Assignment of an unbound bitstring value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanBitString(otherValue);
        return this;
    }

    public TitanBitString_template operator_assign(TitanBitString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound bitstring element to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanBitString((byte)(otherValue.get_bit() ? 1 : 0));
        return this;
    }

    public TitanBitString_template operator_assign(TitanBitString_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    public TitanBitString_template operator_assign(Optional<TitanBitString> otherValue) {
        this.clean_up();
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanBitString(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Assignment of an unbound optional field to a bitstring template.");
            }
        }
        return this;
    }

    private void copy_template(TitanBitString_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = new TitanBitString(otherValue.single_value);
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList<TitanBitString_template>(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanBitString_template temp = new TitanBitString_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            case STRING_PATTERN: {
                this.pattern_value = new int[otherValue.pattern_value.length];
                System.arraycopy(otherValue.pattern_value, 0, this.pattern_value, 0, otherValue.pattern_value.length);
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = otherValue.dec_match;
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported bitstring template.");
            }
        }
        this.set_selection(otherValue);
    }

    public TitanBitString_Element get_at(int index_value) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Accessing a bitstring element of a non-specific bitstring template.");
        }
        return this.single_value.get_at(index_value);
    }

    public TitanBitString_Element get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a bitstring template with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public TitanBitString_Element constGet_at(int index_value) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Accessing a bitstring element of a non-specific bitstring template.");
        }
        return this.single_value.constGet_at(index_value);
    }

    public TitanBitString_Element constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a bitstring template with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanBitString) {
            return this.match((TitanBitString)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to bitstring", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanBitString) {
            this.log_match((TitanBitString)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to bitstring", match_value));
    }

    public boolean match(TitanBitString otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanBitString otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        TitanInteger value_length = otherValue.lengthof();
        if (!this.match_length(value_length.get_int())) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.operator_equals(otherValue);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
            case STRING_PATTERN: {
                return this.match_pattern(this.pattern_value, otherValue);
            }
            case DECODE_MATCH: {
                TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_WARNING);
                TTCN_EncDec.clear_error();
                TitanOctetString os = AdditionalFunctions.bit2oct(otherValue);
                TTCN_Buffer buffer = new TTCN_Buffer(os);
                boolean ret_val = this.dec_match.match(buffer);
                TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);
                TTCN_EncDec.clear_error();
                return ret_val;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported bitstring template.");
    }

    public boolean match(TitanBitString_Element otherValue, boolean legacy) {
        return this.match(new TitanBitString(otherValue), legacy);
    }

    private boolean match_pattern(int[] string_pattern, TitanBitString string_value) {
        int stringPatternSize = string_pattern.length;
        int stringValueNBits = string_value.get_n_bits();
        if (stringPatternSize == 0) {
            return stringValueNBits == 0;
        }
        int value_index = 0;
        int template_index = 0;
        int last_asterisk = -1;
        int last_value_to_asterisk = -1;
        while (true) {
            switch (string_pattern[template_index]) {
                case 0: {
                    if (!string_value.get_bit(value_index)) {
                        ++value_index;
                        ++template_index;
                        break;
                    }
                    if (last_asterisk == -1) {
                        return false;
                    }
                    template_index = last_asterisk + 1;
                    value_index = ++last_value_to_asterisk;
                    break;
                }
                case 1: {
                    if (string_value.get_bit(value_index)) {
                        ++value_index;
                        ++template_index;
                        break;
                    }
                    if (last_asterisk == -1) {
                        return false;
                    }
                    template_index = last_asterisk + 1;
                    value_index = ++last_value_to_asterisk;
                    break;
                }
                case 2: {
                    ++value_index;
                    ++template_index;
                    break;
                }
                case 3: {
                    last_asterisk = template_index++;
                    last_value_to_asterisk = value_index;
                    break;
                }
                default: {
                    throw new TtcnError("Internal error: invalid element in bitstring pattern.");
                }
            }
            if (value_index == stringValueNBits && template_index == stringPatternSize) {
                return true;
            }
            if (template_index == stringPatternSize) {
                if (string_pattern[template_index - 1] == 3) {
                    return true;
                }
                if (last_asterisk == -1) {
                    return false;
                }
                template_index = last_asterisk + 1;
                value_index = ++last_value_to_asterisk;
                continue;
            }
            if (value_index == stringValueNBits) break;
        }
        while (template_index < stringPatternSize && string_pattern[template_index] == 3) {
            ++template_index;
        }
        return template_index == stringPatternSize;
    }

    @Override
    public TitanBitString valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific bitstring template.");
        }
        return this.single_value;
    }

    public TitanInteger lengthof() {
        if (this.is_ifPresent) {
            throw new TtcnError("Performing lengthof() operation on a bitstring template which has an ifpresent attribute.");
        }
        int min_length = 0;
        boolean has_any_or_none = false;
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                min_length = this.single_value.lengthof().get_int();
                has_any_or_none = false;
                break;
            }
            case OMIT_VALUE: {
                throw new TtcnError("Performing lengthof() operation on a bitstring template containing omit value.");
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                min_length = 0;
                has_any_or_none = true;
                break;
            }
            case VALUE_LIST: {
                if (this.value_list.isEmpty()) {
                    throw new TtcnError("Internal error: Performing lengthof() operation on a bitstring template containing an empty list.");
                }
                int item_length = this.value_list.get(0).lengthof().get_int();
                for (int i = 1; i < this.value_list.size(); ++i) {
                    if (this.value_list.get(i).lengthof().get_int() == item_length) continue;
                    throw new TtcnError("Performing lengthof() operation on a bitstring template containing a value list with different lengths.");
                }
                min_length = item_length;
                has_any_or_none = false;
                break;
            }
            case COMPLEMENTED_LIST: {
                throw new TtcnError("Performing lengthof() operation on a bitstring template containing complemented list.");
            }
            case STRING_PATTERN: {
                min_length = 0;
                has_any_or_none = false;
                for (int i = 0; i < this.pattern_value.length; ++i) {
                    if (this.pattern_value[i] < 3) {
                        ++min_length;
                        continue;
                    }
                    has_any_or_none = true;
                }
                break;
            }
            default: {
                throw new TtcnError("Performing lengthof() operation on an uninitialized/unsupported bitstring template.");
            }
        }
        return new TitanInteger(this.check_section_is_single(min_length, has_any_or_none, "length", "a", "bitstring template"));
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int listLength) {
        if (templateType != Base_Template.template_sel.VALUE_LIST && templateType != Base_Template.template_sel.COMPLEMENTED_LIST && templateType != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Setting an invalid list type for a bitstring template.");
        }
        this.clean_up();
        this.set_selection(templateType);
        if (templateType != Base_Template.template_sel.DECODE_MATCH) {
            this.value_list = new ArrayList<TitanBitString_template>(listLength);
            for (int i = 0; i < listLength; ++i) {
                this.value_list.add(new TitanBitString_template());
            }
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list bitstring template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanBitString_template list_item(int listIndex) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list bitstring template.");
        }
        if (listIndex < 0) {
            throw new TtcnError("Accessing an bitstring value list template using a negative index (" + listIndex + ").");
        }
        if (listIndex >= this.value_list.size()) {
            throw new TtcnError("Index overflow in a bitstring value list template.");
        }
        return this.value_list.get(listIndex);
    }

    public void set_decmatch(IDecode_Match dec_match) {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Setting the decoded content matching mechanism of a non-decmatch bitstring template.");
        }
        this.dec_match = dec_match;
    }

    public Object get_decmatch_dec_res() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the decoding result of a non-decmatch bitstring template.");
        }
        return this.dec_match.get_dec_res();
    }

    public Base_Type.TTCN_Typedescriptor get_decmatch_type_descr() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the decoded type's descriptor in a non-decmatch bitstring template.");
        }
        return this.dec_match.get_type_descr();
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value.log();
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case STRING_PATTERN: {
                TTCN_Logger.log_char('\'');
                for (int i = 0; i < this.pattern_value.length; ++i) {
                    int pattern = this.pattern_value[i];
                    if (pattern < 4) {
                        TTCN_Logger.log_char(patterns[pattern]);
                        continue;
                    }
                    TTCN_Logger.log_event_str("<unknown>");
                }
                TTCN_Logger.log_event_str("'B");
                break;
            }
            case DECODE_MATCH: {
                TTCN_Logger.log_event_str("decmatch ");
                this.dec_match.log();
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_restricted();
        this.log_ifpresent();
    }

    public void log_match(TitanBitString match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "bitstring template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanBitString_template temp = new TitanBitString_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Bitstring: {
                this.operator_assign(new TitanBitString((int[])param.get_string_data(), param.get_string_size()));
                break;
            }
            case MP_Bitstring_Template: {
                this.operator_assign(new TitanBitString_template((TitanBitString_template)param.get_string_data()));
                break;
            }
            case MP_Expression: {
                if (param.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanBitString operand1 = new TitanBitString();
                    TitanBitString operand2 = new TitanBitString();
                    operand1.set_param(param.get_operand1());
                    operand2.set_param(param.get_operand2());
                    this.operator_assign(operand1.operator_concatenate(operand2));
                    break;
                }
                param.expr_type_error("a bitstring");
                break;
            }
            default: {
                param.type_error("bitstring template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
        if (param.get_length_restriction() != null) {
            this.set_length_range(param);
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = this.single_value.get_param(param_name);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            case STRING_PATTERN: {
                mp = new Param_Types.Module_Param_Bitstring_Template(TitanBitString_template.pattern_list_2_string(this.pattern_value));
                break;
            }
            case DECODE_MATCH: {
                throw new TtcnError("Referencing a decoded content matching template is not supported.");
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported bitstring template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        mp.set_length_restriction(this.get_length_range());
        return mp;
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_restricted(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value.encode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            case STRING_PATTERN: {
                text_buf.push_int(this.pattern_value.length);
                byte[] temp = new byte[this.pattern_value.length];
                for (int i = 0; i < this.pattern_value.length; ++i) {
                    temp[i] = (byte)this.pattern_value[i];
                }
                text_buf.push_raw(temp);
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported bitstring template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_restricted(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value = new TitanBitString();
                this.single_value.decode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList<TitanBitString_template>(size);
                for (int i = 0; i < size; ++i) {
                    TitanBitString_template temp = new TitanBitString_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            case STRING_PATTERN: {
                int n_elements = text_buf.pull_int().get_int();
                this.pattern_value = new int[n_elements];
                byte[] temp = new byte[n_elements];
                text_buf.pull_raw(n_elements, temp);
                for (int i = 0; i < n_elements; ++i) {
                    this.pattern_value[i] = temp[i];
                }
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for a bitstring template.");
            }
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanBitString_template.get_res_name(restriction), name == null ? "bitstring" : name));
    }
}

