/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class JSON_Tokenizer {
    public static final JSON_Tokenizer DUMMY_BUFFER = new JSON_Tokenizer();
    private static final int MAX_TABS = 64;
    private StringBuilder buf_ptr;
    private int buf_pos;
    private int depth;
    private json_token_t previous_token;
    private boolean pretty;

    private void init(String p_buf) {
        this.buf_ptr = p_buf != null ? new StringBuilder(p_buf) : new StringBuilder();
        this.buf_pos = 0;
        this.depth = 0;
        this.previous_token = json_token_t.JSON_TOKEN_NONE;
    }

    private void put_c(char c) {
        this.buf_ptr.append(c);
    }

    private void put_s(String s) {
        this.buf_ptr.append(s);
    }

    private void put_depth() {
        int tabs = this.depth > 64 ? 64 : this.depth;
        for (int i = 0; i < tabs; ++i) {
            this.put_c('\t');
        }
    }

    private boolean skip_white_spaces() {
        block3: while (this.buf_pos < this.buf_ptr.length()) {
            switch (this.buf_ptr.charAt(this.buf_pos)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++this.buf_pos;
                    continue block3;
                }
            }
            return true;
        }
        return false;
    }

    private boolean check_for_string() {
        if ('\"' == this.buf_ptr.charAt(this.buf_pos)) {
            ++this.buf_pos;
        } else {
            return false;
        }
        while (this.buf_pos < this.buf_ptr.length()) {
            if ('\"' == this.buf_ptr.charAt(this.buf_pos)) {
                return true;
            }
            if ('\\' == this.buf_ptr.charAt(this.buf_pos)) {
                ++this.buf_pos;
            }
            ++this.buf_pos;
        }
        return false;
    }

    private boolean check_for_separator() {
        if (this.buf_pos < this.buf_ptr.length()) {
            switch (this.buf_ptr.charAt(this.buf_pos)) {
                case ',': {
                    ++this.buf_pos;
                }
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean check_for_literal(String p_literal) {
        int len = p_literal.length();
        if (this.buf_ptr.length() - this.buf_pos >= len && this.buf_ptr.substring(this.buf_pos, this.buf_pos + len).equals(p_literal)) {
            int start_pos = this.buf_pos;
            this.buf_pos += len;
            if (!this.skip_white_spaces() || this.check_for_separator()) {
                return true;
            }
            this.buf_pos = start_pos;
        }
        return false;
    }

    private void put_separator() {
        if (json_token_t.JSON_TOKEN_NAME != this.previous_token && json_token_t.JSON_TOKEN_NONE != this.previous_token && json_token_t.JSON_TOKEN_ARRAY_START != this.previous_token && json_token_t.JSON_TOKEN_OBJECT_START != this.previous_token) {
            this.put_c(',');
            if (this.pretty) {
                this.put_c('\n');
                this.put_depth();
            }
        }
    }

    public JSON_Tokenizer() {
        this(false);
    }

    public JSON_Tokenizer(boolean p_pretty) {
        this.pretty = p_pretty;
        this.init(null);
    }

    public JSON_Tokenizer(String p_buf, int p_buf_len) {
        this.pretty = false;
        this.init(p_buf);
    }

    public void set_buffer(String p_buf, int p_buf_len) {
        this.init(p_buf);
    }

    public StringBuilder get_buffer() {
        return this.buf_ptr;
    }

    public int get_buffer_length() {
        return this.buf_ptr.length();
    }

    public int get_next_token(AtomicReference<json_token_t> p_token, StringBuilder p_token_str, AtomicInteger p_str_len) {
        int start_pos = this.buf_pos;
        p_token.set(json_token_t.JSON_TOKEN_NONE);
        if (null != p_token_str && null != p_str_len) {
            p_token_str.setLength(0);
            p_str_len.set(0);
        }
        if (this.skip_white_spaces()) {
            char c = this.buf_ptr.charAt(this.buf_pos);
            switch (c) {
                case '[': 
                case '{': {
                    p_token.set('{' == c ? json_token_t.JSON_TOKEN_OBJECT_START : json_token_t.JSON_TOKEN_ARRAY_START);
                    ++this.buf_pos;
                    break;
                }
                case ']': 
                case '}': {
                    ++this.buf_pos;
                    if (this.skip_white_spaces() && !this.check_for_separator()) {
                        p_token.set(json_token_t.JSON_TOKEN_ERROR);
                        break;
                    }
                    p_token.set('}' == c ? json_token_t.JSON_TOKEN_OBJECT_END : json_token_t.JSON_TOKEN_ARRAY_END);
                    break;
                }
                case '\"': {
                    int string_start_pos = this.buf_pos++;
                    if (!this.check_for_string()) {
                        p_token.set(json_token_t.JSON_TOKEN_ERROR);
                        break;
                    }
                    int string_end_pos = this.buf_pos;
                    if (this.skip_white_spaces() && ':' == this.buf_ptr.charAt(this.buf_pos)) {
                        p_token.set(json_token_t.JSON_TOKEN_NAME);
                        if (null != p_token_str && null != p_str_len) {
                            p_token_str.setLength(0);
                            p_token_str.append(this.buf_ptr.substring(string_start_pos + 1));
                            p_str_len.set(string_end_pos - string_start_pos - 2);
                        }
                        ++this.buf_pos;
                        break;
                    }
                    if (this.check_for_separator()) {
                        p_token.set(json_token_t.JSON_TOKEN_STRING);
                        if (null == p_token_str || null == p_str_len) break;
                        p_token_str.setLength(0);
                        p_token_str.append(this.buf_ptr.substring(string_start_pos));
                        p_str_len.set(string_end_pos - string_start_pos);
                        break;
                    }
                    p_token.set(json_token_t.JSON_TOKEN_ERROR);
                    break;
                }
                default: {
                    if ('0' <= this.buf_ptr.charAt(this.buf_pos) && '9' >= this.buf_ptr.charAt(this.buf_pos) || '-' == this.buf_ptr.charAt(this.buf_pos)) {
                        int number_start_pos = this.buf_pos;
                        if (!this.check_for_number()) {
                            p_token.set(json_token_t.JSON_TOKEN_ERROR);
                            break;
                        }
                        int number_length = this.buf_pos - number_start_pos;
                        if (this.skip_white_spaces() && !this.check_for_separator()) {
                            p_token.set(json_token_t.JSON_TOKEN_ERROR);
                            break;
                        }
                        p_token.set(json_token_t.JSON_TOKEN_NUMBER);
                        if (null == p_token_str || null == p_str_len) break;
                        p_token_str.setLength(0);
                        p_token_str.append(this.buf_ptr.substring(number_start_pos));
                        p_str_len.set(number_length);
                        break;
                    }
                    if (this.check_for_literal("true")) {
                        p_token.set(json_token_t.JSON_TOKEN_LITERAL_TRUE);
                        break;
                    }
                    if (this.check_for_literal("false")) {
                        p_token.set(json_token_t.JSON_TOKEN_LITERAL_FALSE);
                        break;
                    }
                    if (this.check_for_literal("null")) {
                        p_token.set(json_token_t.JSON_TOKEN_LITERAL_NULL);
                        break;
                    }
                    p_token.set(json_token_t.JSON_TOKEN_ERROR);
                }
            }
        }
        if (null != p_token_str && null != p_str_len) {
            String shortValue = p_token_str.substring(0, p_str_len.get());
            p_token_str.setLength(0);
            p_token_str.append(shortValue);
        }
        return this.buf_pos - start_pos;
    }

    public int get_buf_pos() {
        return this.buf_pos;
    }

    public void set_buf_pos(int p_buf_pos) {
        this.buf_pos = p_buf_pos;
    }

    public int put_next_token(json_token_t p_token) {
        return this.put_next_token(p_token, null);
    }

    public int put_next_token(json_token_t p_token, String p_token_str) {
        int start_len = this.buf_ptr.length();
        switch (p_token) {
            case JSON_TOKEN_OBJECT_START: 
            case JSON_TOKEN_ARRAY_START: {
                this.put_separator();
                this.put_c(json_token_t.JSON_TOKEN_OBJECT_START == p_token ? (char)'{' : '[');
                if (!this.pretty) break;
                this.put_c('\n');
                ++this.depth;
                this.put_depth();
                break;
            }
            case JSON_TOKEN_OBJECT_END: 
            case JSON_TOKEN_ARRAY_END: {
                if (this.pretty) {
                    if (json_token_t.JSON_TOKEN_OBJECT_START != this.previous_token && json_token_t.JSON_TOKEN_ARRAY_START != this.previous_token) {
                        this.put_c('\n');
                        --this.depth;
                        this.put_depth();
                    } else if (64 >= this.depth) {
                        --this.depth;
                        this.buf_ptr.deleteCharAt(this.buf_ptr.length() - 1);
                    }
                }
                this.put_c(json_token_t.JSON_TOKEN_OBJECT_END == p_token ? (char)'}' : ']');
                break;
            }
            case JSON_TOKEN_NUMBER: 
            case JSON_TOKEN_STRING: {
                this.put_separator();
                this.put_s(p_token_str);
                break;
            }
            case JSON_TOKEN_LITERAL_TRUE: {
                this.put_separator();
                this.put_s("true");
                break;
            }
            case JSON_TOKEN_LITERAL_FALSE: {
                this.put_separator();
                this.put_s("false");
                break;
            }
            case JSON_TOKEN_LITERAL_NULL: {
                this.put_separator();
                this.put_s("null");
                break;
            }
            case JSON_TOKEN_NAME: {
                this.put_separator();
                this.put_c('\"');
                this.put_s(p_token_str);
                if (this.pretty) {
                    this.put_s("\" : ");
                    break;
                }
                this.put_s("\":");
                break;
            }
            default: {
                return 0;
            }
        }
        this.previous_token = p_token;
        return this.buf_ptr.length() - start_len;
    }

    public void put_raw_data(String p_data) {
        this.buf_ptr.append(p_data);
    }

    public boolean check_for_number() {
        return this.check_for_number(null);
    }

    public boolean check_for_number(AtomicBoolean is_float) {
        boolean first_digit = false;
        boolean zero = false;
        boolean decimal_point = false;
        boolean exponent_mark = false;
        boolean exponent_sign = false;
        if ('-' == this.buf_ptr.charAt(this.buf_pos)) {
            ++this.buf_pos;
        }
        while (this.buf_pos < this.buf_ptr.length()) {
            switch (this.buf_ptr.charAt(this.buf_pos)) {
                case '.': {
                    if (decimal_point || exponent_mark || !first_digit && !zero) {
                        return false;
                    }
                    decimal_point = true;
                    first_digit = false;
                    zero = false;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (exponent_mark || !first_digit && !zero) {
                        return false;
                    }
                    exponent_mark = true;
                    first_digit = false;
                    zero = false;
                    break;
                }
                case '0': {
                    if (!first_digit && (exponent_mark && zero || !decimal_point && zero)) {
                        return false;
                    }
                    zero = true;
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (!first_digit && zero && (!decimal_point || exponent_mark && !zero)) {
                        return false;
                    }
                    first_digit = true;
                    break;
                }
                case '+': 
                case '-': {
                    if (exponent_sign || !exponent_mark || zero || first_digit) {
                        return false;
                    }
                    exponent_sign = true;
                    break;
                }
                default: {
                    if (is_float != null) {
                        is_float.set(decimal_point || exponent_mark);
                    }
                    return first_digit || zero;
                }
            }
            ++this.buf_pos;
        }
        if (is_float != null) {
            is_float.set(decimal_point || exponent_mark);
        }
        return first_digit || zero;
    }

    private static StringBuilder convert_to_json_string(String str) {
        StringBuilder ret_val = new StringBuilder("\"");
        int str_len = str.length();
        block9: for (int i = 0; i < str_len; ++i) {
            switch (str.charAt(i)) {
                case '\n': {
                    ret_val.append("\\n");
                    continue block9;
                }
                case '\r': {
                    ret_val.append("\\r");
                    continue block9;
                }
                case '\t': {
                    ret_val.append("\\t");
                    continue block9;
                }
                case '\f': {
                    ret_val.append("\\f");
                    continue block9;
                }
                case '\b': {
                    ret_val.append("\\b");
                    continue block9;
                }
                case '\"': {
                    ret_val.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    ret_val.append("\\\\");
                    continue block9;
                }
                default: {
                    if (str.charAt(i) < ' ' && str.charAt(i) > '\u0000') {
                        ret_val.append("\\u00");
                        ret_val.append(str.charAt(i) / 16);
                        ret_val.append((char)(str.charAt(i) % 16 < 10 ? str.charAt(i) % 16 + 48 : str.charAt(i) % 16 - 10 + 65));
                        continue block9;
                    }
                    ret_val.append(str.charAt(i));
                }
            }
        }
        return ret_val.append("\"");
    }

    public static enum json_token_t {
        JSON_TOKEN_ERROR,
        JSON_TOKEN_NONE,
        JSON_TOKEN_OBJECT_START,
        JSON_TOKEN_OBJECT_END,
        JSON_TOKEN_ARRAY_START,
        JSON_TOKEN_ARRAY_END,
        JSON_TOKEN_NAME,
        JSON_TOKEN_NUMBER,
        JSON_TOKEN_STRING,
        JSON_TOKEN_LITERAL_TRUE,
        JSON_TOKEN_LITERAL_FALSE,
        JSON_TOKEN_LITERAL_NULL;

    }
}

