/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.util.ArrayList;
import java.util.List;

public final class StringUtils {
    private StringUtils() {
        throw new UnsupportedOperationException();
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String removePrefix(String original, String prefix) {
        if (original.startsWith(prefix)) {
            return original.substring(prefix.length());
        }
        return original;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String getOrdinalIndicator(int n) {
        if (11 <= n % 100 && n % 100 <= 13) {
            return "th";
        }
        switch (n % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public static final List<String> intelligentSplit(String input, char delimiter, char escape) {
        ArrayList<String> results = new ArrayList<String>();
        if (input == null || input.length() == 0) {
            return results;
        }
        StringBuilder tempResult = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (escape == c) {
                tempResult.append(c);
                ++i;
                continue;
            }
            if (delimiter == c) {
                results.add(tempResult.toString());
                tempResult.setLength(0);
                ++i;
                continue;
            }
            tempResult.append(c);
            ++i;
        }
        results.add(tempResult.toString());
        return results;
    }
}

