/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDocSnippetStringEvaluator;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocAccess;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocAccessImpl;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocContentAccessUtility;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreMarkdownAccessImpl;
import org.eclipse.jdt.core.manipulation.internal.javadoc.IJavadocContentFactory;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavadocLookup;
import org.eclipse.jdt.internal.ui.viewsupport.CoreJavaElementLinks;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2MarkdownConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2PlainTextConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDocHTMLPathHandler;
import org.eclipse.lsp4j.Location;

public class JavadocContentAccess2 {
    public static final String SNIPPET = "SNIPPET";
    public static final IJavadocContentFactory JDT_LS_JAVADOC_CONTENT_FACTORY = new IJavadocContentFactory(){

        public IJavadocContentFactory.IJavadocAccess createJavadocAccess(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
            if (source.startsWith("///")) {
                if (lookup == null) {
                    return new CoreMarkdownAccessImpl(element, javadoc, source);
                }
                return new CoreMarkdownAccessImpl(element, javadoc, source, lookup);
            }
            if (lookup == null) {
                return new JdtLsJavadocAccessImpl(element, javadoc, source);
            }
            return new JdtLsJavadocAccessImpl(element, javadoc, source, lookup);
        }
    };

    public static Reader getPlainTextContentReader(IMember member) throws JavaModelException {
        Reader contentReader = CoreJavadocContentAccessUtility.getHTMLContentReader((IMember)member, (boolean)true, (boolean)true);
        if (contentReader != null) {
            try {
                return new JavaDoc2PlainTextConverter(contentReader).getAsReader();
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 1009);
            }
        }
        return null;
    }

    public static Reader getMarkdownContentReader(IJavaElement element) {
        try {
            CoreJavadocAccess access = JavadocContentAccess2.createJdtLsJavadocAccess();
            String rawHtml = access.getHTMLContent(element, true);
            Reader markdownReader = new JavaDoc2MarkdownConverter(rawHtml).getAsReader();
            return markdownReader;
        }
        catch (IOException | CoreException throwable) {
            return null;
        }
    }

    private static CoreJavadocAccess createJdtLsJavadocAccess() {
        return new CoreJavadocAccess(JDT_LS_JAVADOC_CONTENT_FACTORY){
            protected final String UL_CLASS_BLOCK_LIST = "<ul class=\"blockList\">";
            protected final String CONTENT_CONTAINER = "<div class=\"contentContainer\">";

            public String getHTMLContent(IPackageFragment packageFragment) throws CoreException {
                String content = this.readHTMLContent(packageFragment);
                return this.sanitizePackageJavadoc(content);
            }

            protected String sanitizePackageJavadoc(String content) {
                int nextListIndex;
                if (content == null || content.isEmpty()) {
                    return content;
                }
                if (content.indexOf("<div class=\"contentContainer\">") == 0 && (nextListIndex = content.indexOf("<ul class=\"blockList\">")) > 0) {
                    content = content.substring("<div class=\"contentContainer\">".length(), nextListIndex);
                }
                return content;
            }

            protected StringBuffer createSuperMethodReferencesHTML(ArrayList<IMethod> superInterfaceMethods, IMethod superClassMethod) {
                return null;
            }
        };
    }

    private static class JdtLsJavadocAccessImpl
    extends CoreJavadocAccessImpl {
        public JdtLsJavadocAccessImpl(IJavaElement element, Javadoc javadoc, String source) {
            super(element, javadoc, source);
        }

        public JdtLsJavadocAccessImpl(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
            super(element, javadoc, source, lookup);
        }

        protected CoreJavaDocSnippetStringEvaluator createSnippetEvaluator(IJavaElement element) {
            return new CoreJavaDocSnippetStringEvaluator(this.fElement){

                protected String getOneTagElementString(TagElement snippetTag, Object fragment) {
                    String str = super.getOneTagElementString(snippetTag, fragment);
                    return JavadocContentAccess2.SNIPPET + str;
                }

                protected String getModifiedStringForTagElement(TagElement tagElement, List<TagElement> tagElements) {
                    Object str = super.getModifiedString(tagElement, tagElements);
                    if ("@link".equals(tagElement.getTagName())) {
                        int leadingSpaces = 0;
                        while (((String)str).length() > leadingSpaces + 1 && ((String)str).charAt(leadingSpaces) == ' ') {
                            ++leadingSpaces;
                        }
                        try {
                            str = new JavaDoc2MarkdownConverter((String)str).getAsString();
                            int i = 0;
                            while (i < leadingSpaces) {
                                str = " " + (String)str;
                                ++i;
                            }
                            str = (String)str + "  \n";
                        }
                        catch (IOException e) {
                            JavaLanguageServerPlugin.logException(e.getMessage(), e);
                        }
                    }
                    return str;
                }

                protected String getDefaultBoldTag() {
                    return "**";
                }

                protected String getDefaultItalicTag() {
                    return "*";
                }

                protected String getDefaultHighlightedTag() {
                    return "***";
                }

                protected String getStartTag(String tag) {
                    return tag;
                }

                protected String getEndTag(String tag) {
                    return tag;
                }
            };
        }

        protected void handleInLineTextElement(TextElement te, boolean skipLeadingWhitespace, TagElement tagElement, ASTNode previousNode) {
            String text = te.getText();
            if (JavaDocHTMLPathHandler.containsHTMLTag(text)) {
                text = JavaDocHTMLPathHandler.getValidatedHTMLSrcAttribute(te, this.fElement);
            }
            if (skipLeadingWhitespace) {
                text = text.replaceFirst("^\\s", "");
            }
            text = text.replaceAll("(\r\n?|\n)([ \t]*\\*)", "$1");
            text = this.handlePreCounter(tagElement, text);
            this.handleInLineText(text, previousNode);
        }

        protected boolean addCodeTagOnLink() {
            return false;
        }

        protected void handleInLineText(String text, ASTNode previousNode) {
            TagElement previousTag;
            boolean isInSnippet = previousNode instanceof TagElement && "@snippet".equals((previousTag = (TagElement)previousNode).getTagName());
            this.handleText(this.markSnippet(text, isInSnippet));
        }

        protected void handleBlockTags(String title, List<TagElement> tags) {
            super.handleBlockTags(title, tags);
            this.fBuf.append(this.getBlockTagEntryEnd());
        }

        protected void handleSingleTag(TagElement tag) {
            this.fBuf.append(this.getBlockTagStart());
            super.handleSingleTag(tag);
            this.fBuf.append(this.getBlockTagEnd());
        }

        protected void handleReturnTagBody(TagElement tag, CharSequence returnDescription) {
            this.fBuf.append(this.getBlockTagStart());
            super.handleReturnTagBody(tag, returnDescription);
            this.fBuf.append(this.getBlockTagEnd());
            this.fBuf.append(this.getBlockTagEntryEnd());
        }

        protected void handleBlockTagBody(TagElement tag) {
            List fragments = tag.fragments();
            if (!fragments.isEmpty()) {
                this.fBuf.append(this.getBlockTagStart());
                this.fBuf.append(this.getBlockTagEntryStart());
                super.handleContentElements(fragments);
                this.fBuf.append(this.getBlockTagEntryEnd());
                this.fBuf.append(this.getBlockTagEnd());
            }
        }

        protected void handleBlockTagTitle(String title) {
            this.fBuf.append("<li><b>");
            this.fBuf.append(title);
            this.fBuf.append("</b>");
        }

        protected void handleExceptionTagsBody(List<TagElement> tags, List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
            this.fBuf.append(this.getBlockTagStart());
            super.handleExceptionTagsBody(tags, exceptionNames, exceptionDescriptions);
            this.fBuf.append(this.getBlockTagEnd());
            this.fBuf.append(this.getBlockTagEntryEnd());
        }

        protected void handleSingleParameterTag(TagElement tag) {
            this.fBuf.append(this.getBlockTagStart());
            super.handleSingleParameterTag(tag);
            this.fBuf.append(this.getBlockTagEnd());
        }

        protected void handleSingleParameterDescription(String name, CharSequence description, boolean isTypeParameters) {
            this.fBuf.append(this.getBlockTagStart());
            super.handleSingleParameterDescription(name, description, isTypeParameters);
            this.fBuf.append(this.getBlockTagEnd());
        }

        protected String markSnippet(String text, boolean isInSnippet) {
            if (isInSnippet) {
                StringBuilder builder = new StringBuilder();
                text.lines().forEach(l -> {
                    builder.append(JavadocContentAccess2.SNIPPET);
                    builder.append((String)l);
                    builder.append("\n");
                });
                return builder.toString();
            }
            return text;
        }

        protected String createLinkURI(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
            URI javadocURI = CoreJavaElementLinks.createURIAsUri((String)scheme, (IJavaElement)this.fElement, (String)refTypeName, (String)refMemberName, (String[])refParameterTypes);
            IJavaElement linkTarget = CoreJavaElementLinks.parseURI((URI)javadocURI);
            if (linkTarget == null) {
                return "";
            }
            try {
                Location locationToElement = JDTUtils.toLocation(linkTarget);
                if (locationToElement != null) {
                    return locationToElement.getUri() + "#" + (locationToElement.getRange().getStart().getLine() + 1);
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return "";
        }

        protected String getBlockTagStart() {
            return "<ul>";
        }

        protected String getBlockTagEnd() {
            return "</ul>";
        }

        protected String getBlockTagEntryStart() {
            return "<li>";
        }

        protected String getBlockTagEntryEnd() {
            return "</li>";
        }
    }
}

