"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-chat_lib_browser_change-set-file-element_js"],{

/***/ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-element.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/change-set-file-element.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var ChangeSetFileElement_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSetFileElement = exports.ChangeSetElementArgs = exports.ChangeSetFileElementFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const change_set_file_resource_1 = __webpack_require__(/*! ./change-set-file-resource */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-resource.js");
const change_set_file_service_1 = __webpack_require__(/*! ./change-set-file-service */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-service.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const change_set_decorator_service_1 = __webpack_require__(/*! ./change-set-decorator-service */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-decorator-service.js");
exports.ChangeSetFileElementFactory = Symbol('ChangeSetFileElementFactory');
exports.ChangeSetElementArgs = Symbol('ChangeSetElementArgs');
;
let ChangeSetFileElement = ChangeSetFileElement_1 = class ChangeSetFileElement {
    constructor() {
        this.toDispose = new core_1.DisposableCollection();
        this.onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
    }
    static toReadOnlyUri(baseUri, sessionId) {
        return baseUri.withScheme('change-set-immutable').withAuthority(sessionId);
    }
    init() {
        this.getResources();
        this.obtainOriginalContent();
        this.listenForOriginalFileChanges();
        this.toDispose.push(this.onDidChangeEmitter);
    }
    async obtainOriginalContent() {
        var _a;
        this.originalContent = await this.changeSetFileService.read(this.uri);
        this.readOnlyResource.update({ contents: (_a = this.originalContent) !== null && _a !== void 0 ? _a : '' });
        if (this.state === 'applied') {
        }
    }
    getResources() {
        this.readOnlyResource = this.getInMemoryUri(this.readOnlyUri);
        this.readOnlyResource.update({ autosaveable: false, readOnly: true });
        this.changeResource = this.getInMemoryUri(this.changedUri);
        this.changeResource.update({ contents: this.targetState, onSave: content => this.writeChanges(content), autosaveable: false });
        this.toDispose.pushAll([this.readOnlyResource, this.changeResource]);
    }
    getInMemoryUri(uri) {
        try {
            return this.inMemoryResources.resolve(uri);
        }
        catch {
            return this.inMemoryResources.add(uri, { contents: '' });
        }
    }
    listenForOriginalFileChanges() {
        this.toDispose.push(this.fileService.onDidFilesChange(async (event) => {
            if (!event.contains(this.uri)) {
                return;
            }
            // If we are applied, the tricky thing becomes the question what to revert to; otherwise, what to apply.
            const newContent = await this.changeSetFileService.read(this.uri).catch(() => '');
            this.readOnlyResource.update({ contents: newContent });
            if (newContent === this.originalContent) {
                this.state = 'pending';
            }
            else if (newContent === this.targetState) {
                this.state = 'applied';
            }
            else {
                this.state = 'stale';
            }
        }));
    }
    get uri() {
        return this.elementProps.uri;
    }
    get readOnlyUri() {
        return ChangeSetFileElement_1.toReadOnlyUri(this.uri, this.elementProps.chatSessionId);
    }
    get changedUri() {
        return (0, change_set_file_resource_1.createChangeSetFileUri)(this.elementProps.chatSessionId, this.uri);
    }
    get name() {
        var _a;
        return (_a = this.elementProps.name) !== null && _a !== void 0 ? _a : this.changeSetFileService.getName(this.uri);
    }
    get icon() {
        var _a;
        return (_a = this.elementProps.icon) !== null && _a !== void 0 ? _a : this.changeSetFileService.getIcon(this.uri);
    }
    get additionalInfo() {
        return this.changeSetFileService.getAdditionalInfo(this.uri);
    }
    get state() {
        var _a;
        return (_a = this._state) !== null && _a !== void 0 ? _a : this.elementProps.state;
    }
    set state(value) {
        if (this._state !== value) {
            this._state = value;
            this.onDidChangeEmitter.fire();
        }
    }
    get replacements() {
        return this.elementProps.replacements;
    }
    get type() {
        return this.elementProps.type;
    }
    get data() {
        return this.elementProps.data;
    }
    ;
    get targetState() {
        var _a;
        return (_a = this.elementProps.targetState) !== null && _a !== void 0 ? _a : '';
    }
    async open() {
        this.changeSetFileService.open(this);
    }
    async openChange() {
        this.changeSetFileService.openDiff(this.readOnlyUri, this.changedUri);
    }
    async apply(contents) {
        if (!await this.confirm('Apply')) {
            return;
        }
        if (!(await this.changeSetFileService.trySave(this.changedUri))) {
            if (this.type === 'delete') {
                await this.changeSetFileService.delete(this.uri);
                this.state = 'applied';
            }
            else {
                await this.writeChanges(contents);
            }
        }
        this.changeSetFileService.closeDiff(this.readOnlyUri);
    }
    async writeChanges(contents) {
        await this.changeSetFileService.writeFrom(this.changedUri, this.uri, contents !== null && contents !== void 0 ? contents : this.targetState);
        this.state = 'applied';
    }
    async revert() {
        if (!await this.confirm('Revert')) {
            return;
        }
        this.state = 'pending';
        if (this.type === 'add') {
            await this.changeSetFileService.delete(this.uri);
        }
        else if (this.originalContent) {
            await this.changeSetFileService.write(this.uri, this.originalContent);
        }
    }
    async confirm(verb) {
        if (this._state !== 'stale') {
            return true;
        }
        await this.openChange();
        const thing = await new browser_1.ConfirmDialog({
            title: `${verb} suggestion.`,
            msg: `The file ${this.uri.path.toString()} has changed since this suggestion was created. Are you certain you wish to ${verb.toLowerCase()} the change?`
        }).open(true);
        return !!thing;
    }
    dispose() {
        this.toDispose.dispose();
    }
};
exports.ChangeSetFileElement = ChangeSetFileElement;
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.ChangeSetElementArgs),
    tslib_1.__metadata("design:type", Object)
], ChangeSetFileElement.prototype, "elementProps", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_file_service_1.ChangeSetFileService),
    tslib_1.__metadata("design:type", change_set_file_service_1.ChangeSetFileService)
], ChangeSetFileElement.prototype, "changeSetFileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_decorator_service_1.ChangeSetDecoratorService),
    tslib_1.__metadata("design:type", change_set_decorator_service_1.ChangeSetDecoratorService)
], ChangeSetFileElement.prototype, "changeSetDecoratorService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], ChangeSetFileElement.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.ConfigurableInMemoryResources),
    tslib_1.__metadata("design:type", ai_core_1.ConfigurableInMemoryResources)
], ChangeSetFileElement.prototype, "inMemoryResources", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ChangeSetFileElement.prototype, "init", null);
exports.ChangeSetFileElement = ChangeSetFileElement = ChangeSetFileElement_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChangeSetFileElement);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-resource.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/change-set-file-resource.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createChangeSetFileUri = exports.CHANGE_SET_FILE_RESOURCE_SCHEME = void 0;
exports.CHANGE_SET_FILE_RESOURCE_SCHEME = 'changeset-file';
function createChangeSetFileUri(chatSessionId, elementUri) {
    return elementUri.withScheme(exports.CHANGE_SET_FILE_RESOURCE_SCHEME).withAuthority(chatSessionId);
}
exports.createChangeSetFileUri = createChangeSetFileUri;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-service.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/change-set-file-service.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSetFileService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const monaco_workspace_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-workspace */ "../../node_modules/@theia/monaco/lib/browser/monaco-workspace.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
let ChangeSetFileService = class ChangeSetFileService {
    async read(uri) {
        const exists = await this.fileService.exists(uri);
        if (!exists) {
            return undefined;
        }
        try {
            const document = this.monacoWorkspace.getTextDocument(uri.toString());
            if (document) {
                return document.getText();
            }
            return (await this.fileService.readFile(uri)).value.toString();
        }
        catch (error) {
            this.logger.error('Failed to read original content of change set file element.', error);
            return undefined;
        }
    }
    getName(uri) {
        return this.labelProvider.getName(uri);
    }
    getIcon(uri) {
        return this.labelProvider.getIcon(uri);
    }
    getAdditionalInfo(uri) {
        const wsUri = this.wsService.getWorkspaceRootUri(uri);
        if (wsUri) {
            const wsRelative = wsUri.relative(uri);
            if (wsRelative === null || wsRelative === void 0 ? void 0 : wsRelative.hasDir) {
                return `${wsRelative.dir.toString()}`;
            }
            return '';
        }
        return this.labelProvider.getLongName(uri.parent);
    }
    async open(element) {
        const exists = await this.fileService.exists(element.uri);
        if (exists) {
            await (0, browser_1.open)(this.openerService, element.uri);
            return;
        }
        await this.editorManager.open(element.changedUri, {
            mode: 'reveal'
        });
    }
    async openDiff(originalUri, suggestedUri) {
        const diffUri = this.getDiffUri(originalUri, suggestedUri);
        (0, browser_1.open)(this.openerService, diffUri);
    }
    getDiffUri(originalUri, suggestedUri) {
        return browser_1.DiffUris.encode(originalUri, suggestedUri, `AI Changes: ${this.labelProvider.getName(originalUri)}`);
    }
    async delete(uri) {
        const exists = await this.fileService.exists(uri);
        if (exists) {
            await this.fileService.delete(uri);
        }
    }
    /** Returns true if there was a document available to save for the specified URI. */
    async trySave(suggestedUri) {
        const openModel = this.monacoWorkspace.getTextDocument(suggestedUri.toString());
        if (openModel) {
            await openModel.save();
            return true;
        }
        else {
            return false;
        }
    }
    async writeFrom(from, to, fallbackContent) {
        var _a, _b;
        const authoritativeContent = (_b = (_a = this.monacoWorkspace.getTextDocument(from.toString())) === null || _a === void 0 ? void 0 : _a.getText()) !== null && _b !== void 0 ? _b : fallbackContent;
        await this.write(to, authoritativeContent);
    }
    async write(uri, text) {
        const document = this.monacoWorkspace.getTextDocument(uri.toString());
        if (document) {
            await this.monacoWorkspace.applyBackgroundEdit(document, [{
                    range: document.textEditorModel.getFullModelRange(),
                    text
                }], () => true);
        }
        else {
            await this.fileService.write(uri, text);
        }
    }
    closeDiffsForSession(sessionId, except) {
        const openEditors = this.shell.widgets.filter(widget => {
            const uri = browser_1.NavigatableWidget.getUri(widget);
            return uri && uri.authority === sessionId && !(except === null || except === void 0 ? void 0 : except.some(candidate => candidate.path.toString() === uri.path.toString()));
        });
        openEditors.forEach(editor => editor.close());
    }
    closeDiff(uri) {
        const openEditors = this.shell.widgets.filter(widget => { var _a; return (_a = browser_1.NavigatableWidget.getUri(widget)) === null || _a === void 0 ? void 0 : _a.isEqual(uri); });
        openEditors.forEach(editor => editor.close());
    }
};
exports.ChangeSetFileService = ChangeSetFileService;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    tslib_1.__metadata("design:type", Object)
], ChangeSetFileService.prototype, "logger", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], ChangeSetFileService.prototype, "wsService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], ChangeSetFileService.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], ChangeSetFileService.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], ChangeSetFileService.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], ChangeSetFileService.prototype, "shell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_workspace_1.MonacoWorkspace),
    tslib_1.__metadata("design:type", monaco_workspace_1.MonacoWorkspace)
], ChangeSetFileService.prototype, "monacoWorkspace", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], ChangeSetFileService.prototype, "fileService", void 0);
exports.ChangeSetFileService = ChangeSetFileService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChangeSetFileService);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-chat_lib_browser_change-set-file-element_js.js.map