/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.Wrapper;

class TypeConvertingMethodAdapter
extends MethodVisitor {
    private static final int NUM_WRAPPERS = Wrapper.values().length;
    private static final String NAME_OBJECT = "java/lang/Object";
    private static final String WRAPPER_PREFIX = "Ljava/lang/";
    private static final String NAME_BOX_METHOD = "valueOf";
    private static final int[][] wideningOpcodes = new int[NUM_WRAPPERS][NUM_WRAPPERS];
    private static final Wrapper[] FROM_WRAPPER_NAME = new Wrapper[16];
    private static final Wrapper[] FROM_TYPE_SORT = new Wrapper[16];

    TypeConvertingMethodAdapter(MethodVisitor methodVisitor) {
        super(327680, methodVisitor);
    }

    private static void initWidening(Wrapper wrapper, int n, Wrapper ... wrapperArray) {
        for (Wrapper wrapper2 : wrapperArray) {
            TypeConvertingMethodAdapter.wideningOpcodes[wrapper2.ordinal()][wrapper.ordinal()] = n;
        }
    }

    private static int hashWrapperName(String string) {
        if (string.length() < 3) {
            return 0;
        }
        return (3 * string.charAt(1) + string.charAt(2)) % 16;
    }

    private Wrapper wrapperOrNullFromDescriptor(String string) {
        if (!string.startsWith(WRAPPER_PREFIX)) {
            return null;
        }
        String string2 = string.substring(WRAPPER_PREFIX.length(), string.length() - 1);
        Wrapper wrapper = FROM_WRAPPER_NAME[TypeConvertingMethodAdapter.hashWrapperName(string2)];
        if (wrapper == null || wrapper.wrapperSimpleName().equals(string2)) {
            return wrapper;
        }
        return null;
    }

    private static String wrapperName(Wrapper wrapper) {
        return "java/lang/" + wrapper.wrapperSimpleName();
    }

    private static String unboxMethod(Wrapper wrapper) {
        return wrapper.primitiveSimpleName() + "Value";
    }

    private static String boxingDescriptor(Wrapper wrapper) {
        return String.format("(%s)L%s;", Character.valueOf(wrapper.basicTypeChar()), TypeConvertingMethodAdapter.wrapperName(wrapper));
    }

    private static String unboxingDescriptor(Wrapper wrapper) {
        return "()" + wrapper.basicTypeChar();
    }

    void boxIfTypePrimitive(Type type) {
        Wrapper wrapper = FROM_TYPE_SORT[type.getSort()];
        if (wrapper != null) {
            this.box(wrapper);
        }
    }

    void widen(Wrapper wrapper, Wrapper wrapper2) {
        int n;
        if (wrapper != wrapper2 && (n = wideningOpcodes[wrapper.ordinal()][wrapper2.ordinal()]) != 0) {
            this.visitInsn(n);
        }
    }

    void box(Wrapper wrapper) {
        this.visitMethodInsn(184, TypeConvertingMethodAdapter.wrapperName(wrapper), NAME_BOX_METHOD, TypeConvertingMethodAdapter.boxingDescriptor(wrapper), false);
    }

    void unbox(String string, Wrapper wrapper) {
        this.visitMethodInsn(182, string, TypeConvertingMethodAdapter.unboxMethod(wrapper), TypeConvertingMethodAdapter.unboxingDescriptor(wrapper), false);
    }

    private String descriptorToName(String string) {
        int n = string.length() - 1;
        if (string.charAt(0) == 'L' && string.charAt(n) == ';') {
            return string.substring(1, n);
        }
        return string;
    }

    void cast(String string, String string2) {
        String string3 = this.descriptorToName(string);
        String string4 = this.descriptorToName(string2);
        if (!string4.equals(string3) && !string4.equals(NAME_OBJECT)) {
            this.visitTypeInsn(192, string4);
        }
    }

    private boolean isPrimitive(Wrapper wrapper) {
        return wrapper != Wrapper.OBJECT;
    }

    private Wrapper toWrapper(String string) {
        char c = string.charAt(0);
        if (c == '[' || c == '(') {
            c = 'L';
        }
        return Wrapper.forBasicType(c);
    }

    void convertType(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        if (clazz.equals(clazz2) && clazz.equals(clazz3)) {
            return;
        }
        if (clazz == Void.TYPE || clazz2 == Void.TYPE) {
            return;
        }
        if (clazz.isPrimitive()) {
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            if (clazz2.isPrimitive()) {
                this.widen(wrapper, Wrapper.forPrimitiveType(clazz2));
            } else {
                String string = BytecodeDescriptor.unparse(clazz2);
                Wrapper wrapper2 = this.wrapperOrNullFromDescriptor(string);
                if (wrapper2 != null) {
                    this.widen(wrapper, wrapper2);
                    this.box(wrapper2);
                } else {
                    this.box(wrapper);
                    this.cast(TypeConvertingMethodAdapter.wrapperName(wrapper), string);
                }
            }
        } else {
            String string;
            String string2 = BytecodeDescriptor.unparse(clazz);
            if (clazz3.isPrimitive()) {
                string = string2;
            } else {
                string = BytecodeDescriptor.unparse(clazz3);
                this.cast(string2, string);
            }
            String string3 = BytecodeDescriptor.unparse(clazz2);
            if (clazz2.isPrimitive()) {
                Wrapper wrapper = this.toWrapper(string3);
                Wrapper wrapper3 = this.wrapperOrNullFromDescriptor(string);
                if (wrapper3 != null) {
                    if (wrapper3.isSigned() || wrapper3.isFloating()) {
                        this.unbox(TypeConvertingMethodAdapter.wrapperName(wrapper3), wrapper);
                    } else {
                        this.unbox(TypeConvertingMethodAdapter.wrapperName(wrapper3), wrapper3);
                        this.widen(wrapper3, wrapper);
                    }
                } else {
                    String string4 = wrapper.isSigned() || wrapper.isFloating() ? "java/lang/Number" : TypeConvertingMethodAdapter.wrapperName(wrapper);
                    this.cast(string, string4);
                    this.unbox(string4, wrapper);
                }
            } else {
                this.cast(string, string3);
            }
        }
    }

    void iconst(int n) {
        if (n >= -1 && n <= 5) {
            this.mv.visitInsn(3 + n);
        } else if (n >= -128 && n <= 127) {
            this.mv.visitIntInsn(16, n);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, n);
        } else {
            this.mv.visitLdcInsn(n);
        }
    }

    static {
        Wrapper[] wrapperArray = Wrapper.values();
        int n = wrapperArray.length;
        for (int i = 0; i < n; ++i) {
            Wrapper wrapper = wrapperArray[i];
            if (wrapper.basicTypeChar() == 'L') continue;
            int n2 = TypeConvertingMethodAdapter.hashWrapperName(wrapper.wrapperSimpleName());
            assert (FROM_WRAPPER_NAME[n2] == null);
            TypeConvertingMethodAdapter.FROM_WRAPPER_NAME[n2] = wrapper;
        }
        for (int i = 0; i < NUM_WRAPPERS; ++i) {
            for (n = 0; n < NUM_WRAPPERS; ++n) {
                TypeConvertingMethodAdapter.wideningOpcodes[i][n] = 0;
            }
        }
        TypeConvertingMethodAdapter.initWidening(Wrapper.LONG, 133, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConvertingMethodAdapter.initWidening(Wrapper.LONG, 140, Wrapper.FLOAT);
        TypeConvertingMethodAdapter.initWidening(Wrapper.FLOAT, 134, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConvertingMethodAdapter.initWidening(Wrapper.FLOAT, 137, Wrapper.LONG);
        TypeConvertingMethodAdapter.initWidening(Wrapper.DOUBLE, 135, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConvertingMethodAdapter.initWidening(Wrapper.DOUBLE, 141, Wrapper.FLOAT);
        TypeConvertingMethodAdapter.initWidening(Wrapper.DOUBLE, 138, Wrapper.LONG);
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[3] = Wrapper.BYTE;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[4] = Wrapper.SHORT;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[5] = Wrapper.INT;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[7] = Wrapper.LONG;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[2] = Wrapper.CHAR;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[6] = Wrapper.FLOAT;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[8] = Wrapper.DOUBLE;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[1] = Wrapper.BOOLEAN;
    }
}

