/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import sun.awt.SunHints;
import sun.font.Font2D;
import sun.font.FontUtilities;

public class FontStrikeDesc {
    static final int AA_ON = 16;
    static final int AA_LCD_H = 32;
    static final int AA_LCD_V = 64;
    static final int FRAC_METRICS_ON = 256;
    static final int FRAC_METRICS_SP = 512;
    AffineTransform devTx;
    AffineTransform glyphTx;
    int style;
    int aaHint;
    int fmHint;
    private int hashCode;
    private int valuemask;

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.glyphTx.hashCode() + this.devTx.hashCode() + this.valuemask;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        try {
            FontStrikeDesc fontStrikeDesc = (FontStrikeDesc)object;
            return fontStrikeDesc.valuemask == this.valuemask && fontStrikeDesc.glyphTx.equals(this.glyphTx) && fontStrikeDesc.devTx.equals(this.devTx);
        }
        catch (Exception exception) {
            return false;
        }
    }

    FontStrikeDesc() {
    }

    public static int getAAHintIntVal(Object object, Font2D font2D, int n) {
        if (FontUtilities.isMacOSX14 && (object == SunHints.VALUE_TEXT_ANTIALIAS_OFF || object == SunHints.VALUE_TEXT_ANTIALIAS_DEFAULT || object == SunHints.VALUE_TEXT_ANTIALIAS_ON || object == SunHints.VALUE_TEXT_ANTIALIAS_GASP)) {
            return 2;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_OFF || object == SunHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
            return 1;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_ON) {
            return 2;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_GASP) {
            if (font2D.useAAForPtSize(n)) {
                return 2;
            }
            return 1;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || object == SunHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR) {
            return 4;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB || object == SunHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR) {
            return 6;
        }
        return 1;
    }

    public static int getAAHintIntVal(Font2D font2D, Font font, FontRenderContext fontRenderContext) {
        Object object = fontRenderContext.getAntiAliasingHint();
        if (FontUtilities.isMacOSX14 && (object == SunHints.VALUE_TEXT_ANTIALIAS_OFF || object == SunHints.VALUE_TEXT_ANTIALIAS_DEFAULT || object == SunHints.VALUE_TEXT_ANTIALIAS_ON || object == SunHints.VALUE_TEXT_ANTIALIAS_GASP)) {
            return 2;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_OFF || object == SunHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
            return 1;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_ON) {
            return 2;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_GASP) {
            int n;
            AffineTransform affineTransform = fontRenderContext.getTransform();
            if (affineTransform.isIdentity() && !font.isTransformed()) {
                n = font.getSize();
            } else {
                float f = font.getSize2D();
                if (affineTransform.isIdentity()) {
                    affineTransform = font.getTransform();
                    affineTransform.scale(f, f);
                } else {
                    affineTransform.scale(f, f);
                    if (font.isTransformed()) {
                        affineTransform.concatenate(font.getTransform());
                    }
                }
                double d = affineTransform.getShearX();
                double d2 = affineTransform.getScaleY();
                if (d != 0.0) {
                    d2 = Math.sqrt(d * d + d2 * d2);
                }
                n = (int)(Math.abs(d2) + 0.5);
            }
            if (font2D.useAAForPtSize(n)) {
                return 2;
            }
            return 1;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || object == SunHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR) {
            return 4;
        }
        if (object == SunHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB || object == SunHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR) {
            return 6;
        }
        return 1;
    }

    public static int getFMHintIntVal(Object object) {
        if (object == SunHints.VALUE_FRACTIONALMETRICS_OFF || object == SunHints.VALUE_FRACTIONALMETRICS_DEFAULT) {
            return 1;
        }
        return 2;
    }

    public FontStrikeDesc(AffineTransform affineTransform, AffineTransform affineTransform2, int n, int n2, int n3) {
        this.devTx = affineTransform;
        this.glyphTx = affineTransform2;
        this.style = n;
        this.aaHint = n2;
        this.fmHint = n3;
        this.valuemask = n;
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                this.valuemask |= 0x10;
                break;
            }
            case 4: 
            case 5: {
                this.valuemask |= 0x20;
                break;
            }
            case 6: 
            case 7: {
                this.valuemask |= 0x40;
                break;
            }
        }
        if (n3 == 2) {
            this.valuemask |= 0x100;
        }
    }

    FontStrikeDesc(FontStrikeDesc fontStrikeDesc) {
        this.devTx = fontStrikeDesc.devTx;
        this.glyphTx = (AffineTransform)fontStrikeDesc.glyphTx.clone();
        this.style = fontStrikeDesc.style;
        this.aaHint = fontStrikeDesc.aaHint;
        this.fmHint = fontStrikeDesc.fmHint;
        this.hashCode = fontStrikeDesc.hashCode;
        this.valuemask = fontStrikeDesc.valuemask;
    }

    public String toString() {
        return "FontStrikeDesc: Style=" + this.style + " AA=" + this.aaHint + " FM=" + this.fmHint + " devTx=" + this.devTx + " devTx.FontTx.ptSize=" + this.glyphTx;
    }
}

