/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.mbeanserver.WeakIdentityHashMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;

public class MXBeanLookup {
    private static final ThreadLocal<MXBeanLookup> currentLookup = new ThreadLocal();
    private final MBeanServerConnection mbsc;
    private final WeakIdentityHashMap<Object, ObjectName> mxbeanToObjectName = WeakIdentityHashMap.make();
    private final Map<ObjectName, WeakReference<Object>> objectNameToProxy = Util.newMap();
    private static final WeakIdentityHashMap<MBeanServerConnection, WeakReference<MXBeanLookup>> mbscToLookup = WeakIdentityHashMap.make();

    private MXBeanLookup(MBeanServerConnection mBeanServerConnection) {
        this.mbsc = mBeanServerConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MXBeanLookup lookupFor(MBeanServerConnection mBeanServerConnection) {
        WeakIdentityHashMap<MBeanServerConnection, WeakReference<MXBeanLookup>> weakIdentityHashMap = mbscToLookup;
        synchronized (weakIdentityHashMap) {
            MXBeanLookup mXBeanLookup;
            WeakReference<MXBeanLookup> weakReference = mbscToLookup.get(mBeanServerConnection);
            MXBeanLookup mXBeanLookup2 = mXBeanLookup = weakReference == null ? null : (MXBeanLookup)weakReference.get();
            if (mXBeanLookup == null) {
                mXBeanLookup = new MXBeanLookup(mBeanServerConnection);
                mbscToLookup.put(mBeanServerConnection, new WeakReference<MXBeanLookup>(mXBeanLookup));
            }
            return mXBeanLookup;
        }
    }

    synchronized <T> T objectNameToMXBean(ObjectName objectName, Class<T> clazz) {
        Object t;
        WeakReference<Object> weakReference = this.objectNameToProxy.get(objectName);
        if (weakReference != null && clazz.isInstance(t = weakReference.get())) {
            return clazz.cast(t);
        }
        t = JMX.newMXBeanProxy(this.mbsc, objectName, clazz);
        this.objectNameToProxy.put(objectName, new WeakReference(t));
        return t;
    }

    synchronized ObjectName mxbeanToObjectName(Object object) throws OpenDataException {
        String string;
        Object object2;
        if (object instanceof Proxy) {
            object2 = Proxy.getInvocationHandler(object);
            if (object2 instanceof MBeanServerInvocationHandler) {
                MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)object2;
                if (mBeanServerInvocationHandler.getMBeanServerConnection().equals(this.mbsc)) {
                    return mBeanServerInvocationHandler.getObjectName();
                }
                string = "proxy for a different MBeanServer";
            } else {
                string = "not a JMX proxy";
            }
        } else {
            object2 = this.mxbeanToObjectName.get(object);
            if (object2 != null) {
                return object2;
            }
            string = "not an MXBean registered in this MBeanServer";
        }
        object2 = object == null ? "null" : "object of type " + object.getClass().getName();
        throw new OpenDataException("Could not convert " + (String)object2 + " to an ObjectName: " + string);
    }

    synchronized void addReference(ObjectName objectName, Object object) throws InstanceAlreadyExistsException {
        String string;
        ObjectName objectName2 = this.mxbeanToObjectName.get(object);
        if (objectName2 != null && !"true".equalsIgnoreCase(string = AccessController.doPrivileged(new GetPropertyAction("jmx.mxbean.multiname")))) {
            throw new InstanceAlreadyExistsException("MXBean already registered with name " + objectName2);
        }
        this.mxbeanToObjectName.put(object, objectName);
    }

    synchronized boolean removeReference(ObjectName objectName, Object object) {
        if (objectName.equals(this.mxbeanToObjectName.get(object))) {
            this.mxbeanToObjectName.remove(object);
            return true;
        }
        return false;
    }

    static MXBeanLookup getLookup() {
        return currentLookup.get();
    }

    static void setLookup(MXBeanLookup mXBeanLookup) {
        currentLookup.set(mXBeanLookup);
    }
}

