/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.lt;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Centrin\u0117s Afrikos laikas",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Maskvos \u017eiemos laikas",
               "MST",
               "Maskvos vasaros laikas",
               "MST",
               "Maskvos laikas",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japonijos \u017eiemos laikas",
               "JST",
               "Japonijos vasaros laikas",
               "JDT",
               "Japonijos laikas",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistano \u017eiemos laikas",
               "PST",
               "Pakistano vasaros laikas",
               "PST",
               "Pakistano laikas",
               "PT",
            };
        final String[] Taipei = new String[] {
               "Taip\u0117jaus \u017eiemos laikas",
               "TST",
               "Taip\u0117jaus vasaros laikas",
               "TDT",
               "Taip\u0117jaus laikas",
               "TT",
            };
        final String[] Hovd = new String[] {
               "Hovd \u017eiemos laikas",
               "HST",
               "Hovd vasaros laikas",
               "HST",
               "Hovd laikas",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Magadano \u017eiemos laikas",
               "MST",
               "Magadano vasaros laikas",
               "MST",
               "Magadano laikas",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Centrin\u0117s vakar\u0173 Australijos \u017eiemos laikas",
               "ACWST",
               "Centrin\u0117s vakar\u0173 Australijos vasaros laikas",
               "ACWDT",
               "Centrin\u0117s vakar\u0173 Australijos laikas",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Vidurio Europos \u017eiemos laikas",
               "CEST",
               "Vidurio Europos vasaros laikas",
               "CEST",
               "Vidurio Europos laikas",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sachalino \u017eiemos laikas",
               "SST",
               "Sachalino vasaros laikas",
               "SST",
               "Sachalino laikas",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "Paragvajaus \u017eiemos laikas",
               "PST",
               "Paragvajaus vasaros laikas",
               "PST",
               "Paragvajaus laikas",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "Malaizijos laikas",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "Ryt\u0173 \u017eiemos laikas",
               "EST",
               "Ryt\u0173 vasaros laikas",
               "EDT",
               "Ryt\u0173 laikas",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe \u017eiemos laikas",
               "LHST",
               "Lord Howe vasaros laikas",
               "LHDT",
               "Lord Howe laikas",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Naujosios Zelandijos \u017eiemos laikas",
               "NZST",
               "Naujosios Zelandijos vasaros laikas",
               "NZDT",
               "Naujosios Zelandijos laikas",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijos vandenyno laikas",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsko \u017eiemos laikas",
               "YST",
               "Jakutsko vasaros laikas",
               "YST",
               "Jakutsko laikas",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "Mauricijaus \u017eiemos laikas",
               "MST",
               "Mauricijaus vasaros laikas",
               "MST",
               "Mauricijaus laikas",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ryt\u0173 Afrikos laikas",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Ryt\u0173 Timoro laikas",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "Saliamono sal\u0173 laikas",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae laikas",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "Mar\u0161alo sal\u0173 laikas",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "Ryt\u0173 Europos \u017eiemos laikas",
               "EEST",
               "Ryt\u0173 Europos vasaros laikas",
               "EEST",
               "Ryt\u0173 Europos laikas",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Niufaundlendo \u017eiemos laikas",
               "NST",
               "Niufaundlendo vasaros laikas",
               "NDT",
               "Niufaundlendo laikas",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganistano laikas",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "Honkongo \u017eiemos laikas",
               "HKST",
               "Honkongo vasaros laikas",
               "HKST",
               "Honkongo laikas",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Vakar\u0173 Argentinos \u017eiemos laikas",
               "WAST",
               "Vakar\u0173 Argentinos vasaros laikas",
               "WAST",
               "Vakar\u0173 Argentinos laikas",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Atlanto \u017eiemos laikas",
               "AST",
               "Atlanto vasaros laikas",
               "ADT",
               "Atlanto laikas",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponap\u0117s laikas",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Bolivia = new String[] {
               "Bolivijos laikas",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Indochina = new String[] {
               "Indokinijos laikas",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgo \u017eiemos laikas",
               "YST",
               "Jekaterinburgo vasaros laikas",
               "YST",
               "Jekaterinburgo laikas",
               "YT",
            };
        final String[] Maldives = new String[] {
               "Maldyv\u0173 laikas",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "Tai\u010dio laikas",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "Izraelio \u017eiemos laikas",
               "IST",
               "Izraelio vasaros laikas",
               "IDT",
               "Izraelio laikas",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centrin\u0117s Indokinijos laikas",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "Wallis ir Futuna laikas",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Piet\u0173 Afrikos laikas",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Line_Islands = new String[] {
               "Linijos sal\u0173 laikas",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistano \u017eiemos laikas",
               "UST",
               "Uzbekistano vasaros laikas",
               "UST",
               "Uzbekistano laikas",
               "UT",
            };
        final String[] Omsk = new String[] {
               "Omsko \u017eiemos laikas",
               "OST",
               "Omsko vasaros laikas",
               "OST",
               "Omsko laikas",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "Sei\u0161eli\u0173 sal\u0173 laikas",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "Urugvajaus \u017eiemos laikas",
               "UST",
               "Urugvajaus vasaros laikas",
               "UST",
               "Urugvajaus laikas",
               "UT",
            };
        final String[] Nepal = new String[] {
               "Nepalo laikas",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batoro \u017eiemos laikas",
               "UBST",
               "Ulan Batoro vasaros laikas",
               "UBST",
               "Ulan Batoro laikas",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Centro \u017eiemos laikas",
               "CST",
               "Centro vasaros laikas",
               "CDT",
               "Centro laikas",
               "CT",
            };
        final String[] Truk = new String[] {
               "Truk laikas",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "Niuj\u0117s laikas",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Wake = new String[] {
               "Veiko salos Laikas",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Falkland = new String[] {
               "Folkland\u0173 sal\u0173 \u017eiemos laikas",
               "FIST",
               "Folkland\u0173 sal\u0173 vasaros laikas",
               "FIST",
               "Folkland\u0173 sal\u0173 laikas",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu \u017eiemos laikas",
               "VST",
               "Vanuatu vasaros laikas",
               "VST",
               "Vanuatu laikas",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsko \u017eiemos laikas",
               "NST",
               "Novosibirsko vasaros laikas",
               "NST",
               "Novosibirsko laikas",
               "NT",
            };
        final String[] Singapore = new String[] {
               "Singap\u016bro \u017eiemos laikas",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Azores = new String[] {
               "Azor\u0173 sal\u0173 \u017eiemos laikas",
               "AST",
               "Azor\u0173 sal\u0173 vasaros laikas",
               "AST",
               "Azor\u0173 sal\u0173 laikas",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "Butano laikas",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Nauru = new String[] {
               "Nauru laikas",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsko \u017eiemos laikas",
               "KST",
               "Krasnojarsko vasaros laikas",
               "KST",
               "Krasnojarsko laikas",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Vakar\u0173 Kazachstano laikas",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "Myanmar laikas",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "Kal\u0117d\u0173 salos laikas",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazon\u0117s \u017eiemos laikas",
               "AST",
               "Amazon\u0117s vasaros laikas",
               "AST",
               "Amazon\u0117s laikas",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ryt\u0173 Kazachstano laikas",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017eio \u017eiemos laikas",
               "FST",
               "Fid\u017eio vasaros laikas",
               "FST",
               "Fid\u017eio laikas",
               "FT",
            };
        final String[] Reunion = new String[] {
               "Reunion laikas",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "Kokos\u0173 sal\u0173 laikas",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "Chatham \u017eiemos laikas",
               "CST",
               "Chatham vasaros laikas",
               "CDT",
               "Chatham laikas",
               "CT",
            };
        final String[] Argentina = new String[] {
               "Argentinos \u017eiemos laikas",
               "AST",
               "Argentinos vasaros laikas",
               "AST",
               "Argentinos laikas",
               "AT",
            };
        final String[] Gambier = new String[] {
               "Gambier laikas",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu laikas",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos laikas",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Makvario laikas",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "Venesuelos laikas",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaj\u0173\u2013Aleut\u0173 \u017eiemos laikas",
               "HAST",
               "Havaj\u0173\u2013Aleut\u0173 vasaros laikas",
               "HADT",
               "Havaj\u0173\u2013Aleut\u0173 laikas",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Centrin\u0117s Australijos \u017eiemos laikas",
               "ACST",
               "Centrin\u0117s Australijos vasaros laikas",
               "ACDT",
               "Centrin\u0117s Australijos laikas",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Ramiojo vandenyno \u017eiemos laikas",
               "PST",
               "Ramiojo vandenyno vasaros laikas",
               "PDT",
               "Ramiojo vandenyno laikas",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Finikso sal\u0173 laikas",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistano \u017eiemos laikas",
               "TST",
               "Turkmenistano vasaros laikas",
               "TST",
               "Turkmenistano laikas",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "Vakar\u0173 Europos \u017eiemos laikas",
               "WEST",
               "Vakar\u0173 Europos vasaros laikas",
               "WEST",
               "Vakar\u0173 Europos laikas",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Verde i\u0161ky\u0161ulio \u017eiemos laikas",
               "CVST",
               "Verde i\u0161ky\u0161ulio vasaros laikas",
               "CVST",
               "Verde i\u0161ky\u0161ulio laikas",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolko sal\u0173 laikas",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Guyana = new String[] {
               "Gajanos laikas",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn laikas",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Samoa = new String[] {
               "Samoa \u017eiemos laikas",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau laikas",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017eano \u017eiemos laikas",
               "AST",
               "Azerbaid\u017eano vasaros laikas",
               "AST",
               "Azerbaid\u017eano laikas",
               "AT",
            };
        final String[] Cuba = new String[] {
               "Kubos \u017eiemos laikas",
               "CST",
               "Kubos vasaros laikas",
               "CDT",
               "Kubos laikas",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Vakar\u0173 Afrikos \u017eiemos laikas",
               "WAST",
               "Vakar\u0173 Afrikos vasaros laikas",
               "WAST",
               "Vakar\u0173 Afrikos laikas",
               "WAT",
            };
        final String[] Philippines = new String[] {
               "Filipin\u0173 \u017eiemos laikas",
               "PST",
               "Filipin\u0173 vasaros laikas",
               "PST",
               "Filipin\u0173 laikas",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Piet\u0173 Pranc\u016bzijos ir Antarktinis Laikas",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "Piet\u0173 D\u017eord\u017eijos laikas",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "Naujosios Kaledonijos \u017eiemos laikas",
               "NCST",
               "Naujosios Kaledonijos vasaros laikas",
               "NCST",
               "Naujosios Kaledonijos laikas",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "Volgogrado \u017eiemos laikas",
               "VST",
               "Volgogrado vasaros laikas",
               "VST",
               "Volgogrado laikas",
               "VT",
            };
        final String[] Brunei = new String[] {
               "Brun\u0117jaus Darussalam laikas",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "Irano \u017eiemos laikas",
               "IST",
               "Irano vasaros laikas",
               "IDT",
               "Irano laikas",
               "IT",
            };
        final String[] Easter = new String[] {
               "Velyk\u0173 salos \u017eiemos laikas",
               "EIST",
               "Velyk\u0173 salos vasaros laikas",
               "EIST",
               "Velyk\u0173 salos laikas",
               "EIT",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikijos laikas",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tonga = new String[] {
               "Tongos \u017eiemos laikas",
               "TST",
               "Tongos vasaros laikas",
               "TST",
               "Tongos laikas",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161o \u017eiemos laikas",
               "BST",
               "Banglade\u0161o vasaros laikas",
               "BST",
               "Banglade\u0161o laikas",
               "BT",
            };
        final String[] Peru = new String[] {
               "Peru \u017eiemos laikas",
               "PST",
               "Peru vasaros laikas",
               "PST",
               "Peru laikas",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "Grenlandijos vakar\u0173 \u017eiemos laikas",
               "WGST",
               "Grenlandijos vakar\u0173 vasaros laikas",
               "WGST",
               "Grenlandijos vakar\u0173 laikas",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvadoro laikas",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "Grenlandijos ryt\u0173 \u017eiemos laikas",
               "EGST",
               "Grenlandijos ryt\u0173 vasaros laikas",
               "EGST",
               "Grenlandijos ryt\u0173 laikas",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Gulf laikas",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ryt\u0173 Indonezijos laikas",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Kor\u0117jie\u010di\u0173 \u017eiemos laikas",
               "KST",
               "Kor\u0117jie\u010di\u0173 vasaros laikas",
               "KDT",
               "Kor\u0117jie\u010di\u0173 laikas",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Vakar\u0173 Australijos \u017eiemos laikas",
               "AWST",
               "Vakar\u0173 Australijos vasaros laikas",
               "AWDT",
               "Vakar\u0173 Australijos laikas",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgystan laikas",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vakar\u0173 Indonezijos laikas",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Centrin\u0117s ryt\u0173 Australijos \u017eiemos laikas",
               "AEST",
               "Ryt\u0173 Australijos vasaros laikas",
               "AEDT",
               "Ryt\u0173 Australijos laikas",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "Pranc\u016bz\u0173 Gajanos laikas",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "Kolumbijos \u017eiemos laikas",
               "CST",
               "Kolumbijos vasaros laikas",
               "CST",
               "Kolumbijos laikas",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u010cil\u0117s \u017eiemos laikas",
               "CST",
               "\u010cil\u0117s vasaros laikas",
               "CST",
               "\u010cil\u0117s laikas",
               "CT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberto sal\u0173 laikas",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "Kaln\u0173 \u017eiemos laikas",
               "MST",
               "Kaln\u0173 vasaros laikas",
               "MDT",
               "Kaln\u0173 laikas",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas laikas",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Alaska = new String[] {
               "Aliaskos \u017eiemos laikas",
               "AKST",
               "Aliaskos vasaros laikas",
               "AKDT",
               "Aliaskos laikas",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoko \u017eiemos laikas",
               "VST",
               "Vladivostoko vasaros laikas",
               "VST",
               "Vladivostoko laikas",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro laikas",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsko \u017eiemos laikas",
               "IST",
               "Irkutsko vasaros laikas",
               "IST",
               "Irkutsko laikas",
               "IT",
            };
        final String[] Georgia = new String[] {
               "Gruzijos \u017eiemos laikas",
               "GST",
               "Gruzijos vasaros laikas",
               "GST",
               "Gruzijos laikas",
               "GT",
            };
        final String[] Tokelau = new String[] {
               "Tokelau laikas",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Naujosios Gvin\u0117jos laikas",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronjos \u017eiemos laikas",
               "FNST",
               "Fernando de Noronjos vasaros laikas",
               "FNST",
               "Fernando de Noronjos laikas",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan \u017eiemos laikas",
               "CST",
               "Choibalsan vasaros laikas",
               "CST",
               "\u010coibalsano laikas",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Brazilijos \u017eiemos laikas",
               "BST",
               "Brazilijos vasaros laikas",
               "BST",
               "Brazilijos laikas",
               "BT",
            };
        final String[] China = new String[] {
               "Kinijos \u017eiemos laikas",
               "CST",
               "Kinijos vasaros laikas",
               "CDT",
               "Kinijos laikas",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Arm\u0117nijos \u017eiemos laikas",
               "AST",
               "Arm\u0117nijos vasaros laikas",
               "AST",
               "Arm\u0117nijos laikas",
               "AT",
            };
        final String[] Cook = new String[] {
               "Kuko sal\u0173 pus\u0117s \u017eiemos laikas",
               "CIST",
               "Kuko sal\u0173 pus\u0117s vasaros laikas",
               "CIHST",
               "Kuko sal\u0173 pus\u0117s laikas",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Pacific/Efate", Vanuatu },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
