/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.provider.ParameterCache;
import sun.security.util.SecurityProviderConstants;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private DHParameterSpec params;
    private int pSize;
    private SecureRandom random;

    public DHKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_DH_KEY_SIZE, null);
    }

    static void checkKeySize(int n, int n2) throws InvalidParameterException {
        if (n < 512 || n > 8192 || (n & 0x3F) != 0) {
            throw new InvalidParameterException("DH key size must be multiple of 64, and can only range from 512 to 8192 (inclusive). The specific key size " + n + " is not supported");
        }
        if (n2 < 0 || n2 > n) {
            throw new InvalidParameterException("Exponent size must be positive and no larger than modulus size");
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        DHKeyPairGenerator.checkKeySize(n, 0);
        try {
            this.params = ParameterCache.getDHParameterSpec(n, secureRandom);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterException(generalSecurityException.getMessage());
        }
        this.pSize = n;
        this.random = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        this.params = (DHParameterSpec)algorithmParameterSpec;
        this.pSize = this.params.getP().bitLength();
        try {
            DHKeyPairGenerator.checkKeySize(this.pSize, this.params.getL());
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new InvalidAlgorithmParameterException(invalidParameterException.getMessage());
        }
        this.random = secureRandom;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        BigInteger bigInteger2 = this.params.getP();
        BigInteger bigInteger3 = this.params.getG();
        int n = this.params.getL();
        if (n == 0) {
            n = SecurityProviderConstants.getDefDHPrivateExpSize(this.params);
        }
        BigInteger bigInteger4 = bigInteger2.subtract(BigInteger.valueOf(2L));
        while ((bigInteger = new BigInteger(n, this.random)).compareTo(BigInteger.ONE) < 0 || bigInteger.compareTo(bigInteger4) > 0 || bigInteger.bitLength() != n) {
        }
        BigInteger bigInteger5 = bigInteger3.modPow(bigInteger, bigInteger2);
        DHPublicKey dHPublicKey = new DHPublicKey(bigInteger5, bigInteger2, bigInteger3, n);
        DHPrivateKey dHPrivateKey = new DHPrivateKey(bigInteger, bigInteger2, bigInteger3, n);
        return new KeyPair(dHPublicKey, dHPrivateKey);
    }
}

