/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTError;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.awt.CGraphicsDevice;
import sun.java2d.MacosxSurfaceManagerFactory;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceManagerFactory;

public final class CGraphicsEnvironment
extends SunGraphicsEnvironment {
    private final Map<Integer, CGraphicsDevice> devices = new HashMap<Integer, CGraphicsDevice>(5);
    private final long displayReconfigContext;
    static String[] sLogicalFonts;

    private static native void initCocoa();

    private static native int[] getDisplayIDs();

    private static native int getMainDisplayID();

    public static void init() {
    }

    private native long registerDisplayReconfiguration();

    private native void deregisterDisplayReconfiguration(long var1);

    public CGraphicsEnvironment() {
        if (CGraphicsEnvironment.isHeadless()) {
            this.displayReconfigContext = 0L;
            return;
        }
        this.initDevices();
        this.displayReconfigContext = this.registerDisplayReconfiguration();
        if (this.displayReconfigContext == 0L) {
            throw new RuntimeException("Could not register CoreGraphics display reconfiguration callback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _displayReconfiguration(int n, boolean bl) {
        CGraphicsEnvironment cGraphicsEnvironment = this;
        synchronized (cGraphicsEnvironment) {
            if (bl && this.devices.containsKey(n)) {
                CGraphicsDevice cGraphicsDevice = this.devices.remove(n);
                cGraphicsDevice.invalidate(CGraphicsEnvironment.getMainDisplayID());
                cGraphicsDevice.displayChanged();
            }
        }
        this.initDevices();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.deregisterDisplayReconfiguration(this.displayReconfigContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDevices() {
        CGraphicsEnvironment cGraphicsEnvironment = this;
        synchronized (cGraphicsEnvironment) {
            HashMap<Integer, CGraphicsDevice> hashMap = new HashMap<Integer, CGraphicsDevice>(this.devices);
            this.devices.clear();
            int n = CGraphicsEnvironment.getMainDisplayID();
            if (!hashMap.containsKey(n)) {
                hashMap.put(n, new CGraphicsDevice(n));
            }
            for (int n2 : CGraphicsEnvironment.getDisplayIDs()) {
                this.devices.put(n2, hashMap.containsKey(n2) ? (CGraphicsDevice)hashMap.get(n2) : new CGraphicsDevice(n2));
            }
        }
        this.displayChanged();
    }

    @Override
    public synchronized GraphicsDevice getDefaultScreenDevice() throws HeadlessException {
        int n = CGraphicsEnvironment.getMainDisplayID();
        CGraphicsDevice cGraphicsDevice = this.devices.get(n);
        if (cGraphicsDevice == null) {
            this.initDevices();
            cGraphicsDevice = this.devices.get(n);
            if (cGraphicsDevice == null) {
                throw new AWTError("no screen devices");
            }
        }
        return cGraphicsDevice;
    }

    @Override
    public synchronized GraphicsDevice[] getScreenDevices() throws HeadlessException {
        return this.devices.values().toArray(new CGraphicsDevice[this.devices.values().size()]);
    }

    public synchronized GraphicsDevice getScreenDevice(int n) {
        return this.devices.get(n);
    }

    @Override
    protected synchronized int getNumScreens() {
        return this.devices.size();
    }

    @Override
    protected GraphicsDevice makeScreenDevice(int n) {
        throw new UnsupportedOperationException("This method is unused and should not be called in this implementation");
    }

    @Override
    public boolean isDisplayLocal() {
        return true;
    }

    @Override
    public Font[] getAllFonts() {
        Font[] fontArray = super.getAllFonts();
        int n = sLogicalFonts.length;
        int n2 = fontArray.length;
        Font[] fontArray2 = new Font[n2 + n];
        System.arraycopy(fontArray, 0, fontArray2, n, n2);
        for (int i = 0; i < n; ++i) {
            fontArray2[i] = new Font(sLogicalFonts[i], 0, 1);
        }
        return fontArray2;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (GraphicsEnvironment.isHeadless()) {
                    return null;
                }
                CGraphicsEnvironment.initCocoa();
                return null;
            }
        });
        SurfaceManagerFactory.setInstance(new MacosxSurfaceManagerFactory());
        sLogicalFonts = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
    }
}

