/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Transforms
extends SignatureElementProxy {
    public static final String TRANSFORM_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String TRANSFORM_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String TRANSFORM_C14N11_OMIT_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11";
    public static final String TRANSFORM_C14N11_WITH_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
    public static final String TRANSFORM_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANSFORM_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String TRANSFORM_XSLT = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String TRANSFORM_BASE64_DECODE = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String TRANSFORM_XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String TRANSFORM_ENVELOPED_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String TRANSFORM_XPOINTER = "http://www.w3.org/TR/2001/WD-xptr-20010108";
    public static final String TRANSFORM_XPATH2FILTER = "http://www.w3.org/2002/06/xmldsig-filter2";
    private static final Logger LOG = LoggerFactory.getLogger(Transforms.class);
    private Element[] transforms;
    private boolean secureValidation;

    protected Transforms() {
    }

    public Transforms(Document document) {
        super(document);
        this.addReturnToSelf();
    }

    public Transforms(Element element, String string) throws DOMException, XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        int n = this.getLength();
        if (n == 0) {
            Object[] objectArray = new Object[]{"Transform", "Transforms"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
    }

    public void setSecureValidation(boolean bl) {
        this.secureValidation = bl;
    }

    public void addTransform(String string) throws TransformationException {
        try {
            LOG.debug("Transforms.addTransform({})", string);
            Transform transform = new Transform(this.getDocument(), string);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException(invalidTransformException);
        }
    }

    public void addTransform(String string, Element element) throws TransformationException {
        try {
            LOG.debug("Transforms.addTransform({})", string);
            Transform transform = new Transform(this.getDocument(), string, element);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException(invalidTransformException);
        }
    }

    public void addTransform(String string, NodeList nodeList) throws TransformationException {
        try {
            Transform transform = new Transform(this.getDocument(), string, nodeList);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException(invalidTransformException);
        }
    }

    private void addTransform(Transform transform) {
        LOG.debug("Transforms.addTransform({})", transform.getURI());
        Element element = transform.getElement();
        this.appendSelf(element);
        this.addReturnToSelf();
    }

    public XMLSignatureInput performTransforms(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        return this.performTransforms(xMLSignatureInput, null);
    }

    public XMLSignatureInput performTransforms(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws TransformationException {
        try {
            int n = this.getLength() - 1;
            for (int i = 0; i < n; ++i) {
                Transform transform = this.item(i);
                LOG.debug("Perform the ({})th {} transform", i, transform.getURI());
                this.checkSecureValidation(transform);
                xMLSignatureInput = transform.performTransform(xMLSignatureInput);
            }
            if (n >= 0) {
                Transform transform = this.item(n);
                LOG.debug("Perform the ({})th {} transform", n, transform.getURI());
                this.checkSecureValidation(transform);
                xMLSignatureInput = transform.performTransform(xMLSignatureInput, outputStream);
            }
            return xMLSignatureInput;
        }
        catch (IOException iOException) {
            throw new TransformationException(iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException(canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException(invalidCanonicalizerException);
        }
    }

    private void checkSecureValidation(Transform transform) throws TransformationException {
        String string = transform.getURI();
        if (this.secureValidation && TRANSFORM_XSLT.equals(string)) {
            Object[] objectArray = new Object[]{string};
            throw new TransformationException("signature.Transform.ForbiddenTransform", objectArray);
        }
        transform.setSecureValidation(this.secureValidation);
    }

    public int getLength() {
        this.initTransforms();
        return this.transforms.length;
    }

    public Transform item(int n) throws TransformationException {
        try {
            this.initTransforms();
            return new Transform(this.transforms[n], this.baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException(xMLSecurityException);
        }
    }

    private void initTransforms() {
        if (this.transforms == null) {
            this.transforms = XMLUtils.selectDsNodes(this.getFirstChild(), "Transform");
        }
    }

    @Override
    public String getBaseLocalName() {
        return "Transforms";
    }
}

