/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.mr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_mr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "\u092b\u0949\u0915\u0932\u0902\u0921 \u092c\u0947\u091f\u0947 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "FIST",
               "\u092b\u0949\u0915\u0932\u0902\u0921 \u092c\u0947\u091f\u0947 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "FIST",
               "\u092b\u0949\u0915\u0932\u0902\u0921 \u092c\u0947\u091f\u0947 \u0935\u0947\u0933",
               "FIT",
            };
        final String[] Iran = new String[] {
               "\u0908\u0930\u093e\u0923 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "IST",
               "\u0908\u0930\u093e\u0923 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "IDT",
               "\u0908\u0930\u093e\u0923 \u0935\u0947\u0933",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "\u0915\u0947\u092a \u0935\u094d\u0939\u0930\u094d\u0921\u0947 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CVST",
               "\u0915\u0947\u092a \u0935\u094d\u0939\u0930\u094d\u0921\u0947 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "CVST",
               "\u0915\u0947\u092a \u0935\u094d\u0939\u0930\u094d\u0921\u0947 \u0935\u0947\u0933",
               "CVT",
            };
        final String[] GMT = new String[] {
               "\u0917\u094d\u0930\u093f\u0928\u093f\u091a \u092e\u0927\u094d\u092f\u092e\u093e\u0928 \u0935\u0947\u0933",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Ponape = new String[] {
               "\u092a\u094b\u0928\u093e\u092a\u0947 \u0935\u0947\u0933",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "OST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "OST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0935\u0947\u0933",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "\u0915\u094b\u0936\u0930\u094d\u200d\u092f\u0947 \u0935\u0947\u0933",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0939\u0935\u093e\u0908- \u0905\u200d\u0945\u0932\u094d\u092f\u0942\u091f\u093f\u092f\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "HAST",
               "\u0939\u0935\u093e\u0908 \u090f\u0932\u094d\u092f\u0941\u0936\u093f\u092f\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "HADT",
               "\u0939\u0935\u093e\u0908 \u090f\u0932\u094d\u092f\u0941\u0936\u093f\u092f\u0928 \u0935\u0947\u0933",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930 \u0935\u0947\u0933",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "\u0938\u0916\u0932\u093f\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "SST",
               "\u0938\u0916\u0932\u093f\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "SST",
               "\u0938\u0916\u0932\u093f\u0928 \u0935\u0947\u0933",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "\u092f\u0941\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "YST",
               "\u092f\u0941\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "YST",
               "\u092f\u0915\u0941\u0924\u094d\u0938\u094d\u0915",
               "YT",
            };
        final String[] Gambier = new String[] {
               "\u0917\u0945\u092e\u094d\u092c\u093f\u092f\u0930 \u0935\u0947\u0933",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Paraguay = new String[] {
               "\u092a\u0930\u093e\u0917\u094d\u0935\u0947 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "PST",
               "\u092a\u0930\u093e\u0917\u094d\u0935\u0947 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "PST",
               "\u092a\u0930\u093e\u0917\u094d\u0935\u0947 \u0935\u0947\u0933",
               "PT",
            };
        final String[] Nepal = new String[] {
               "\u0928\u0947\u092a\u093e\u0933 \u0935\u0947\u0933",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Maldives = new String[] {
               "\u092e\u093e\u0932\u0926\u0940\u0935\u094d\u091c \u0935\u0947\u0933",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "TST",
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "TST",
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928 \u0935\u0947\u0933",
               "TT",
            };
        final String[] Truk = new String[] {
               "\u091f\u094d\u0930\u0915 \u0935\u0947\u0933",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "\u091c\u092a\u093e\u0928 \u092a\u094d\u0930\u092e\u093e\u0923 \u0935\u0947\u0933",
               "JST",
               "\u091c\u092a\u093e\u0928 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "JDT",
               "\u091c\u092a\u093e\u0928 \u0935\u0947\u0933",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "VST",
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "VST",
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "WEST",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "WEST",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0935\u0947\u0933",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "BST",
               "\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "BST",
               "\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936 \u0935\u0947\u0933",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "\u092a\u0942\u0930\u094d\u0935 \u0924\u093f\u092e\u094b\u0930 \u0935\u0947\u0933",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "WGST",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "WGST",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u0935\u0947\u0933",
               "WGT",
            };
        final String[] Marquesas = new String[] {
               "\u092e\u093e\u0930\u094d\u0915\u094d\u0935\u0940\u0938\u093e\u0938 \u0935\u0947\u0933",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Colombia = new String[] {
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CST",
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "CST",
               "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e \u0935\u0947\u0933",
               "CT",
            };
        final String[] Wake = new String[] {
               "\u0935\u0947\u0915 \u092c\u0947\u091f \u0935\u0947\u0933",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Suriname = new String[] {
               "\u0938\u0941\u0930\u0940\u092e\u093e\u0928 \u0935\u0947\u0933",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Gulf = new String[] {
               "\u0917\u0932\u094d\u092b \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Singapore = new String[] {
               "\u0938\u093f\u0902\u0917\u093e\u092a\u0942\u0930 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "\u0939\u0949\u0935\u094d\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "HST",
               "\u0939\u0949\u0935\u094d\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "HST",
               "\u0939\u0949\u0935\u094d\u0921 \u0935\u0947\u0933",
               "HT",
            };
        final String[] Amazon = new String[] {
               "\u0905\u0945\u092e\u0947\u091d\u0949\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AST",
               "\u0905\u0945\u092e\u0947\u091d\u0949\u0928 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "AST",
               "\u0905\u0945\u092e\u0947\u091d\u0949\u0928 \u0935\u0947\u0933",
               "AT",
            };
        final String[] Tokelau = new String[] {
               "\u091f\u094b\u0915\u0947\u0932\u093e\u090a \u0935\u0947\u0933",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u0917\u093f\u0932\u092c\u0930\u094d\u091f \u092c\u0947\u091f\u0947 \u0935\u0947\u0933",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Pakistan = new String[] {
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "PST",
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "PST",
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0935\u0947\u0933",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "\u0909\u0932\u093e\u0928 \u092c\u093e\u0924\u094b\u0930 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "UBST",
               "\u0909\u0932\u093e\u0928 \u092c\u093e\u0924\u094b\u0930 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "UBST",
               "\u0909\u0932\u093e\u0928 \u092c\u093e\u0924\u094b\u0930 \u0935\u0947\u0933",
               "UBT",
            };
        final String[] Palau = new String[] {
               "\u092a\u0932\u093e\u0909 \u0935\u0947\u0933",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "\u0928\u094d\u092f\u0942 \u0915\u0945\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "NCST",
               "\u0928\u094d\u092f\u0942 \u0915\u0945\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "NCST",
               "\u0928\u094d\u092f\u0942 \u0915\u0945\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e \u0935\u0947\u0933",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "\u0928\u0909\u0930\u0941 \u0935\u0947\u0933",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "\u092a\u0945\u0938\u093f\u092b\u093f\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "PST",
               "\u092a\u0945\u0938\u093f\u092b\u093f\u0915 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "PDT",
               "\u092a\u0945\u0938\u093f\u092b\u093f\u0915 \u0935\u0947\u0933",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u0935\u0947\u0933",
               "WAST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0935\u0947\u0933",
               "WAST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0935\u0947\u0933",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "\u0917\u0945\u0932\u093e\u092a\u093e\u0917\u094b\u0938 \u0935\u0947\u0933",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "\u092b\u094d\u0930\u0947\u0902\u091a \u0917\u092f\u093e\u0928\u093e \u0935\u0947\u0933",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "EGST",
               "\u092a\u0942\u0930\u094d\u0935 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "EGST",
               "\u092a\u0942\u0930\u094d\u0935 \u0917\u094d\u0930\u0940\u0928\u0932\u0901\u0921 \u0935\u0947\u0933",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "\u0916\u094d\u0930\u093f\u0938\u092e\u0938 \u092c\u0947\u091f \u0935\u0947\u0933",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "\u0935\u094d\u0939\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "VST",
               "\u0935\u094d\u0939\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "VST",
               "\u0935\u094d\u0939\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u0935\u0947\u0933",
               "VT",
            };
        final String[] Korea = new String[] {
               "\u0915\u094b\u0930\u093f\u092f\u0928 \u092a\u094d\u0930\u092e\u093e\u0923 \u0935\u0947\u0933",
               "KST",
               "\u0915\u094b\u0930\u093f\u092f\u0928 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "KDT",
               "\u0915\u094b\u0930\u093f\u092f\u0928 \u0935\u0947\u0933",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "\u0935\u093e\u0928\u093e\u091f\u0941 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "VST",
               "\u0935\u093e\u0928\u093e\u091f\u0941 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "VST",
               "\u0935\u093e\u0928\u093e\u091f\u0941 \u0935\u0947\u0933",
               "VT",
            };
        final String[] Argentina = new String[] {
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "AST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e \u0935\u0947\u0933",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u094b\u0935\u0947 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "LHST",
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u094b\u0935\u0947 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "LHDT",
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u094b\u0935\u0947 \u0935\u0947\u0933",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "\u0938\u094d\u092f\u094b\u0935\u093e \u0935\u0947\u0933",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Kyrgystan = new String[] {
               "\u0915\u093f\u0930\u0917\u0940\u0938\u094d\u0924\u093e\u0928 \u0935\u0947\u0933",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Arabian = new String[] {
               "\u0905\u0930\u092c\u0940 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AST",
               "\u0905\u0930\u092c\u0940 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "ADT",
               "\u0905\u0930\u092c\u0940 \u0935\u0947\u0933",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u092a\u0942\u0930\u094d\u0935\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AEST",
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u092a\u0942\u0930\u094d\u0935\u0940\u092f \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "AEDT",
               "\u092a\u0942\u0930\u094d\u0935 \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0935\u0947\u0933",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "\u0907\u0930\u094d\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "IST",
               "\u0907\u0930\u094d\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "IST",
               "\u0907\u0930\u094d\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0935\u0947\u0933",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "\u092e\u0949\u0930\u093f\u0936\u0938 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "MST",
               "\u092e\u0949\u0930\u093f\u0936\u0938 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "MST",
               "\u092e\u0949\u0930\u093f\u0936\u0938 \u0935\u0947\u0933",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0939\u093f\u0902\u0926\u0940 \u092e\u0939\u093e\u0938\u093e\u0917\u0930 \u0935\u0947\u0933",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "\u091a\u094b\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CST",
               "\u091a\u094b\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "CST",
               "\u091a\u094b\u0908\u092c\u093e\u0932\u094d\u0938\u0928 \u0935\u0947\u0933",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "EST",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "EDT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0935\u0947\u0933",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AWST",
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "AWDT",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0935\u0947\u0933",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u092e\u0927\u094d\u092f-\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "ACWST",
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u092e\u0927\u094d\u092f-\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "ACWDT",
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u092e\u0927\u094d\u092f-\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0935\u0947\u0933",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0915\u094d\u0930\u093e\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0915\u094d\u0938 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "KST",
               "\u0915\u094d\u0930\u093e\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0915\u094d\u0938 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "KST",
               "\u0915\u094d\u0930\u094b\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u0935\u0947\u0933",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935 \u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e \u0935\u0947\u0933",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "\u0935\u094d\u0939\u0947\u0928\u0947\u091d\u0941\u090f\u0932\u093e \u0935\u0947\u0933",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Pitcairn = new String[] {
               "\u092a\u093f\u091f\u0915\u0948\u0930\u094d\u0928 \u0935\u0947\u0933",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Bhutan = new String[] {
               "\u092d\u0942\u0924\u093e\u0928 \u0935\u0947\u0933",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "\u092b\u0930\u094d\u0928\u093e\u0902\u0921\u094b \u0926\u0940 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "FNST",
               "\u092b\u0930\u094d\u0928\u093e\u0902\u0921\u094b \u0926\u0940 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "FNST",
               "\u092b\u0930\u094d\u0928\u093e\u0902\u0921\u094b \u0926\u0940 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0935\u0947\u0933",
               "FNT",
            };
        final String[] Malaysia = new String[] {
               "\u092e\u0932\u0947\u0936\u093f\u092f\u093e \u0935\u0947\u0933",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0928\u094b\u0935\u094b\u0938\u093f\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "NST",
               "\u0928\u094b\u0935\u094b\u0938\u093f\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "NST",
               "\u0928\u094b\u0935\u094b\u0938\u094b\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u0935\u0947\u0933",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "\u092a\u0930\u094d\u0935\u0924\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "MST",
               "\u092a\u0930\u094d\u0935\u0924\u0940\u092f \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "MDT",
               "\u092a\u0930\u094d\u0935\u0924\u0940\u092f \u0935\u0947\u0933",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "\u0928\u0949\u0930\u092b\u094b\u0915 \u092c\u0947\u091f\u0947 \u0935\u0947\u0933",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "\u0928\u093f\u092f\u0942 \u0935\u0947\u0933",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Vostok = new String[] {
               "\u0935\u094b\u0938\u094d\u091f\u094b\u0915 \u0935\u0947\u0933",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AKST",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "AKDT",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0935\u0947\u0933",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AST",
               "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "AST",
               "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e \u0935\u0947\u0933",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u092e\u093e\u0930\u094d\u0936\u0932 \u092c\u0947\u091f\u0947 \u0935\u0947\u0933",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "ACST",
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u0928 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "ACDT",
               "\u092e\u0927\u094d\u092f \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0935\u0947\u0933",
               "CAT",
            };
        final String[] Azores = new String[] {
               "\u0905\u200d\u0945\u091d\u094b\u0930\u0938 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AST",
               "\u0905\u200d\u0945\u091d\u094b\u0930\u0938 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "AST",
               "\u0905\u200d\u0945\u091d\u094b\u0930\u0938 \u0935\u0947\u0933",
               "AT",
            };
        final String[] Reunion = new String[] {
               "\u0930\u0940\u092f\u0942\u0928\u093f\u092f\u0928 \u0935\u0947\u0933",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "\u0907\u0902\u0921\u094b\u091a\u093e\u092f\u0928\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "\u0907\u0915\u094d\u0935\u093e\u0921\u094b\u0930 \u0935\u0947\u0933",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "\u092e\u0945\u0917\u093e\u0921\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "MST",
               "\u092e\u0945\u0917\u093e\u0921\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "MST",
               "\u092e\u0947\u0917\u093e\u0921\u0928 \u0935\u0947\u0933",
               "MT",
            };
        final String[] Chatham = new String[] {
               "\u091a\u0945\u091f\u0939\u0945\u092e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CST",
               "\u091a\u0945\u091f\u0939\u0945\u092e \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "CDT",
               "\u091a\u0945\u091f\u0939\u0945\u092e \u0935\u0947\u0933",
               "CT",
            };
        final String[] Davis = new String[] {
               "\u0921\u0947\u0935\u094d\u0939\u093f\u0938 \u0935\u0947\u0933",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\u0915\u094d\u092f\u0942\u092c\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CST",
               "\u0915\u094d\u092f\u0942\u092c\u093e \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "CDT",
               "\u0915\u094d\u092f\u0942\u092c\u093e \u0935\u0947\u0933",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0905\u092b\u094d\u0930\u093f\u0915\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "WAST",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0905\u092b\u094d\u0930\u093f\u0915\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "WAST",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0905\u092b\u094d\u0930\u093f\u0915\u093e \u0935\u0947\u0933",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "\u092e\u0949\u0938\u094d\u0915\u094b \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "MST",
               "\u092e\u0949\u0938\u094d\u0915\u094b \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "MST",
               "\u092e\u0949\u0938\u094d\u0915\u094b \u0935\u0947\u0933",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093f\u0928\u0940 \u0935\u0947\u0933",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935 \u0915\u091d\u093e\u0915\u0938\u094d\u0924\u093e\u0928 \u0935\u0947\u0933",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "\u0928\u094d\u092f\u0942\u091d\u0940\u0932\u0902\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "NZST",
               "\u0928\u094d\u092f\u0942\u091d\u0940\u0932\u0902\u0921 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "NZDT",
               "\u0928\u094d\u092f\u0942\u091d\u0940\u0932\u0902\u0921 \u0935\u0947\u0933",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0939\u093e\u0901\u0917\u0915\u093e\u0901\u0917 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933'",
               "HKST",
               "\u0939\u093e\u0901\u0917\u0915\u093e\u0901\u0917 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "HKST",
               "\u0939\u093e\u0901\u0917\u0915\u093e\u0901\u0917 \u0935\u0947\u0933",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "\u092c\u094d\u0930\u093e\u0938\u093f\u0932\u093f\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "BST",
               "\u092c\u094d\u0930\u093e\u0938\u093f\u0932\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "BST",
               "\u092c\u094d\u0930\u093e\u0938\u093f\u0932\u093f\u092f\u093e \u0935\u0947\u0933",
               "BT",
            };
        final String[] Taipei = new String[] {
               "\u0924\u093e\u0907\u092a\u0947\u0908 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "TST",
               "\u0924\u093e\u0907\u092a\u0947\u0908 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "TDT",
               "\u0924\u093e\u0907\u092a\u0947\u0908 \u0935\u0947\u0933",
               "TT",
            };
        final String[] Cocos = new String[] {
               "\u0915\u094b\u0915\u094b\u0938 \u092c\u0947\u091f \u0935\u0947\u0933",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "\u0905\u092b\u0917\u093e\u0923\u093f\u0938\u094d\u0924\u093e\u0928 \u0935\u0947\u0933",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e \u0935\u0947\u0933",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "\u092c\u094d\u0930\u0941\u0928\u0947\u0908 \u0926\u093e\u0930\u0941\u0938\u0932\u093e\u092e \u0935\u0947\u0933",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u092b\u094b\u0928\u093f\u0915\u094d\u0938 \u092c\u0947\u091f\u0947 \u0935\u0947\u0933",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "\u0938\u0947\u0936\u0947\u0932\u094d\u0938 \u0935\u0947\u0933",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "\u092e\u0927\u094d\u092f \u0905\u092b\u094d\u0930\u093f\u0915\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "Easter Island Standard Time",
               "EIST",
               "\u0908\u0938\u094d\u091f\u0930 \u092c\u0947\u091f \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "EIST",
               "Easter Island Time",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0935\u0947\u0933",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u092e\u0927\u094d\u092f \u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e \u0935\u0947\u0933",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u0940 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "PST",
               "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "PST",
               "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u0940 \u0935\u0947\u0933",
               "PT",
            };
        final String[] Georgia = new String[] {
               "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "GST",
               "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "GST",
               "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0935\u0947\u0933",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "\u092c\u094b\u0932\u093f\u0935\u094d\u0939\u093f\u092f\u093e \u0935\u0947\u0933",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "\u092a\u0947\u0930\u0941 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "PST",
               "\u092a\u0947\u0930\u0941 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "PST",
               "\u092a\u0947\u0930\u0941 \u0935\u0947\u0933",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "\u091a\u0945\u092e\u094b\u0930\u094b \u0935\u0947\u0933",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "\u0928\u094d\u092f\u0942 \u092b\u093e\u0909\u0902\u0921\u0932\u0902\u0921 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "NST",
               "\u0928\u094d\u092f\u0942 \u092b\u093e\u0909\u0902\u0921\u0932\u0902\u0921 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "NDT",
               "\u0928\u094d\u092f\u0942 \u092b\u093e\u0909\u0902\u0921\u0932\u0902\u0921 \u0935\u0947\u0933",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "\u0932\u093e\u0907\u0928 \u092c\u0947\u091f\u0947 \u0935\u0947\u0933",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "\u0915\u0941\u0915 \u092c\u0947\u091f\u0947 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CIST",
               "\u0915\u0941\u0915 \u092c\u0947\u091f\u0947 \u0905\u0930\u094d\u0927 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "CIHST",
               "\u0915\u0941\u0915 \u092c\u0947\u091f\u0947 \u0935\u0947\u0933",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CST",
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "CDT",
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0935\u0947\u0933",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935 \u0905\u092b\u094d\u0930\u093f\u0915\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0905\u091d\u0930\u092c\u0948\u091c\u093e\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AST",
               "\u0905\u091d\u0930\u092c\u0948\u091c\u093e\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "AST",
               "\u0905\u091d\u0930\u092c\u0948\u091c\u093e\u0928 \u0935\u0947\u0933",
               "AT",
            };
        final String[] Guyana = new String[] {
               "\u0917\u092f\u093e\u0928\u093e \u0935\u0947\u0933",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u092f\u0947\u0915\u0924\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "YST",
               "\u092f\u0947\u0915\u0924\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "YST",
               "\u092f\u0947\u0915\u094d\u0924\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u0935\u0947\u0933",
               "YT",
            };
        final String[] China = new String[] {
               "\u091a\u0940\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CST",
               "\u091a\u0940\u0928 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "CDT",
               "\u091a\u0940\u0928 \u0935\u0947\u0933",
               "CT",
            };
        final String[] Samoa = new String[] {
               "\u0938\u093e\u092e\u094b\u0906 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "\u091f\u094b\u0902\u0917\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "TST",
               "\u091f\u094b\u0902\u0917\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "TST",
               "\u091f\u094b\u0902\u0917\u093e \u0935\u0947\u0933",
               "TT",
            };
        final String[] Solomon = new String[] {
               "\u0938\u094b\u0932\u094b\u092e\u0928 \u092c\u0947\u091f\u0947 \u0935\u0947\u0933",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092b\u094d\u0930\u093f\u0915\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "\u092e\u0915\u094d\u0935\u093e\u0930\u0947 \u0935\u0947\u0933",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "\u092b\u094d\u0930\u0947\u0902\u091a \u0926\u093e\u0915\u094d\u0937\u093f\u0923\u093e\u0924\u094d\u092f \u0906\u0923\u093f \u0905\u0902\u091f\u093e\u0930\u094d\u0915\u094d\u091f\u093f\u0915 \u0935\u0947\u0933",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "\u091a\u093f\u0932\u0940 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CST",
               "\u091a\u093f\u0932\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "CST",
               "\u091a\u093f\u0932\u0940 \u0935\u0947\u0933",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0915\u091d\u093e\u0915\u0938\u094d\u0924\u093e\u0928 \u0935\u0947\u0933",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "\u0907\u0938\u094d\u0924\u094d\u0930\u093e\u0907\u0932 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "IST",
               "\u0907\u0938\u094d\u0924\u094d\u0930\u093e\u0907\u0932 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "IDT",
               "\u0907\u0938\u094d\u0924\u094d\u0930\u093e\u0907\u0932 \u0935\u0947\u0933",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "\u0924\u093e\u091c\u093f\u0915\u0940\u0938\u094d\u0924\u093e\u0928 \u0935\u0947\u0933",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tahiti = new String[] {
               "\u0924\u093e\u0939\u093f\u0924\u0940 \u0935\u0947\u0933",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "\u092e\u0949\u0938\u0928 \u0935\u0947\u0933",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u092a\u093f\u092f\u0930\u0947 \u0906\u0923\u093f \u092e\u093f\u0915\u094d\u0935\u0947\u0932\u094b\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "PMST",
               "\u092a\u093f\u092f\u0930\u0947 \u0906\u0923\u093f \u092e\u093f\u0915\u094d\u0935\u0947\u0932\u094b\u0928 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "PMDT",
               "\u092a\u093f\u092f\u0930\u0947 \u0906\u0923\u093f \u092e\u093f\u0915\u094d\u0935\u0947\u0932\u094b\u0928 \u0935\u0947\u0933",
               "PMT",
            };
        final String[] Fiji = new String[] {
               "\u092b\u093f\u091c\u0940 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "FST",
               "\u092b\u093f\u091c\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "FST",
               "\u092b\u093f\u091c\u0940 \u0935\u0947\u0933",
               "FT",
            };
        final String[] Rothera = new String[] {
               "\u0930\u0949\u0925\u0947\u0930\u093e \u0935\u0947\u0933",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "\u092e\u0927\u094d\u092f \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "CEST",
               "\u092e\u0927\u094d\u092f \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "CEST",
               "\u092e\u0927\u094d\u092f \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0935\u0947\u0933",
               "CET",
            };
        final String[] India = new String[] {
               "\u092d\u093e\u0930\u0924\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0921\u094d\u092f\u0942\u092e\u093e\u0901\u091f \u0921\u0940' \u0909\u0930\u0935\u094d\u0939\u093f\u0932\u0947 \u0935\u0947\u0933",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Wallis = new String[] {
               "\u0935\u093e\u0932\u093f\u0938 \u0906\u0923\u093f \u092b\u0941\u091f\u0941\u0928\u093e \u0935\u0947\u0933",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "\u091f\u0941\u0935\u093e\u0932\u0941 \u0935\u0947\u0933",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0909\u091d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "UST",
               "\u0909\u091d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "UST",
               "\u0909\u091d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0935\u0947\u0933",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935 \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "EEST",
               "\u092a\u0942\u0930\u094d\u0935 \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "EEST",
               "\u092a\u0942\u0930\u094d\u0935 \u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0935\u0947\u0933",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "AST",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u0926\u093f\u0935\u0938 \u0935\u0947\u0933",
               "ADT",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u0935\u0947\u0933",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "\u0909\u0930\u0941\u0917\u094d\u0935\u0947 \u092a\u094d\u0930\u092e\u093e\u0923\u0935\u0947\u0933",
               "UST",
               "\u0909\u0930\u0941\u0917\u094d\u0935\u0947 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0935\u0947\u0933",
               "UST",
               "\u0909\u0930\u0941\u0917\u094d\u0935\u0947 \u0935\u0947\u0933",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Singapore", Singapore },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Africa/Bissau", GMT },
            { "Asia/Taipei", Taipei },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Lima", Peru },
            { "Atlantic/Stanley", Falkland },
            { "Europe/Rome", Europe_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Central },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Kashgar", China },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Pacific/Wallis", Wallis },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Nome", Alaska },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Wake", Wake },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Dushanbe", Tajikistan },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
