/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.si;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_si extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "\u0dbd\u0ddd\u0d9a\u0dba" },
            { "002", "\u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "003", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "005", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "009", "\u0d94\u0dc2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "011", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "013", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "014", "\u0db4\u0dd9\u0dbb\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "015", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "017", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "018", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "021", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4\u0daf\u0dd2\u0d9c \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "029", "\u0d9a\u0dd0\u0dbb\u0dd3\u0db6\u0dd2\u0dba\u0db1\u0dca" },
            { "030", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "034", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "035", "\u0d85\u0d9c\u0dca\u0db1\u0dd2\u0daf\u0dd2\u0d9c \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "039", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "053", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "057", "\u0db8\u0dba\u0dd2\u0d9a\u0dca\u200d\u0dbb\u0ddd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9a\u0dc5\u0dcf\u0db4\u0dba" },
            { "061", "\u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "142", "\u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "143", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "145", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "150", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "151", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "154", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "155", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "419", "\u0dbd\u0dad\u0dd2\u0db1\u0dca \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "AC", "\u0d87\u0dc3\u0dd9\u0db1\u0dca\u0dc2\u0db1\u0dca \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1" },
            { "AD", "\u0d87\u0db1\u0dca\u0da9\u0ddd\u0dbb\u0dcf\u0dc0" },
            { "AE", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d91\u0db8\u0dd2\u0dbb\u0dca \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba" },
            { "AF", "\u0d87\u0dc6\u0dca\u0d9c\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "AG", "\u0d87\u0db1\u0dca\u0da7\u0dd2\u0d9c\u0dd4\u0dc0\u0dcf \u0dc3\u0dc4 \u0db6\u0dcf\u0db6\u0dd2\u0dba\u0dd4\u0da9\u0dcf" },
            { "AI", "\u0d87\u0db1\u0dca\u0d9c\u0dd4\u0dba\u0dd2\u0dbd\u0dcf\u0dc0" },
            { "AL", "\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AM", "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AN", "\u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad \u0d87\u0db1\u0dca\u0da7\u0dd2\u0dbd\u0dd3\u0dc3\u0dd2\u0dba" },
            { "AO", "\u0d87\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dcf\u0dc0" },
            { "AQ", "\u0d87\u0db1\u0dca\u0da7\u0dcf\u0d9a\u0dca\u0da7\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "AR", "\u0d86\u0dbb\u0dca\u0da2\u0dd9\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf\u0dc0" },
            { "AS", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf\u0dc0" },
            { "AT", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AU", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AW", "\u0d85\u0dbb\u0dd4\u0db6\u0dcf\u0dc0" },
            { "AX", "\u0d95\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "AZ", "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dba" },
            { "BA", "\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0dc4\u0dbb\u0dca\u0dc3\u0d9c\u0ddc\u0dc0\u0dd3\u0db1\u0dcf\u0dc0" },
            { "BB", "\u0db6\u0dcf\u0dbb\u0dca\u0db6\u0da9\u0ddd\u0dc3\u0dca" },
            { "BD", "\u0db6\u0d82\u0d9c\u0dbd\u0dd2\u0daf\u0dda\u0dc1\u0dba" },
            { "BE", "\u0db6\u0dd9\u0dbd\u0dca\u0da2\u0dd2\u0dba\u0db8" },
            { "BF", "\u0db6\u0dbb\u0dca\u0d9a\u0dd2\u0db1\u0dcf \u0dc6\u0dcf\u0dc3\u0ddd" },
            { "BG", "\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "BH", "\u0db6\u0dc4\u0dbb\u0dda\u0db1\u0dca" },
            { "BI", "\u0db6\u0dd4\u0dbb\u0dd4\u0db1\u0dca\u0da9\u0dd2" },
            { "BJ", "\u0db6\u0dd9\u0db1\u0dd2\u0db1\u0dca" },
            { "BM", "\u0db6\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dd4\u0da9\u0dcf" },
            { "BN", "\u0db6\u0df2\u0db1\u0dcf\u0dba\u0dd2" },
            { "BO", "\u0db6\u0ddc\u0dbd\u0dd3\u0dc0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "BR", "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd\u0dba" },
            { "BS", "\u0db6\u0dc4\u0db8\u0dcf\u0dc3\u0dca" },
            { "BT", "\u0db7\u0dd6\u0dad\u0dcf\u0db1\u0dba" },
            { "BW", "\u0db6\u0ddc\u0dc3\u0dca\u0da7\u0dca\u0dc0\u0dcf\u0db1\u0dcf" },
            { "BY", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd4\u0dc3\u0dca" },
            { "BZ", "\u0db6\u0dd9\u0dbd\u0dd3\u0dc3\u0dca" },
            { "CA", "\u0d9a\u0dd0\u0db1\u0da9\u0dcf\u0dc0" },
            { "CC", "\u0d9a\u0ddc\u0d9a\u0ddd\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca\u0da7\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "CK", "\u0d9a\u0dd4\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "CL", "\u0da0\u0dd2\u0dbd\u0dd3" },
            { "CM", "\u0d9a\u0dd0\u0db8\u0dbb\u0dd6\u0db1\u0dca" },
            { "CN", "\u0da0\u0dd3\u0db1\u0dba" },
            { "CO", "\u0d9a\u0ddc\u0dc5\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "CU", "\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0dc0" },
            { "CY", "\u0dc3\u0dba\u0dd2\u0db4\u0dca\u200d\u0dbb\u0dc3\u0dba" },
            { "DE", "\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dd2\u0dba" },
            { "DK", "\u0da9\u0dd9\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dca\u0d9a\u0dba" },
            { "DZ", "\u0d87\u0dbd\u0dca\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "EC", "\u0d89\u0d9a\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba" },
            { "EE", "\u0d91\u0dc3\u0dca\u0dad\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "EG", "\u0d8a\u0da2\u0dd2\u0db4\u0dca\u0dad\u0dd4\u0dc0" },
            { "EH", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dc3\u0dc4\u0dbb\u0dcf\u0dc0" },
            { "ER", "\u0d91\u0dbb\u0dd2\u0dad\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ES", "\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4\u0dba" },
            { "ET", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0dc0" },
            { "EU", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dcf \u0dc3\u0d82\u0d9c\u0db8\u0dba" },
            { "FI", "\u0dc6\u0dd2\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "FJ", "\u0dc6\u0dd3\u0da2\u0dd3" },
            { "FK", "\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0dad \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "FO", "\u0dc6\u0dd0\u0dbb\u0ddd \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "FR", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1\u0dba" },
            { "GA", "\u0d9c\u0dd0\u0db6\u0ddc\u0db1\u0dca" },
            { "GB", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0dbb\u0dcf\u0da2\u0db0\u0dcf\u0db1\u0dd2\u0dba" },
            { "GD", "\u0d9c\u0dca\u200d\u0dbb\u0dd0\u0db1\u0da9\u0dcf\u0dc0" },
            { "GE", "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GF", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0d9c\u0dba\u0db1\u0dcf\u0dc0" },
            { "GH", "\u0d9d\u0dcf\u0db1\u0dcf\u0dc0" },
            { "GI", "\u0da2\u0dd2\u0db6\u0dca\u200d\u0dbb\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0" },
            { "GL", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "GM", "\u0d9c\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GN", "\u0d9c\u0dd2\u0dab\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GQ", "\u0dc3\u0db8\u0d9a \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GR", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2\u0dba" },
            { "HK", "\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0da0\u0dd3\u0db1 \u0dc0\u0dd2\u0dc1\u0dda\u0dc2 \u0db4\u0dbb\u0dd2\u0db4\u0dcf\u0dbd\u0db1 \u0d9a\u0dbd\u0dcf\u0db4\u0dba" },
            { "HM", "\u0dc4\u0dcf\u0da9\u0dca \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0dca\u0da9\u0ddc\u0db1\u0dbd\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "HN", "\u0dc4\u0ddc\u0db1\u0dca\u0da9\u0dd4\u0dbb\u0dcf\u0dc3\u0dca" },
            { "HT", "\u0dc4\u0dba\u0dd2\u0da7\u0dd2" },
            { "HU", "\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ID", "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IE", "\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "IL", "\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd\u0dba" },
            { "IN", "\u0d89\u0db1\u0dca\u0daf\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IO", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0db1\u0dca\u0daf\u0dd3\u0dba \u0dc3\u0dcf\u0d9c\u0dbb \u0db4\u0dca\u200d\u0dbb\u0dcf\u0db1\u0dca\u0dad\u0dba" },
            { "IQ", "\u0d89\u0dbb\u0dcf\u0d9a\u0dba" },
            { "IR", "\u0d89\u0dbb\u0dcf\u0db1\u0dba" },
            { "IS", "\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "IT", "\u0d89\u0dad\u0dcf\u0dbd\u0dd2\u0dba" },
            { "JM", "\u0da2\u0dd0\u0db8\u0dd9\u0dba\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "JO", "\u0da2\u0ddd\u0dbb\u0dca\u0daf\u0dcf\u0db1\u0dba" },
            { "JP", "\u0da2\u0db4\u0dcf\u0db1\u0dba" },
            { "KE", "\u0d9a\u0dd9\u0db1\u0dca\u0dba\u0dcf\u0dc0" },
            { "KP", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "KR", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "KW", "\u0d9a\u0dd4\u0dc0\u0dda\u0da7\u0dba" },
            { "LA", "\u0dbd\u0dcf\u0d95\u0dc3\u0dba" },
            { "LB", "\u0dbd\u0dd9\u0db6\u0db1\u0db1\u0dba" },
            { "LC", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dbd\u0dd4\u0dc3\u0dd2\u0dba\u0dcf" },
            { "LK", "\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf\u0dc0" },
            { "LR", "\u0dbd\u0dba\u0dd2\u0db6\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LT", "\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LV", "\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LY", "\u0dbd\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MA", "\u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd\u0dc0" },
            { "MC", "\u0db8\u0ddc\u0db1\u0dcf\u0d9a\u0ddd\u0dc0" },
            { "MD", "\u0db8\u0ddc\u0dbd\u0dca\u0da9\u0ddd\u0dc0\u0dcf\u0dc0" },
            { "ME", "\u0db8\u0ddc\u0db1\u0dca\u0da9\u0dd2\u0db1\u0dd3\u0d9c\u0dca\u200d\u0dbb\u0ddd" },
            { "ML", "\u0db8\u0dcf\u0dbd\u0dd2" },
            { "MM", "\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dba" },
            { "MN", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MR", "\u0db8\u0dcf\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dd2\u0d9a\u0dca" },
            { "MS", "\u0db8\u0ddc\u0db1\u0dca\u0dc3\u0dd9\u0dbb\u0dcf\u0da7\u0dca" },
            { "MT", "\u0db8\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0" },
            { "MU", "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2\u0dba" },
            { "MV", "\u0db8\u0dcf\u0dbd \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1" },
            { "MX", "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd\u0dc0" },
            { "MY", "\u0db8\u0dd0\u0dbd\u0dda\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MZ", "\u0db8\u0ddc\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0d9a\u0dca" },
            { "NA", "\u0db1\u0dd0\u0db8\u0dd3\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "NC", "\u0db1\u0dc0 \u0d9a\u0dd0\u0dbd\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "NE", "\u0db1\u0dba\u0dd2\u0da2\u0dbb\u0dca" },
            { "NF", "\u0db1\u0ddd\u0dc6\u0ddd\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "NG", "\u0db1\u0dba\u0dd2\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "NI", "\u0db1\u0dd2\u0d9a\u0dbb\u0d9c\u0dd4\u0dc0\u0dcf\u0dc0" },
            { "NL", "\u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "NO", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dda" },
            { "NP", "\u0db1\u0dda\u0db4\u0dcf\u0dbd\u0dba" },
            { "NR", "\u0db1\u0dcf\u0dc0\u0dd4\u0dbb\u0dd4" },
            { "NU", "\u0db1\u0dd2\u0dba\u0dd6" },
            { "NZ", "\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "OM", "\u0d95\u0db8\u0dcf\u0db1\u0dba" },
            { "PA", "\u0db4\u0dd0\u0db1\u0db8\u0dcf" },
            { "PE", "\u0db4\u0dda\u0dbb\u0dd4" },
            { "PF", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "PG", "\u0db4\u0dd0\u0db4\u0dd4\u0dc0\u0dcf \u0db1\u0dd2\u0dc0\u0dca \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "PH", "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1\u0dba" },
            { "PK", "\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "PL", "\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "PN", "\u0db4\u0dd2\u0da7\u0dca\u0d9a\u0dd9\u0dba\u0dca\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "PS", "\u0db4\u0dbd\u0dc3\u0dca\u0dad\u0dd3\u0db1\u0dba" },
            { "PT", "\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dcf\u0dbd\u0dba" },
            { "PW", "\u0db4\u0dbd\u0dcf\u0dc0\u0dd4" },
            { "PY", "\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda" },
            { "QA", "\u0d9a\u0da7\u0dcf\u0dbb\u0dca\u0dba" },
            { "RO", "\u0dbb\u0dd4\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RS", "\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RU", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SA", "\u0dc3\u0dde\u0daf\u0dd2 \u0d85\u0dbb\u0dcf\u0db6\u0dd2\u0dba" },
            { "SD", "\u0dc3\u0dd6\u0da9\u0dcf\u0db1\u0dba" },
            { "SE", "\u0dc3\u0dca\u0dc0\u0dd3\u0da9\u0db1\u0dba" },
            { "SG", "\u0dc3\u0dd2\u0d82\u0d9c\u0db4\u0dca\u0db4\u0dd6\u0dbb\u0dd4\u0dc0" },
            { "SI", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SK", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dd0\u0d9a\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SV", "\u0d91\u0dbd\u0dca \u0dc3\u0dd0\u0dbd\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba" },
            { "TC", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0dc3\u0dca \u0dc3\u0dc4 \u0d9a\u0dba\u0dd2\u0d9a\u0ddc\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "TH", "\u0dad\u0dcf\u0dba\u0dd2\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "TK", "\u0da7\u0ddc\u0d9a\u0dbd\u0dcf\u0dc0\u0dd4" },
            { "TM", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "TN", "\u0da7\u0dd2\u0dba\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "TR", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2\u0dba" },
            { "TT", "\u0da7\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dd2\u0da9\u0dd1\u0da9\u0dca \u0dc3\u0dc4 \u0da7\u0ddc\u0db6\u0dd0\u0d9c\u0ddd" },
            { "TV", "\u0da7\u0dd4\u0dc0\u0dcf\u0dbd\u0dd6" },
            { "TW", "\u0dad\u0dcf\u0dba\u0dd2\u0dc0\u0dcf\u0db1\u0dba" },
            { "UA", "\u0dba\u0dd4\u0d9a\u0dca\u0dbb\u0dda\u0db1\u0dba" },
            { "US", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0db1\u0db4\u0daf\u0dba" },
            { "UZ", "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "VG", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0dc0\u0dbb\u0dca\u0da2\u0dd2\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "VI", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc0\u0dbb\u0dca\u0da2\u0dd2\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "VN", "\u0dc0\u0dd2\u0dba\u0da7\u0dca\u0db1\u0dcf\u0db8\u0dba" },
            { "VU", "\u0dc0\u0db1\u0dd4\u0dc0\u0dcf\u0da7\u0dd4" },
            { "WS", "\u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf" },
            { "YE", "\u0dba\u0dda\u0db8\u0db1\u0dba" },
            { "ZA", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "ZM", "\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ZW", "\u0dc3\u0dd2\u0db8\u0dca\u0db6\u0dcf\u0db6\u0dca\u0dc0\u0dda" },
            { "ZZ", "\u0dc4\u0db3\u0dd4\u0db1\u0dcf \u0db1\u0ddc\u0d9c\u0dad\u0dca \u0d9a\u0dc5\u0dcf\u0db4\u0dba" },
            { "ar", "\u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "bn", "\u0db6\u0dd9\u0d82\u0d9c\u0dbd\u0dd2" },
            { "bo", "\u0da7\u0dd2\u0db6\u0dd9\u0da7\u0dca" },
            { "de", "\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "dv", "\u0daf\u0dd2\u0dc0\u0dd9\u0dc4\u0dd2" },
            { "el", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a" },
            { "en", "\u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "es", "\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "fa", "\u0db4\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "fr", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "gu", "\u0d9c\u0dd4\u0da2\u0dbb\u0dcf\u0da7\u0dd2" },
            { "he", "\u0dc4\u0dd3\u0db6\u0df2" },
            { "hi", "\u0dc4\u0dd2\u0db1\u0dca\u0daf\u0dd2" },
            { "hu", "\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "hy", "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "it", "\u0d89\u0dad\u0dcf\u0dbd\u0dd2" },
            { "ja", "\u0da2\u0db4\u0db1\u0dca" },
            { "kn", "\u0d9a\u0dab\u0dca\u0dab\u0da9" },
            { "ko", "\u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "la", "\u0dbd\u0dad\u0dd2\u0db1\u0dca" },
            { "ms", "\u0db8\u0dd0\u0dbd\u0dda" },
            { "nl", "\u0dbd\u0db1\u0dca\u0daf\u0dda\u0dc3\u0dd2" },
            { "pl", "\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad" },
            { "pt", "\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "ru", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "sa", "\u0dc3\u0d82\u0dc3\u0dca\u0d9a\u0dd8\u0dad" },
            { "si", "\u0dc3\u0dd2\u0d82\u0dc4\u0dbd" },
            { "ta", "\u0daf\u0dd9\u0db8\u0dc5" },
            { "th", "\u0dad\u0dcf\u0dba\u0dd2" },
            { "tr", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2" },
            { "zh", "\u0da0\u0dd3\u0db1" },
            { "Arab", "\u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "Armn", "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Cyrl", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dbd\u0dd2\u0d9a\u0dca" },
            { "Deva", "\u0daf\u0dda\u0dc0\u0db1\u0dcf\u0d9c\u0dbb\u0dd3" },
            { "Grek", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a" },
            { "Gujr", "\u0d9c\u0dd4\u0da2\u0dbb\u0dcf\u0da7\u0dd2" },
            { "Hans", "\u0dc3\u0dbb\u0dc5" },
            { "Hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a" },
            { "Hebr", "\u0dc4\u0dd3\u0db6\u0df2" },
            { "Hira", "\u0dc4\u0dd2\u0dbb\u0d9f\u0db1\u0dcf" },
            { "Jpan", "\u0da2\u0db4\u0db1\u0dca" },
            { "Knda", "\u0d9a\u0dab\u0dca\u0dab\u0da9" },
            { "Kore", "\u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Latn", "\u0dbd\u0dad\u0dd2\u0db1\u0dca" },
            { "Mlym", "\u0db8\u0dbd\u0dba\u0dcf\u0dbd\u0db8\u0dca" },
            { "Mong", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Sinh", "\u0dc3\u0dd2\u0d82\u0dc4\u0dbd" },
            { "Taml", "\u0daf\u0dd9\u0db8\u0dbd" },
            { "Telu", "\u0dad\u0dd9\u0dc5\u0dd2\u0d9f\u0dd4" },
            { "Thai", "\u0dad\u0dcf\u0dba\u0dd2" },
            { "Tibt", "\u0da7\u0dd2\u200d\u0db6\u0dd9\u0da7\u0dca" },
            { "de_AT", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "en_AU", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "en_CA", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "en_GB", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2\u0db1\u0dca\u200d\u0dba" },
            { "en_US", "\u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "fr_CA", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
        };
        return data;
    }
}
