/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;

public class XRMaskImage {
    private static final int MASK_SCALE_FACTOR = 8;
    private static final int BLIT_MASK_SIZE = 8;
    Dimension blitMaskDimensions = new Dimension(8, 8);
    int blitMaskPixmap;
    int blitMaskPicture;
    int lastMaskWidth = 0;
    int lastMaskHeight = 0;
    int lastEA = -1;
    AffineTransform lastMaskTransform;
    XRCompositeManager xrMgr;
    XRBackend con;

    public XRMaskImage(XRCompositeManager xRCompositeManager, int n) {
        this.xrMgr = xRCompositeManager;
        this.con = xRCompositeManager.getBackend();
        this.initBlitMask(n, 8, 8);
    }

    public int prepareBlitMask(XRSurfaceData xRSurfaceData, AffineTransform affineTransform, int n, int n2) {
        int n3 = Math.max(n / 8, 1);
        int n4 = Math.max(n2 / 8, 1);
        affineTransform.scale((double)n / (double)n3, (double)n2 / (double)n4);
        try {
            affineTransform.invert();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform.setToIdentity();
        }
        this.ensureBlitMaskSize(n3, n4);
        if (this.lastMaskTransform == null || !this.lastMaskTransform.equals(affineTransform)) {
            this.con.setPictureTransform(this.blitMaskPicture, affineTransform);
            this.lastMaskTransform = affineTransform;
        }
        int n5 = this.xrMgr.getAlphaColor().getAlpha();
        if (this.lastMaskWidth != n3 || this.lastMaskHeight != n4 || this.lastEA != n5) {
            if (this.lastMaskWidth > n3 || this.lastMaskHeight > n4) {
                this.con.renderRectangle(this.blitMaskPicture, (byte)0, XRColor.NO_ALPHA, 0, 0, this.lastMaskWidth, this.lastMaskHeight);
            }
            this.con.renderRectangle(this.blitMaskPicture, (byte)1, this.xrMgr.getAlphaColor(), 0, 0, n3, n4);
            this.lastEA = n5;
        }
        this.lastMaskWidth = n3;
        this.lastMaskHeight = n4;
        return this.blitMaskPicture;
    }

    private void initBlitMask(int n, int n2, int n3) {
        int n4 = this.con.createPixmap(n, 8, n2, n3);
        int n5 = this.con.createPicture(n4, 2);
        if (this.blitMaskPixmap != 0) {
            this.con.freePixmap(this.blitMaskPixmap);
            this.con.freePicture(this.blitMaskPicture);
        }
        this.blitMaskPixmap = n4;
        this.blitMaskPicture = n5;
        this.con.renderRectangle(this.blitMaskPicture, (byte)0, XRColor.NO_ALPHA, 0, 0, n2, n3);
        this.blitMaskDimensions.width = n2;
        this.blitMaskDimensions.height = n3;
        this.lastMaskWidth = 0;
        this.lastMaskHeight = 0;
        this.lastMaskTransform = null;
    }

    private void ensureBlitMaskSize(int n, int n2) {
        if (n > this.blitMaskDimensions.width || n2 > this.blitMaskDimensions.height) {
            int n3 = Math.max(n, this.blitMaskDimensions.width);
            int n4 = Math.max(n2, this.blitMaskDimensions.height);
            this.initBlitMask(this.blitMaskPixmap, n3, n4);
        }
    }
}

