/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Vector;
import sun.awt.AppContext;

public class LayoutQueue {
    private static final Object DEFAULT_QUEUE = new Object();
    private Vector<Runnable> tasks = new Vector();
    private Thread worker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LayoutQueue getDefaultQueue() {
        AppContext appContext = AppContext.getAppContext();
        Object object = DEFAULT_QUEUE;
        synchronized (object) {
            LayoutQueue layoutQueue = (LayoutQueue)appContext.get(DEFAULT_QUEUE);
            if (layoutQueue == null) {
                layoutQueue = new LayoutQueue();
                appContext.put(DEFAULT_QUEUE, layoutQueue);
            }
            return layoutQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultQueue(LayoutQueue layoutQueue) {
        Object object = DEFAULT_QUEUE;
        synchronized (object) {
            AppContext.getAppContext().put(DEFAULT_QUEUE, layoutQueue);
        }
    }

    public synchronized void addTask(Runnable runnable) {
        if (this.worker == null) {
            this.worker = new LayoutThread();
            this.worker.start();
        }
        this.tasks.addElement(runnable);
        this.notifyAll();
    }

    protected synchronized Runnable waitForWork() {
        while (this.tasks.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        Runnable runnable = this.tasks.firstElement();
        this.tasks.removeElementAt(0);
        return runnable;
    }

    class LayoutThread
    extends Thread {
        LayoutThread() {
            super("text-layout");
            this.setPriority(1);
        }

        @Override
        public void run() {
            Runnable runnable;
            do {
                if ((runnable = LayoutQueue.this.waitForWork()) == null) continue;
                runnable.run();
            } while (runnable != null);
        }
    }
}

