/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.whitebox;

import java.lang.management.MemoryUsage;
import java.lang.reflect.Executable;
import java.security.BasicPermission;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.test.whitebox.parser.DiagnosticCommand;

public class WhiteBox {
    private static final WhiteBox instance = new WhiteBox();
    private static boolean concurrentGCIsControlled;
    public final String AFTER_MARKING_STARTED = "AFTER MARKING STARTED";
    public final String BEFORE_MARKING_COMPLETED = "BEFORE MARKING COMPLETED";
    public final String AFTER_CONCURRENT_REFERENCE_PROCESSING_STARTED = "AFTER CONCURRENT REFERENCE PROCESSING STARTED";
    public final String G1_AFTER_REBUILD_STARTED = "AFTER REBUILD STARTED";
    public final String G1_BEFORE_REBUILD_COMPLETED = "BEFORE REBUILD COMPLETED";
    public final String G1_AFTER_CLEANUP_STARTED = "AFTER CLEANUP STARTED";
    public final String G1_BEFORE_CLEANUP_COMPLETED = "BEFORE CLEANUP COMPLETED";
    private final List<Function<String, Object>> flagsGetters = Arrays.asList(this::getBooleanVMFlag, this::getIntVMFlag, this::getUintVMFlag, this::getIntxVMFlag, this::getUintxVMFlag, this::getUint64VMFlag, this::getSizeTVMFlag, this::getStringVMFlag, this::getDoubleVMFlag);
    private final List<BiFunction<Executable, String, Object>> methodOptionGetters = Arrays.asList(this::getMethodBooleanOption, this::getMethodIntxOption, this::getMethodUintxOption, this::getMethodDoubleOption, this::getMethodStringOption);

    private WhiteBox() {
    }

    private static native void registerNatives();

    public static synchronized WhiteBox getWhiteBox() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WhiteBoxPermission("getInstance"));
        }
        return instance;
    }

    public native long getCompressedOopsMaxHeapSize();

    public native void printHeapSizes();

    private native long getObjectAddress0(Object var1);

    public long getObjectAddress(Object o) {
        Objects.requireNonNull(o);
        return this.getObjectAddress0(o);
    }

    public native int getHeapOopSize();

    public native int getVMPageSize();

    public native long getVMAllocationGranularity();

    public native long getVMLargePageSize();

    public native long getHeapSpaceAlignment();

    public native long getHeapAlignment();

    private native boolean isObjectInOldGen0(Object var1);

    public boolean isObjectInOldGen(Object o) {
        Objects.requireNonNull(o);
        return this.isObjectInOldGen0(o);
    }

    private native long getObjectSize0(Object var1);

    public long getObjectSize(Object o) {
        Objects.requireNonNull(o);
        return this.getObjectSize0(o);
    }

    public int countAliveClasses(String name) {
        return this.countAliveClasses0(name.replace('.', '/'));
    }

    private native int countAliveClasses0(String var1);

    public boolean isClassAlive(String name) {
        return this.countAliveClasses(name) != 0;
    }

    public native int getSymbolRefcount(String var1);

    public native boolean deflateIdleMonitors();

    private native boolean isMonitorInflated0(Object var1);

    public boolean isMonitorInflated(Object obj) {
        Objects.requireNonNull(obj);
        return this.isMonitorInflated0(obj);
    }

    public native int getLockStackCapacity();

    public native boolean supportsRecursiveLightweightLocking();

    public native void forceSafepoint();

    public native void forceClassLoaderStatsSafepoint();

    private native long getConstantPool0(Class<?> var1);

    public long getConstantPool(Class<?> aClass) {
        Objects.requireNonNull(aClass);
        return this.getConstantPool0(aClass);
    }

    private native Object[] getResolvedReferences0(Class<?> var1);

    public Object[] getResolvedReferences(Class<?> aClass) {
        Objects.requireNonNull(aClass);
        return this.getResolvedReferences0(aClass);
    }

    private native int remapInstructionOperandFromCPCache0(Class<?> var1, int var2);

    public int remapInstructionOperandFromCPCache(Class<?> aClass, int index) {
        Objects.requireNonNull(aClass);
        return this.remapInstructionOperandFromCPCache0(aClass, index);
    }

    private native int encodeConstantPoolIndyIndex0(int var1);

    public int encodeConstantPoolIndyIndex(int index) {
        return this.encodeConstantPoolIndyIndex0(index);
    }

    private native int getFieldEntriesLength0(Class<?> var1);

    public int getFieldEntriesLength(Class<?> aClass) {
        Objects.requireNonNull(aClass);
        return this.getFieldEntriesLength0(aClass);
    }

    private native int getFieldCPIndex0(Class<?> var1, int var2);

    public int getFieldCPIndex(Class<?> aClass, int index) {
        Objects.requireNonNull(aClass);
        return this.getFieldCPIndex0(aClass, index);
    }

    private native int getMethodEntriesLength0(Class<?> var1);

    public int getMethodEntriesLength(Class<?> aClass) {
        Objects.requireNonNull(aClass);
        return this.getMethodEntriesLength0(aClass);
    }

    private native int getMethodCPIndex0(Class<?> var1, int var2);

    public int getMethodCPIndex(Class<?> aClass, int index) {
        Objects.requireNonNull(aClass);
        return this.getMethodCPIndex0(aClass, index);
    }

    private native int getIndyInfoLength0(Class<?> var1);

    public int getIndyInfoLength(Class<?> aClass) {
        Objects.requireNonNull(aClass);
        return this.getIndyInfoLength0(aClass);
    }

    private native int getIndyCPIndex0(Class<?> var1, int var2);

    public int getIndyCPIndex(Class<?> aClass, int index) {
        Objects.requireNonNull(aClass);
        return this.getIndyCPIndex0(aClass, index);
    }

    private native String printClasses0(String var1, int var2);

    public String printClasses(String classNamePattern, int flags) {
        Objects.requireNonNull(classNamePattern);
        return this.printClasses0(classNamePattern, flags);
    }

    private native String printMethods0(String var1, String var2, int var3);

    public String printMethods(String classNamePattern, String methodPattern, int flags) {
        Objects.requireNonNull(classNamePattern);
        Objects.requireNonNull(methodPattern);
        return this.printMethods0(classNamePattern, methodPattern, flags);
    }

    private native void addToBootstrapClassLoaderSearch0(String var1);

    public void addToBootstrapClassLoaderSearch(String segment) {
        Objects.requireNonNull(segment);
        this.addToBootstrapClassLoaderSearch0(segment);
    }

    private native void addToSystemClassLoaderSearch0(String var1);

    public void addToSystemClassLoaderSearch(String segment) {
        Objects.requireNonNull(segment);
        this.addToSystemClassLoaderSearch0(segment);
    }

    public native boolean g1InConcurrentMark();

    public native int g1CompletedConcurrentMarkCycles();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean g1RunConcurrentGC(boolean errorIfFail) {
        try {
            this.concurrentGCAcquireControl();
            int count = this.g1CompletedConcurrentMarkCycles();
            this.concurrentGCRunTo("AFTER MARKING STARTED", false);
            this.concurrentGCRunToIdle();
            if (count < this.g1CompletedConcurrentMarkCycles()) {
                boolean bl = true;
                return bl;
            }
            if (errorIfFail) {
                throw new RuntimeException("Concurrent GC aborted");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.concurrentGCReleaseControl();
        }
    }

    public void g1RunConcurrentGC() {
        this.g1RunConcurrentGC(true);
    }

    public void g1StartConcurrentGC() {
        try {
            this.concurrentGCAcquireControl();
            this.concurrentGCRunTo("AFTER MARKING STARTED", false);
        }
        finally {
            this.concurrentGCReleaseControl();
        }
    }

    public native boolean g1HasRegionsToUncommit();

    private native boolean g1IsHumongous0(Object var1);

    public boolean g1IsHumongous(Object o) {
        Objects.requireNonNull(o);
        return this.g1IsHumongous0(o);
    }

    private native boolean g1BelongsToHumongousRegion0(long var1);

    public boolean g1BelongsToHumongousRegion(long adr) {
        if (adr == 0L) {
            throw new IllegalArgumentException("adr argument should not be null");
        }
        return this.g1BelongsToHumongousRegion0(adr);
    }

    private native boolean g1BelongsToFreeRegion0(long var1);

    public boolean g1BelongsToFreeRegion(long adr) {
        if (adr == 0L) {
            throw new IllegalArgumentException("adr argument should not be null");
        }
        return this.g1BelongsToFreeRegion0(adr);
    }

    public native long g1NumMaxRegions();

    public native long g1NumFreeRegions();

    public native int g1RegionSize();

    public native MemoryUsage g1AuxiliaryMemoryUsage();

    private native Object[] parseCommandLine0(String var1, char var2, DiagnosticCommand[] var3);

    public Object[] parseCommandLine(String commandline, char delim, DiagnosticCommand[] args) {
        Objects.requireNonNull(args);
        return this.parseCommandLine0(commandline, delim, args);
    }

    public native int g1ActiveMemoryNodeCount();

    public native int[] g1MemoryNodeIds();

    public native long psVirtualSpaceAlignment();

    public native long psHeapGenerationAlignment();

    public native long[] g1GetMixedGCInfo(int var1);

    public native long NMTMalloc(long var1);

    public native void NMTFree(long var1);

    public native long NMTReserveMemory(long var1);

    public native long NMTAttemptReserveMemoryAt(long var1, long var3);

    public native void NMTCommitMemory(long var1, long var3);

    public native void NMTUncommitMemory(long var1, long var3);

    public native void NMTReleaseMemory(long var1, long var3);

    public native long NMTMallocWithPseudoStack(long var1, int var3);

    public native long NMTMallocWithPseudoStackAndType(long var1, int var3, int var4);

    public native int NMTGetHashSize();

    public native long NMTNewArena(long var1);

    public native void NMTFreeArena(long var1);

    public native void NMTArenaMalloc(long var1, long var3);

    public native boolean hasLibgraal();

    public native boolean isC2OrJVMCIIncluded();

    public native boolean isJVMCISupportedByGC();

    public native int matchesMethod(Executable var1, String var2);

    public native int matchesInline(Executable var1, String var2);

    public native boolean shouldPrintAssembly(Executable var1, int var2);

    public native int deoptimizeFrames(boolean var1);

    public native boolean isFrameDeoptimized(int var1);

    public native void deoptimizeAll();

    public boolean isMethodCompiled(Executable method) {
        return this.isMethodCompiled(method, false);
    }

    private native boolean isMethodCompiled0(Executable var1, boolean var2);

    public boolean isMethodCompiled(Executable method, boolean isOsr) {
        Objects.requireNonNull(method);
        return this.isMethodCompiled0(method, isOsr);
    }

    public boolean isMethodCompilable(Executable method) {
        return this.isMethodCompilable(method, -1);
    }

    public boolean isMethodCompilable(Executable method, int compLevel) {
        return this.isMethodCompilable(method, compLevel, false);
    }

    private native boolean isMethodCompilable0(Executable var1, int var2, boolean var3);

    public boolean isMethodCompilable(Executable method, int compLevel, boolean isOsr) {
        Objects.requireNonNull(method);
        return this.isMethodCompilable0(method, compLevel, isOsr);
    }

    private native boolean isMethodQueuedForCompilation0(Executable var1);

    public boolean isMethodQueuedForCompilation(Executable method) {
        Objects.requireNonNull(method);
        return this.isMethodQueuedForCompilation0(method);
    }

    public boolean isIntrinsicAvailable(Executable method, Executable compilationContext, int compLevel) {
        Objects.requireNonNull(method);
        return this.isIntrinsicAvailable0(method, compilationContext, compLevel);
    }

    public boolean isIntrinsicAvailable(Executable method, int compLevel) {
        return this.isIntrinsicAvailable(method, null, compLevel);
    }

    private native boolean isIntrinsicAvailable0(Executable var1, Executable var2, int var3);

    public int deoptimizeMethod(Executable method) {
        return this.deoptimizeMethod(method, false);
    }

    private native int deoptimizeMethod0(Executable var1, boolean var2);

    public int deoptimizeMethod(Executable method, boolean isOsr) {
        Objects.requireNonNull(method);
        return this.deoptimizeMethod0(method, isOsr);
    }

    public void makeMethodNotCompilable(Executable method) {
        this.makeMethodNotCompilable(method, -1);
    }

    public void makeMethodNotCompilable(Executable method, int compLevel) {
        this.makeMethodNotCompilable(method, compLevel, false);
    }

    private native void makeMethodNotCompilable0(Executable var1, int var2, boolean var3);

    public void makeMethodNotCompilable(Executable method, int compLevel, boolean isOsr) {
        Objects.requireNonNull(method);
        this.makeMethodNotCompilable0(method, compLevel, isOsr);
    }

    public int getMethodCompilationLevel(Executable method) {
        return this.getMethodCompilationLevel(method, false);
    }

    private native int getMethodCompilationLevel0(Executable var1, boolean var2);

    public int getMethodCompilationLevel(Executable method, boolean isOsr) {
        Objects.requireNonNull(method);
        return this.getMethodCompilationLevel0(method, isOsr);
    }

    public int getMethodDecompileCount(Executable method) {
        Objects.requireNonNull(method);
        return this.getMethodDecompileCount0(method);
    }

    private native int getMethodDecompileCount0(Executable var1);

    public int getMethodTrapCount(Executable method) {
        Objects.requireNonNull(method);
        return this.getMethodTrapCount0(method, null);
    }

    public int getMethodTrapCount(Executable method, String reason) {
        Objects.requireNonNull(method);
        return this.getMethodTrapCount0(method, reason);
    }

    private native int getMethodTrapCount0(Executable var1, String var2);

    public int getDeoptCount() {
        return this.getDeoptCount0(null, null);
    }

    public int getDeoptCount(String reason, String action) {
        return this.getDeoptCount0(reason, action);
    }

    private native int getDeoptCount0(String var1, String var2);

    private native boolean testSetDontInlineMethod0(Executable var1, boolean var2);

    public boolean testSetDontInlineMethod(Executable method, boolean value) {
        Objects.requireNonNull(method);
        return this.testSetDontInlineMethod0(method, value);
    }

    public int getCompileQueuesSize() {
        return this.getCompileQueueSize(-1);
    }

    public native int getCompileQueueSize(int var1);

    private native boolean testSetForceInlineMethod0(Executable var1, boolean var2);

    public boolean testSetForceInlineMethod(Executable method, boolean value) {
        Objects.requireNonNull(method);
        return this.testSetForceInlineMethod0(method, value);
    }

    public boolean enqueueMethodForCompilation(Executable method, int compLevel) {
        return this.enqueueMethodForCompilation(method, compLevel, -1);
    }

    private native boolean enqueueMethodForCompilation0(Executable var1, int var2, int var3);

    public boolean enqueueMethodForCompilation(Executable method, int compLevel, int entry_bci) {
        Objects.requireNonNull(method);
        return this.enqueueMethodForCompilation0(method, compLevel, entry_bci);
    }

    private native boolean enqueueInitializerForCompilation0(Class<?> var1, int var2);

    public boolean enqueueInitializerForCompilation(Class<?> aClass, int compLevel) {
        Objects.requireNonNull(aClass);
        return this.enqueueInitializerForCompilation0(aClass, compLevel);
    }

    private native void clearMethodState0(Executable var1);

    public native void markMethodProfiled(Executable var1);

    public void clearMethodState(Executable method) {
        Objects.requireNonNull(method);
        this.clearMethodState0(method);
    }

    public native void lockCompilation();

    public native void unlockCompilation();

    private native int getMethodEntryBci0(Executable var1);

    public int getMethodEntryBci(Executable method) {
        Objects.requireNonNull(method);
        return this.getMethodEntryBci0(method);
    }

    private native Object[] getNMethod0(Executable var1, boolean var2);

    public Object[] getNMethod(Executable method, boolean isOsr) {
        Objects.requireNonNull(method);
        return this.getNMethod0(method, isOsr);
    }

    public native long allocateCodeBlob(int var1, int var2);

    public long allocateCodeBlob(long size, int type) {
        int intSize = (int)size;
        if ((long)intSize != size || size < 0L) {
            throw new IllegalArgumentException("size argument has illegal value " + size);
        }
        return this.allocateCodeBlob(intSize, type);
    }

    public native void freeCodeBlob(long var1);

    public native Object[] getCodeHeapEntries(int var1);

    public native int getCompilationActivityMode();

    private native long getMethodData0(Executable var1);

    public long getMethodData(Executable method) {
        Objects.requireNonNull(method);
        return this.getMethodData0(method);
    }

    public native Object[] getCodeBlob(long var1);

    private native void clearInlineCaches0(boolean var1);

    public void clearInlineCaches() {
        this.clearInlineCaches0(false);
    }

    public void clearInlineCaches(boolean preserve_static_stubs) {
        this.clearInlineCaches0(preserve_static_stubs);
    }

    public native boolean isInStringTable(String var1);

    public native void readReservedMemory();

    public native long allocateMetaspace(ClassLoader var1, long var2);

    public native long incMetaspaceCapacityUntilGC(long var1);

    public native long metaspaceCapacityUntilGC();

    public native long metaspaceSharedRegionAlignment();

    public native void cleanMetaspaces();

    public native long createMetaspaceTestContext(long var1, long var3);

    public native void destroyMetaspaceTestContext(long var1);

    public native void purgeMetaspaceTestContext(long var1);

    public native void printMetaspaceTestContext(long var1);

    public native long getTotalCommittedWordsInMetaspaceTestContext(long var1);

    public native long getTotalUsedWordsInMetaspaceTestContext(long var1);

    public native long createArenaInTestContext(long var1, boolean var3);

    public native void destroyMetaspaceTestArena(long var1);

    public native long allocateFromMetaspaceTestArena(long var1, long var3);

    public native void deallocateToMetaspaceTestArena(long var1, long var3, long var5);

    public native long maxMetaspaceAllocationSize();

    public native boolean isGCSupported(int var1);

    public native boolean isGCSupportedByJVMCICompiler(int var1);

    public native boolean isGCSelected(int var1);

    public native boolean isGCSelectedErgonomically();

    public native void youngGC();

    public native void fullGC();

    public native boolean supportsConcurrentGCBreakpoints();

    private void checkConcurrentGCBreakpointsSupported() {
        if (!this.supportsConcurrentGCBreakpoints()) {
            throw new UnsupportedOperationException("Concurrent GC breakpoints not supported");
        }
    }

    private native void concurrentGCAcquireControl0();

    private native void concurrentGCReleaseControl0();

    private native void concurrentGCRunToIdle0();

    private native boolean concurrentGCRunTo0(String var1);

    private void checkConcurrentGCIsControlled() {
        if (!concurrentGCIsControlled) {
            throw new IllegalStateException("Not controlling concurrent GC");
        }
    }

    public void concurrentGCAcquireControl() {
        this.checkConcurrentGCBreakpointsSupported();
        if (concurrentGCIsControlled) {
            throw new IllegalStateException("Already controlling concurrent GC");
        }
        this.concurrentGCAcquireControl0();
        concurrentGCIsControlled = true;
    }

    public void concurrentGCReleaseControl() {
        this.checkConcurrentGCBreakpointsSupported();
        this.concurrentGCReleaseControl0();
        concurrentGCIsControlled = false;
    }

    public void concurrentGCRunToIdle() {
        this.checkConcurrentGCBreakpointsSupported();
        this.checkConcurrentGCIsControlled();
        this.concurrentGCRunToIdle0();
    }

    public void concurrentGCRunTo(String breakpoint) {
        this.concurrentGCRunTo(breakpoint, true);
    }

    public boolean concurrentGCRunTo(String breakpoint, boolean errorIfFail) {
        this.checkConcurrentGCBreakpointsSupported();
        this.checkConcurrentGCIsControlled();
        if (breakpoint == null) {
            throw new NullPointerException("null breakpoint");
        }
        if (this.concurrentGCRunTo0(breakpoint)) {
            return true;
        }
        if (errorIfFail) {
            throw new IllegalStateException("Missed requested breakpoint \"" + breakpoint + "\"");
        }
        return false;
    }

    public native int stressVirtualSpaceResize(long var1, long var3, long var5);

    public native void readFromNoaccessArea();

    public native long getThreadStackSize();

    public native long getThreadRemainingStackSize();

    public native String getCPUFeatures();

    public native boolean isConstantVMFlag(String var1);

    public native boolean isDefaultVMFlag(String var1);

    public native boolean isLockedVMFlag(String var1);

    public native void setBooleanVMFlag(String var1, boolean var2);

    public native void setIntVMFlag(String var1, long var2);

    public native void setUintVMFlag(String var1, long var2);

    public native void setIntxVMFlag(String var1, long var2);

    public native void setUintxVMFlag(String var1, long var2);

    public native void setUint64VMFlag(String var1, long var2);

    public native void setSizeTVMFlag(String var1, long var2);

    public native void setStringVMFlag(String var1, String var2);

    public native void setDoubleVMFlag(String var1, double var2);

    public native Boolean getBooleanVMFlag(String var1);

    public native Long getIntVMFlag(String var1);

    public native Long getUintVMFlag(String var1);

    public native Long getIntxVMFlag(String var1);

    public native Long getUintxVMFlag(String var1);

    public native Long getUint64VMFlag(String var1);

    public native Long getSizeTVMFlag(String var1);

    public native String getStringVMFlag(String var1);

    public native Double getDoubleVMFlag(String var1);

    public Object getVMFlag(String name) {
        return this.flagsGetters.stream().map(f -> f.apply(name)).filter(x -> x != null).findAny().orElse(null);
    }

    public native void DefineModule(Object var1, boolean var2, String var3, String var4, Object[] var5);

    public native void AddModuleExports(Object var1, String var2, Object var3);

    public native void AddReadsModule(Object var1, Object var2);

    public native void AddModuleExportsToAllUnnamed(Object var1, String var2);

    public native void AddModuleExportsToAll(Object var1, String var2);

    public native int getCDSOffsetForName0(String var1);

    public int getCDSOffsetForName(String name) throws Exception {
        int offset = this.getCDSOffsetForName0(name);
        if (offset == -1) {
            throw new RuntimeException(name + " not found");
        }
        return offset;
    }

    public native int getCDSConstantForName0(String var1);

    public int getCDSConstantForName(String name) throws Exception {
        int constant = this.getCDSConstantForName0(name);
        if (constant == -1) {
            throw new RuntimeException(name + " not found");
        }
        return constant;
    }

    public native Boolean getMethodBooleanOption(Executable var1, String var2);

    public native Long getMethodIntxOption(Executable var1, String var2);

    public native Long getMethodUintxOption(Executable var1, String var2);

    public native Double getMethodDoubleOption(Executable var1, String var2);

    public native String getMethodStringOption(Executable var1, String var2);

    public Object getMethodOption(Executable method, String name) {
        return this.methodOptionGetters.stream().map(f -> f.apply(method, name)).filter(x -> x != null).findAny().orElse(null);
    }

    public native int getCDSGenericHeaderMinVersion();

    public native int getCurrentCDSVersion();

    public native String getDefaultArchivePath();

    public native boolean cdsMemoryMappingFailed();

    public native boolean isSharingEnabled();

    public native boolean isSharedClass(Class<?> var1);

    public native boolean areSharedStringsMapped();

    public native boolean isSharedInternedString(String var1);

    public native boolean isCDSIncluded();

    public native boolean isJFRIncluded();

    public native boolean isDTraceIncluded();

    public native boolean canWriteJavaHeapArchive();

    public native void linkClass(Class<?> var1);

    public native boolean areOpenArchiveHeapObjectsMapped();

    public native int addCompilerDirective(String var1);

    public native void removeCompilerDirective(int var1);

    public native int handshakeWalkStack(Thread var1, boolean var2);

    public native boolean handshakeReadMonitors(Thread var1);

    public native void asyncHandshakeWalkStack(Thread var1);

    public native void lockAndBlock(boolean var1);

    public native boolean checkLibSpecifiesNoexecstack(String var1);

    public native boolean isContainerized();

    public native int validateCgroup(String var1, String var2, String var3);

    public native void printOsInfo();

    public native long hostPhysicalMemory();

    public native long hostPhysicalSwap();

    public native void disableElfSectionCache();

    public native long resolvedMethodItemsCount();

    public native int protectionDomainRemovedCount();

    public native int getKlassMetadataSize(Class<?> var1);

    public native void checkThreadObjOfTerminatingThread(Thread var1);

    public native String getLibcName();

    public native void verifyFrames(boolean var1, boolean var2);

    public native boolean isJVMTIIncluded();

    public native void waitUnsafe(int var1);

    public native void lockCritical();

    public native void unlockCritical();

    public native void pinObject(Object var1);

    public native void unpinObject(Object var1);

    public native boolean setVirtualThreadsNotifyJvmtiMode(boolean var1);

    public native void preTouchMemory(long var1, long var3);

    static {
        WhiteBox.registerNatives();
        concurrentGCIsControlled = false;
    }

    public static class WhiteBoxPermission
    extends BasicPermission {
        public WhiteBoxPermission(String s) {
            super(s);
        }
    }
}

