/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_zbl = "Bliss jelk\u00e9prendszer";
        final String metaValue_JP = "Jap\u00e1n";
        final String metaValue_Hant = "Hagyom\u00e1nyos";
        final Object[][] data = new Object[][] {
            { "001", "Vil\u00e1g" },
            { "002", "Afrika" },
            { "003", "\u00c9szak-Amerika" },
            { "005", "D\u00e9l-Amerika" },
            { "009", "\u00d3ce\u00e1nia" },
            { "011", "Nyugat-Afrika" },
            { "013", "K\u00f6z\u00e9p-Amerika" },
            { "014", "Kelet-Afrika" },
            { "015", "\u00c9szak-Afrika" },
            { "017", "K\u00f6z\u00e9p-Afrika" },
            { "018", "Afrika d\u00e9li r\u00e9sze" },
            { "019", "Amerika" },
            { "021", "Amerika \u00e9szaki r\u00e9sze" },
            { "029", "Karib-t\u00e9rs\u00e9g" },
            { "030", "Kelet-\u00c1zsia" },
            { "034", "D\u00e9l-\u00c1zsia" },
            { "035", "D\u00e9lkelet-\u00c1zsia" },
            { "039", "D\u00e9l-Eur\u00f3pa" },
            { "053", "Ausztr\u00e1l\u00e1zsia" },
            { "054", "Melan\u00e9zia" },
            { "057", "Mikron\u00e9ziai r\u00e9gi\u00f3" },
            { "061", "Polin\u00e9zia" },
            { "142", "\u00c1zsia" },
            { "143", "K\u00f6z\u00e9p-\u00c1zsia" },
            { "145", "Nyugat-\u00c1zsia" },
            { "150", "Eur\u00f3pa" },
            { "151", "Kelet-Eur\u00f3pa" },
            { "154", "\u00c9szak-Eur\u00f3pa" },
            { "155", "Nyugat-Eur\u00f3pa" },
            { "202", "Szubszaharai Afrika" },
            { "419", "Latin-Amerika" },
            { "AC", "Ascension-sziget" },
            { "AD", "Andorra" },
            { "AE", "Egyes\u00fclt Arab Em\u00edrs\u00e9gek" },
            { "AF", "Afganiszt\u00e1n" },
            { "AG", "Antigua \u00e9s Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Alb\u00e1nia" },
            { "AM", "\u00d6rm\u00e9nyorsz\u00e1g" },
            { "AO", "Angola" },
            { "AQ", "Antarktisz" },
            { "AR", "Argent\u00edna" },
            { "AS", "Amerikai Szamoa" },
            { "AT", "Ausztria" },
            { "AU", "Ausztr\u00e1lia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land-szigetek" },
            { "AZ", "Azerbajdzs\u00e1n" },
            { "BA", "Bosznia-Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Banglades" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulg\u00e1ria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Holland Karib-t\u00e9rs\u00e9g" },
            { "BR", "Braz\u00edlia" },
            { "BS", "Bahama-szigetek" },
            { "BT", "Bhut\u00e1n" },
            { "BV", "Bouvet-sziget" },
            { "BW", "Botswana" },
            { "BY", "Belarusz" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "K\u00f3kusz (Keeling)-szigetek" },
            { "CD", "Kong\u00f3 \u2013 Kinshasa" },
            { "CF", "K\u00f6z\u00e9p-afrikai K\u00f6zt\u00e1rsas\u00e1g" },
            { "CG", "Kong\u00f3 \u2013 Brazzaville" },
            { "CH", "Sv\u00e1jc" },
            { "CI", "Elef\u00e1ntcsontpart" },
            { "CK", "Cook-szigetek" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "K\u00edna" },
            { "CO", "Kolumbia" },
            { "CP", "Clipperton-sziget" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Z\u00f6ld-foki K\u00f6zt\u00e1rsas\u00e1g" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Kar\u00e1csony-sziget" },
            { "CY", "Ciprus" },
            { "CZ", "Csehorsz\u00e1g" },
            { "DE", "N\u00e9metorsz\u00e1g" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dzsibuti" },
            { "DK", "D\u00e1nia" },
            { "DM", "Dominika" },
            { "DO", "Dominikai K\u00f6zt\u00e1rsas\u00e1g" },
            { "DZ", "Alg\u00e9ria" },
            { "EA", "Ceuta \u00e9s Melilla" },
            { "EC", "Ecuador" },
            { "EE", "\u00c9sztorsz\u00e1g" },
            { "EG", "Egyiptom" },
            { "EH", "Nyugat-Szahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanyolorsz\u00e1g" },
            { "ET", "Eti\u00f3pia" },
            { "EU", "Eur\u00f3pai Uni\u00f3" },
            { "EZ", "Eur\u00f3z\u00f3na" },
            { "FI", "Finnorsz\u00e1g" },
            { "FJ", "Fidzsi" },
            { "FK", "Falkland-szigetek" },
            { "FM", "Mikron\u00e9zia" },
            { "FO", "Fer\u00f6er szigetek" },
            { "FR", "Franciaorsz\u00e1g" },
            { "GA", "Gabon" },
            { "GB", "Egyes\u00fclt Kir\u00e1lys\u00e1g" },
            { "GD", "Grenada" },
            { "GE", "Gr\u00fazia" },
            { "GF", "Francia Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Gh\u00e1na" },
            { "GI", "Gibralt\u00e1r" },
            { "GL", "Gr\u00f6nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Egyenl\u00edt\u0151i-Guinea" },
            { "GR", "G\u00f6r\u00f6gorsz\u00e1g" },
            { "GS", "D\u00e9li-Georgia \u00e9s D\u00e9li-Sandwich-szigetek" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Bissau-Guinea" },
            { "GY", "Guyana" },
            { "HK", "Hongkong KKT" },
            { "HM", "Heard-sziget \u00e9s McDonald-szigetek" },
            { "HN", "Honduras" },
            { "HR", "Horv\u00e1torsz\u00e1g" },
            { "HT", "Haiti" },
            { "HU", "Magyarorsz\u00e1g" },
            { "IC", "Kan\u00e1ri-szigetek" },
            { "ID", "Indon\u00e9zia" },
            { "IE", "\u00cdrorsz\u00e1g" },
            { "IL", "Izrael" },
            { "IM", "Man-sziget" },
            { "IN", "India" },
            { "IO", "Brit Indiai-\u00f3ce\u00e1ni Ter\u00fclet" },
            { "IQ", "Irak" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Izland" },
            { "IT", "Olaszorsz\u00e1g" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jord\u00e1nia" },
            { "JP", metaValue_JP },
            { "KE", "Kenya" },
            { "KG", "Kirgiziszt\u00e1n" },
            { "KH", "Kambodzsa" },
            { "KI", "Kiribati" },
            { "KM", "Comore-szigetek" },
            { "KN", "Saint Kitts \u00e9s Nevis" },
            { "KP", "\u00c9szak-Korea" },
            { "KR", "D\u00e9l-Korea" },
            { "KW", "Kuvait" },
            { "KY", "Kajm\u00e1n-szigetek" },
            { "KZ", "Kazahszt\u00e1n" },
            { "LA", "Laosz" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sr\u00ed Lanka" },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lesotho" },
            { "LT", "Litv\u00e1nia" },
            { "LU", "Luxemburg" },
            { "LV", "Lettorsz\u00e1g" },
            { "LY", "L\u00edbia" },
            { "MA", "Marokk\u00f3" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegr\u00f3" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaszk\u00e1r" },
            { "MH", "Marshall-szigetek" },
            { "MK", "\u00c9szak-Maced\u00f3nia" },
            { "ML", "Mali" },
            { "MM", "Mianmar" },
            { "MN", "Mong\u00f3lia" },
            { "MO", "Maka\u00f3 KKT" },
            { "MP", "\u00c9szaki Mariana-szigetek" },
            { "MQ", "Martinique" },
            { "MR", "Maurit\u00e1nia" },
            { "MS", "Montserrat" },
            { "MT", "M\u00e1lta" },
            { "MU", "Mauritius" },
            { "MV", "Mald\u00edv-szigetek" },
            { "MW", "Malawi" },
            { "MX", "Mexik\u00f3" },
            { "MY", "Malajzia" },
            { "MZ", "Mozambik" },
            { "NA", "Nam\u00edbia" },
            { "NC", "\u00daj-Kaled\u00f3nia" },
            { "NE", "Niger" },
            { "NF", "Norfolk-sziget" },
            { "NG", "Nig\u00e9ria" },
            { "NI", "Nicaragua" },
            { "NL", "Hollandia" },
            { "NO", "Norv\u00e9gia" },
            { "NP", "Nep\u00e1l" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "\u00daj-Z\u00e9land" },
            { "OM", "Om\u00e1n" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francia Polin\u00e9zia" },
            { "PG", "P\u00e1pua \u00daj-Guinea" },
            { "PH", "F\u00fcl\u00f6p-szigetek" },
            { "PK", "Pakiszt\u00e1n" },
            { "PL", "Lengyelorsz\u00e1g" },
            { "PM", "Saint-Pierre \u00e9s Miquelon" },
            { "PN", "Pitcairn-szigetek" },
            { "PR", "Puerto Rico" },
            { "PS", "Palesztin Auton\u00f3mia" },
            { "PT", "Portug\u00e1lia" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "K\u00fcls\u0151-\u00d3ce\u00e1nia" },
            { "RE", "R\u00e9union" },
            { "RO", "Rom\u00e1nia" },
            { "RS", "Szerbia" },
            { "RU", "Oroszorsz\u00e1g" },
            { "RW", "Ruanda" },
            { "SA", "Sza\u00fad-Ar\u00e1bia" },
            { "SB", "Salamon-szigetek" },
            { "SC", "Seychelle-szigetek" },
            { "SD", "Szud\u00e1n" },
            { "SE", "Sv\u00e9dorsz\u00e1g" },
            { "SG", "Szingap\u00far" },
            { "SH", "Szent Ilona" },
            { "SI", "Szlov\u00e9nia" },
            { "SJ", "Svalbard \u00e9s Jan Mayen" },
            { "SK", "Szlov\u00e1kia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Szeneg\u00e1l" },
            { "SO", "Szom\u00e1lia" },
            { "SR", "Suriname" },
            { "SS", "D\u00e9l-Szud\u00e1n" },
            { "ST", "S\u00e3o Tom\u00e9 \u00e9s Pr\u00edncipe" },
            { "SV", "Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Sz\u00edria" },
            { "SZ", "Szv\u00e1zif\u00f6ld" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- \u00e9s Caicos-szigetek" },
            { "TD", "Cs\u00e1d" },
            { "TF", "Francia D\u00e9li Ter\u00fcletek" },
            { "TG", "Togo" },
            { "TH", "Thaif\u00f6ld" },
            { "TJ", "T\u00e1dzsikiszt\u00e1n" },
            { "TK", "Tokelau" },
            { "TL", "Kelet-Timor" },
            { "TM", "T\u00fcrkmeniszt\u00e1n" },
            { "TN", "Tun\u00e9zia" },
            { "TO", "Tonga" },
            { "TR", "T\u00f6r\u00f6korsz\u00e1g" },
            { "TT", "Trinidad \u00e9s Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "TZ", "Tanz\u00e1nia" },
            { "UA", "Ukrajna" },
            { "UG", "Uganda" },
            { "UM", "Az USA lakatlan k\u00fclbirtokai" },
            { "UN", "Egyes\u00fclt Nemzetek Szervezete" },
            { "US", "Egyes\u00fclt \u00c1llamok" },
            { "UY", "Uruguay" },
            { "UZ", "\u00dczbegiszt\u00e1n" },
            { "VA", "Vatik\u00e1n" },
            { "VC", "Saint Vincent \u00e9s a Grenadine-szigetek" },
            { "VE", "Venezuela" },
            { "VG", "Brit Virgin-szigetek" },
            { "VI", "Amerikai Virgin-szigetek" },
            { "VN", "Vietn\u00e1m" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis \u00e9s Futuna" },
            { "WS", "Szamoa" },
            { "XA", "Pszeudo-nyelvj\u00e1r\u00e1sok" },
            { "XB", "Pszeudo-k\u00e9tir\u00e1ny\u00fa" },
            { "XK", "Koszov\u00f3" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "D\u00e9l-afrikai K\u00f6zt\u00e1rsas\u00e1g" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Ismeretlen k\u00f6rzet" },
            { "aa", "afar" },
            { "ab", "abh\u00e1z" },
            { "ae", "aveszt\u00e1n" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhara" },
            { "an", "aragon\u00e9z" },
            { "ar", "arab" },
            { "as", "assz\u00e1mi" },
            { "av", "avar" },
            { "ay", "ajmara" },
            { "az", "azerbajdzs\u00e1ni" },
            { "ba", "bask\u00edr" },
            { "be", "belarusz" },
            { "bg", "bolg\u00e1r" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bangla" },
            { "bo", "tibeti" },
            { "br", "breton" },
            { "bs", "bosny\u00e1k" },
            { "ca", "katal\u00e1n" },
            { "ce", "csecsen" },
            { "ch", "csamor\u00f3" },
            { "co", "korzikai" },
            { "cr", "kr\u00ed" },
            { "cs", "cseh" },
            { "cu", "egyh\u00e1zi szl\u00e1v" },
            { "cv", "csuvas" },
            { "cy", "walesi" },
            { "da", "d\u00e1n" },
            { "de", "n\u00e9met" },
            { "dv", "divehi" },
            { "dz", "dzsonga" },
            { "ee", "eve" },
            { "el", "g\u00f6r\u00f6g" },
            { "en", "angol" },
            { "eo", "eszperant\u00f3" },
            { "es", "spanyol" },
            { "et", "\u00e9szt" },
            { "eu", "baszk" },
            { "fa", "perzsa" },
            { "ff", "fulani" },
            { "fi", "finn" },
            { "fj", "fidzsi" },
            { "fo", "fer\u00f6eri" },
            { "fr", "francia" },
            { "fy", "nyugati fr\u00edz" },
            { "ga", "\u00edr" },
            { "gd", "sk\u00f3ciai kelta" },
            { "gl", "gallego" },
            { "gn", "guarani" },
            { "gu", "gudzsar\u00e1ti" },
            { "gv", "man-szigeti" },
            { "ha", "hausza" },
            { "he", "h\u00e9ber" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "horv\u00e1t" },
            { "ht", "haiti kreol" },
            { "hu", "magyar" },
            { "hy", "\u00f6rm\u00e9ny" },
            { "hz", "herero" },
            { "ia", "interlingva" },
            { "id", "indon\u00e9z" },
            { "ie", "interlingue" },
            { "ig", "igb\u00f3" },
            { "ii", "szecsu\u00e1n ji" },
            { "ik", "inupiak" },
            { "io", "id\u00f3" },
            { "is", "izlandi" },
            { "it", "olasz" },
            { "iu", "inuktitut" },
            { "ja", "jap\u00e1n" },
            { "jv", "j\u00e1vai" },
            { "ka", "gr\u00faz" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kuanyama" },
            { "kk", "kazah" },
            { "kl", "gr\u00f6nlandi" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "ko", "koreai" },
            { "kr", "kanuri" },
            { "ks", "kasm\u00edri" },
            { "ku", "kurd" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiz" },
            { "la", "latin" },
            { "lb", "luxemburgi" },
            { "lg", "ganda" },
            { "li", "limburgi" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "litv\u00e1n" },
            { "lu", "luba-katanga" },
            { "lv", "lett" },
            { "mg", "malgas" },
            { "mh", "marshalli" },
            { "mi", "maori" },
            { "mk", "maced\u00f3n" },
            { "ml", "malaj\u00e1lam" },
            { "mn", "mongol" },
            { "mr", "mar\u00e1thi" },
            { "ms", "mal\u00e1j" },
            { "mt", "m\u00e1ltai" },
            { "my", "burmai" },
            { "na", "naurui" },
            { "nb", "norv\u00e9g (bokm\u00e5l)" },
            { "nd", "\u00e9szaki ndebele" },
            { "ne", "nep\u00e1li" },
            { "ng", "ndonga" },
            { "nl", "holland" },
            { "nn", "norv\u00e9g (nynorsk)" },
            { "no", "norv\u00e9g" },
            { "nr", "d\u00e9li ndebele" },
            { "nv", "navah\u00f3" },
            { "ny", "nyandzsa" },
            { "oc", "okszit\u00e1n" },
            { "oj", "ojibva" },
            { "om", "oromo" },
            { "or", "odia" },
            { "os", "osz\u00e9t" },
            { "pa", "pandzs\u00e1bi" },
            { "pi", "pali" },
            { "pl", "lengyel" },
            { "ps", "pastu" },
            { "pt", "portug\u00e1l" },
            { "qu", "kecsua" },
            { "rm", "r\u00e9torom\u00e1n" },
            { "rn", "kirundi" },
            { "ro", "rom\u00e1n" },
            { "ru", "orosz" },
            { "rw", "kinyarvanda" },
            { "sa", "szanszkrit" },
            { "sc", "szard\u00edniai" },
            { "sd", "szindhi" },
            { "se", "\u00e9szaki sz\u00e1mi" },
            { "sg", "szang\u00f3" },
            { "sh", "szerbhorv\u00e1t" },
            { "si", "szingal\u00e9z" },
            { "sk", "szlov\u00e1k" },
            { "sl", "szlov\u00e9n" },
            { "sm", "szamoai" },
            { "sn", "sona" },
            { "so", "szom\u00e1li" },
            { "sq", "alb\u00e1n" },
            { "sr", "szerb" },
            { "ss", "sziszuati" },
            { "st", "d\u00e9li szeszot\u00f3" },
            { "su", "szundan\u00e9z" },
            { "sv", "sv\u00e9d" },
            { "sw", "szuah\u00e9li" },
            { "ta", "tamil" },
            { "te", "telugu" },
            { "tg", "tadzsik" },
            { "th", "thai" },
            { "ti", "tigrinya" },
            { "tk", "t\u00fcrkm\u00e9n" },
            { "tl", "tagalog" },
            { "tn", "szecsu\u00e1ni" },
            { "to", "tongai" },
            { "tr", "t\u00f6r\u00f6k" },
            { "ts", "conga" },
            { "tt", "tat\u00e1r" },
            { "tw", "twi" },
            { "ty", "tahiti" },
            { "ug", "ujgur" },
            { "uk", "ukr\u00e1n" },
            { "ur", "urdu" },
            { "uz", "\u00fczb\u00e9g" },
            { "ve", "venda" },
            { "vi", "vietn\u00e1mi" },
            { "vo", "volap\u00fck" },
            { "wa", "vallon" },
            { "wo", "volof" },
            { "xh", "xhosza" },
            { "yi", "jiddis" },
            { "yo", "joruba" },
            { "za", "zsuang" },
            { "zh", "k\u00ednai" },
            { "zu", "zulu" },
            { "ace", "achin\u00e9z" },
            { "ach", "akoli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "afh", "afrihili" },
            { "agq", "agem" },
            { "ain", "ainu" },
            { "akk", "akk\u00e1d" },
            { "ale", "aleut" },
            { "alt", "d\u00e9l-altaji" },
            { "ang", "\u00f3angol" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "levantei arab" },
            { "arc", "ar\u00e1mi" },
            { "arn", "mapucse" },
            { "arp", "arapaho" },
            { "ars", "nedzsdi arab" },
            { "arw", "aravak" },
            { "asa", "asu" },
            { "ast", "aszt\u00far" },
            { "atj", "attikamek" },
            { "awa", "aw\u00e1di" },
            { "bal", "balucsi" },
            { "ban", "balin\u00e9z" },
            { "bas", "basza" },
            { "bax", "bamun" },
            { "bbj", "gomala" },
            { "bej", "bedzsa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "haryanvi" },
            { "bgn", "nyugati beludzs" },
            { "bho", "bodzspuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "koszi" },
            { "bua", "burj\u00e1t" },
            { "bug", "bugin\u00e9z" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karib" },
            { "cay", "kajuga" },
            { "cch", "atszam" },
            { "ccp", "csakma" },
            { "ceb", "szebuano" },
            { "cgg", "kiga" },
            { "chb", "csibcsa" },
            { "chg", "csagat\u00e1j" },
            { "chk", "csuk\u00e9z" },
            { "chm", "mari" },
            { "chn", "csinuk zsargon" },
            { "cho", "csokt\u00f3" },
            { "chp", "csipev\u00e9" },
            { "chr", "cseroki" },
            { "chy", "csejen" },
            { "ckb", "k\u00f6z\u00e9p-\u00e1zsiai kurd" },
            { "clc", "csilkotin" },
            { "cop", "kopt" },
            { "crg", "micsif" },
            { "crh", "kr\u00edmi tat\u00e1r" },
            { "crj", "d\u00e9lkeleti kr\u00ed" },
            { "crk", "s\u00edks\u00e1gi kr\u00ed" },
            { "crl", "\u00e9szakkeleti kr\u00ed" },
            { "crm", "moose kr\u00ed" },
            { "crr", "karolinai algonkin" },
            { "crs", "szeszelva kreol francia" },
            { "csb", "kasub" },
            { "csw", "mocs\u00e1ri kr\u00ed" },
            { "dak", "dakota" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "del", "delav\u00e1r" },
            { "den", "szlevi" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "als\u00f3-szorb" },
            { "dua", "duala" },
            { "dum", "k\u00f6z\u00e9p holland" },
            { "dyo", "jola-fonyi" },
            { "dyu", "diula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "\u00f3egyiptomi" },
            { "eka", "ekadzsuk" },
            { "elx", "elamit" },
            { "enm", "k\u00f6z\u00e9p angol" },
            { "ewo", "evondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipp\u00edn\u00f3" },
            { "fon", "fon" },
            { "frc", "cajun francia" },
            { "frm", "k\u00f6z\u00e9p francia" },
            { "fro", "\u00f3francia" },
            { "frr", "\u00e9szaki fr\u00edz" },
            { "frs", "keleti fr\u00edz" },
            { "fur", "friuli" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "gan k\u00ednai" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gez", "geez" },
            { "gil", "ikiribati" },
            { "gmh", "k\u00f6z\u00e9p fels\u0151 n\u00e9met" },
            { "goh", "\u00f3fels\u0151 n\u00e9met" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "g\u00f3t" },
            { "grb", "greb\u00f3" },
            { "grc", "\u00f3g\u00f6r\u00f6g" },
            { "gsw", "sv\u00e1jci n\u00e9met" },
            { "guz", "guszii" },
            { "gwi", "gvicsin" },
            { "hai", "haida" },
            { "hak", "hakka k\u00ednai" },
            { "haw", "hawaii" },
            { "hax", "d\u00e9li haida" },
            { "hil", "ilokano" },
            { "hit", "hettita" },
            { "hmn", "hmong" },
            { "hsb", "fels\u0151-szorb" },
            { "hsn", "xiang k\u00ednai" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "nyugat-kanadai inuit" },
            { "ilo", "ilok\u00f3" },
            { "inh", "ingus" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "zsid\u00f3-perzsa" },
            { "jrb", "zsid\u00f3-arab" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabije" },
            { "kac", "kacsin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardi" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kaszi" },
            { "kho", "kotan\u00e9z" },
            { "khq", "kojra-cs\u00edni" },
            { "kkj", "kak\u00f3" },
            { "kln", "kalendzsin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permj\u00e1k" },
            { "kok", "konkani" },
            { "kos", "kosrei" },
            { "kpe", "kpelle" },
            { "krc", "karacs\u00e1j-balk\u00e1r" },
            { "krl", "karelai" },
            { "kru", "kuruh" },
            { "ksb", "sambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "kum\u00fck" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezg" },
            { "lij", "ligur" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "lombard" },
            { "lol", "mong\u00f3" },
            { "lou", "louisianai kreol" },
            { "loz", "lozi" },
            { "lrc", "\u00e9szaki luri" },
            { "lsm", "samia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "lujia" },
            { "mad", "madurai" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makaszar" },
            { "man", "manding\u00f3" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "moks\u00e1n" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "mauritiusi kreol" },
            { "mga", "k\u00f6z\u00e9p \u00edr" },
            { "mgh", "makua-met\u00f3" },
            { "mgo", "meta\u2019" },
            { "mic", "mikmak" },
            { "min", "minangkabau" },
            { "mnc", "mandzsu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "moszi" },
            { "mua", "mundang" },
            { "mul", "t\u00f6bbsz\u00f6r\u00f6s nyelvek" },
            { "mus", "kr\u00edk" },
            { "mwl", "mirand\u00e9z" },
            { "mwr", "m\u00e1rv\u00e1ri" },
            { "mye", "myene" },
            { "myv", "erzj\u00e1ny" },
            { "mzn", "m\u00e1zander\u00e1ni" },
            { "nan", "min nan k\u00ednai" },
            { "nap", "n\u00e1polyi" },
            { "naq", "nama" },
            { "nds", "als\u00f3n\u00e9met" },
            { "new", "nevari" },
            { "nia", "nias" },
            { "niu", "niuei" },
            { "nmg", "ngumba" },
            { "nnh", "ngiemboon" },
            { "nog", "nogaj" },
            { "non", "\u00f3skandin\u00e1v" },
            { "nqo", "n\u2019k\u00f3" },
            { "nso", "\u00e9szaki szeszot\u00f3" },
            { "nus", "nuer" },
            { "nwc", "klasszikus newari" },
            { "nym", "nyamv\u00e9zi" },
            { "nyn", "nyankole" },
            { "nyo", "nyor\u00f3" },
            { "nzi", "nzima" },
            { "ojb", "\u00e9szaknyugati odzsibva" },
            { "ojc", "k\u00f6z\u00e9pvid\u00e9ki odzsibva" },
            { "ojs", "odzsi-kr\u00ed" },
            { "ojw", "nyugati odzsibva" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "oszm\u00e1n-t\u00f6r\u00f6k" },
            { "pag", "pangaszinan" },
            { "pal", "pahlavi" },
            { "pam", "pampangan" },
            { "pap", "papiamento" },
            { "pau", "palaui" },
            { "pcm", "nig\u00e9riai pidgin" },
            { "peo", "\u00f3perzsa" },
            { "phn", "f\u0151niciai" },
            { "pis", "pidzsin" },
            { "pon", "pohnpei" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "porosz" },
            { "pro", "\u00f3prov\u00e1nszi" },
            { "quc", "kicse" },
            { "raj", "radzsaszt\u00e1ni" },
            { "rap", "rapanui" },
            { "rar", "rarotongai" },
            { "rhg", "rohingja" },
            { "rof", "rombo" },
            { "rom", "roma" },
            { "rup", "arom\u00e1n" },
            { "rwk", "rwo" },
            { "sad", "szandave" },
            { "sah", "szaha" },
            { "sam", "szamarit\u00e1nus ar\u00e1mi" },
            { "saq", "szamburu" },
            { "sas", "sasak" },
            { "sat", "szant\u00e1li" },
            { "sba", "ngambay" },
            { "sbp", "szangu" },
            { "scn", "szic\u00edliai" },
            { "sco", "sk\u00f3t" },
            { "sdh", "d\u00e9l-kurd" },
            { "see", "szeneka" },
            { "seh", "szena" },
            { "sel", "sz\u00f6lkup" },
            { "ses", "kojra-szenni" },
            { "sga", "\u00f3\u00edr" },
            { "shi", "tachelhit" },
            { "shn", "san" },
            { "shu", "cs\u00e1di arab" },
            { "sid", "szidam\u00f3" },
            { "slh", "d\u00e9li lushootseed" },
            { "sma", "d\u00e9li sz\u00e1mi" },
            { "smj", "lulei sz\u00e1mi" },
            { "smn", "inari sz\u00e1mi" },
            { "sms", "kolta sz\u00e1mi" },
            { "snk", "szoninke" },
            { "sog", "sogdien" },
            { "srn", "szranai tong\u00f3" },
            { "srr", "szerer" },
            { "ssy", "szah\u00f3" },
            { "str", "szorosmenti salish" },
            { "suk", "szukuma" },
            { "sus", "szuszu" },
            { "sux", "sum\u00e9r" },
            { "swb", "comorei" },
            { "syc", "klasszikus sz\u00edr" },
            { "syr", "sz\u00edr" },
            { "szl", "szil\u00e9ziai" },
            { "tce", "d\u00e9li tutchone" },
            { "tem", "temne" },
            { "teo", "tesz\u00f3" },
            { "ter", "teren\u00f3" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tiv" },
            { "tkl", "tokelaui" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tamasek" },
            { "tog", "nyugati nyasza" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "tarok\u00f3" },
            { "tsi", "csimsi\u00e1ni" },
            { "ttm", "\u00e9szaki tutchone" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "szav\u00e1k" },
            { "tyv", "tuvai" },
            { "tzm", "k\u00f6z\u00e9p-atlaszi tamazigt" },
            { "udm", "udmurt" },
            { "uga", "ugariti" },
            { "umb", "umbundu" },
            { "und", "ismeretlen nyelv" },
            { "vai", "vai" },
            { "vec", "velencei" },
            { "vot", "votj\u00e1k" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "valamo" },
            { "war", "vara\u00f3" },
            { "was", "vas\u00f3" },
            { "wbp", "warlpiri" },
            { "wuu", "wu k\u00ednai" },
            { "xal", "kalm\u00fck" },
            { "xog", "szoga" },
            { "yao", "ja\u00f3" },
            { "yap", "japi" },
            { "yav", "jangben" },
            { "ybb", "jemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantoni" },
            { "zap", "zapot\u00e9k" },
            { "zbl", metaValue_zbl },
            { "zen", "zenaga" },
            { "zgh", "marokk\u00f3i tamazight" },
            { "zun", "zuni" },
            { "zxx", "nincs nyelv\u00e9szeti tartalom" },
            { "zza", "zaza" },
            { "Adlm", "Adlam" },
            { "Aghb", "Kauk\u00e1zusi albaniai" },
            { "Arab", "Arab" },
            { "Aran", "Nasztalik" },
            { "Armi", "Birodalmi ar\u00e1mi" },
            { "Armn", "\u00d6rm\u00e9ny" },
            { "Avst", "Aveszt\u00e1n" },
            { "Bali", "Balin\u00e9z" },
            { "Batk", "Batak" },
            { "Beng", "Beng\u00e1li" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Br\u00e1mi" },
            { "Brai", "Vak\u00edr\u00e1s" },
            { "Bugi", "Bugin\u00e9z" },
            { "Buhd", "Buhid" },
            { "Cakm", "Csakma" },
            { "Cans", "Egyes\u00edtett kanadai \u0151slakos jelek" },
            { "Cari", "Kari" },
            { "Cham", "Cs\u00e1m" },
            { "Cher", "Cseroki" },
            { "Copt", "Kopt" },
            { "Cpmn", "Ciprusi-min\u00f3szi" },
            { "Cprt", "Ciprusi" },
            { "Cyrl", "Cirill" },
            { "Cyrs", "\u00d3egyh\u00e1zi szl\u00e1v cirill" },
            { "Deva", "Devanag\u00e1ri" },
            { "Dsrt", "Deseret" },
            { "Egyd", "Egyiptomi demotikus" },
            { "Egyh", "Egyiptomi hieratikus" },
            { "Egyp", "Egyiptomi hieroglif\u00e1k" },
            { "Ethi", "Eti\u00f3p" },
            { "Geok", "Gr\u00faz kucsuri" },
            { "Geor", "Gr\u00faz" },
            { "Glag", "Glagolitikus" },
            { "Goth", "G\u00f3t" },
            { "Grek", "G\u00f6r\u00f6g" },
            { "Gujr", "Gudzsar\u00e1ti" },
            { "Guru", "Gurmuki" },
            { "Hanb", "Han bopomof\u00f3val" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Egyszer\u0171s\u00edtett" },
            { "Hant", metaValue_Hant },
            { "Hebr", "H\u00e9ber" },
            { "Hira", "Hiragana" },
            { "Hluw", "Anat\u00f3liai hieroglif\u00e1k" },
            { "Hmng", "Pahawh hmong" },
            { "Hrkt", "Katakana vagy hiragana" },
            { "Hung", "\u00d3magyar" },
            { "Inds", "Indus" },
            { "Ital", "R\u00e9gi olasz" },
            { "Jamo", "Jamo" },
            { "Java", "J\u00e1vai" },
            { "Jpan", metaValue_JP },
            { "Kali", "Kajah li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Khmer" },
            { "Knda", "Kannada" },
            { "Kore", "Koreai" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Lao" },
            { "Latf", "Fraktur latin" },
            { "Latg", "Gael latin" },
            { "Latn", "Latin" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Line\u00e1ris A" },
            { "Linb", "Line\u00e1ris B" },
            { "Lyci", "L\u00edciai" },
            { "Lydi", "L\u00eddiai" },
            { "Mand", "Mandai" },
            { "Mani", "Manicheus" },
            { "Maya", "Maja hieroglif\u00e1k" },
            { "Mero", "Meroitikus" },
            { "Mlym", "Malaj\u00e1lam" },
            { "Mong", "Mongol" },
            { "Moon", "Moon" },
            { "Mtei", "Meitei mayek" },
            { "Mymr", "Burmai" },
            { "Nbat", "Nabateus" },
            { "Nkoo", "N\u2019ko" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol chiki" },
            { "Orkh", "Orhon" },
            { "Orya", "Oriya" },
            { "Osma", "Oszm\u00e1n" },
            { "Perm", "\u00d3permikus" },
            { "Phag", "Phags-pa" },
            { "Phli", "Felriatos pahlavi" },
            { "Phlp", "Psalter pahlavi" },
            { "Phlv", "K\u00f6nyv pahlavi" },
            { "Phnx", "F\u0151niciai" },
            { "Plrd", "Pollard fonetikus" },
            { "Prti", "Feliratos parthian" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Redzsang" },
            { "Rohg", "Hanifi" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runikus" },
            { "Samr", "Szamarit\u00e1n" },
            { "Sara", "Szarati" },
            { "Saur", "Szaurastra" },
            { "Sgnw", "Jel\u00edr\u00e1s" },
            { "Shaw", "Shaw \u00e1b\u00e9c\u00e9" },
            { "Sidd", "Sziddham" },
            { "Sinh", "Szingal\u00e9z" },
            { "Sogd", "Szogd" },
            { "Sogo", "\u00d3szogd" },
            { "Sund", "Szundan\u00e9z" },
            { "Sylo", "Sylheti nag\u00e1ri" },
            { "Syrc", "Sz\u00edriai" },
            { "Syre", "Estrangelo sz\u00edriai" },
            { "Syrj", "Nyugat-sz\u00edriai" },
            { "Syrn", "Kelet-sz\u00edriai" },
            { "Tagb", "Tagbanwa" },
            { "Tale", "Tai Le" },
            { "Talu", "\u00daj tai lue" },
            { "Taml", "Tamil" },
            { "Tavt", "Tai viet" },
            { "Telu", "Telugu" },
            { "Teng", "Tengwar" },
            { "Tfng", "Berber" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Thaana" },
            { "Thai", "Thai" },
            { "Tibt", "Tibeti" },
            { "Ugar", "Ugari" },
            { "Vaii", "Vai" },
            { "Visp", "L\u00e1that\u00f3 besz\u00e9d" },
            { "Xpeo", "\u00d3perzsa" },
            { "Xsux", "\u00c9k\u00edr\u00e1sos sum\u00e9ro-akk\u00e1d" },
            { "Yiii", "Ji" },
            { "Zinh", "Sz\u00e1rmaztatott" },
            { "Zmth", "Matematikai jelrendszer" },
            { "Zsye", "Emoji" },
            { "Zsym", "Szimb\u00f3lum" },
            { "Zxxx", "\u00cdratlan nyelvek k\u00f3dja" },
            { "Zyyy", "Meghat\u00e1rozatlan" },
            { "Zzzz", "Ismeretlen \u00edr\u00e1srendszer" },
            { "de_AT", "osztr\u00e1k n\u00e9met" },
            { "de_CH", "sv\u00e1jci feln\u00e9met" },
            { "en_AU", "ausztr\u00e1l angol" },
            { "en_CA", "kanadai angol" },
            { "en_GB", "brit angol" },
            { "en_US", "amerikai angol" },
            { "es_ES", "eur\u00f3pai spanyol" },
            { "es_MX", "spanyol (mexik\u00f3i)" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadai francia" },
            { "fr_CH", "sv\u00e1jci francia" },
            { "nl_BE", "flamand" },
            { "pt_BR", "braz\u00edliai portug\u00e1l" },
            { "pt_PT", "eur\u00f3pai portug\u00e1l" },
            { "ro_MD", "moldvai" },
            { "sw_CD", "kong\u00f3i szuah\u00e9li" },
            { "%%1901", "Hagyom\u00e1nyos n\u00e9met helyes\u00edr\u00e1s" },
            { "%%1994", "Szabv\u00e1nyos\u00edtott rezij\u00e1n helyes\u00edr\u00e1s" },
            { "%%1996", "1996-os n\u00e9met helyes\u00edr\u00e1s" },
            { "ar_001", "modern szabv\u00e1nyos arab" },
            { "es_419", "latin-amerikai spanyol" },
            { "key.ca", "Napt\u00e1r" },
            { "key.cf", "P\u00e9nznemform\u00e1tum" },
            { "key.co", "Rendez\u00e9si sorrend" },
            { "key.cu", "P\u00e9nznem" },
            { "key.hc", "\u00d3raform\u00e1tum (12 \u2013 24)" },
            { "key.lb", "Sort\u00f6r\u00e9s st\u00edlusa" },
            { "key.ms", "M\u00e9rt\u00e9kegys\u00e9grendszer" },
            { "key.nu", "Sz\u00e1mok" },
            { "key.tz", "Id\u0151z\u00f3na" },
            { "key.va", "F\u00f6ldrajzi helyvari\u00e1ns" },
            { "nds_NL", "als\u00f3sz\u00e1sz" },
            { "%%ALUKU", "Aluku dialektus" },
            { "%%BISKE", "San Giorgo/Bila t\u00e1jsz\u00f3l\u00e1s" },
            { "%%BOONT", "Boontling" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "Meghat\u00e1rozatlan helyes\u00edr\u00e1s" },
            { "%%LIPAW", "Rezij\u00e1n lipovaz t\u00e1jsz\u00f3l\u00e1s" },
            { "%%NEDIS", "Natisone dialektus" },
            { "%%NJIVA", "Gniva/Njiva t\u00e1jsz\u00f3l\u00e1s" },
            { "%%OSOJS", "Oseacco/Osojane t\u00e1jsz\u00f3l\u00e1s" },
            { "%%POSIX", "Sz\u00e1m\u00edt\u00f3g\u00e9p" },
            { "%%PUTER", "Puter" },
            { "%%ROZAJ", "Rezij\u00e1n" },
            { "%%RUMGR", "Rumgr" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Stolvizza/Solbica t\u00e1jsz\u00f3l\u00e1s" },
            { "%%UCCOR", "Egyes\u00edtett helyes\u00edr\u00e1s" },
            { "hi_Latn", "hindi (latin)" },
            { "zh_Hans", "egyszer\u0171s\u00edtett k\u00ednai" },
            { "zh_Hant", "hagyom\u00e1nyos k\u00ednai" },
            { "%%FONIPA", "IPA fonetika" },
            { "%%FONUPA", "UPA fonetika" },
            { "%%NDYUKA", "Ndyuka dialektus" },
            { "%%PAMAKA", "Pamaka dialektus" },
            { "%%PINYIN", "pinjin \u00e1t\u00edr\u00e1s" },
            { "%%SCOUSE", "Scouse" },
            { "%%TARASK", "Taraskijevica helyes\u00edr\u00e1s" },
            { "%%UCRCOR", "Egyes\u00edtett \u00e1tdolgozott helyes\u00edr\u00e1s" },
            { "%%ULSTER", "Ulster" },
            { "%%ALALC97", "ALA-LC romaniz\u00e1ci\u00f3, 1997-es kiad\u00e1s" },
            { "%%AREVELA", "Keleti \u00f6rm\u00e9ny" },
            { "%%AREVMDA", "Nyugati \u00f6rm\u00e9ny" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%HEPBURN", "Hepburn romaniz\u00e1ci\u00f3" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%MONOTON", "Monoton" },
            { "%%POLYTON", "Politonikus" },
            { "%%REVISED", "\u00c1tdolgozott helyes\u00edr\u00e1s" },
            { "%%SURSILV", "Sursilv" },
            { "%%SUTSILV", "Sutsilv" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "K\u00e9s\u0151i k\u00f6z\u00e9p francia 1606-ig" },
            { "%%1694ACAD", "Korai modern francia" },
            { "%%1959ACAD", "Akad\u00e9miai" },
            { "%%BAKU1926", "Egyes\u00edtett t\u00fcrkic latin \u00e1b\u00e9c\u00e9" },
            { "%%BISCAYAN", "Biszkajan" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "%%HOGNORSK", "Hongorszk" },
            { "%%JYUTPING", "Jyutping" },
            { "%%LUNA1918", "Luna1918" },
            { "%%PETR1708", "Petr1708" },
            { "%%SCOTLAND", "Sk\u00f3t szabv\u00e1nyos angol" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%VALENCIA", "Valencia" },
            { "%%VALLADER", "Vallader" },
            { "%%WADEGILE", "Wade-Giles \u00e1t\u00edr\u00e1s" },
            { "type.ca.roc", "K\u00ednai k\u00f6zt\u00e1rsas\u00e1gi napt\u00e1r" },
            { "type.co.eor", "Eur\u00f3pai rendez\u00e9si szab\u00e1lyok" },
            { "type.hc.h11", "12 \u00f3r\u00e1s rendszer (0\u201311)" },
            { "type.hc.h12", "12 \u00f3r\u00e1s rendszer (0\u201312)" },
            { "type.hc.h23", "24 \u00f3r\u00e1s rendszer (0\u201323)" },
            { "type.hc.h24", "24 \u00f3r\u00e1s rendszer (0\u201324)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "Arab-indiai sz\u00e1mjegyek" },
            { "type.nu.armn", "\u00d6rm\u00e9ny sz\u00e1mok" },
            { "type.nu.beng", "Beng\u00e1li sz\u00e1mjegyek" },
            { "type.nu.cakm", "Csakma sz\u00e1mjegyek" },
            { "type.nu.deva", "D\u00e9van\u00e1gari sz\u00e1mjegyek" },
            { "type.nu.ethi", "Eti\u00f3p sz\u00e1mok" },
            { "type.nu.geor", "Gr\u00faz sz\u00e1mok" },
            { "type.nu.grek", "G\u00f6r\u00f6g sz\u00e1mok" },
            { "type.nu.gujr", "Gudzsar\u00e1ti sz\u00e1mjegyek" },
            { "type.nu.guru", "Gurmuki sz\u00e1mjegyek" },
            { "type.nu.hans", "Egyszer\u0171s\u00edtett k\u00ednai sz\u00e1mok" },
            { "type.nu.hant", "Hagyom\u00e1nyos k\u00ednai sz\u00e1mok" },
            { "type.nu.hebr", "H\u00e9ber sz\u00e1mok" },
            { "type.nu.java", "J\u00e1vai sz\u00e1mjegyek" },
            { "type.nu.jpan", "Jap\u00e1n sz\u00e1mok" },
            { "type.nu.khmr", "Khmer sz\u00e1mjegyek" },
            { "type.nu.knda", "Kannada sz\u00e1mjegyek" },
            { "type.nu.laoo", "Lao sz\u00e1mjegyek" },
            { "type.nu.latn", "Nyugati sz\u00e1mjegyek" },
            { "type.nu.mlym", "Malaj\u00e1lam sz\u00e1mjegyek" },
            { "type.nu.mong", "Mongol sz\u00e1mjegyek" },
            { "type.nu.mtei", "Meitei Mayek sz\u00e1mjegyek" },
            { "type.nu.mymr", "Mianmari sz\u00e1mjegyek" },
            { "type.nu.olck", "Ol Chiki sz\u00e1mjegyek" },
            { "type.nu.orya", "Orija sz\u00e1mjegyek" },
            { "type.nu.taml", "Hagyom\u00e1nyos tamil sz\u00e1mjegyek" },
            { "type.nu.telu", "Telugu sz\u00e1mjegyek" },
            { "type.nu.thai", "Thai sz\u00e1mjegyek" },
            { "type.nu.tibt", "Tibeti sz\u00e1mjegyek" },
            { "type.nu.vaii", "Vai sz\u00e1mjegyek" },
            { "type.ca.dangi", "Dangi napt\u00e1r" },
            { "type.co.ducet", "Alap\u00e9rtelmezett Unicode rendez\u00e9si sorrend" },
            { "type.co.emoji", "Emodzsi rendez\u00e9si sorrend" },
            { "type.lb.loose", "T\u00e1g st\u00edlus\u00fa sort\u00f6r\u00e9s" },
            { "type.nu.roman", "R\u00f3mai sz\u00e1mok" },
            { "type.ca.coptic", "Kopt napt\u00e1r" },
            { "type.ca.hebrew", "H\u00e9ber napt\u00e1r" },
            { "type.ca.indian", "Indiai nemzeti napt\u00e1r" },
            { "type.co.compat", "El\u0151z\u0151 rendez\u00e9si sorrend a kompatibilit\u00e1s \u00e9rdek\u00e9ben" },
            { "type.co.pinyin", "Pinyin sorrend" },
            { "type.co.search", "\u00c1ltal\u00e1nos c\u00e9l\u00fa keres\u00e9s" },
            { "type.co.stroke", "Von\u00e1ssorrend" },
            { "type.co.unihan", "Sz\u00f3t\u0151von\u00e1s rendez\u00e9si sorrend" },
            { "type.co.zhuyin", "Zujin rendez\u00e9si sorrend" },
            { "type.d0.fwidth", "Teljes sz\u00e9less\u00e9g" },
            { "type.d0.hwidth", "F\u00e9l sz\u00e9less\u00e9g" },
            { "type.lb.normal", "Norm\u00e1l st\u00edlus\u00fa sort\u00f6r\u00e9s" },
            { "type.lb.strict", "Sz\u0171k st\u00edlus\u00fa sort\u00f6r\u00e9s" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "M\u00e9terrendszer" },
            { "type.nu.native", "Nat\u00edv sz\u00e1mjegyek" },
            { "type.ca.chinese", "K\u00ednai napt\u00e1r" },
            { "type.ca.islamic", "Hidzsra napt\u00e1r" },
            { "type.ca.iso8601", "ISO-8601 napt\u00e1r" },
            { "type.ca.persian", "Perzsa napt\u00e1r" },
            { "type.cf.account", "K\u00f6nyvel\u00e9si p\u00e9nznemform\u00e1tum" },
            { "type.co.big5han", "Hagyom\u00e1nyos k\u00ednai sorrend - Big5" },
            { "type.d0.npinyin", "Sz\u00e1m" },
            { "type.nu.arabext", "Kib\u0151v\u00edtett arab-indiai sz\u00e1mjegyek" },
            { "type.nu.armnlow", "\u00d6rm\u00e9ny kisbet\u0171s sz\u00e1mok" },
            { "type.nu.finance", "P\u00e9nz\u00fcgyi sz\u00e1mok" },
            { "type.nu.greklow", "G\u00f6r\u00f6g kisbet\u0171s sz\u00e1mok" },
            { "type.nu.hanidec", "K\u00ednai tizedes sz\u00e1mok" },
            { "type.nu.hansfin", "Egyszer\u0171s\u00edtett k\u00ednai p\u00e9nz\u00fcgyi sz\u00e1mok" },
            { "type.nu.hantfin", "Hagyom\u00e1nyos k\u00ednai p\u00e9nz\u00fcgyi sz\u00e1mok" },
            { "type.nu.jpanfin", "Jap\u00e1n p\u00e9nz\u00fcgyi sz\u00e1mok" },
            { "type.nu.tamldec", "Tamil sz\u00e1mjegyek" },
            { "type.ca.buddhist", "Buddhista napt\u00e1r" },
            { "type.ca.ethiopic", "Eti\u00f3p napt\u00e1r" },
            { "type.ca.japanese", "Jap\u00e1n napt\u00e1r" },
            { "type.cf.standard", "Norm\u00e1l p\u00e9nznemform\u00e1tum" },
            { "type.co.phonetic", "Fonetikus rendez\u00e9si sorrend" },
            { "type.co.searchjl", "Keres\u00e9s hangul kezd\u0151 m\u00e1ssalhangz\u00f3 szerint" },
            { "type.co.standard", "Norm\u00e1l rendez\u00e9si sorrend" },
            { "type.ms.uksystem", "Angolsz\u00e1sz m\u00e9rt\u00e9kegys\u00e9grendszer" },
            { "type.ms.ussystem", "Amerikai m\u00e9rt\u00e9kegys\u00e9grendszer" },
            { "type.nu.fullwide", "Teljes sz\u00e9less\u00e9g\u0171 sz\u00e1mjegyek" },
            { "type.nu.romanlow", "R\u00f3mai kisbet\u0171s sz\u00e1mok" },
            { "type.ca.gregorian", "Gergely-napt\u00e1r" },
            { "type.co.gb2312han", "Egyszer\u0171s\u00edtett k\u00ednai sorrend - GB2312" },
            { "type.co.phonebook", "Telefonk\u00f6nyv sorrend" },
            { "type.co.dictionary", "Sz\u00f3t\u00e1ri rendez\u00e9si sorrend" },
            { "type.co.traditional", metaValue_Hant },
            { "type.nu.traditional", "Hagyom\u00e1nyos sz\u00e1mok" },
            { "type.ca.islamic-civil", "Hidzsra napt\u00e1r (t\u00e1bl\u00e1zatos, polg\u00e1ri)" },
            { "type.ca.islamic-umalqura", "Hidzsra napt\u00e1r (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Eti\u00f3p amete alem napt\u00e1r" },
        };
        return data;
    }
}
