/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FR = "W\u012bw\u012b";
        final String metaValue_hy = "\u0100meiniana";
        final String metaValue_bn = "P\u0101ngara";
        final String metaValue_ccp = "Tiakam\u0101";
        final String metaValue_ka = "H\u014driana";
        final String metaValue_el = "Kiriki";
        final String metaValue_gu = "Kutar\u0101ti";
        final String metaValue_he = "H\u012bperu";
        final String metaValue_ja = "Hapanihi";
        final String metaValue_km = "Kimei";
        final String metaValue_kn = "Kanara";
        final String metaValue_ko = "K\u014dreana";
        final String metaValue_lo = "Rao";
        final String metaValue_mn = "Mong\u014driana";
        final String metaValue_nqo = "Unuk\u014d";
        final String metaValue_syr = "H\u012briaka";
        final String metaValue_te = "Teruku";
        final String metaValue_th = "Tai";
        final String metaValue_bo = "Tipete";
        final String metaValue_vai = "Wai";
        final Object[][] data = new Object[][] {
            { "001", "te ao" },
            { "002", "\u0100wherika" },
            { "003", "Amerika ki te Raki" },
            { "005", "Amerika ki te Tonga" },
            { "009", "\u014chi\u0101nia" },
            { "011", "\u0100wherika ki te Uru" },
            { "013", "Te Puku o Amerika" },
            { "014", "\u0100wherika ki te R\u0101whiti" },
            { "015", "\u0100wherika ki te Raki" },
            { "017", "Te Pokap\u016b o \u0100wherika" },
            { "018", "\u0100wherika Whakatetonga" },
            { "019", "Amerika" },
            { "021", "Te Raki o Amerika" },
            { "029", "Karapiana" },
            { "030", "\u0100hia ki te R\u0101whiti" },
            { "034", "\u0100hia ki te Tonga" },
            { "035", "\u0100hia ki te Tonga-m\u0101-uru" },
            { "039", "\u016aropi ki te Tonga" },
            { "053", "Te Moana Ahitereiria" },
            { "054", "Meran\u012bhia" },
            { "057", "Te Rohe o Mikoron\u012bhia" },
            { "061", "Te Moana-nui-a-Kiwa" },
            { "142", "\u0100hia" },
            { "143", "Te Puku o \u0100hia" },
            { "145", "\u0100hia ki te Uru" },
            { "150", "\u016aropi" },
            { "151", "\u016aropi ki te R\u0101whiti" },
            { "154", "\u016aropi ki te Raki" },
            { "155", "\u016aropi ki te Uru" },
            { "202", "\u0100wherika ki te Tonga o Te Hah\u0101ra" },
            { "419", "Amerika R\u0101tini" },
            { "AG", "Anatikua me P\u0101pura" },
            { "AI", "\u0100kuira" },
            { "AO", "Anakora" },
            { "AR", "\u0100ketina" },
            { "AT", "Ateria" },
            { "AW", "Ar\u016bpa" },
            { "AX", "Motu \u014crana" },
            { "BB", "P\u0101pet\u014d" },
            { "BE", "Paratiamu" },
            { "BF", "P\u0113kina Waho" },
            { "BI", "Puruniti" },
            { "BJ", "Pen\u012bna" },
            { "BL", "Hato P\u0101teremi" },
            { "BM", "Pemiuta" },
            { "BO", "Poriwia" },
            { "BQ", "Karepeana H\u014drana" },
            { "BR", "Par\u012bhi" },
            { "BS", "Pah\u0101ma" },
            { "BV", "Motu P\u016bwei" },
            { "BW", "Poriwana" },
            { "BZ", "Per\u012bhi" },
            { "CA", "K\u0101nata" },
            { "CD", "K\u014dngo - Kingih\u0101ha" },
            { "CF", "Te Puku o \u0100wherika" },
            { "CG", "K\u014dngo - Par\u0101whe" },
            { "CH", "Huiterangi" },
            { "CI", "Te Tai Rei" },
            { "CL", "Hiri" },
            { "CM", "Kamar\u016bna" },
            { "CN", "Haina" },
            { "CO", "Korom\u014dpia" },
            { "CR", "Kota R\u012bka" },
            { "CU", "Kiupa" },
            { "CV", "Te K\u016brae Matomato" },
            { "CW", "Kurahao" },
            { "DE", "Tiamani" },
            { "DJ", "Tip\u016bti" },
            { "DK", "Tenem\u0101ka" },
            { "DM", "Tominika" },
            { "DO", "Te Whenua Tominika" },
            { "DZ", "Aratiria" },
            { "EA", "H\u016bta me Merera" },
            { "EC", "Ekuatoa" },
            { "EE", "Et\u014dnia" },
            { "EG", "\u012ahipa" },
            { "EH", "Hah\u0101ra ki te Tonga" },
            { "ER", "Erit\u0113ria" },
            { "ET", "Etiopia" },
            { "EU", "Te Uniana o \u016aropi" },
            { "EZ", "Te Rohe o \u016aropi" },
            { "FI", "Whinirana" },
            { "FK", "Motu Wh\u0101karangi" },
            { "FO", "Motu Wharo" },
            { "FR", metaValue_FR },
            { "GA", "K\u0101pona" },
            { "GB", "Te Hononga o Piritene" },
            { "GD", "Keren\u0101ta" },
            { "GF", "Kaiana W\u012bw\u012b" },
            { "GG", "K\u0113ni" },
            { "GH", "K\u0101na" },
            { "GL", "Kir\u012brangi" },
            { "GM", "Te Kamopia" },
            { "GN", "Kini" },
            { "GP", "Kuatar\u016b" },
            { "GQ", "Kini Ekuatoria" },
            { "GS", "H\u014dria ki te Tonga me Motu Hanuwiti ki te Tonga" },
            { "GT", "Kuatam\u0101ra" },
            { "GW", "Kini-Pihao" },
            { "GY", "Kaiana" },
            { "HN", "Hon\u016bra" },
            { "HT", "Haiti" },
            { "IC", "Motu K\u0101nara" },
            { "IE", "Aerana" },
            { "IM", "Motu Tangata" },
            { "IN", "Inia" },
            { "IO", "Te Rohe o te Moana \u012aniana Piritihi" },
            { "IS", "Tiorangi" },
            { "IT", "It\u0101ria" },
            { "JE", "Tiehe" },
            { "JM", "Hemeika" },
            { "JP", "Hapani" },
            { "KE", "K\u0113nia" },
            { "KM", "Komoro" },
            { "KN", "Hato Kiti me Newhi" },
            { "KY", "Ng\u0101 Motu Keimana" },
            { "LC", "Hato Ruhia" },
            { "LI", "R\u012bkeneteina" },
            { "LR", "Raipiri" },
            { "LS", "Teroto" },
            { "LT", "Ritu\u0101nia" },
            { "LU", "Rakimip\u0113ki" },
            { "LV", "Ratawia" },
            { "LY", "R\u012bpia" },
            { "MA", "Moroko" },
            { "MC", "Manako" },
            { "MF", "Hato M\u0101tene" },
            { "MG", "Marak\u0101hia" },
            { "MK", "Maker\u014dnia ki te Raki" },
            { "ML", "M\u0101ri" },
            { "MQ", "M\u0101teniki" },
            { "MR", "Maurit\u0101nia" },
            { "MS", "Monoter\u0101" },
            { "MU", "M\u014drihi" },
            { "MW", "Mar\u0101wi" },
            { "MX", "M\u0113hiko" },
            { "MZ", "Mohapiki" },
            { "NA", "Nam\u012bpia" },
            { "NE", "Ng\u0101ika" },
            { "NG", "Ng\u0101itiria" },
            { "NI", "Nikarakua" },
            { "NL", "H\u014drana" },
            { "NO", "N\u014dwei" },
            { "NZ", "Aotearoa" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PM", "Hato Piere & Mikarona" },
            { "PR", "P\u014dta Riko" },
            { "PY", "Parakai" },
            { "QO", "Ng\u0101 moutere m\u014dwaho i a \u014chi\u0101nia" },
            { "RE", "R\u0113nio" },
            { "RU", "R\u016bhia" },
            { "RW", "R\u0101wana" },
            { "SC", "Heihere" },
            { "SD", "H\u016bt\u0101ne" },
            { "SE", "Hu\u012btene" },
            { "SH", "Hato Har\u012bna" },
            { "SJ", "Heop\u0101ra me Ia Maiana" },
            { "SL", "Te Araone" },
            { "SN", "Henekara" },
            { "SO", "H\u016bm\u0101rie" },
            { "SR", "Hurin\u0101me" },
            { "SS", "H\u016bt\u0101ne ki te Tonga" },
            { "ST", "Hao Tomei me Pirinipei" },
            { "SV", "Ere H\u0101what\u014d" },
            { "SX", "Hiti M\u0101tene" },
            { "SZ", "Ewatini" },
            { "TC", "T\u0101ke me ng\u0101 Motu o Keiko" },
            { "TD", "K\u0101ta" },
            { "TF", "Ng\u0101 Rohe o W\u012bw\u012b ki te Tonga" },
            { "TG", "Toko" },
            { "TN", "T\u016bnihia" },
            { "TT", "Tinit\u0101t\u0101 me Top\u0113ko" },
            { "TZ", "T\u0101nahia" },
            { "UG", "Uk\u0101na" },
            { "UN", "Te Kotahitanga o Ng\u0101 Iwi o te Ao" },
            { "US", "Hononga o Amerika" },
            { "UY", "Urukoi" },
            { "VC", "Hato Wetene me Keret\u012bni" },
            { "VE", "Weneh\u016bera" },
            { "VG", "Ng\u0101 Motu o T\u0101t\u0101hou Piritene" },
            { "VI", "Ng\u0101 Motu o T\u0101t\u0101hou Amerika" },
            { "XA", "T\u016breo Kimikimi" },
            { "XB", "Piri Kimikimi" },
            { "YT", "Maio" },
            { "ZA", "\u0100wherika ki te Tonga" },
            { "ZM", "T\u0101mipia" },
            { "ZW", "Timuwawe" },
            { "ZZ", "Rohe T\u0113 M\u014dhiotia" },
            { "ab", "Apak\u0101hiana" },
            { "af", "Awherik\u0101na" },
            { "ak", "\u0100kana" },
            { "am", "Amahereka" },
            { "an", "Arakonihi" },
            { "ar", "\u0100rapi" },
            { "as", "\u0100ham\u0113hi" },
            { "av", "\u0100wh\u0101riki" },
            { "ay", "Aim\u0101ra" },
            { "az", "Ahapah\u0101na" },
            { "ba", "P\u0101kira" },
            { "be", "Perar\u016bhiana" },
            { "bg", "Puk\u0113riana" },
            { "bi", "Pihir\u0101ma" },
            { "bm", "P\u0101para" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Peretana" },
            { "bs", "P\u014dngiana" },
            { "ca", "Katarana" },
            { "ce", "Tietiene" },
            { "ch", "Tiamoro" },
            { "co", "Kohikana" },
            { "cs", "Tiekerow\u0101kiana" },
            { "cv", "Tiuwh\u0101" },
            { "cy", "Werehi" },
            { "da", "Teina" },
            { "de", "Tiamana" },
            { "dv", "Tewhe" },
            { "dz", "Tonoka" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Ingarihi" },
            { "eo", "Eheper\u0101to" },
            { "es", "P\u0101niora" },
            { "et", "Ehet\u014dniana" },
            { "eu", "P\u0101ka" },
            { "fa", "P\u0101hiana" },
            { "ff", "Whar\u0101" },
            { "fi", "Whinir\u0101nia" },
            { "fj", "Wh\u012bt\u012bana" },
            { "fo", "Wharo\u012bhi" },
            { "fr", metaValue_FR },
            { "fy", "Whir\u012bhiana ki te Uru" },
            { "ga", "Airihi" },
            { "gd", "Kotimana Keiriki" },
            { "gl", "Kar\u012bhia" },
            { "gn", "Kuaran\u012b" },
            { "gu", metaValue_gu },
            { "gv", "Manaki" },
            { "ha", "Hauha" },
            { "he", metaValue_he },
            { "hi", "H\u012bni" },
            { "hr", "Koro\u0101tiana" },
            { "ht", "Haitiana Kereo" },
            { "hu", "Hanakariana" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Inar\u012bngua" },
            { "id", "Initon\u012bhiana" },
            { "ig", "Ingo" },
            { "ii", "H\u012bhuana E\u012b" },
            { "io", "\u012ato" },
            { "is", "Tiorangiana" },
            { "it", "It\u0101riana" },
            { "iu", "Inukitet\u016b" },
            { "ja", metaValue_ja },
            { "jv", "H\u0101whanihi" },
            { "ka", metaValue_ka },
            { "ki", "Kikiu" },
            { "kj", "Kuini\u0101ma" },
            { "kk", "Kah\u0101ka" },
            { "kl", "Kar\u0101rihutu" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kahimiri" },
            { "ku", "K\u016brihi" },
            { "kv", "Komi" },
            { "kw", "K\u014dnihi" },
            { "ky", "K\u0113kete" },
            { "la", "R\u0101tini" },
            { "lb", "Rakimip\u0113kihi" },
            { "lg", "Kan\u0101ta" },
            { "li", "Rip\u0113kuehe" },
            { "ln", "Ringar\u0101" },
            { "lo", metaValue_lo },
            { "lt", "Rihuainiana" },
            { "lu", "Rupa Katanga" },
            { "lv", "R\u0101tiana" },
            { "mg", "Marak\u0101hi" },
            { "mh", "Marar\u012bhi" },
            { "mi", "M\u0101ori" },
            { "mk", "Makat\u014dniana" },
            { "ml", "Mareiarama" },
            { "mn", metaValue_mn },
            { "mr", "Marati" },
            { "ms", "Marei" },
            { "mt", "M\u014dt\u012bhi" },
            { "my", "P\u016bm\u012bh\u012b" },
            { "na", "Nauru" },
            { "nb", "Pakam\u014d N\u014dw\u012btiana" },
            { "nd", "Enetep\u0113ra ki te Raki" },
            { "ne", "Nepari" },
            { "ng", "Nat\u014dka" },
            { "nl", "Tati" },
            { "nn", "N\u012bn\u014dka N\u014dw\u012btiana" },
            { "no", "N\u014dw\u012btiana" },
            { "nr", "Enetep\u0113ra ki te Tonga" },
            { "nv", "Nawah\u014d" },
            { "ny", "N\u0101nia" },
            { "oc", "\u014ckitana" },
            { "om", "\u014cromo" },
            { "or", "\u014ctia" },
            { "os", "\u014ct\u012btiki" },
            { "pa", "Punutapi" },
            { "pl", "P\u014dr\u012bhi" },
            { "ps", "P\u0101tio" },
            { "pt", "P\u014dtuk\u012bhi" },
            { "qu", "K\u0113tua" },
            { "rm", "Rom\u0101nihi" },
            { "rn", "R\u016bniti" },
            { "ro", "Rom\u0113niana" },
            { "ru", "Ruhiana" },
            { "rw", "Kiniaw\u0101na" },
            { "sa", "Hanahiti" },
            { "sc", "H\u0101t\u012briana" },
            { "sd", "Hiniti" },
            { "se", "Hami ki te Raki" },
            { "sg", "H\u0101ngo" },
            { "si", "Hinih\u0101ra" },
            { "sk", "Horow\u0101kia" },
            { "sl", "Horow\u0113niana" },
            { "sm", "H\u0101moa" },
            { "sn", "H\u014dna" },
            { "so", "Ham\u0101ri" },
            { "sq", "Arapeiniana" },
            { "sr", "H\u0113piana" },
            { "ss", "W\u0101ti" },
            { "st", "H\u014dto ki te Tonga" },
            { "su", "Hunan\u012bhi" },
            { "sv", "Hu\u012bteneana" },
            { "sw", "W\u0101h\u012bri" },
            { "ta", "Tamira" },
            { "te", metaValue_te },
            { "tg", "T\u0101hiki" },
            { "th", metaValue_th },
            { "ti", "Tekirina" },
            { "tk", "T\u0101kamana" },
            { "tn", "Haw\u0101na" },
            { "to", "Tonga" },
            { "tr", "T\u0101kei" },
            { "ts", "Honga" },
            { "tt", "Tat\u0101" },
            { "ty", "Tahiti" },
            { "ug", "W\u012bkura" },
            { "uk", "Ukarainiana" },
            { "ur", "\u016aru" },
            { "uz", "\u016apeke" },
            { "ve", "Wen\u0113ra" },
            { "vi", "Witin\u0101miana" },
            { "wa", "War\u016bna" },
            { "wo", "Warawhe" },
            { "xh", "T\u014dha" },
            { "yi", "Irihi" },
            { "yo", "\u014cr\u016bpa" },
            { "zh", "Hainamana" },
            { "zu", "T\u016bru" },
            { "ace", "Akan\u012bhi" },
            { "ada", "Atanga" },
            { "ady", "\u0100teke" },
            { "agq", "\u0100keme" },
            { "ain", "Ainu" },
            { "ale", "Ariuta" },
            { "alt", "\u0100tai ki te Tonga" },
            { "ann", "\u014cporo" },
            { "anp", "Anahika" },
            { "arn", "Map\u016bte" },
            { "arp", "Arapaho" },
            { "ars", "Arapika Nah\u0101ri" },
            { "asa", "Ahu" },
            { "ast", "Ahit\u016briana" },
            { "atj", "Atikameke" },
            { "awa", "\u0100wati" },
            { "ban", "P\u0101rin\u012bhi" },
            { "bas", "Pah\u0101" },
            { "bem", "Pema" },
            { "bez", "Pena" },
            { "bho", "P\u014dhipuri" },
            { "bin", "Pini" },
            { "bla", "Hihika" },
            { "brx", "P\u014dto" },
            { "bug", "Puken\u012bhi" },
            { "byn", "Pirina" },
            { "cay", "Keiuka" },
            { "ccp", metaValue_ccp },
            { "ceb", "Hepuano" },
            { "cgg", "Tieka" },
            { "chk", "Tiuk\u012bhi" },
            { "chm", "Mari" },
            { "cho", "Tiokat\u014d" },
            { "chp", "Tipiwaiana" },
            { "chr", "Tierok\u012b" },
            { "chy", "Haiene" },
            { "ckb", "Te Puku o K\u016brihi" },
            { "clc", "Tiekautini" },
            { "crg", "M\u012btiwhi" },
            { "crj", "Kir\u012b Tonga-m\u0101-R\u0101whiti" },
            { "crk", "Parana Kir\u012b" },
            { "crl", "Kir\u012b Raki-m\u0101-R\u0101whiti" },
            { "crm", "M\u016b Kiri" },
            { "crr", "Arak\u014dkiana Kararaina" },
            { "csw", "W\u0101pi Kir\u012b" },
            { "dak", "Teik\u014dta" },
            { "dar", "T\u0101kawa" },
            { "dav", "Taita" },
            { "dgr", "T\u014dkiripi" },
            { "dje", "T\u0101ma" },
            { "doi", "T\u014dkiri" },
            { "dsb", "H\u014dpiana \u014cpaki" },
            { "dua", "Tu\u0101ra" },
            { "dyo", "Hora-Wh\u014dni" },
            { "dzg", "T\u0101haka" },
            { "ebu", "Emep\u016b" },
            { "efi", "Ewhiki" },
            { "eka", "Ekatika" },
            { "ewo", "Ew\u0101to" },
            { "fil", "Pirip\u012bno" },
            { "fon", "Wh\u0101na" },
            { "frc", "W\u012bw\u012b Keihana" },
            { "frr", "Whir\u012bhiana ki te Raki" },
            { "fur", "Whiri\u016briana" },
            { "gaa", "K\u0101" },
            { "gez", "K\u012bhi" },
            { "gil", "Kiripat\u012bhi" },
            { "gor", "Kor\u014dtaro" },
            { "gsw", "Tiamana Huiterangi" },
            { "guz", "K\u016bh\u012b" },
            { "gwi", "Ku\u012bti" },
            { "hai", "Haira" },
            { "haw", "Hawaiana" },
            { "hax", "Haira ki te Tonga" },
            { "hil", "Hirikeino" },
            { "hmn", "M\u014dnga" },
            { "hsb", "H\u014dpiana \u014ckawa" },
            { "hup", "Hupa" },
            { "hur", "Hekomerema" },
            { "iba", "\u012apana" },
            { "ibb", "Ip\u012bpio" },
            { "ikt", "Inukitet\u016b K\u0101nata ki te Uru" },
            { "ilo", "Iroko" },
            { "inh", "Inguihi" },
            { "jbo", "R\u014dp\u0101na" },
            { "jgo", "Nak\u014dma" },
            { "jmc", "M\u0101kame" },
            { "kab", "Kap\u0101io" },
            { "kac", "K\u0101tiana" },
            { "kaj", "Hiu" },
            { "kam", "K\u0101mapa" },
            { "kbd", "Kap\u0101riana" },
            { "kcg", "Tiapa" },
            { "kde", "Makonote" },
            { "kea", "Kapuw\u0113tianu" },
            { "kfo", "Koro" },
            { "kgp", "Keing\u0101na" },
            { "kha", "Kahi" },
            { "khq", "K\u014dia T\u012bni" },
            { "kkj", "Kako" },
            { "kln", "Karenini" },
            { "kmb", "Kimipunu" },
            { "kok", "K\u014dkani" },
            { "kpe", "Kepere" },
            { "krc", "Karatai-P\u0101ka" },
            { "krl", "Kareriana" },
            { "kru", "Kur\u0101" },
            { "ksb", "Hap\u0101ra" },
            { "ksf", "P\u0101whia" },
            { "ksh", "Kor\u014dniana" },
            { "kum", "Kumiki" },
            { "kwk", "Kuakawara" },
            { "lad", "Ratino" },
            { "lag", "Rangi" },
            { "lez", "R\u0113hiana" },
            { "lil", "Rir\u016bete" },
            { "lkt", "Rakota" },
            { "lou", "Ru\u012bhana Kereo" },
            { "loz", "Rauhi" },
            { "lrc", "Ruri ki te Raki" },
            { "lsm", "H\u0101mia" },
            { "lua", "Rupa Rurua" },
            { "lun", "Runa" },
            { "luo", "Ruo" },
            { "lus", "M\u012bho" },
            { "luy", "R\u016bia" },
            { "mad", "Matuir\u012bhi" },
            { "mag", "Mak\u0101hi" },
            { "mai", "Maitiri" },
            { "mak", "Makah\u0101" },
            { "mas", "M\u0101hai" },
            { "mdf", "M\u014dkaha" },
            { "men", "Men\u0113te" },
            { "mer", "Meru" },
            { "mfe", "Morihiene" },
            { "mgh", "Makuwa-M\u0113to" },
            { "mgo", "Meta" },
            { "mic", "M\u012bkam\u0101" },
            { "min", "Min\u0101kapao" },
            { "mni", "Manipuri" },
            { "moe", "Inu-aimuna" },
            { "moh", "Mauh\u014dka" },
            { "mos", "Moh\u012b" },
            { "mua", "M\u016btanga" },
            { "mul", "Ng\u0101 reo maha" },
            { "mus", "Muk\u014dki" },
            { "mwl", "Miranat\u012bhi" },
            { "myv", "Ereh\u012ba" },
            { "mzn", "Mahaterani" },
            { "nap", "Neaporitana" },
            { "naq", "Nama" },
            { "nds", "Tiamana \u014cpaki" },
            { "new", "Newari" },
            { "nia", "Ni\u0113he" },
            { "niu", "Niueana" },
            { "nmg", "Kuatio" },
            { "nnh", "Nekeip\u016b" },
            { "nog", "N\u014dkai" },
            { "nqo", metaValue_nqo },
            { "nso", "Hoto ki te Raki" },
            { "nus", "Nua" },
            { "nyn", "N\u0101nakore" },
            { "ojb", "\u014ct\u012bpia Raki-m\u0101-Uru" },
            { "ojc", "Te Puku o \u014chiwa" },
            { "ojs", "\u014cti-Kir\u012b" },
            { "ojw", "\u014ch\u012bpiwa ki te Uru" },
            { "oka", "\u014ckanakana" },
            { "pag", "P\u0101ngahina" },
            { "pam", "Pamapaka" },
            { "pap", "Papiam\u0113to" },
            { "pau", "Parauna" },
            { "pcm", "Ng\u0101itiriana K\u014drapurapu" },
            { "pis", "P\u012btini" },
            { "pqm", "Marahiti-Pehamakoare" },
            { "rap", "Rapanui" },
            { "rar", "Rarotonga" },
            { "rhg", "Rohingia" },
            { "rof", "Romopo" },
            { "rup", "Aromeiniana" },
            { "rwk", "Rawa" },
            { "sad", "H\u0101tawe" },
            { "sah", "Hak\u0101" },
            { "saq", "H\u0101puru" },
            { "sat", "H\u0101tari" },
            { "sba", "Nek\u0101pei" },
            { "sbp", "H\u0101ngu" },
            { "scn", "Hihiriana" },
            { "sco", "Kotimana" },
            { "seh", "Hena" },
            { "ses", "K\u014diaporo Heni" },
            { "shi", "Tahere" },
            { "shn", "H\u0101na" },
            { "slh", "Rat\u016bti ki te Tonga" },
            { "smn", "Inari Hami" },
            { "sms", "Hakoto H\u0101mi" },
            { "snk", "Hon\u012bke" },
            { "srn", "Har\u0101na Tongo" },
            { "str", "Terete H\u0101rihi" },
            { "suk", "Hukuma" },
            { "swb", "Kom\u014driana" },
            { "syr", metaValue_syr },
            { "tce", "Tat\u014dne ki te Tonga" },
            { "tem", "T\u012bmene" },
            { "teo", "Teho" },
            { "tet", "Tetumu" },
            { "tgx", "T\u0113kihi" },
            { "tht", "T\u0101tana" },
            { "tig", "T\u012bkara" },
            { "tlh", "Kirionga" },
            { "tli", "Tir\u012bkiti" },
            { "tok", "Toki Pona" },
            { "tpi", "Toko P\u012bhini" },
            { "trv", "Taroko" },
            { "ttm", "T\u016btone ki te Raki" },
            { "tum", "T\u016bmuka" },
            { "tvl", "Tuwaru" },
            { "twq", "Tahawaka" },
            { "tyv", "Tuw\u012bniana" },
            { "tzm", "Te Puku o Atarihi Tamah\u0113te" },
            { "udm", "\u016amutu" },
            { "umb", "\u016apunu" },
            { "und", "Reo T\u0113 M\u014dhiotia" },
            { "vai", metaValue_vai },
            { "vun", "W\u0101hau" },
            { "wae", "W\u0101here" },
            { "wal", "Wareita" },
            { "war", "Warei" },
            { "wuu", "Hainamana W\u016b" },
            { "xal", "Karamiki" },
            { "xog", "Hoka" },
            { "yav", "Angapene" },
            { "ybb", "Emapa" },
            { "yrl", "N\u012bk\u0101t\u016b" },
            { "yue", "Katon\u012bhi" },
            { "zgh", "Moroko Tamatai" },
            { "zun", "Tuni" },
            { "zxx", "Wetereo kiko kore" },
            { "zza", "T\u0101t\u0101" },
            { "Adlm", "Ar\u0101ma" },
            { "Arab", "Arapika" },
            { "Aran", "Nat\u0101rika" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "Papamawha" },
            { "Brai", "Tuhi Matap\u014d" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Ng\u0101 Tohu o te reo o ng\u0101 iwi Taketake o K\u0101nata kua paiheretia" },
            { "Cher", "Terok\u012b" },
            { "Cyrl", "H\u012bririki" },
            { "Deva", "Tewhang\u0101ngari" },
            { "Ethi", "Etiopika" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "K\u016bmuki" },
            { "Hanb", "Hana me te Papamawha" },
            { "Hang", "H\u0101ng\u016b" },
            { "Hani", "Hana" },
            { "Hans", "M\u0101m\u0101" },
            { "Hant", "Tuku iho" },
            { "Hebr", metaValue_he },
            { "Hira", "Hirakana" },
            { "Hrkt", "Tohu Hapanihi" },
            { "Jamo", "Hamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "Katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "R\u0101tina" },
            { "Mlym", "Maramara" },
            { "Mong", metaValue_mn },
            { "Mtei", "Meitei Maeke" },
            { "Mymr", "Mienem\u0101" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "\u014ctiki" },
            { "Orya", "Otia" },
            { "Rohg", "H\u0101niwhi" },
            { "Sinh", "Hin\u0101ra" },
            { "Sund", "Hunanihi" },
            { "Syrc", metaValue_syr },
            { "Taml", "Tamiera" },
            { "Telu", metaValue_te },
            { "Tfng", "Tiwhin\u0101" },
            { "Thaa", "T\u0101na" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "Ei" },
            { "Zmth", "Reo Tohu P\u0101ngarau" },
            { "Zsye", "Emohi" },
            { "Zsym", "Tohu" },
            { "Zxxx", "Tuhikore" },
            { "Zyyy", "Komona" },
            { "Zzzz", "Momotuhi T\u0113 M\u014dhiotia" },
            { "de_AT", "Tiamana Ateriana" },
            { "de_CH", "Tiamana \u014ckawa Huiterangi" },
            { "en_AU", "Ingarihi Ahitereiriana" },
            { "en_CA", "Ingarihi K\u0101nata" },
            { "en_GB", "Ingarihi Piritene" },
            { "en_US", "Ingarihi Amerikana" },
            { "es_ES", "P\u0101niora \u016aropi" },
            { "es_MX", "P\u0101niora Mehikana" },
            { "fa_AF", "Tari" },
            { "fr_CA", "W\u012bw\u012b K\u0101nata" },
            { "fr_CH", "W\u012bw\u012b Huiterangi" },
            { "nl_BE", "Tati Wh\u0113mirihi" },
            { "pt_BR", "P\u014dtuk\u012bhi Parahi" },
            { "pt_PT", "P\u014dtuk\u012bhi Uropi" },
            { "ar_001", "\u0100rapi Moroki" },
            { "es_419", "P\u0101niora Amerikana ki te Tonga" },
            { "zh_Hans", "Hainamana M\u0101m\u0101" },
            { "zh_Hant", "Hainamana Tukuiho" },
            { "type.nu.latn", "Ng\u0101 Mati P\u0101keh\u0101" },
            { "type.co.standard", "Raupapa K\u014dmaka Arowh\u0101nui" },
            { "type.ca.gregorian", "Maramataka P\u0101keh\u0101" },
        };
        return data;
    }
}
