/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ta extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "\u0b85\u0bb5\u0bc6\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd";
        final String metaValue_ar = "\u0b85\u0bb0\u0baa\u0bbf\u0b95\u0bcd";
        final String metaValue_bn = "\u0bb5\u0b99\u0bcd\u0b95\u0bbe\u0bb3\u0bae\u0bcd";
        final String metaValue_bo = "\u0ba4\u0bbf\u0baa\u0bc6\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd";
        final String metaValue_el = "\u0b95\u0bbf\u0bb0\u0bc7\u0b95\u0bcd\u0b95\u0bae\u0bcd";
        final String metaValue_gu = "\u0b95\u0bc1\u0b9c\u0bb0\u0bbe\u0ba4\u0bcd\u0ba4\u0bbf";
        final String metaValue_ja = "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0baf\u0bae\u0bcd";
        final String metaValue_jv = "\u0b9c\u0bbe\u0bb5\u0ba9\u0bc0\u0bb8\u0bcd";
        final String metaValue_ka = "\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0ba9\u0bcd";
        final String metaValue_kn = "\u0b95\u0ba9\u0bcd\u0ba9\u0b9f\u0bae\u0bcd";
        final String metaValue_ko = "\u0b95\u0bca\u0bb0\u0bbf\u0baf\u0ba9\u0bcd";
        final String metaValue_la = "\u0bb2\u0ba4\u0bcd\u0ba4\u0bbf\u0ba9\u0bcd";
        final String metaValue_lo = "\u0bb2\u0bbe\u0bb5\u0bcb";
        final String metaValue_ml = "\u0bae\u0bb2\u0bc8\u0baf\u0bbe\u0bb3\u0bae\u0bcd";
        final String metaValue_mn = "\u0bae\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbf\u0baf\u0ba9\u0bcd";
        final String metaValue_or = "\u0b92\u0b9f\u0bbf\u0baf\u0bbe";
        final String metaValue_si = "\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0bb3\u0bae\u0bcd";
        final String metaValue_ta = "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd";
        final String metaValue_te = "\u0ba4\u0bc6\u0bb2\u0bc1\u0b99\u0bcd\u0b95\u0bc1";
        final String metaValue_th = "\u0ba4\u0bbe\u0baf\u0bcd";
        final String metaValue_bug = "\u0baa\u0bc1\u0b95\u0bbf\u0ba9\u0bc0\u0bb8\u0bcd";
        final String metaValue_cop = "\u0b95\u0bbe\u0baa\u0bcd\u0b9f\u0bbf\u0b95\u0bcd";
        final String metaValue_got = "\u0b95\u0bcb\u0ba4\u0bbf\u0b95\u0bcd";
        final String metaValue_nqo = "\u0b8e\u0ba9\u0bcd\u2018\u0b95\u0bcb";
        final String metaValue_peo = "\u0baa\u0bb4\u0bc8\u0baf \u0baa\u0bc6\u0bb0\u0bcd\u0bb7\u0bbf\u0baf\u0ba9\u0bcd";
        final String metaValue_syr = "\u0b9a\u0bbf\u0bb0\u0bbf\u0baf\u0bbe\u0b95\u0bcd";
        final String metaValue_vai = "\u0bb5\u0bc8";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0b95\u0bca\u0bb2\u0bcb\u0b95\u0bcd\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Ogam", "\u0b92\u0b95\u0bbe\u0bae\u0bcd" },
            { "mwl", "\u0bae\u0bbf\u0bb0\u0bbe\u0ba9\u0bcd\u0b9f\u0bc0\u0bb8\u0bcd" },
            { "Zsym", "\u0b9a\u0bbf\u0ba9\u0bcd\u0ba9\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "cch", "\u0b86\u0b9f\u0bcd\u0b9a\u0bae\u0bcd" },
            { "mwr", "\u0bae\u0bbe\u0bb0\u0bcd\u0bb5\u0bbe\u0bb0\u0bbf" },
            { "Tagb", "\u0ba4\u0b95\u0bcb\u0bb5\u0bbe\u0ba9\u0bbe" },
            { "Zsye", "\u0b8e\u0bae\u0bcb\u0b9c\u0bbf" },
            { "egy", "\u0baa\u0ba3\u0bcd\u0b9f\u0bc8\u0baf \u0b8e\u0b95\u0bbf\u0baa\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd" },
            { "raj", "\u0bb0\u0bbe\u0b9c\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bbf" },
            { "Phag", "\u0baa\u0b95\u0bcd\u0bb8\u0bcd-\u0baa\u0bbe" },
            { "tem", "\u0b9f\u0bbf\u0bae\u0bcd\u0ba9\u0bc7" },
            { "teo", "\u0b9f\u0bc6\u0b9a\u0bcb" },
            { "rap", "\u0bb0\u0baa\u0ba9\u0bc1\u0baf\u0bcd" },
            { "ter", "\u0b9f\u0bc6\u0bb0\u0bc6\u0ba9\u0bcb" },
            { "AC", "\u0b85\u0bb7\u0ba9\u0bcd\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1" },
            { "rar", "\u0bb0\u0bb0\u0bcb\u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0ba9\u0bcd" },
            { "tet", "\u0b9f\u0bc6\u0b9f\u0bc1\u0bae\u0bcd" },
            { "AD", "\u0b85\u0ba9\u0bcd\u0b9f\u0bcb\u0bb0\u0bbe" },
            { "AE", "\u0b90\u0b95\u0bcd\u0b95\u0bbf\u0baf \u0b85\u0bb0\u0baa\u0bc1 \u0b8e\u0bae\u0bbf\u0bb0\u0bc7\u0b9f\u0bcd\u0bb8\u0bcd" },
            { "nl_BE", "\u0b83\u0baa\u0bcd\u0bb2\u0bc6\u0bae\u0bbf\u0bb7\u0bcd" },
            { "AF", "\u0b86\u0baa\u0bcd\u0b95\u0bbe\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd" },
            { "AG", "\u0b86\u0ba3\u0bcd\u0b9f\u0bbf\u0b95\u0bc1\u0bb5\u0bbe \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0baa\u0bbe\u0bb0\u0bcd\u0baa\u0bc1\u0b9f\u0bbe" },
            { "type.ca.ethiopic", "\u0b8e\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0b95\u0bcd \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "AI", "\u0b85\u0b99\u0bcd\u0b95\u0bc1\u0baf\u0bcd\u0bb2\u0bbe" },
            { "key.tz", "\u0ba8\u0bc7\u0bb0 \u0bae\u0ba3\u0bcd\u0b9f\u0bb2\u0bae\u0bcd" },
            { "AL", "\u0b85\u0bb2\u0bcd\u0baa\u0bc7\u0ba9\u0bbf\u0baf\u0bbe" },
            { "AM", "\u0b85\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0bbe" },
            { "Teng", "\u0ba4\u0bc6\u0b99\u0bcd\u0bb5\u0bbe\u0bb0\u0bcd" },
            { "AO", "\u0b85\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbe" },
            { "AQ", "\u0b85\u0ba3\u0bcd\u0b9f\u0bbe\u0bb0\u0bcd\u0b9f\u0bbf\u0b95\u0bbe" },
            { "AR", "\u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe" },
            { "Prti", "\u0b87\u0ba9\u0bcd\u0bb8\u0bcd\u0b95\u0bbf\u0bb0\u0bbf\u0baa\u0bcd\u0bb7\u0ba9\u0bb2\u0bcd \u0baa\u0bbe\u0bb0\u0bcd\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd" },
            { "AS", "\u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0b9a\u0bae\u0bcb\u0bb5\u0bbe" },
            { "AT", "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bbf\u0baf\u0bbe" },
            { "AU", "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0bbe" },
            { "AW", "\u0b85\u0bb0\u0bc2\u0baa\u0bbe" },
            { "en_US", "\u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0b86\u0b99\u0bcd\u0b95\u0bbf\u0bb2\u0bae\u0bcd" },
            { "AX", "\u0b86\u0bb2\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "AZ", "\u0b85\u0b9a\u0bb0\u0bcd\u0baa\u0bc8\u0b9c\u0bbe\u0ba9\u0bcd" },
            { "BA", "\u0baa\u0bcb\u0bb8\u0bcd\u0ba9\u0bbf\u0baf\u0bbe & \u0bb9\u0bc6\u0bb0\u0bcd\u0bb8\u0b95\u0bcb\u0bb5\u0bbf\u0ba9\u0bbe" },
            { "BB", "\u0baa\u0bbe\u0bb0\u0bcd\u0baa\u0b9f\u0bcb\u0bb8\u0bcd" },
            { "ceb", "\u0b9a\u0bc6\u0baa\u0bc1\u0bb5\u0bbe\u0ba9\u0bcb" },
            { "BD", "\u0baa\u0b99\u0bcd\u0b95\u0bb3\u0bbe\u0ba4\u0bc7\u0bb7\u0bcd" },
            { "kum", "\u0b95\u0bc1\u0bae\u0bcd\u0b87\u0b95\u0bcd" },
            { "BE", "\u0baa\u0bc6\u0bb2\u0bcd\u0b9c\u0bbf\u0baf\u0bae\u0bcd" },
            { "gmh", "\u0bae\u0bbf\u0b9f\u0bbf\u0bb2\u0bcd \u0bb9\u0bc8 \u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd" },
            { "BF", "\u0baa\u0bc1\u0bb0\u0bcd\u0b95\u0bbf\u0ba9\u0bbe \u0b83\u0baa\u0bbe\u0bb8\u0bcb" },
            { "BG", "\u0baa\u0bb2\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0bbe" },
            { "BH", "\u0baa\u0bb9\u0bcd\u0bb0\u0bc8\u0ba9\u0bcd" },
            { "BI", "\u0baa\u0bc1\u0bb0\u0bc1\u0ba3\u0bcd\u0b9f\u0bbf" },
            { "BJ", "\u0baa\u0bc6\u0ba9\u0bbf\u0ba9\u0bcd" },
            { "BL", "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0baa\u0bbe\u0bb0\u0bcd\u0ba4\u0bc7\u0bb2\u0bc6\u0bae\u0bbf" },
            { "BM", "\u0baa\u0bc6\u0bb0\u0bcd\u0bae\u0bc1\u0b9f\u0bbe" },
            { "kut", "\u0b95\u0bc1\u0b9f\u0bc7\u0ba9\u0bc8" },
            { "myv", "\u0b8f\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe" },
            { "BN", "\u0baa\u0bc1\u0bb0\u0bc1\u0ba9\u0bc7" },
            { "BO", "\u0baa\u0bca\u0bb2\u0bbf\u0bb5\u0bbf\u0baf\u0bbe" },
            { "BQ", "\u0b95\u0bb0\u0bc0\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bc6\u0ba4\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "BR", "\u0baa\u0bbf\u0bb0\u0bc7\u0b9a\u0bbf\u0bb2\u0bcd" },
            { "BS", "\u0baa\u0bb9\u0bbe\u0bae\u0bbe\u0bb8\u0bcd" },
            { "xog", "\u0b9a\u0bcb\u0b95\u0bbe" },
            { "BT", "\u0baa\u0bc2\u0b9f\u0bbe\u0ba9\u0bcd" },
            { "BV", "\u0baa\u0bca\u0bb5\u0bc7\u0b9f\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "BW", "\u0baa\u0bcb\u0b9f\u0bcd\u0bb8\u0bcd\u0bb5\u0bbe\u0ba9\u0bbe" },
            { "BY", "\u0baa\u0bc6\u0bb2\u0bbe\u0bb0\u0bc2\u0bb8\u0bcd" },
            { "BZ", "\u0baa\u0bc6\u0bb2\u0bbf\u0bb8\u0bcd" },
            { "Visp", "\u0bb5\u0bbf\u0b9a\u0bbf\u0baa\u0bbf\u0bb3\u0bcd \u0bb8\u0bcd\u0baa\u0bc0\u0b9a\u0bcd" },
            { "type.ca.persian", "\u0baa\u0bc6\u0bb0\u0bcd\u0b9a\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "type.nu.hebr", "\u0bb9\u0bc0\u0baa\u0bcd\u0bb0\u0bc1 \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "CA", "\u0b95\u0ba9\u0b9f\u0bbe" },
            { "CC", "\u0b95\u0bcb\u0b95\u0bcb\u0bb8\u0bcd (\u0b95\u0bc0\u0bb2\u0bbf\u0b99\u0bcd) \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "mzn", "\u0bae\u0b9a\u0ba8\u0bcd\u0ba4\u0bc7\u0bb0\u0ba9\u0bbf" },
            { "CD", "\u0b95\u0bbe\u0b99\u0bcd\u0b95\u0bcb - \u0b95\u0bbf\u0ba9\u0bcd\u0bb7\u0bbe\u0b9a\u0bbe" },
            { "CF", "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0b95\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1" },
            { "CG", "\u0b95\u0bbe\u0b99\u0bcd\u0b95\u0bcb - \u0baa\u0bcd\u0bb0\u0bbe\u0bb8\u0bbe\u0bb5\u0bbf\u0bb2\u0bcd\u0bb2\u0bc7" },
            { "CH", "\u0bb8\u0bcd\u0bb5\u0bbf\u0b9f\u0bcd\u0b9a\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "CI", "\u0b95\u0bcb\u0b9f\u0bcd \u0ba4\u0bbf\u2019\u0bb5\u0bbe\u0baf\u0bb0\u0bcd" },
            { "CK", "\u0b95\u0bc1\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "CL", "\u0b9a\u0bbf\u0bb2\u0bbf" },
            { "Kthi", "\u0b95\u0bbe\u0baf\u0bcd\u0ba4\u0bbf" },
            { "CM", "\u0b95\u0bc7\u0bae\u0bb0\u0bc2\u0ba9\u0bcd" },
            { "CN", "\u0b9a\u0bc0\u0ba9\u0bbe" },
            { "CO", "\u0b95\u0bca\u0bb2\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe" },
            { "CP", "\u0b95\u0bbf\u0bb2\u0bbf\u0baa\u0bcd\u0baa\u0bb0\u0bcd\u0b9f\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1" },
            { "CR", "\u0b95\u0bcb\u0bb8\u0bcd\u0b9f\u0bbe\u0bb0\u0bbf\u0b95\u0bbe" },
            { "CU", "\u0b95\u0bbf\u0baf\u0bc2\u0baa\u0bbe" },
            { "CV", "\u0b95\u0bc7\u0baa\u0bcd \u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bc7" },
            { "CW", "\u0b95\u0bc1\u0bb0\u0bbe\u0b95\u0bb5\u0bcd" },
            { "CX", "\u0b95\u0bbf\u0bb1\u0bbf\u0bb8\u0bcd\u0ba4\u0bc1\u0bae\u0bb8\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1" },
            { "CY", "\u0b9a\u0bc8\u0baa\u0bcd\u0bb0\u0bb8\u0bcd" },
            { "CZ", "\u0b9a\u0bc6\u0b9a\u0bbf\u0baf\u0bbe" },
            { "eka", "\u0b88\u0b95\u0bbe\u0b9c\u0bc1\u0b95\u0bcd" },
            { "DE", "\u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bbf" },
            { "goh", "\u0baa\u0bb4\u0bc8\u0baf \u0bb9\u0bc8 \u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd" },
            { "ace", "\u0b86\u0b9a\u0bcd\u0b9a\u0bbf\u0ba9\u0bc0\u0bb8\u0bcd" },
            { "cgg", "\u0b9a\u0bbf\u0b95\u0bbe" },
            { "DG", "\u0b9f\u0bbf\u0baf\u0b95\u0bcb \u0b95\u0bbe\u0bb0\u0bcd\u0bb7\u0bbf\u0baf\u0bbe" },
            { "type.nu.deva", "\u0ba4\u0bc7\u0bb5\u0ba8\u0bbe\u0b95\u0bb0\u0bbf \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "DJ", "\u0b9c\u0bbf\u0baa\u0bcc\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "DK", "\u0b9f\u0bc6\u0ba9\u0bcd\u0bae\u0bbe\u0bb0\u0bcd\u0b95\u0bcd" },
            { "ach", "\u0b85\u0b95\u0bcb\u0bb2\u0bbf" },
            { "gon", "\u0b95\u0bcb\u0ba9\u0bcd\u0b9f\u0bbf" },
            { "Brai", "\u0baa\u0bbf\u0bb0\u0bc6\u0baf\u0bbf\u0bb2\u0bcd" },
            { "Brah", "\u0baa\u0bbf\u0bb0\u0bae\u0bcd\u0bae\u0bbf" },
            { "DM", "\u0b9f\u0bca\u0bae\u0bbf\u0ba9\u0bbf\u0b95\u0bbe" },
            { "type.nu.armnlow", "\u0b86\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0b9a\u0bbf\u0bb1\u0bcd\u0bb1\u0bc6\u0bb4\u0bc1\u0ba4\u0bcd\u0ba4\u0bc1 \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "DO", "\u0b9f\u0bca\u0bae\u0bbf\u0ba9\u0bbf\u0b95\u0ba9\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1" },
            { "gor", "\u0b95\u0bcb\u0bb0\u0bcb\u0ba9\u0bcd\u0b9f\u0bb2\u0bcb" },
            { "got", metaValue_got },
            { "Mtei", "\u0bae\u0bc6\u0baf\u0bcd\u0ba4\u0bc6\u0baf\u0bcd \u0bae\u0baf\u0b95\u0bcd" },
            { "zun", "\u0b9c\u0bc2\u0ba9\u0bbf" },
            { "tig", "\u0b9f\u0bc8\u0b95\u0bcd\u0bb0\u0bc7" },
            { "DZ", "\u0b85\u0bb2\u0bcd\u0b9c\u0bc0\u0bb0\u0bbf\u0baf\u0bbe" },
            { "pag", "\u0baa\u0ba9\u0bcd\u0b95\u0bbe\u0b9a\u0bbf\u0ba9\u0ba9\u0bcd" },
            { "type.d0.hwidth", "\u0b85\u0bb0\u0bc8 \u0b85\u0b95\u0bb2\u0bae\u0bcd" },
            { "pal", "\u0baa\u0bbe\u0bb9\u0bcd\u0bb2\u0bb5\u0bbf" },
            { "EA", "\u0b9a\u0bbf\u0baf\u0bc2\u0b9f\u0bbe & \u0bae\u0bc6\u0bb2\u0bbf\u0bb2\u0bcd\u0bb2\u0bbe" },
            { "chb", "\u0b9a\u0bbf\u0baa\u0bcd\u0b9a\u0bbe" },
            { "pam", "\u0baa\u0bae\u0bcd\u0baa\u0bbe\u0b99\u0bcd\u0b95\u0bbe" },
            { "EC", "\u0b88\u0b95\u0bcd\u0bb5\u0b9f\u0bbe\u0bb0\u0bcd" },
            { "pap", "\u0baa\u0baa\u0bbf\u0baf\u0bbe\u0bae\u0bc6\u0ba9\u0bcd\u0b9f\u0bcb" },
            { "ada", "\u0b85\u0ba4\u0bbe\u0b99\u0bcd\u0bae\u0bc7" },
            { "EE", "\u0b8e\u0bb8\u0bcd\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe" },
            { "tiv", "\u0b9f\u0bbf\u0bb5\u0bcd" },
            { "EG", "\u0b8e\u0b95\u0bbf\u0baa\u0bcd\u0ba4\u0bc1" },
            { "EH", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bb9\u0bbe\u0bb0\u0bbe" },
            { "chg", "\u0bb7\u0b95\u0ba4\u0bc8" },
            { "pau", "\u0baa\u0bb2\u0bcc\u0bb5\u0ba9\u0bcd" },
            { "chk", "\u0b9a\u0bc2\u0b95\u0bbf\u0b9a\u0bc7" },
            { "chn", "\u0b9a\u0bbf\u0ba9\u0bc2\u0b95\u0bcd \u0b9c\u0bbe\u0bb0\u0bcd\u0b95\u0bbe\u0ba9\u0bcd" },
            { "chm", "\u0bae\u0bbe\u0bb0\u0bbf" },
            { "chp", "\u0b9a\u0bbf\u0baa\u0bc6\u0bb5\u0bcd\u0baf\u0bbe\u0ba9\u0bcd" },
            { "cho", "\u0b9a\u0bcb\u0b95\u0bcd\u0ba4\u0bcc" },
            { "chr", "\u0b9a\u0bc6\u0bb0\u0bcb\u0b95\u0bc0" },
            { "ER", "\u0b8e\u0bb0\u0bbf\u0b9f\u0bcd\u0bb0\u0bbf\u0baf\u0bbe" },
            { "ES", "\u0bb8\u0bcd\u0baa\u0bc6\u0baf\u0bbf\u0ba9\u0bcd" },
            { "ET", "\u0b8e\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf\u0bbe" },
            { "EU", "\u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0baf\u0bc2\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "elx", "\u0b8e\u0bb2\u0bae\u0bc8\u0b9f\u0bcd" },
            { "type.ca.gregorian", "\u0b95\u0bbf\u0bb0\u0bbf\u0b95\u0bcb\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "EZ", "\u0baf\u0bc2\u0bb0\u0bcb\u0b9c\u0bcb\u0ba9\u0bcd" },
            { "chy", "\u0b9a\u0bc6\u0baf\u0bc7\u0ba9\u0bbf" },
            { "type.nu.gujr", "\u0b95\u0bc1\u0b9c\u0bb0\u0bbe\u0ba4\u0bcd\u0ba4\u0bbf \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "Inds", "\u0b9a\u0bbf\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "ady", "\u0b85\u0ba4\u0b95\u0bc7" },
            { "aeb", "\u0ba4\u0bc1\u0ba9\u0bbf\u0b9a\u0bbf\u0baf \u0b85\u0bb0\u0baa\u0bc1" },
            { "FI", "\u0baa\u0bbf\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "FJ", "\u0b83\u0baa\u0bbf\u0b9c\u0bbf" },
            { "FK", "\u0b83\u0baa\u0bbe\u0b95\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "FM", "\u0bae\u0bc8\u0b95\u0bcd\u0bb0\u0bcb\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0bbe" },
            { "key.va", "\u0bae\u0bca\u0bb4\u0bbf \u0bae\u0bbe\u0bb1\u0bbf\u0bb2\u0bbf" },
            { "FO", "\u0b83\u0baa\u0bbe\u0bb0\u0bcb \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "Taml", metaValue_ta },
            { "FR", "\u0baa\u0bbf\u0bb0\u0bbe\u0ba9\u0bcd\u0bb8\u0bcd" },
            { "tkl", "\u0b9f\u0bcb\u0b95\u0bc7\u0bb2\u0bcc" },
            { "grb", "\u0b95\u0bcd\u0bb0\u0bc7\u0baa\u0bcb" },
            { "root", "\u0bb0\u0bc2\u0b9f\u0bcd" },
            { "type.ca.indian", "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf \u0ba4\u0bc7\u0b9a \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "grc", "\u0baa\u0ba3\u0bcd\u0b9f\u0bc8\u0baf \u0b95\u0bbf\u0bb0\u0bc7\u0b95\u0bcd\u0b95\u0bae\u0bcd" },
            { "GA", "\u0b95\u0bc7\u0baa\u0bbe\u0ba9\u0bcd" },
            { "vot", "\u0bb5\u0bcb\u0b9f\u0bcd\u0b95\u0bcd" },
            { "GB", "\u0baf\u0bc1\u0ba9\u0bc8\u0b9f\u0bc6\u0b9f\u0bcd \u0b95\u0bbf\u0b99\u0bcd\u0b9f\u0bae\u0bcd" },
            { "pcm", "\u0ba8\u0bc8\u0b9c\u0bc0\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0bbf\u0b9f\u0bcd\u0b95\u0bbf\u0ba9\u0bcd" },
            { "GD", "\u0b95\u0bbf\u0bb0\u0ba9\u0bc6\u0b9f\u0bbe" },
            { "GE", "\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe" },
            { "GF", "\u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1 \u0b95\u0baf\u0bbe\u0ba9\u0bbe" },
            { "GG", "\u0b95\u0bc6\u0bb0\u0bcd\u0ba9\u0bcd\u0b9a\u0bbf" },
            { "GH", "\u0b95\u0bbe\u0ba9\u0bbe" },
            { "Tale", "\u0ba4\u0bbe\u0baf\u0bcd \u0bb2\u0bc7" },
            { "GI", "\u0b9c\u0bbf\u0baa\u0bcd\u0bb0\u0bbe\u0bb2\u0bcd\u0b9f\u0bb0\u0bcd" },
            { "afh", "\u0b85\u0b83\u0baa\u0bcd\u0bb0\u0bbf\u0bb9\u0bbf\u0bb2\u0bbf" },
            { "GL", "\u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "enm", "\u0bae\u0bbf\u0b9f\u0bbf\u0bb2\u0bcd \u0b86\u0b99\u0bcd\u0b95\u0bbf\u0bb2\u0bae\u0bcd" },
            { "GM", "\u0b95\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe" },
            { "GN", "\u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe" },
            { "GP", "\u0b95\u0bcd\u0bb5\u0bbe\u0ba4\u0bc7\u0bb2\u0bcb\u0baa\u0bcd" },
            { "GQ", "\u0b88\u0b95\u0bcd\u0bb5\u0b9f\u0bcb\u0bb0\u0bbf\u0baf\u0bb2\u0bcd \u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe" },
            { "GR", "\u0b95\u0bbf\u0bb0\u0bc0\u0bb8\u0bcd" },
            { "GS", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bbe\u0ba3\u0bcd\u0b9f\u0bcd\u0bb5\u0bbf\u0b9a\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "GT", "\u0b95\u0bb5\u0bc1\u0ba4\u0bae\u0bbe\u0bb2\u0bbe" },
            { "GU", "\u0b95\u0bc1\u0bb5\u0bbe\u0bae\u0bcd" },
            { "pdc", "\u0baa\u0bc6\u0ba9\u0bcd\u0b9a\u0bbf\u0bb2\u0bcd\u0bb5\u0bc7\u0ba9\u0bbf\u0baf \u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd" },
            { "GW", "\u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe-\u0baa\u0bbf\u0bb8\u0bcd\u0bb8\u0bbe\u0bb5\u0bcd" },
            { "tli", "\u0bb2\u0bbf\u0b99\u0bcd\u0b95\u0bbf\u0b9f\u0bcd" },
            { "tlh", "\u0b95\u0bcd\u0bb3\u0bbf\u0b99\u0bcd\u0b95\u0bcb\u0ba9\u0bcd" },
            { "Talu", "\u0baa\u0bc1\u0ba4\u0bbf\u0baf \u0ba4\u0bc8 \u0bb2\u0bc2" },
            { "GY", "\u0b95\u0baf\u0bbe\u0ba9\u0bbe" },
            { "ckb", "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b95\u0bc1\u0bb0\u0bcd\u0ba4\u0bbf\u0bb7\u0bcd" },
            { "zxx", "\u0bae\u0bca\u0bb4\u0bbf \u0b89\u0bb3\u0bcd\u0bb3\u0b9f\u0b95\u0bcd\u0b95\u0bae\u0bcd \u0b8f\u0ba4\u0bc1\u0bae\u0bbf\u0bb2\u0bcd\u0bb2\u0bc8" },
            { "de_AT", "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bbf\u0baf \u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0bb9\u0bbe\u0b99\u0bcd\u0b95\u0bbe\u0b99\u0bcd \u0b8e\u0bb8\u0bcd\u0b8f\u0b86\u0bb0\u0bcd \u0b9a\u0bc0\u0ba9\u0bbe" },
            { "HM", "\u0bb9\u0bc7\u0bb0\u0bcd\u0b9f\u0bcd \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0bae\u0bc6\u0b95\u0bcd\u0b9f\u0bca\u0ba9\u0bbe\u0bb2\u0bcd\u0b9f\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "HN", "\u0bb9\u0bcb\u0ba3\u0bcd\u0b9f\u0bc2\u0bb0\u0bbe\u0bb8\u0bcd" },
            { "HR", "\u0b95\u0bc1\u0bb0\u0bc7\u0bb7\u0bbf\u0baf\u0bbe" },
            { "agq", "\u0b85\u0b95\u0bc6\u0bae\u0bcd" },
            { "gsw", "\u0bb8\u0bcd\u0bb5\u0bbf\u0bb8\u0bcd \u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd" },
            { "type.ca.islamic-umalqura", "\u0b87\u0bb8\u0bcd\u0bb2\u0bbe\u0bae\u0bbf\u0baf \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf (\u0b89\u0bae\u0bcd-\u0b85\u0bb2\u0bcd-\u0b95\u0bc1\u0bb0\u0bbe)" },
            { "HT", "\u0bb9\u0bc8\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "HU", "\u0bb9\u0b99\u0bcd\u0b95\u0bc7\u0bb0\u0bbf" },
            { "tmh", "\u0ba4\u0bae\u0bb7\u0bc7\u0b95\u0bcd" },
            { "IC", "\u0b95\u0bc7\u0ba9\u0bb0\u0bbf \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "nan", "\u0bae\u0bbf\u0ba9\u0bcd \u0ba8\u0bbe\u0ba9\u0bcd \u0b9a\u0bc0\u0ba9\u0bae\u0bcd" },
            { "peo", metaValue_peo },
            { "ID", "\u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0b9a\u0bbf\u0baf\u0bbe" },
            { "IE", "\u0b85\u0baf\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "nap", "\u0ba8\u0bbf\u0baf\u0bcb\u0baa\u0bcb\u0bb2\u0bbf\u0b9f\u0ba9\u0bcd" },
            { "naq", "\u0ba8\u0bbe\u0bae\u0bbe" },
            { "zza", "\u0b9c\u0bbe\u0b9c\u0bbe" },
            { "IL", "\u0b87\u0bb8\u0bcd\u0bb0\u0bc7\u0bb2\u0bcd" },
            { "IM", "\u0b90\u0bb2\u0bcd \u0b86\u0b83\u0baa\u0bcd \u0bae\u0bc7\u0ba9\u0bcd" },
            { "IN", "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe" },
            { "type.co.eor", "\u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8\u0baa\u0bcd\u0baa\u0b9f\u0bc1\u0ba4\u0bcd\u0ba4\u0bb2\u0bcd \u0bb5\u0bbf\u0ba4\u0bbf\u0b95\u0bb3\u0bcd" },
            { "IO", "\u0baa\u0bbf\u0bb0\u0bbf\u0b9f\u0bcd\u0b9f\u0bbf\u0bb7\u0bcd \u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0baa\u0bcd \u0baa\u0bc6\u0bb0\u0bc1\u0b99\u0bcd\u0b95\u0b9f\u0bb2\u0bcd \u0baa\u0bbf\u0bb0\u0ba4\u0bc7\u0b9a\u0bae\u0bcd" },
            { "IQ", "\u0b88\u0bb0\u0bbe\u0b95\u0bcd" },
            { "IR", "\u0b88\u0bb0\u0bbe\u0ba9\u0bcd" },
            { "IS", "\u0b90\u0bb8\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "IT", "\u0b87\u0ba4\u0bcd\u0ba4\u0bbe\u0bb2\u0bbf" },
            { "Zmth", "\u0b95\u0ba3\u0bbf\u0ba4\u0b95\u0bcd\u0b95\u0bc1\u0bb1\u0bbf\u0baf\u0bc0\u0b9f\u0bc1" },
            { "type.nu.thai", "\u0ba4\u0bbe\u0baf\u0bcd \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "type.nu.beng", "\u0baa\u0bc6\u0b99\u0bcd\u0b95\u0bbe\u0bb2\u0bbf \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "JE", "\u0b9c\u0bc6\u0bb0\u0bcd\u0b9a\u0bbf" },
            { "type.ca.islamic", "\u0b87\u0bb8\u0bcd\u0bb2\u0bbe\u0bae\u0bbf\u0baf \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "Beng", metaValue_bn },
            { "JM", "\u0b9c\u0bae\u0bc8\u0b95\u0bbe" },
            { "JO", "\u0b9c\u0bcb\u0bb0\u0bcd\u0b9f\u0bbe\u0ba9\u0bcd" },
            { "JP", "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bcd" },
            { "ain", "\u0b90\u0ba9\u0bc1" },
            { "guz", "\u0b95\u0bc1\u0bb8\u0bbf" },
            { "tog", "\u0ba8\u0baf\u0bbe\u0b9a\u0bbe \u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0bbe" },
            { "type.nu.knda", "\u0b95\u0ba9\u0bcd\u0ba9\u0b9f \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "Kali", "\u0b95\u0baf\u0bbe\u0bb9\u0bcd \u0bb2\u0bc0" },
            { "de_CH", "\u0bb8\u0bcd\u0bb5\u0bbf\u0bb8\u0bcd \u0bb9\u0bc8 \u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd" },
            { "type.co.phonetic", "\u0b92\u0bb2\u0bbf\u0baf\u0bbf\u0baf\u0bb2\u0bcd \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8\u0baa\u0bcd\u0baa\u0b9f\u0bc1\u0ba4\u0bcd\u0ba4\u0bb2\u0bcd \u0bae\u0bc1\u0bb1\u0bc8" },
            { "type.ca.buddhist", "\u0baa\u0bc1\u0ba4\u0bcd\u0ba4 \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "KE", "\u0b95\u0bc6\u0ba9\u0bcd\u0baf\u0bbe" },
            { "419", "\u0bb2\u0ba4\u0bcd\u0ba4\u0bc0\u0ba9\u0bcd \u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "KG", "\u0b95\u0bbf\u0bb0\u0bcd\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd" },
            { "KH", "\u0b95\u0bae\u0bcd\u0baa\u0bcb\u0b9f\u0bbf\u0baf\u0bbe" },
            { "KI", "\u0b95\u0bbf\u0bb0\u0bbf\u0baa\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "KM", "\u0b95\u0bcb\u0bae\u0bb0\u0bcb\u0bb8\u0bcd" },
            { "Knda", metaValue_kn },
            { "KN", "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0b95\u0bbf\u0b9f\u0bcd\u0bb8\u0bcd & \u0ba8\u0bc6\u0bb5\u0bbf\u0bb8\u0bcd" },
            { "Zinh", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf\u0bae\u0bbe\u0ba9" },
            { "fr_CA", "\u0b95\u0ba9\u0b9f\u0bbf\u0baf \u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1" },
            { "KP", "\u0bb5\u0b9f \u0b95\u0bca\u0bb0\u0bbf\u0baf\u0bbe" },
            { "KR", "\u0ba4\u0bc6\u0ba9\u0bcd \u0b95\u0bca\u0bb0\u0bbf\u0baf\u0bbe" },
            { "Plrd", "\u0baa\u0bcb\u0bb2\u0bbe\u0bb0\u0bcd\u0b9f\u0bcd \u0b83\u0baa\u0bca\u0ba9\u0bc6\u0b9f\u0bcd\u0b9f\u0bbf\u0b95\u0bcd" },
            { "fr_CH", "\u0bb8\u0bcd\u0bb5\u0bbf\u0bb8\u0bcd \u0baa\u0bbf\u0bb0\u0b9e\u0bcd\u0b9a\u0bc1" },
            { "KW", "\u0b95\u0bc1\u0bb5\u0bc8\u0ba4\u0bcd" },
            { "tpi", "\u0b9f\u0bcb\u0b95\u0bcd \u0baa\u0bbf\u0bb8\u0bbf\u0ba9\u0bcd" },
            { "KY", "\u0b95\u0bc6\u0baf\u0bcd\u0bae\u0bc6\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "KZ", "\u0b95\u0bb8\u0b95\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd" },
            { "Cyrl", "\u0b9a\u0bbf\u0bb0\u0bbf\u0bb2\u0bbf\u0b95\u0bcd" },
            { "LA", "\u0bb2\u0bbe\u0bb5\u0bcb\u0bb8\u0bcd" },
            { "LB", "\u0bb2\u0bc6\u0baa\u0ba9\u0bbe\u0ba9\u0bcd" },
            { "LC", "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bb2\u0bc2\u0b9a\u0bbf\u0baf\u0bbe" },
            { "phn", "\u0b83\u0baa\u0bca\u0ba9\u0bbf\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Cyrs", "\u0baa\u0bb4\u0bc8\u0baf \u0b9a\u0bb0\u0bcd\u0b9a\u0bcd \u0bb8\u0bcd\u0bb2\u0bb5\u0bcb\u0ba9\u0bbf\u0b95\u0bcd \u0b9a\u0bbf\u0bb0\u0bbf\u0bb2\u0bbf\u0b95\u0bcd" },
            { "gwi", "\u0b95\u0bc1\u0bb5\u0bbf\u0b9a\u0bbf\u0ba9\u0bcd" },
            { "nds", "\u0bb2\u0bcb \u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd" },
            { "LI", "\u0bb2\u0bbf\u0b9a\u0bcd\u0b9a\u0bc6\u0ba3\u0bcd\u0bb8\u0bcd\u0b9f\u0bc6\u0baf\u0bcd\u0ba9\u0bcd" },
            { "LK", "\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8" },
            { "akk", "\u0b85\u0b95\u0bcd\u0b95\u0bc7\u0ba4\u0bbf\u0baf\u0ba9\u0bcd" },
            { "cop", metaValue_cop },
            { "LR", "\u0bb2\u0bc8\u0baa\u0bc0\u0bb0\u0bbf\u0baf\u0bbe" },
            { "LS", "\u0bb2\u0bc6\u0b9a\u0bcb\u0ba4\u0bcb" },
            { "Phlv", "\u0baa\u0bc1\u0b95\u0bcd \u0baa\u0bb9\u0bb2\u0bb5\u0bbf" },
            { "LT", "\u0bb2\u0bbf\u0ba4\u0bc1\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0bbe" },
            { "LU", "\u0bb2\u0b95\u0bcd\u0bb8\u0bcd\u0b9a\u0bae\u0bcd\u0baa\u0bb0\u0bcd\u0b95\u0bcd" },
            { "LV", "\u0bb2\u0bbe\u0b9f\u0bcd\u0bb5\u0bbf\u0baf\u0bbe" },
            { "Kana", "\u0b95\u0ba4\u0b95\u0bbe\u0ba9\u0bbe" },
            { "LY", "\u0bb2\u0bbf\u0baa\u0bbf\u0baf\u0bbe" },
            { "lad", "\u0bb2\u0b9f\u0bbf\u0ba9\u0bcb" },
            { "vun", "\u0bb5\u0bc1\u0ba9\u0bcd\u0b9c\u0bcb" },
            { "lah", "\u0bb2\u0bb9\u0ba9\u0bcd\u0b9f\u0bbe" },
            { "lag", "\u0bb2\u0b99\u0bcd\u0b95\u0bbf" },
            { "Thaa", "\u0ba4\u0bbe\u0ba9\u0bbe" },
            { "MA", "\u0bae\u0bca\u0bb0\u0bbe\u0b95\u0bcd\u0b95\u0bcb" },
            { "MC", "\u0bae\u0bca\u0ba9\u0bbe\u0b95\u0bcd\u0b95\u0bcb" },
            { "MD", "\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bcb\u0bb5\u0bbe" },
            { "ME", "\u0bae\u0bbe\u0ba9\u0bcd\u0b9f\u0bc7\u0ba9\u0bc6\u0b95\u0bcd\u0bb0\u0bcb" },
            { "MF", "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bae\u0bbe\u0bb0\u0bcd\u0b9f\u0bcd\u0b9f\u0bc0\u0ba9\u0bcd" },
            { "lam", "\u0bb2\u0bae\u0bcd\u0baa\u0bbe" },
            { "MG", "\u0bae\u0b9f\u0b95\u0bbe\u0bb8\u0bcd\u0b95\u0bb0\u0bcd" },
            { "Thai", metaValue_th },
            { "MH", "\u0bae\u0bbe\u0bb0\u0bcd\u0bb7\u0bb2\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "ale", "\u0b85\u0bb2\u0bc2\u0b9f\u0bcd" },
            { "type.nu.vaii", "\u0bb5\u0bc8 \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "MK", "\u0bae\u0bbe\u0b9a\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe" },
            { "ML", "\u0bae\u0bbe\u0bb2\u0bbf" },
            { "MM", "\u0bae\u0bbf\u0baf\u0bbe\u0ba9\u0bcd\u0bae\u0bbe\u0bb0\u0bcd (\u0baa\u0bb0\u0bcd\u0bae\u0bbe)" },
            { "MN", "\u0bae\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbf\u0baf\u0bbe" },
            { "new", "\u0ba8\u0bc6\u0bb5\u0bbe\u0bb0\u0bbf" },
            { "MO", "\u0bae\u0b95\u0bbe\u0bb5\u0bcd \u0b8e\u0bb8\u0bcd\u0b8f\u0b86\u0bb0\u0bcd \u0b9a\u0bc0\u0ba9\u0bbe" },
            { "MP", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0bae\u0bb0\u0bbf\u0baf\u0bbe\u0ba9\u0bbe \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "MQ", "\u0bae\u0bbe\u0bb0\u0bcd\u0b9f\u0bbf\u0ba9\u0bbf\u0b95\u0bcd" },
            { "MR", "\u0bae\u0bcc\u0bb0\u0bbf\u0b9f\u0bbe\u0ba9\u0bbf\u0baf\u0bbe" },
            { "MS", "\u0bae\u0bbe\u0ba3\u0bcd\u0b9f\u0bcd\u0b9a\u0bc6\u0bb0\u0bbe\u0b9f\u0bcd" },
            { "MT", "\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bbe" },
            { "type.m0.ungegn", "UNGEGN" },
            { "MU", "\u0bae\u0bca\u0bb0\u0bbf\u0b9a\u0bbf\u0baf\u0bb8\u0bcd" },
            { "alt", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b85\u0bb2\u0bcd\u0ba4\u0bc8" },
            { "MV", "\u0bae\u0bbe\u0bb2\u0ba4\u0bcd\u0ba4\u0bc0\u0bb5\u0bc1" },
            { "MW", "\u0bae\u0bb2\u0bbe\u0bb5\u0bbf" },
            { "MX", "\u0bae\u0bc6\u0b95\u0bcd\u0b9a\u0bbf\u0b95\u0bcb" },
            { "type.ca.japanese", "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0baf \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "MY", "\u0bae\u0bb2\u0bc7\u0b9a\u0bbf\u0baf\u0bbe" },
            { "MZ", "\u0bae\u0bca\u0b9a\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0b95\u0bcd" },
            { "Phli", "\u0b87\u0ba9\u0bcd\u0bb8\u0bcd\u0b95\u0bbf\u0bb0\u0bbf\u0baa\u0bcd\u0bb7\u0ba9\u0bb2\u0bcd \u0baa\u0bb9\u0bb2\u0bb5\u0bbf" },
            { "NA", "\u0ba8\u0bae\u0bc0\u0baa\u0bbf\u0baf\u0bbe" },
            { "202", "\u0b9a\u0baa\u0bcd-\u0b9a\u0bb9\u0bbe\u0bb0\u0ba9\u0bcd \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "type.ca.hebrew", "\u0bb9\u0bc0\u0baa\u0bcd\u0bb0\u0bc1 \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "type.co.dictionary", "\u0b85\u0b95\u0bb0\u0bbe\u0ba4\u0bbf \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "NC", "\u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bc7\u0bb2\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe" },
            { "%%WADEGILE", "\u0bb5\u0bc7\u0b9f\u0bcd-\u0b95\u0bc8\u0bb2\u0bcd\u0bb8\u0bcd \u0bb0\u0bcb\u0bae\u0ba9\u0bc8\u0bb7\u0bc7\u0b9a\u0ba9\u0bcd" },
            { "NE", "\u0ba8\u0bc8\u0b9c\u0bb0\u0bcd" },
            { "NF", "\u0ba8\u0bbe\u0bb0\u0bcd\u0b83\u0baa\u0bcb\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "NG", "\u0ba8\u0bc8\u0b9c\u0bc0\u0bb0\u0bbf\u0baf\u0bbe" },
            { "trv", "\u0ba4\u0bb0\u0bcb\u0b95\u0bcb" },
            { "Phlp", "\u0b9a\u0bbe\u0bb2\u0bcd\u0b9f\u0bb0\u0bcd \u0baa\u0bb9\u0bb2\u0bb5\u0bbf" },
            { "NI", "\u0ba8\u0bbf\u0b95\u0bb0\u0b95\u0bc1\u0bb5\u0bbe" },
            { "Hmng", "\u0baa\u0bb9\u0bbe\u0bb5\u0bcd \u0bae\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "NL", "\u0ba8\u0bc6\u0ba4\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "NO", "\u0ba8\u0bbe\u0bb0\u0bcd\u0bb5\u0bc7" },
            { "NP", "\u0ba8\u0bc7\u0baa\u0bbe\u0bb3\u0bae\u0bcd" },
            { "NR", "\u0ba8\u0bcc\u0bb0\u0bc1" },
            { "NU", "\u0ba8\u0bbf\u0baf\u0bc2" },
            { "Phnx", "\u0b83\u0baa\u0bcb\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "rof", "\u0bb0\u0bcb\u0bae\u0bcd\u0baa\u0bcb" },
            { "tsi", "\u0b9f\u0bcd\u0bb8\u0bbf\u0bae\u0bcd\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "NZ", "\u0ba8\u0bbf\u0baf\u0bc2\u0b9a\u0bbf\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "rom", "\u0bb0\u0bcb\u0bae\u0bbe\u0ba9\u0bbf" },
            { "Mero", "\u0bae\u0bc6\u0bb0\u0bbe\u0baf\u0bcd\u0b9f\u0bbf\u0b95\u0bcd" },
            { "crh", "\u0b95\u0bbf\u0bb0\u0bbf\u0bae\u0bbf\u0baf\u0ba9\u0bcd \u0ba4\u0bc1\u0bb0\u0bcd\u0b95\u0bcd\u0b95\u0bbf" },
            { "ang", "\u0baa\u0bb4\u0bc8\u0baf \u0b86\u0b99\u0bcd\u0b95\u0bbf\u0bb2\u0bae\u0bcd" },
            { "OM", "\u0b93\u0bae\u0ba9\u0bcd" },
            { "anp", "\u0b85\u0b99\u0bcd\u0b95\u0bbf\u0b95\u0bbe" },
            { "crs", "\u0b9a\u0bc6\u0b9a\u0bc6\u0bb2\u0bcd\u0bb5\u0bbe \u0b95\u0bcd\u0bb0\u0bc6\u0baf\u0bcb\u0bb2\u0bcd \u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u0baa\u0ba9\u0bbe\u0bae\u0bbe" },
            { "type.ca.islamic-civil", "\u0b87\u0bb8\u0bcd\u0bb2\u0bbe\u0bae\u0bbf\u0baf \u0b9a\u0bbf\u0bb5\u0bbf\u0bb2\u0bcd \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "csb", "\u0b95\u0bb7\u0bc1\u0baa\u0bbf\u0baf\u0ba9\u0bcd" },
            { "en_GB", "\u0baa\u0bbf\u0bb0\u0bbf\u0b9f\u0bcd\u0b9f\u0bbf\u0bb7\u0bcd \u0b86\u0b99\u0bcd\u0b95\u0bbf\u0bb2\u0bae\u0bcd" },
            { "PE", "\u0baa\u0bc6\u0bb0\u0bc1" },
            { "PF", "\u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1 \u0baa\u0bbe\u0bb2\u0bbf\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0bbe" },
            { "PG", "\u0baa\u0baa\u0bcd\u0baa\u0bc1\u0bb5\u0bbe \u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe" },
            { "PH", "\u0baa\u0bbf\u0bb2\u0bbf\u0baa\u0bcd\u0baa\u0bc8\u0ba9\u0bcd\u0bb8\u0bcd" },
            { "PK", "\u0baa\u0bbe\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd" },
            { "PL", "\u0baa\u0bcb\u0bb2\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "ewo", "\u0b8e\u0bb5\u0bcb\u0ba9\u0bcd\u0b9f\u0bcb" },
            { "PM", "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0baa\u0bbf\u0baf\u0bb0\u0bcd & \u0bae\u0bbf\u0b95\u0bcd\u0bb5\u0bc7\u0bb2\u0bbe\u0ba9\u0bcd" },
            { "PN", "\u0baa\u0bbf\u0b9f\u0bcd\u0b95\u0bc6\u0baf\u0bcd\u0bb0\u0bcd\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "PR", "\u0baa\u0bbf\u0baf\u0bc2\u0bb0\u0bcd\u0b9f\u0bcb \u0bb0\u0bbf\u0b95\u0bcb" },
            { "PS", "\u0baa\u0bbe\u0bb2\u0bb8\u0bcd\u0ba4\u0bc0\u0ba9\u0bbf\u0baf \u0baa\u0bbf\u0bb0\u0ba4\u0bc7\u0b9a\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "Bali", "\u0baa\u0bbe\u0bb2\u0bbf\u0ba9\u0bc0\u0bb8\u0bcd" },
            { "PT", "\u0baa\u0bcb\u0bb0\u0bcd\u0b9a\u0bcd\u0b9a\u0bc1\u0b95\u0bcd\u0b95\u0bb2\u0bcd" },
            { "PW", "\u0baa\u0bbe\u0bb2\u0bcb" },
            { "nia", "\u0ba8\u0bbf\u0baf\u0bbe\u0bb8\u0bcd" },
            { "type.nu.greklow", "\u0b95\u0bbf\u0bb0\u0bc0\u0b95\u0bcd \u0b9a\u0bbf\u0bb1\u0bcd\u0bb1\u0bc6\u0bb4\u0bc1\u0ba4\u0bcd\u0ba4\u0bc1 \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "PY", "\u0baa\u0bb0\u0bbe\u0b95\u0bc1\u0bb5\u0bc7" },
            { "tum", "\u0ba4\u0bc1\u0bae\u0bcd\u0baa\u0bc1\u0b95\u0bbe" },
            { "Hebr", "\u0bb9\u0bc0\u0baa\u0bcd\u0bb0\u0bc1" },
            { "QA", "\u0b95\u0ba4\u0bcd\u0ba4\u0bbe\u0bb0\u0bcd" },
            { "niu", "\u0ba8\u0bbf\u0baf\u0bc2\u0bb5\u0bbe\u0ba9\u0bcd" },
            { "QO", "\u0bb5\u0bc6\u0bb3\u0bbf\u0baa\u0bcd\u0baa\u0bc1\u0bb1 \u0b93\u0bb7\u0bbf\u0baf\u0bbe\u0ba9\u0bbf\u0baf\u0bbe" },
            { "lez", "\u0bb2\u0bc6\u0b9c\u0bcd\u0b9c\u0bbf\u0baf\u0ba9\u0bcd" },
            { "tvl", "\u0b9f\u0bc1\u0bb5\u0bbe\u0bb2\u0bc1" },
            { "Tavt", "\u0ba4\u0bc8 \u0bb5\u0bbf\u0baf\u0ba4\u0bcd" },
            { "001", "\u0b89\u0bb2\u0b95\u0bae\u0bcd" },
            { "002", "\u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "003", "\u0bb5\u0b9f \u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "RE", "\u0bb0\u0bc0\u0baf\u0bc2\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "005", "\u0ba4\u0bc6\u0ba9\u0bcd \u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "jbo", "\u0bb2\u0bcb\u0b9c\u0bcd\u0baa\u0ba9\u0bcd" },
            { "Rjng", "\u0bb0\u0bc6\u0b9c\u0bc6\u0baf\u0bcd\u0ba9\u0bcd" },
            { "009", "\u0b93\u0bb7\u0bbf\u0baf\u0bbe\u0ba9\u0bbf\u0baf\u0bbe" },
            { "RO", "\u0bb0\u0bc1\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0bbe" },
            { "RS", "\u0b9a\u0bc6\u0bb0\u0bcd\u0baa\u0bbf\u0baf\u0bbe" },
            { "RU", "\u0bb0\u0bb7\u0bcd\u0baf\u0bbe" },
            { "RW", "\u0bb0\u0bc1\u0bb5\u0bbe\u0ba3\u0bcd\u0b9f\u0bbe" },
            { "Mani", "\u0bae\u0ba9\u0bbf\u0b9a\u0bc6\u0baf\u0bcd\u0ba9\u0bcd" },
            { "Ugar", "\u0b89\u0b95\u0bbe\u0bb0\u0ba4\u0bbf\u0b95\u0bcd" },
            { "Khar", "\u0b95\u0bb0\u0bcb\u0bb7\u0bcd\u0b9f\u0bbf" },
            { "SA", "\u0b9a\u0bb5\u0bc2\u0ba4\u0bbf \u0b85\u0bb0\u0bc7\u0baa\u0bbf\u0baf\u0bbe" },
            { "pon", "\u0b83\u0baa\u0bcb\u0ba9\u0bcd\u0baa\u0bc6\u0baf\u0bc6\u0ba9\u0bcd" },
            { "Mand", "\u0bae\u0bc7\u0ba9\u0bcd\u0b9f\u0bbf\u0baf\u0ba9\u0bcd" },
            { "SB", "\u0b9a\u0bbe\u0bb2\u0bae\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "twq", "\u0b9f\u0b9a\u0bb5\u0bbe\u0b95\u0bcd" },
            { "011", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "SC", "\u0b9a\u0bc0\u0bb7\u0bc6\u0bb2\u0bcd\u0bb8\u0bcd" },
            { "SD", "\u0b9a\u0bc2\u0b9f\u0bbe\u0ba9\u0bcd" },
            { "013", "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "SE", "\u0bb8\u0bcd\u0bb5\u0bc0\u0b9f\u0ba9\u0bcd" },
            { "014", "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "arc", "\u0b85\u0bb0\u0bbe\u0bae\u0bc8\u0b95\u0bcd" },
            { "015", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "SG", "\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd" },
            { "SH", "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bb9\u0bc6\u0bb2\u0bc6\u0ba9\u0bbe" },
            { "type.lb.strict", "\u0b95\u0ba3\u0bcd\u0b9f\u0bbf\u0baa\u0bcd\u0baa\u0bbe\u0ba9 \u0bb5\u0bb0\u0bbf \u0bae\u0bc1\u0bb1\u0bbf\u0baa\u0bcd\u0baa\u0bc1 \u0bb8\u0bcd\u0b9f\u0bc8\u0bb2\u0bcd" },
            { "017", "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "SI", "\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0bbe" },
            { "018", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "SJ", "\u0bb8\u0bcd\u0bb5\u0bb2\u0bcd\u0baa\u0bbe\u0bb0\u0bcd\u0b9f\u0bc1 & \u0b9c\u0bbe\u0ba9\u0bcd \u0bae\u0bc7\u0baf\u0ba9\u0bcd" },
            { "019", "\u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe\u0bb8\u0bcd" },
            { "SK", "\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bbe\u0b95\u0bbf\u0baf\u0bbe" },
            { "SL", "\u0b9a\u0bbf\u0baf\u0bbe\u0bb0\u0bbe \u0bb2\u0bbf\u0baf\u0bcb\u0ba9\u0bcd" },
            { "SM", "\u0b9a\u0bbe\u0ba9\u0bcd \u0bae\u0bb0\u0bbf\u0ba9\u0bcb" },
            { "SN", "\u0b9a\u0bc6\u0ba9\u0bc6\u0b95\u0bb2\u0bcd" },
            { "SO", "\u0b9a\u0bcb\u0bae\u0bbe\u0bb2\u0bbf\u0baf\u0bbe" },
            { "arn", "\u0bae\u0baa\u0bc1\u0b9a\u0bcd\u0b9a\u0bc7" },
            { "arp", "\u0b85\u0bb0\u0baa\u0bb9\u0bcb" },
            { "type.nu.taml", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0ba4\u0bae\u0bbf\u0bb4\u0bcd \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "SR", "\u0b9a\u0bc1\u0bb0\u0bbf\u0ba9\u0bbe\u0bae\u0bcd" },
            { "SS", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bc2\u0b9f\u0bbe\u0ba9\u0bcd" },
            { "ST", "\u0b9a\u0bbe\u0bb5\u0bcd \u0ba4\u0bcb\u0bae\u0bcd & \u0baa\u0bcd\u0bb0\u0bbf\u0ba9\u0bcd\u0b9a\u0bbf\u0baa\u0bbf" },
            { "SV", "\u0b8e\u0bb2\u0bcd \u0b9a\u0bbe\u0bb2\u0bcd\u0bb5\u0b9f\u0bbe\u0bb0\u0bcd" },
            { "SX", "\u0b9a\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bae\u0bbe\u0bb0\u0bcd\u0b9f\u0bc6\u0ba9\u0bcd" },
            { "SY", "\u0b9a\u0bbf\u0bb0\u0bbf\u0baf\u0bbe" },
            { "yao", "\u0baf\u0bbe\u0bb5\u0bcd" },
            { "SZ", "\u0bb8\u0bcd\u0bb5\u0bbe\u0bb8\u0bbf\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "arw", "\u0b85\u0bb0\u0bbe\u0bb5\u0bbe\u0b95\u0bcd" },
            { "yap", "\u0baf\u0bbe\u0baa\u0bc7\u0b9a\u0bc7" },
            { "TA", "\u0b9f\u0bbf\u0bb0\u0bbf\u0bb8\u0bcd\u0b9f\u0ba9\u0bcd \u0b9f\u0bbe \u0b95\u0bc1\u0ba9\u0bcd\u0bb9\u0bbe" },
            { "asa", "\u0b85\u0b9a\u0bc1" },
            { "type.ms.ussystem", "\u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0b85\u0bb3\u0bb5\u0bc0\u0b9f\u0bcd\u0b9f\u0bc1 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "021", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "TC", "\u0b9f\u0bb0\u0bcd\u0b95\u0bcd\u0bb8\u0bcd & \u0b95\u0bc8\u0b95\u0bcb\u0bb8\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "yav", "\u0baf\u0bbe\u0b99\u0bcd\u0baa\u0bc6\u0ba9\u0bcd" },
            { "TD", "\u0b9a\u0bbe\u0b9f\u0bcd" },
            { "TF", "\u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1 \u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0baa\u0bbf\u0bb0\u0ba4\u0bc7\u0b9a\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "TG", "\u0b9f\u0bcb\u0b95\u0bcb" },
            { "TH", "\u0ba4\u0bbe\u0baf\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1" },
            { "TJ", "\u0ba4\u0b9c\u0bbf\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd" },
            { "029", "\u0b95\u0bb0\u0bc0\u0baa\u0bbf\u0baf\u0ba9\u0bcd" },
            { "TK", "\u0b9f\u0bcb\u0b95\u0bc7\u0bb2\u0bcb" },
            { "TL", "\u0ba4\u0bc8\u0bae\u0bc2\u0bb0\u0bcd-\u0bb2\u0bc6\u0bb8\u0bcd\u0ba4\u0bc7" },
            { "ybb", "\u0baf\u0bc6\u0bae\u0bcd\u0baa\u0bbe" },
            { "type.co.searchjl", "\u0bb9\u0b99\u0bcd\u0b95\u0bc1\u0bb2\u0bcd \u0bae\u0bc1\u0ba4\u0ba9\u0bcd\u0bae\u0bc8 \u0bae\u0bc6\u0baf\u0bcd\u0baf\u0bc6\u0bb4\u0bc1\u0ba4\u0bcd\u0ba4\u0bbf\u0ba9\u0bcd\u0baa\u0b9f\u0bbf \u0ba4\u0bc7\u0b9f\u0bc1" },
            { "TM", "\u0ba4\u0bc1\u0bb0\u0bcd\u0b95\u0bcd\u0bae\u0bc6\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd" },
            { "TN", "\u0b9f\u0bc1\u0ba9\u0bbf\u0b9a\u0bbf\u0baf\u0bbe" },
            { "TO", "\u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0bbe" },
            { "TR", "\u0ba4\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bbf" },
            { "TT", "\u0b9f\u0bbf\u0bb0\u0bbf\u0ba9\u0bbf\u0b9f\u0bbe\u0b9f\u0bcd & \u0b9f\u0bca\u0baa\u0bbe\u0b95\u0bcb" },
            { "TV", "\u0ba4\u0bc1\u0bb5\u0bbe\u0bb2\u0bc2" },
            { "TW", "\u0ba4\u0bc8\u0bb5\u0bbe\u0ba9\u0bcd" },
            { "ast", "\u0b85\u0bb8\u0bcd\u0ba4\u0bc1\u0bb0\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Orkh", "\u0b86\u0bb0\u0bcd\u0b95\u0bbe\u0ba9\u0bcd" },
            { "TZ", "\u0ba4\u0bbe\u0ba9\u0bcd\u0b9a\u0bbe\u0ba9\u0bbf\u0baf\u0bbe" },
            { "nmg", "\u0b95\u0bcd\u0bb5\u0bbe\u0b9a\u0bbf\u0baf\u0bcb" },
            { "Zzzz", "\u0b85\u0bb1\u0bbf\u0baf\u0baa\u0bcd\u0baa\u0b9f\u0bbe\u0ba4 \u0bb8\u0bcd\u0b95\u0bbf\u0bb0\u0bbf\u0baa\u0bcd\u0b9f\u0bcd" },
            { "UA", "\u0b89\u0b95\u0bcd\u0bb0\u0bc8\u0ba9\u0bcd" },
            { "rup", "\u0b85\u0bb0\u0bcb\u0bae\u0bbe\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "030", "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bbe\u0b9a\u0bbf\u0baf\u0bbe" },
            { "tyv", "\u0b9f\u0bc1\u0bb5\u0bbf\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "sw_CD", "\u0b95\u0bbe\u0b99\u0bcd\u0b95\u0bcb \u0bb8\u0bcd\u0bb5\u0bbe\u0bb9\u0bbf\u0bb2\u0bbf" },
            { "034", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bbe\u0b9a\u0bbf\u0baf\u0bbe" },
            { "hai", "\u0bb9\u0bc8\u0b9f\u0bbe" },
            { "035", "\u0ba4\u0bc6\u0ba9\u0bcd\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bbe\u0b9a\u0bbf\u0baf\u0bbe" },
            { "UG", "\u0b89\u0b95\u0bbe\u0ba3\u0bcd\u0b9f\u0bbe" },
            { "hak", "\u0bb9\u0b95\u0bcd\u0b95\u0bbe \u0b9a\u0bc0\u0ba9\u0bae\u0bcd" },
            { "type.co.pinyin", "\u0baa\u0bbf\u0ba9\u0bcd\u0baf\u0bbf\u0ba9\u0bcd \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "039", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbe" },
            { "Sinh", metaValue_si },
            { "UM", "\u0baf\u0bc2.\u0b8e\u0bb8\u0bcd. \u0bb5\u0bc6\u0bb3\u0bbf\u0baa\u0bcd\u0baa\u0bc1\u0bb1\u0ba4\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "UN", "\u0b90\u0b95\u0bcd\u0b95\u0bbf\u0baf \u0ba8\u0bbe\u0b9f\u0bc1\u0b95\u0bb3\u0bcd" },
            { "US", "\u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "haw", "\u0bb9\u0bb5\u0bbe\u0baf\u0bbf\u0baf\u0ba9\u0bcd" },
            { "type.co.gb2312han", "\u0b8e\u0bb3\u0bbf\u0bae\u0bc8\u0baf\u0bbe\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f \u0b9a\u0bc0\u0ba9 \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bb5\u0b9f\u0bbf\u0bb5\u0bae\u0bcd - GB2312" },
            { "UY", "\u0b89\u0bb0\u0bc1\u0b95\u0bc1\u0bb5\u0bc7" },
            { "prg", "\u0baa\u0bbf\u0bb0\u0bb7\u0bcd\u0baf\u0ba9\u0bcd" },
            { "UZ", "\u0b89\u0bb8\u0bcd\u0baa\u0bc6\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd" },
            { "tzm", "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b85\u0b9f\u0bcd\u0bb2\u0bb8\u0bcd \u0b9f\u0bae\u0b9a\u0bc8\u0b9f\u0bcd" },
            { "type.co.stroke", "\u0bb8\u0bcd\u0b9f\u0bcd\u0bb0\u0bcb\u0b95\u0bcd \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "nnh", "\u0ba8\u0bc6\u0b95\u0bc6\u0baf\u0bcd\u0bae\u0bcd\u0baa\u0bc2\u0ba9\u0bcd" },
            { "VA", "\u0bb5\u0bbe\u0b9f\u0bbf\u0b95\u0ba9\u0bcd \u0ba8\u0b95\u0bb0\u0bae\u0bcd" },
            { "pro", "\u0baa\u0bb4\u0bc8\u0baf \u0baa\u0bcd\u0bb0\u0bcb\u0bb5\u0bc6\u0ba9\u0bcd\u0b9a\u0bbe\u0bb2\u0bcd" },
            { "VC", "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bb5\u0bbf\u0ba9\u0bcd\u0b9a\u0bc6\u0ba9\u0bcd\u0b9f\u0bcd & \u0b95\u0bbf\u0bb0\u0bc6\u0ba9\u0b9f\u0bc8\u0ba9\u0bcd\u0bb8\u0bcd" },
            { "VE", "\u0bb5\u0bc6\u0ba9\u0bbf\u0b9a\u0bc1\u0bb2\u0bbe" },
            { "VG", "\u0baa\u0bbf\u0bb0\u0bbf\u0b9f\u0bcd\u0b9f\u0bc0\u0bb7\u0bcd \u0b95\u0ba9\u0bcd\u0ba9\u0bbf\u0ba4\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "VI", "\u0baf\u0bc2.\u0b8e\u0bb8\u0bcd. \u0b95\u0ba9\u0bcd\u0ba9\u0bbf\u0ba4\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd" },
            { "VN", "\u0bb5\u0bbf\u0baf\u0b9f\u0bcd\u0ba8\u0bbe\u0bae\u0bcd" },
            { "VU", "\u0bb5\u0ba9\u0bc1\u0bb5\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1" },
            { "nog", "\u0ba8\u0bcb\u0b95\u0bc8" },
            { "rwk", "\u0bb0\u0bc1\u0bb5\u0bbe" },
            { "non", "\u0baa\u0bb4\u0bc8\u0baf \u0ba8\u0bcb\u0bb0\u0bcd\u0bb8\u0bcd" },
            { "053", "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bb2\u0bc7\u0b9a\u0bbf\u0baf\u0bbe" },
            { "054", "\u0bae\u0bc6\u0bb2\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0bbe" },
            { "WF", "\u0bb5\u0bbe\u0bb2\u0bbf\u0bb8\u0bcd \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0b83\u0baa\u0bc1\u0b9f\u0bc1\u0ba9\u0bbe" },
            { "type.co.traditional", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "057", "\u0bae\u0bc8\u0b95\u0bcd\u0bb0\u0bcb \u0ba8\u0bc7\u0bb7\u0bbf\u0baf\u0bbe \u0baa\u0bbf\u0bb0\u0ba4\u0bc7\u0b9a\u0bae\u0bcd" },
            { "jgo", "\u0ba8\u0b95\u0bca\u0bae\u0bcd\u0baa\u0bbe" },
            { "lkt", "\u0bb2\u0b95\u0bcb\u0b9f\u0bbe" },
            { "type.nu.finance", "\u0ba8\u0bbf\u0ba4\u0bbf \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "type.co.compat", "\u0bae\u0bc1\u0ba8\u0bcd\u0ba4\u0bc8\u0baf \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bb5\u0b9f\u0bbf\u0bb5\u0bae\u0bcd, \u0b87\u0ba3\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0ba9\u0bcd\u0bae\u0bc8\u0b95\u0bcd\u0b95\u0bc1" },
            { "wae", "\u0bb5\u0bbe\u0bb2\u0bcd\u0b9a\u0bc7\u0bb0\u0bcd" },
            { "WS", "\u0b9a\u0bae\u0bcb\u0bb5\u0bbe" },
            { "wal", "\u0bb5\u0bcb\u0bb2\u0bbe\u0baf\u0bcd\u0b9f\u0bcd\u0b9f\u0bbe" },
            { "was", "\u0bb5\u0bbe\u0bb7\u0bcb" },
            { "war", "\u0bb5\u0bbe\u0bb0\u0bc7" },
            { "awa", "\u0b85\u0bb5\u0ba4\u0bbf" },
            { "061", "\u0baa\u0bbe\u0bb2\u0bbf\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0bbe" },
            { "XK", "\u0b95\u0bca\u0b9a\u0bcb\u0bb5\u0bcb" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0b8e\u0bb4\u0bc1\u0ba4\u0baa\u0bcd\u0baa\u0b9f\u0bbe\u0ba4\u0ba4\u0bc1" },
            { "Olck", "\u0b92\u0bb2\u0bcd \u0b9a\u0bbf\u0b95\u0bcd\u0b95\u0bbf" },
            { "wbp", "\u0bb5\u0bb2\u0bcd\u0baa\u0bbf\u0bb0\u0bbf" },
            { "Batk", "\u0baa\u0bbe\u0b9f\u0bbe\u0b95\u0bcd" },
            { "Blis", "\u0baa\u0bcd\u0bb2\u0bbf\u0bb8\u0bcd\u0bb8\u0bbf\u0bae\u0bbf\u0baa\u0bbe\u0bb2\u0bcd\u0bb8\u0bcd" },
            { "YE", "\u0b8f\u0bae\u0ba9\u0bcd" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "fan", "\u0b83\u0baa\u0bc7\u0b99\u0bcd\u0b95\u0bcd" },
            { "fat", "\u0b83\u0baa\u0bbe\u0ba9\u0bcd\u0b9f\u0bbf" },
            { "Sgnw", "\u0bb8\u0bc8\u0ba9\u0bcd\u0b8e\u0bb4\u0bc1\u0ba4\u0bcd\u0ba4\u0bc1" },
            { "YT", "\u0bae\u0baf\u0bcb\u0b9f\u0bcd" },
            { "ZA", "\u0ba4\u0bc6\u0ba9\u0bcd \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe" },
            { "type.lb.loose", "\u0ba4\u0bb3\u0bb0\u0bcd\u0bb5\u0bbe\u0ba9 \u0bb5\u0bb0\u0bbf \u0bae\u0bc1\u0bb1\u0bbf\u0baa\u0bcd\u0baa\u0bc1 \u0bb8\u0bcd\u0b9f\u0bc8\u0bb2\u0bcd" },
            { "Deva", "\u0ba4\u0bc7\u0bb5\u0ba8\u0bbe\u0b95\u0bb0\u0bbf" },
            { "type.nu.geor", "\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0ba9\u0bcd \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "Hira", "\u0bb9\u0bbf\u0bb0\u0bbe\u0b95\u0bbe\u0ba9\u0bbe" },
            { "ZM", "\u0b9c\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe" },
            { "%%PINYIN", "\u0baa\u0bbf\u0ba9\u0bcd\u0baf\u0bbf\u0ba9\u0bcd \u0bb0\u0bcb\u0bae\u0bbe\u0ba9\u0bc8\u0b9a\u0bc6\u0bb7\u0ba9\u0bcd" },
            { "ZW", "\u0b9c\u0bbf\u0bae\u0bcd\u0baa\u0bbe\u0baa\u0bcd\u0bb5\u0bc7" },
            { "ZZ", "\u0b85\u0bb1\u0bbf\u0baf\u0baa\u0bcd\u0baa\u0b9f\u0bbe\u0ba4 \u0baa\u0bbf\u0bb0\u0ba4\u0bc7\u0b9a\u0bae\u0bcd" },
            { "Runr", "\u0bb0\u0bc1\u0ba9\u0bbf\u0b95\u0bcd" },
            { "type.ms.metric", "\u0bae\u0bc6\u0b9f\u0bcd\u0bb0\u0bbf\u0b95\u0bcd \u0bae\u0bc1\u0bb1\u0bc8" },
            { "type.ca.iso8601", "ISO-8601 \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "lol", "\u0bae\u0bcb\u0b99\u0bcd\u0b95\u0bcb" },
            { "nso", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0b9a\u0bcb\u0ba4\u0bcb" },
            { "type.nu.telu", "\u0ba4\u0bc6\u0bb2\u0bc1\u0b99\u0bcd\u0b95\u0bc1 \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "lou", "\u0bb2\u0bc2\u0b9a\u0bbf\u0baf\u0bbe\u0ba9\u0bbe \u0b95\u0bcd\u0bb0\u0baf\u0bcb\u0bb2\u0bcd" },
            { "loz", "\u0bb2\u0bcb\u0b9a\u0bbf" },
            { "jmc", "\u0bae\u0bbe\u0b9a\u0bc6\u0bae\u0bcd" },
            { "hif", "\u0b83\u0baa\u0bbf\u0b9c\u0bbf \u0b87\u0ba8\u0bcd\u0ba4\u0bbf" },
            { "type.nu.hansfin", "\u0b8e\u0bb3\u0bbf\u0ba4\u0bbe\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f \u0b9a\u0bc0\u0ba9 \u0ba8\u0bbf\u0ba4\u0bbf \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "hil", "\u0bb9\u0bbf\u0bb2\u0bbf\u0b95\u0bbe\u0baf\u0bcd\u0ba9\u0bbe\u0ba9\u0bcd" },
            { "type.nu.arabext", "\u0ba8\u0bc0\u0b9f\u0bcd\u0b9f\u0bbf\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f \u0b85\u0bb0\u0baa\u0bbf\u0baf-\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "nus", "\u0ba8\u0bbf\u0baf\u0bc2\u0bb0\u0bcd" },
            { "dak", "\u0b9f\u0b95\u0bcb\u0b9f\u0bbe" },
            { "type.nu.fullwide", "\u0bae\u0bc1\u0bb4\u0bc1-\u0b85\u0b95\u0bb2 \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "hit", "\u0bb9\u0bbf\u0b9f\u0bcd\u0b9f\u0bc8\u0b9f\u0bcd" },
            { "dar", "\u0ba4\u0bbe\u0bb0\u0bcd\u0b95\u0bc1\u0bb5\u0bbe" },
            { "dav", "\u0b9f\u0bc8\u0b9f\u0bbe" },
            { "Maya", "\u0bae\u0baf\u0bbe\u0ba9\u0bcd \u0bb9\u0bc8\u0bb0\u0bcb\u0b95\u0bbf\u0bb3\u0bbf\u0baa\u0bcd" },
            { "lrc", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0bb2\u0bc1\u0bb0\u0bbf" },
            { "Copt", metaValue_cop },
            { "nwc", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0ba8\u0bc7\u0bb5\u0bbe\u0bb0\u0bbf" },
            { "udm", "\u0b89\u0b9f\u0bcd\u0bae\u0bc1\u0bb0\u0bcd\u0b9f\u0bcd" },
            { "Khmr", "\u0b95\u0bae\u0bc6\u0bb0\u0bcd" },
            { "Limb", "\u0bb2\u0bbf\u0bae\u0bcd\u0baa\u0bc1" },
            { "sad", "\u0b9a\u0bbe\u0ba9\u0bcd\u0b9f\u0bbe\u0bb5\u0bc7" },
            { "type.nu.roman", "\u0bb0\u0bcb\u0bae\u0ba9\u0bcd \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "sah", "\u0b9a\u0b95\u0bbe" },
            { "sam", "\u0b9a\u0bae\u0bbe\u0bb0\u0bbf\u0b9f\u0ba9\u0bcd \u0b85\u0bb0\u0bbe\u0bae\u0bc8\u0b95\u0bcd" },
            { "saq", "\u0b9a\u0bae\u0bcd\u0baa\u0bc1\u0bb0\u0bc1" },
            { "sas", "\u0b9a\u0bbe\u0b9a\u0bbe\u0b95\u0bcd" },
            { "sat", "\u0b9a\u0bbe\u0ba9\u0bcd\u0b9f\u0bbe\u0bb2\u0bbf" },
            { "Tfng", "\u0b9f\u0bbf\u0b83\u0baa\u0bbf\u0ba9\u0bbe\u0b95\u0bcd" },
            { "jpr", "\u0b9c\u0bc2\u0ba4\u0bc7\u0baf\u0bcb-\u0baa\u0bc6\u0bb0\u0bcd\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "saz", "\u0b9a\u0bcc\u0bb0\u0bbe\u0bb7\u0bcd\u0b9f\u0bbf\u0bb0\u0bae\u0bcd" },
            { "type.d0.npinyin", "\u0b8e\u0ba3\u0bcd" },
            { "type.nu.native", "\u0b9a\u0bca\u0ba8\u0bcd\u0ba4 \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "sba", "\u0ba8\u0bc6\u0b95\u0bbe\u0bae\u0bcd\u0baa\u0bc7" },
            { "Guru", "\u0b95\u0bc1\u0bb0\u0bcd\u0bae\u0bc1\u0b95\u0bbf" },
            { "lua", "\u0bb2\u0bc1\u0baa\u0bbe-\u0bb2\u0bc1\u0bb2\u0bc1\u0bb2\u0bbe" },
            { "type.d0.fwidth", "\u0bae\u0bc1\u0bb4\u0bc1 \u0b85\u0b95\u0bb2\u0bae\u0bcd" },
            { "sbp", "\u0b9a\u0b99\u0bcd\u0b95\u0bc1" },
            { "lui", "\u0bb2\u0bc1\u0baf\u0bcd\u0b9a\u0bc7\u0ba9\u0bcb" },
            { "nyn", "\u0ba8\u0bbf\u0baf\u0bbe\u0ba9\u0bcd\u0b95\u0bcb\u0bb2\u0bc7" },
            { "nym", "\u0ba8\u0bbf\u0baf\u0bbe\u0bae\u0bcd\u0bb5\u0bc7\u0b9c\u0bbf" },
            { "lun", "\u0bb2\u0bc2\u0ba9\u0bcd\u0b9f\u0bbe" },
            { "nyo", "\u0ba8\u0bbf\u0baf\u0bcb\u0bb0\u0bcb" },
            { "luo", "\u0bb2\u0bc1\u0baf\u0bcb" },
            { "fil", "\u0b83\u0baa\u0bbf\u0bb2\u0bbf\u0baa\u0bbf\u0ba9\u0bcb" },
            { "hmn", "\u0bae\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "del", "\u0b9f\u0bc6\u0bb2\u0bbe\u0bb5\u0bb0\u0bcd" },
            { "lus", "\u0bae\u0bbf\u0bb8\u0bcb" },
            { "bal", "\u0baa\u0bb2\u0bc2\u0b9a\u0bcd\u0b9a\u0bbf" },
            { "den", "\u0bb8\u0bcd\u0bb2\u0bbe\u0bb5\u0bcd" },
            { "ban", "\u0baa\u0bb2\u0bbf\u0ba9\u0bc0\u0bb8\u0bcd" },
            { "uga", "\u0b89\u0b95\u0bbe\u0bb0\u0bbf\u0b9f\u0bbf\u0b95\u0bcd" },
            { "luy", "\u0bb2\u0bc1\u0baf\u0bbf\u0baf\u0bbe" },
            { "bas", "\u0baa\u0bbe\u0bb8\u0bbe" },
            { "jrb", "\u0b9c\u0bc2\u0ba4\u0bc7\u0baf\u0bcb-\u0b85\u0bb0\u0bbe\u0baa\u0bbf\u0b95\u0bcd" },
            { "es_ES", "\u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0bb8\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0bb7\u0bcd" },
            { "nzi", "\u0ba8\u0bbf\u0b9c\u0bcd\u0bae\u0bbe" },
            { "sco", "\u0bb8\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0bb8\u0bcd" },
            { "scn", "\u0b9a\u0bbf\u0b9a\u0bbf\u0bb2\u0bbf\u0baf\u0ba9\u0bcd" },
            { "aa", "\u0b85\u0b83\u0baa\u0bbe\u0bb0\u0bcd" },
            { "ab", "\u0b85\u0baa\u0bcd\u0b95\u0bbe\u0b9c\u0bbf\u0baf\u0bbe\u0ba9\u0bcd" },
            { "ae", metaValue_ae },
            { "af", "\u0b86\u0b83\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bbe\u0ba9\u0bcd\u0bb8\u0bcd" },
            { "ak", "\u0b85\u0b95\u0bbe\u0ba9\u0bcd" },
            { "am", "\u0b85\u0bae\u0bcd\u0bb9\u0bbe\u0bb0\u0bbf\u0b95\u0bcd" },
            { "Arab", metaValue_ar },
            { "an", "\u0b86\u0bb0\u0bcd\u0b95\u0bcb\u0ba9\u0bc0\u0bb8\u0bcd" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0baf \u0b8e\u0bb4\u0bc1\u0ba4\u0bcd\u0ba4\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bb3\u0bcd" },
            { "as", "\u0b85\u0bb8\u0bcd\u0bb8\u0bbe\u0bae\u0bc0\u0bb8\u0bcd" },
            { "Lina", "\u0bb2\u0bbf\u0ba9\u0bbf\u0baf\u0bb0\u0bcd \u0b8f" },
            { "av", "\u0b85\u0bb5\u0bc7\u0bb0\u0bbf\u0b95\u0bcd" },
            { "Linb", "\u0bb2\u0bbf\u0ba9\u0bbf\u0baf\u0bb0\u0bcd \u0baa\u0bbf" },
            { "sdh", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b95\u0bc1\u0bb0\u0bcd\u0ba4\u0bbf\u0bb7\u0bcd" },
            { "ay", "\u0b85\u0baf\u0bcd\u0bae\u0bb0\u0bbe" },
            { "az", "\u0b85\u0bb8\u0bb0\u0bcd\u0baa\u0bc8\u0b9c\u0bbe\u0ba9\u0bbf" },
            { "ba", "\u0baa\u0bb7\u0bcd\u0b95\u0bbf\u0bb0\u0bcd" },
            { "type.co.unihan", "\u0bb0\u0bc7\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0bb8\u0bcd\u0b9f\u0bcd\u0bb0\u0bcb\u0b95\u0bcd \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "be", "\u0baa\u0bc6\u0bb2\u0bbe\u0bb0\u0bc1\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "bg", "\u0baa\u0bb2\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0ba9\u0bcd" },
            { "bi", "\u0baa\u0bbf\u0bb8\u0bcd\u0bb2\u0bbe\u0bae\u0bbe" },
            { "bm", "\u0baa\u0bae\u0bcd\u0baa\u0bbe\u0bb0\u0bbe" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u0b9f\u0bcb\u0b95\u0bcd\u0bb0\u0bbf\u0baa\u0bcd" },
            { "br", "\u0baa\u0bbf\u0bb0\u0bc6\u0b9f\u0bcd\u0b9f\u0ba9\u0bcd" },
            { "bs", "\u0baa\u0bcb\u0bb8\u0bcd\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Mymr", "\u0bae\u0bbf\u0baf\u0bbe\u0ba9\u0bcd\u0bae\u0bb0\u0bcd" },
            { "type.nu.laoo", "\u0bb2\u0bbe\u0bb5\u0bcb \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "seh", "\u0b9a\u0bc6\u0ba9\u0bbe" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0b9a\u0bc6\u0bb2\u0bcd\u0b95\u0bc1\u0baa\u0bcd" },
            { "ca", "\u0b95\u0bc7\u0b9f\u0bcd\u0b9f\u0bb2\u0bbe\u0ba9\u0bcd" },
            { "ses", "\u0b95\u0bca\u0baf\u0bcd\u0bb0\u0bbe\u0baa\u0bcb\u0bb0\u0bcb \u0b9a\u0bc6\u0ba9\u0bcd\u0ba9\u0bbf" },
            { "ce", "\u0b9a\u0bc6\u0b9a\u0bcd\u0b9a\u0bc6\u0ba9\u0bcd" },
            { "ch", "\u0b9a\u0bbe\u0bae\u0bcb\u0bb0\u0bcb" },
            { "co", "\u0b95\u0bbe\u0bb0\u0bcd\u0b9a\u0bbf\u0b95\u0ba9\u0bcd" },
            { "Orya", metaValue_or },
            { "cr", "\u0b95\u0bcd\u0bb0\u0bc0" },
            { "cs", "\u0b9a\u0bc6\u0b95\u0bcd" },
            { "cu", "\u0b9a\u0bb0\u0bcd\u0b9a\u0bcd \u0bb8\u0bcd\u0bb2\u0bbe\u0bb5\u0bbf\u0b95\u0bcd" },
            { "cv", "\u0b9a\u0bc1\u0bb5\u0bbe\u0bb7\u0bcd" },
            { "cy", "\u0bb5\u0bc7\u0bb2\u0bcd\u0bb7\u0bcd" },
            { "type.nu.ethi", "\u0b8e\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "Yiii", "\u0baf\u0bc0" },
            { "da", "\u0b9f\u0bc7\u0ba9\u0bbf\u0bb7\u0bcd" },
            { "pt_PT", "\u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0baa\u0bcb\u0bb0\u0bcd\u0b9a\u0bcd\u0b9a\u0bc1\u0b95\u0bc0\u0bb8\u0bcd" },
            { "de", "\u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd" },
            { "type.cf.standard", "\u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bbe\u0ba3\u0baf \u0bb5\u0b9f\u0bbf\u0bb5\u0bae\u0bcd" },
            { "bej", "\u0baa\u0bc7\u0b9c\u0bbe" },
            { "din", "\u0b9f\u0bbf\u0ba9\u0bcd\u0b95\u0bbe" },
            { "Bugi", metaValue_bug },
            { "bem", "\u0baa\u0bc6\u0bae\u0bcd\u0baa\u0bbe" },
            { "sga", "\u0baa\u0bb4\u0bc8\u0baf \u0b90\u0bb0\u0bbf\u0bb7\u0bcd" },
            { "type.nu.mong", "\u0bae\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "dv", "\u0ba4\u0bbf\u0bb5\u0bc7\u0bb9\u0bbf" },
            { "es_419", "\u0bb2\u0ba4\u0bcd\u0ba4\u0bbf\u0ba9\u0bcd \u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0bb8\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0bb7\u0bcd" },
            { "dz", "\u0baa\u0bc2\u0b9f\u0bbe\u0ba9\u0bbf" },
            { "bez", "\u0baa\u0bc6\u0ba9\u0bbe" },
            { "type.ca.chinese", "\u0b9a\u0bc0\u0ba9 \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "dje", "\u0bb8\u0bbe\u0bb0\u0bcd\u0bae\u0bbe" },
            { "type.nu.grek", "\u0b95\u0bbf\u0bb0\u0bc0\u0b95\u0bcd \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "ee", "\u0b88\u0bb5\u0bcd" },
            { "type.lb.normal", "\u0b9a\u0bbe\u0ba4\u0bbe\u0bb0\u0ba3 \u0bb5\u0bb0\u0bbf \u0bae\u0bc1\u0bb1\u0bbf\u0baa\u0bcd\u0baa\u0bc1 \u0bb8\u0bcd\u0b9f\u0bc8\u0bb2\u0bcd" },
            { "ro_MD", "\u0bae\u0bcb\u0bb2\u0bcd\u0b9f\u0bbe\u0bb5\u0bbf\u0baf\u0ba9\u0bcd" },
            { "el", metaValue_el },
            { "en", "\u0b86\u0b99\u0bcd\u0b95\u0bbf\u0bb2\u0bae\u0bcd" },
            { "eo", "\u0b8e\u0bb8\u0bcd\u0baa\u0bb0\u0bc7\u0ba9\u0bcd\u0b9f\u0bcb" },
            { "bfq", "\u0baa\u0b9f\u0b95\u0bbe" },
            { "type.co.big5han", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0b9a\u0bc0\u0ba9 \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bb5\u0b9f\u0bbf\u0bb5\u0bae\u0bcd - Big5" },
            { "es", "\u0bb8\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0bb7\u0bcd" },
            { "et", "\u0b8e\u0bb8\u0bcd\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Hanb", "\u0bb9\u0ba9\u0bcd\u0baa\u0bcd" },
            { "eu", "\u0baa\u0bbe\u0bb8\u0bcd\u0b95\u0bcd" },
            { "Buhd", "\u0baa\u0bc1\u0b95\u0bbf\u0ba4\u0bcd" },
            { "Hang", "\u0bb9\u0b99\u0bcd\u0b95\u0bc1\u0bb2\u0bcd" },
            { "Samr", "\u0b9a\u0bae\u0bbe\u0bb0\u0bbf\u0b9f\u0ba9\u0bcd" },
            { "shi", "\u0ba4\u0b9a\u0bc7\u0bb9\u0bbf\u0ba4\u0bcd" },
            { "hsb", "\u0b85\u0baa\u0bcd\u0baa\u0bb0\u0bcd \u0b9a\u0bcb\u0bb0\u0bcd\u0baa\u0bbf\u0baf\u0bbe\u0ba9\u0bcd" },
            { "Hani", "\u0bb9\u0ba9\u0bcd" },
            { "shn", "\u0bb7\u0bbe\u0ba9\u0bcd" },
            { "Hano", "\u0bb9\u0ba9\u0bc1\u0ba9\u0bc2" },
            { "fa", "\u0baa\u0bc6\u0bb0\u0bcd\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Hans", "\u0b8e\u0bb3\u0bbf\u0ba4\u0bbe\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f\u0ba4\u0bc1" },
            { "type.nu.latn", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "Hant", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf\u0bae\u0bcd" },
            { "ff", "\u0b83\u0baa\u0bc1\u0bb2\u0bbe" },
            { "hsn", "\u0b9a\u0bbf\u0baf\u0bbe\u0b99\u0bcd\u0b95\u0bcd \u0b9a\u0bc0\u0ba9\u0bae\u0bcd" },
            { "fi", "\u0b83\u0baa\u0bbf\u0ba9\u0bcd\u0ba9\u0bbf\u0bb7\u0bcd" },
            { "fj", "\u0b83\u0baa\u0bbf\u0b9c\u0bbf\u0baf\u0ba9\u0bcd" },
            { "fon", "\u0b83\u0baa\u0bbe\u0ba9\u0bcd" },
            { "bgn", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0baa\u0bb2\u0bcb\u0b9a\u0bcd\u0b9a\u0bbf" },
            { "yue", "\u0b95\u0bbe\u0ba3\u0bcd\u0b9f\u0bcb\u0ba9\u0bc0\u0bb8\u0bcd" },
            { "fo", "\u0b83\u0baa\u0bb0\u0bcb\u0baf\u0bbf\u0bb8\u0bcd" },
            { "type.m0.bgn", "\u0baf\u0bc2\u0b8e\u0bb8\u0bcd \u0baa\u0bbf\u0b9c\u0bbf\u0b8e\u0ba9\u0bcd \u0b92\u0bb2\u0bbf\u0baa\u0bc6\u0baf\u0bb0\u0bcd\u0baa\u0bcd\u0baa\u0bc1" },
            { "umb", "\u0b85\u0bae\u0bcd\u0baa\u0bca\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "fr", "\u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1" },
            { "sid", "\u0b9a\u0bbf\u0b9f\u0bbe\u0bae\u0bcb" },
            { "fy", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b83\u0baa\u0bcd\u0bb0\u0bbf\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "ga", "\u0b90\u0bb0\u0bbf\u0bb7\u0bcd" },
            { "gd", "\u0bb8\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0bb8\u0bcd \u0b95\u0bc7\u0bb2\u0bbf\u0b95\u0bcd" },
            { "gl", "\u0b95\u0bbe\u0bb2\u0bbf\u0bb8\u0bbf\u0baf\u0ba9\u0bcd" },
            { "gn", "\u0b95\u0bcd\u0bb5\u0bbe\u0bb0\u0ba9\u0bbf" },
            { "bho", "\u0baa\u0bcb\u0b9c\u0bcd\u0baa\u0bc2\u0bb0\u0bbf" },
            { "und", "\u0b85\u0bb1\u0bbf\u0baf\u0baa\u0bcd\u0baa\u0b9f\u0bbe\u0ba4 \u0bae\u0bca\u0bb4\u0bbf" },
            { "type.ca.ethiopic-amete-alem", "\u0b8e\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0bcb\u0baa\u0bbf\u0b95\u0bcd \u0b85\u0bae\u0bc7\u0ba4\u0bc7 \u0b86\u0bb2\u0bc6\u0bae\u0bcd \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "gu", metaValue_gu },
            { "gv", "\u0bae\u0bc7\u0b99\u0bcd\u0b95\u0bcd\u0bb8\u0bcd" },
            { "ha", "\u0bb9\u0bcc\u0bb8\u0bbe" },
            { "he", "\u0bb9\u0bc0\u0baa\u0bcd\u0bb0\u0bc2" },
            { "hi", "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf" },
            { "hup", "\u0bb9\u0bc1\u0baa\u0bbe" },
            { "bik", "\u0baa\u0bbf\u0b95\u0bcb\u0bb2\u0bcd" },
            { "bin", "\u0baa\u0bbf\u0ba9\u0bbf" },
            { "ho", "\u0bb9\u0bbf\u0bb0\u0bbf \u0bae\u0bcb\u0b9f\u0bcd\u0b9f\u0bc1" },
            { "hr", "\u0b95\u0bc1\u0bb0\u0bcb\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "ht", "\u0bb9\u0bc8\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bcd\u0bb0\u0bbf\u0baf\u0bcb\u0bb2\u0bbf" },
            { "hu", "\u0bb9\u0b99\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0ba9\u0bcd" },
            { "hy", "\u0b86\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "hz", "\u0bb9\u0bc6\u0bb0\u0bc7\u0bb0\u0bcb" },
            { "frc", "\u0b95\u0b9c\u0bc1\u0ba9\u0bcd \u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1" },
            { "ia", "\u0b87\u0ba9\u0bcd\u0b9f\u0bb0\u0bcd\u0bb2\u0bbf\u0b99\u0bcd\u0bb5\u0bbe" },
            { "Jamo", "\u0b9c\u0bae\u0bcb" },
            { "id", "\u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "type.nu.tibt", "\u0ba4\u0bbf\u0baa\u0bc6\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "ie", "\u0b87\u0ba9\u0bcd\u0b9f\u0bb0\u0bcd\u0bb2\u0bbf\u0b99\u0bcd" },
            { "ig", "\u0b87\u0b95\u0bcd\u0baa\u0bcb" },
            { "ii", "\u0b9a\u0bbf\u0b9a\u0bc1\u0bb5\u0bbe\u0ba9\u0bcd \u0b88" },
            { "frm", "\u0bae\u0bbf\u0b9f\u0bbf\u0bb2\u0bcd \u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1" },
            { "ik", "\u0b87\u0ba9\u0bc1\u0baa\u0bbf\u0baf\u0bbe\u0b95\u0bcd" },
            { "fro", "\u0baa\u0bb4\u0bc8\u0baf \u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1" },
            { "io", "\u0b87\u0b9f\u0bcb" },
            { "frs", "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b83\u0baa\u0bcd\u0bb0\u0bbf\u0bb8\u0bbf\u0baf\u0bbe\u0ba9\u0bcd" },
            { "frr", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0b83\u0baa\u0bcd\u0bb0\u0bbf\u0bb8\u0bbf\u0baf\u0bbe\u0ba9\u0bcd" },
            { "is", "\u0b90\u0bb8\u0bcd\u0bb2\u0bc7\u0ba3\u0bcd\u0b9f\u0bbf\u0b95\u0bcd" },
            { "it", "\u0b87\u0ba4\u0bcd\u0ba4\u0bbe\u0bb2\u0bbf\u0baf\u0ba9\u0bcd" },
            { "iu", "\u0b87\u0ba9\u0bc1\u0b95\u0bbf\u0b9f\u0bc2\u0b9f\u0bcd" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "\u0b9a\u0bbe\u0bb0\u0bbe\u0ba4\u0bbf" },
            { "doi", "\u0b9f\u0bcb\u0b95\u0bcd\u0bb0\u0bbf" },
            { "sma", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bae\u0bbf" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0bb7\u0bb5\u0bbf\u0baf\u0bbe\u0ba9\u0bcd" },
            { "mad", "\u0bae\u0ba4\u0bc1\u0bb0\u0bc0\u0bb8\u0bcd" },
            { "smj", "\u0bb2\u0bc1\u0bb2\u0bc7 \u0b9a\u0bae\u0bbf" },
            { "mag", "\u0bae\u0b95\u0bbe\u0bb9\u0bbf" },
            { "mai", "\u0bae\u0bc8\u0ba4\u0bbf\u0bb2\u0bbf" },
            { "smn", "\u0b87\u0ba9\u0bbe\u0bb0\u0bbf \u0b9a\u0bae\u0bbf" },
            { "ka", metaValue_ka },
            { "bla", "\u0b9a\u0bbf\u0b95\u0bcd\u0b9a\u0bbf\u0b95\u0bbe" },
            { "mak", "\u0bae\u0b95\u0bbe\u0b9a\u0bbe\u0bb0\u0bcd" },
            { "wuu", "\u0bb5\u0bc2 \u0b9a\u0bc0\u0ba9\u0bae\u0bcd" },
            { "sms", "\u0bb8\u0bcd\u0b95\u0bcb\u0bb2\u0bcd\u0b9f\u0bcd \u0b9a\u0bae\u0bbf" },
            { "man", "\u0bae\u0bbe\u0ba9\u0bcd\u0b9f\u0bbf\u0b99\u0bcd\u0b95\u0bcb" },
            { "kg", "\u0b95\u0bbe\u0b99\u0bcd\u0b95\u0bcb" },
            { "Goth", metaValue_got },
            { "ki", "\u0b95\u0bbf\u0b95\u0bc1\u0baf\u0bc2" },
            { "mas", "\u0bae\u0bbe\u0b9a\u0bbe\u0baf\u0bcd" },
            { "kj", "\u0b95\u0bc1\u0bb5\u0bbe\u0ba9\u0bcd\u0baf\u0bbe\u0bae\u0bbe" },
            { "kk", "\u0b95\u0b9a\u0bbe\u0b95\u0bcd" },
            { "kl", "\u0b95\u0bb2\u0bbe\u0bb2\u0bbf\u0b9a\u0bc2\u0b9f\u0bcd" },
            { "km", "\u0b95\u0bc6\u0bae\u0bc6\u0bb0\u0bcd" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0b95\u0ba9\u0bc1\u0bb0\u0bbf" },
            { "ks", "\u0b95\u0bbe\u0bb7\u0bcd\u0bae\u0bbf\u0bb0\u0bbf" },
            { "Cirt", "\u0b95\u0bbf\u0bb0\u0bcd\u0ba4\u0bcd" },
            { "Lepc", "\u0bb2\u0bc6\u0baa\u0bcd\u0b9a\u0bbe" },
            { "Avst", metaValue_ae },
            { "ku", "\u0b95\u0bc1\u0bb0\u0bcd\u0ba4\u0bbf\u0bb7\u0bcd" },
            { "kv", "\u0b95\u0bca\u0bae\u0bbf" },
            { "kw", "\u0b95\u0bbe\u0bb0\u0bcd\u0ba9\u0bbf\u0bb7\u0bcd" },
            { "ky", "\u0b95\u0bbf\u0bb0\u0bcd\u0b95\u0bbf\u0bb8\u0bcd" },
            { "snk", "\u0b9a\u0bcb\u0ba9\u0bbf\u0ba9\u0bcd\u0b95\u0bc7" },
            { "la", metaValue_la },
            { "lb", "\u0bb2\u0b95\u0bcd\u0bb8\u0bae\u0bcd\u0baa\u0bcb\u0bb0\u0bcd\u0b95\u0bbf\u0bb7\u0bcd" },
            { "type.nu.mlym", "\u0bae\u0bb2\u0bc8\u0baf\u0bbe\u0bb3 \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "lg", "\u0b95\u0bbe\u0ba9\u0bcd\u0b9f\u0bbe" },
            { "Roro", "\u0bb0\u0bca\u0b99\u0bcd\u0b95\u0bcb\u0bb0\u0bca\u0b99\u0bcd\u0b95\u0bcb" },
            { "li", "\u0bb2\u0bbf\u0bae\u0bcd\u0baa\u0bb0\u0bcd\u0b95\u0bbf\u0bb7\u0bcd" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0bb2\u0bbf\u0b99\u0bcd\u0b95\u0bbe\u0bb2\u0bbe" },
            { "fur", "\u0b83\u0baa\u0bcd\u0bb0\u0bbf\u0baf\u0bc2\u0bb2\u0bbf\u0baf\u0ba9\u0bcd" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0b87\u0bae\u0bcd\u0baa\u0bc0\u0bb0\u0bbf\u0baf\u0bb2\u0bcd \u0b85\u0bb3\u0bb5\u0bc0\u0b9f\u0bcd\u0b9f\u0bc1 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "lt", "\u0bb2\u0bbf\u0ba4\u0bc1\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "lu", "\u0bb2\u0bc1\u0baa\u0bbe-\u0b95\u0b9f\u0bbe\u0b99\u0bcd\u0b95\u0bbe" },
            { "lv", "\u0bb2\u0bbe\u0b9f\u0bcd\u0bb5\u0bbf\u0baf\u0ba9\u0bcd" },
            { "sog", "\u0b9a\u0bcb\u0b95\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd" },
            { "mg", "\u0bae\u0bb2\u0b95\u0bbe\u0bb8\u0bbf" },
            { "mh", "\u0bae\u0bbe\u0bb0\u0bcd\u0bb7\u0bc6\u0bb2\u0bc0\u0bb8\u0bcd" },
            { "type.co.ducet", "\u0b87\u0baf\u0bb2\u0bcd\u0baa\u0bc1\u0ba8\u0bbf\u0bb2\u0bc8 \u0baf\u0bc1\u0ba9\u0bbf\u0b95\u0bcb\u0b9f\u0bcd \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "mi", "\u0bae\u0bcc\u0bb0\u0bbf" },
            { "mk", "\u0bae\u0bbe\u0bb8\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u0bae\u0bb0\u0bbe\u0ba4\u0bcd\u0ba4\u0bbf" },
            { "ms", "\u0bae\u0bb2\u0bbe\u0baf\u0bcd" },
            { "mt", "\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bbf\u0bb8\u0bcd" },
            { "my", "\u0baa\u0bb0\u0bcd\u0bae\u0bc0\u0bb8\u0bcd" },
            { "Saur", "\u0b9a\u0bcc\u0bb0\u0bbe\u0bb7\u0bcd\u0b9f\u0bcd\u0bb0\u0bbe" },
            { "Armn", "\u0b85\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "mdf", "\u0bae\u0bcb\u0b95\u0bcd\u0b95\u0bcd\u0bb7\u0bbe" },
            { "dsb", "\u0bb2\u0bcb\u0baf\u0bb0\u0bcd \u0b9a\u0bcb\u0bb0\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Armi", "\u0b87\u0bae\u0bcd\u0baa\u0bc7\u0bb0\u0bbf\u0baf\u0bb2\u0bcd \u0b85\u0bb0\u0bae\u0bc6\u0baf\u0bcd\u0b95\u0bcd" },
            { "na", "\u0ba8\u0bb5\u0bcd\u0bb0\u0bc2" },
            { "type.co.search", "\u0baa\u0bca\u0ba4\u0bc1\u0baa\u0bcd\u0baa\u0b9f\u0bc8\u0baf\u0bbe\u0ba9 \u0ba4\u0bc7\u0b9f\u0bb2\u0bcd" },
            { "nb", "\u0ba8\u0bbe\u0bb0\u0bcd\u0bb5\u0bc7\u0b9c\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0bca\u0b95\u0bcd\u0bae\u0bbe\u0bb2\u0bcd" },
            { "nd", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0ba4\u0bc6\u0baa\u0bc6\u0bb2\u0bc7" },
            { "ne", "\u0ba8\u0bc7\u0baa\u0bbe\u0bb3\u0bbf" },
            { "ng", "\u0ba4\u0bcb\u0b99\u0bcd\u0b95\u0bbe" },
            { "mdr", "\u0bae\u0bbe\u0ba9\u0bcd\u0b9f\u0bbe\u0bb0\u0bcd" },
            { "nl", "\u0b9f\u0b9a\u0bcd\u0b9a\u0bc1" },
            { "nn", "\u0ba8\u0bbe\u0bb0\u0bcd\u0bb5\u0bc7\u0b9c\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bbf\u0baf\u0bc2\u0ba8\u0bbe\u0bb0\u0bcd\u0bb8\u0bcd\u0b95\u0bcd" },
            { "no", "\u0ba8\u0bbe\u0bb0\u0bcd\u0bb5\u0bc7\u0b9c\u0bbf\u0baf\u0ba9\u0bcd" },
            { "nr", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0ba4\u0bc6\u0baa\u0bc6\u0bb2\u0bc7" },
            { "nv", "\u0ba8\u0bb5\u0bbe\u0b9c\u0bcb" },
            { "kaa", "\u0b95\u0bbe\u0bb0\u0bbe-\u0b95\u0bb2\u0bcd\u0baa\u0bbe\u0b95\u0bcd" },
            { "ny", "\u0ba8\u0baf\u0ba9\u0bcd\u0b9c\u0bbe" },
            { "kac", "\u0b95\u0bbe\u0b9a\u0bbf\u0ba9\u0bcd" },
            { "kab", "\u0b95\u0baa\u0bbe\u0baf\u0bcd\u0bb2\u0bcd" },
            { "oc", "\u0b92\u0b95\u0bcd\u0b95\u0bbf\u0b9f\u0ba9\u0bcd" },
            { "kaj", "\u0b9c\u0bcd\u0b9c\u0bc2" },
            { "kam", "\u0b95\u0bae\u0bcd\u0baa\u0bbe" },
            { "men", "\u0bae\u0bc6\u0ba9\u0bcd\u0b9f\u0bc0" },
            { "oj", "\u0b92\u0b9c\u0bbf\u0baa\u0bcd\u0bb5\u0bbe" },
            { "mer", "\u0bae\u0bc6\u0bb0\u0bc1" },
            { "type.nu.armn", "\u0b86\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "om", "\u0b92\u0bb0\u0bcb\u0bae\u0bcb" },
            { "kaw", "\u0b95\u0bbe\u0bb5\u0bbf" },
            { "or", metaValue_or },
            { "os", "\u0b92\u0b9a\u0bc6\u0b9f\u0bcd\u0b9f\u0bbf\u0b95\u0bcd" },
            { "bpy", "\u0baa\u0bbf\u0bb7\u0bcd\u0ba3\u0bc1\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0baf\u0bbe" },
            { "kbd", "\u0b95\u0baa\u0bbe\u0bb0\u0bcd\u0b9f\u0bbf\u0baf\u0ba9\u0bcd" },
            { "mfe", "\u0bae\u0bca\u0bb0\u0bbf\u0b9a\u0bbf\u0baf\u0ba9\u0bcd" },
            { "srn", "\u0bb8\u0bcd\u0bb0\u0bbe\u0ba9\u0ba9\u0bcd \u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0bcb" },
            { "pa", "\u0baa\u0b9e\u0bcd\u0b9a\u0bbe\u0baa\u0bbf" },
            { "dua", "\u0b9f\u0bc1\u0bb5\u0bbe\u0bb2\u0bbe" },
            { "srr", "\u0b9a\u0bc6\u0bb0\u0bc6\u0bb0\u0bcd" },
            { "pi", "\u0baa\u0bbe\u0bb2\u0bbf" },
            { "pl", "\u0baa\u0bcb\u0bb2\u0bbf\u0bb7\u0bcd" },
            { "dum", "\u0bae\u0bbf\u0b9f\u0bbf\u0bb2\u0bcd \u0b9f\u0b9a\u0bcd\u0b9a\u0bc1" },
            { "type.ca.dangi", "\u0b9f\u0bc7\u0b99\u0bcd\u0b95\u0bbf \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "ps", "\u0baa\u0bb7\u0bcd\u0ba4\u0bcb" },
            { "pt", "\u0baa\u0bcb\u0bb0\u0bcd\u0b9a\u0bcd\u0b9a\u0bc1\u0b95\u0bcd\u0b95\u0bc0\u0bb8\u0bcd" },
            { "mga", "\u0bae\u0bbf\u0b9f\u0bbf\u0bb2\u0bcd \u0b90\u0bb0\u0bbf\u0bb7\u0bcd" },
            { "key.co", "\u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "pt_BR", "\u0baa\u0bbf\u0bb0\u0bc7\u0b9a\u0bbf\u0bb2\u0bbf\u0baf \u0baa\u0bcb\u0bb0\u0bcd\u0b9a\u0bcd\u0b9a\u0bc1\u0b95\u0bc0\u0bb8\u0bcd" },
            { "kcg", "\u0ba4\u0bc8\u0baf\u0bbe\u0baa\u0bcd" },
            { "mgh", "\u0bae\u0b95\u0bc1\u0bb5\u0bbe-\u0bae\u0bc0\u0b9f\u0bcd\u0b9f\u0bcb" },
            { "key.cf", "\u0ba8\u0bbe\u0ba3\u0baf \u0bb5\u0b9f\u0bbf\u0bb5\u0bae\u0bcd" },
            { "bra", "\u0baa\u0bcd\u0bb0\u0bbe\u0b9c\u0bcd" },
            { "key.ca", "\u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0bae\u0bc7\u0b9f\u0bbe" },
            { "type.hc.h23", "24 \u0bae\u0ba3\u0bbf\u0ba8\u0bc7\u0bb0 \u0bae\u0bc1\u0bb1\u0bc8\u0bae\u0bc8 (0\u201323)" },
            { "type.hc.h24", "24 \u0bae\u0ba3\u0bbf\u0ba8\u0bc7\u0bb0 \u0bae\u0bc1\u0bb1\u0bc8\u0bae\u0bc8 (1\u201324)" },
            { "ssy", "\u0b9a\u0bb9\u0bcb" },
            { "type.nu.mymr", "\u0bae\u0bbf\u0baf\u0bbe\u0ba9\u0bcd\u0bae\u0bb0\u0bcd \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "qu", "\u0b95\u0bcd\u0bb5\u0bc6\u0b9a\u0bcd\u0b9a\u0bc1\u0bb5\u0bbe" },
            { "zap", "\u0b9c\u0bbe\u0baa\u0bcb\u0b9f\u0bc6\u0b95\u0bcd" },
            { "brx", "\u0baa\u0bcb\u0b9f\u0bcb" },
            { "Lana", "\u0bb2\u0ba9\u0bcd\u0ba9\u0bbe" },
            { "kde", "\u0bae\u0b95\u0bca\u0ba3\u0bcd\u0b9f\u0bc7" },
            { "Ethi", "\u0b8e\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0bcb\u0baa\u0bbf\u0b95\u0bcd" },
            { "type.hc.h12", "12 \u0bae\u0ba3\u0bbf\u0ba8\u0bc7\u0bb0 \u0bae\u0bc1\u0bb1\u0bc8\u0bae\u0bc8 (1\u201312)" },
            { "type.hc.h11", "12 \u0bae\u0ba3\u0bbf\u0ba8\u0bc7\u0bb0 \u0bae\u0bc1\u0bb1\u0bc8\u0bae\u0bc8 (0\u201311)" },
            { "rm", "\u0bb0\u0bcb\u0bae\u0bbe\u0ba9\u0bcd\u0bb7\u0bcd" },
            { "rn", "\u0bb0\u0bc1\u0ba3\u0bcd\u0b9f\u0bbf" },
            { "key.cu", "\u0ba8\u0bbe\u0ba3\u0baf\u0bae\u0bcd" },
            { "ro", "\u0bb0\u0bcb\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "type.nu.orya", "\u0b92\u0b9f\u0bbf\u0baf\u0bbe \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "type.nu.hanidec", "\u0b9a\u0bc0\u0ba9 \u0baa\u0bbf\u0ba9\u0bcd\u0ba9 \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "ru", "\u0bb0\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "rw", "\u0b95\u0bbf\u0ba9\u0bcd\u0baf\u0bbe\u0bb0\u0bc1\u0bb5\u0bbe\u0ba9\u0bcd\u0b9f\u0bbe" },
            { "zbl", "\u0baa\u0bcd\u0bb2\u0bbf\u0bb8\u0bcd\u0bb8\u0bbf\u0bae\u0bcd\u0baa\u0bbe\u0bb2\u0bcd\u0bb8\u0bcd" },
            { "kea", "\u0b95\u0baa\u0bc1\u0bb5\u0bc6\u0bb0\u0bcd\u0ba4\u0bbf\u0baf\u0bbe\u0ba9\u0bc1" },
            { "mic", "\u0bae\u0bbf\u0b95\u0bcd\u0bae\u0bbe\u0b95\u0bcd" },
            { "suk", "\u0b9a\u0bc1\u0b95\u0bc1\u0bae\u0bbe" },
            { "en_AU", "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf \u0b86\u0b99\u0bcd\u0b95\u0bbf\u0bb2\u0bae\u0bcd" },
            { "sa", "\u0b9a\u0bae\u0bb8\u0bcd\u0b95\u0bbf\u0bb0\u0bc1\u0ba4\u0bae\u0bcd" },
            { "sc", "\u0b9a\u0bbe\u0bb0\u0bcd\u0ba4\u0bc0\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "sus", "\u0b9a\u0bc1\u0b9a\u0bc1" },
            { "sd", "\u0b9a\u0bbf\u0ba8\u0bcd\u0ba4\u0bbf" },
            { "se", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0b9a\u0bae\u0bbf" },
            { "min", "\u0bae\u0bbf\u0ba9\u0bcd\u0ba9\u0bbe\u0b99\u0bcd\u0b95\u0baa\u0bcc" },
            { "sg", "\u0b9a\u0bbe\u0b99\u0bcd\u0b95\u0bcb" },
            { "sh", "\u0b9a\u0bc6\u0bb0\u0bcd\u0baa\u0bcb-\u0b95\u0bc1\u0bb0\u0bcb\u0bb7\u0bbf\u0baf\u0ba9\u0bcd" },
            { "si", metaValue_si },
            { "sux", "\u0b9a\u0bc1\u0bae\u0bc7\u0bb0\u0bbf\u0baf\u0ba9\u0bcd" },
            { "sk", "\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bbe\u0b95\u0bcd" },
            { "sl", "\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "sm", "\u0b9a\u0bae\u0bcb\u0bb5\u0bbe\u0ba9\u0bcd" },
            { "sn", "\u0bb7\u0bcb\u0ba9\u0bbe" },
            { "so", "\u0b9a\u0bcb\u0bae\u0bbe\u0bb2\u0bbf" },
            { "type.nu.arab", "\u0b85\u0bb0\u0baa\u0bbf\u0baf-\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "sq", "\u0b85\u0bb2\u0bcd\u0baa\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "sr", "\u0b9a\u0bc6\u0bb0\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd" },
            { "ss", "\u0bb8\u0bcd\u0bb5\u0bbe\u0b9f\u0bc0" },
            { "type.cf.account", "\u0b95\u0ba3\u0b95\u0bcd\u0b95\u0bbf\u0b9f\u0bb2\u0bcd \u0ba8\u0bbe\u0ba3\u0baf \u0bb5\u0b9f\u0bbf\u0bb5\u0bae\u0bcd" },
            { "Java", metaValue_jv },
            { "st", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0bb8\u0bcb\u0ba4\u0bcb" },
            { "su", "\u0b9a\u0bc1\u0ba3\u0bcd\u0b9f\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd" },
            { "sv", "\u0bb8\u0bcd\u0bb5\u0bc0\u0b9f\u0bbf\u0bb7\u0bcd" },
            { "sw", "\u0bb8\u0bcd\u0bb5\u0bbe\u0bb9\u0bbf\u0bb2\u0bbf" },
            { "type.nu.hantfin", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0b9a\u0bc0\u0ba9 \u0ba8\u0bbf\u0ba4\u0bbf \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "ibb", "\u0b87\u0baa\u0bbf\u0baa\u0bbf\u0baf\u0bcb" },
            { "iba", "\u0b87\u0baa\u0bbe\u0ba9\u0bcd" },
            { "ta", metaValue_ta },
            { "142", "\u0b86\u0b9a\u0bbf\u0baf\u0bbe" },
            { "bua", "\u0baa\u0bc1\u0bb0\u0bbf\u0baf\u0bbe\u0ba4\u0bcd" },
            { "143", "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0b9a\u0bbf\u0baf\u0bbe" },
            { "te", metaValue_te },
            { "145", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bbe\u0b9a\u0bbf\u0baf\u0bbe" },
            { "tg", "\u0ba4\u0b9c\u0bbf\u0b95\u0bcd" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "\u0b9f\u0bbf\u0b95\u0bcd\u0bb0\u0bbf\u0ba9\u0bcd\u0baf\u0bbe" },
            { "kfo", "\u0b95\u0bcb\u0bb0\u0bcb" },
            { "en_CA", "\u0b95\u0ba9\u0b9f\u0bbf\u0baf \u0b86\u0b99\u0bcd\u0b95\u0bbf\u0bb2\u0bae\u0bcd" },
            { "tk", "\u0ba4\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0bae\u0bc6\u0ba9\u0bcd" },
            { "tl", "\u0b9f\u0bbe\u0b95\u0bbe\u0bb2\u0bcb\u0b95\u0bcd" },
            { "tn", "\u0bb8\u0bcd\u0bb5\u0bbe\u0ba9\u0bbe" },
            { "to", "\u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0bbe\u0ba9\u0bcd" },
            { "dyo", "\u0b9c\u0bcb\u0bb2\u0bbe-\u0b83\u0baa\u0bcb\u0ba9\u0bcd\u0baf\u0bbf" },
            { "type.nu.jpan", "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0baf \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "tr", "\u0ba4\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bbf\u0bb7\u0bcd" },
            { "ts", "\u0bb8\u0bcb\u0b99\u0bcd\u0b95\u0bbe" },
            { "swb", "\u0b95\u0bca\u0bae\u0bcb\u0bb0\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Cakm", "\u0b9a\u0b95\u0bcd\u0bae\u0bbe" },
            { "tt", "\u0b9f\u0bbe\u0b9f\u0bb0\u0bcd" },
            { "dyu", "\u0b9f\u0bcd\u0baf\u0bc2\u0bb2\u0bbe" },
            { "tw", "\u0b9f\u0bcd\u0bb5\u0bbf" },
            { "ty", "\u0ba4\u0bb9\u0bbf\u0ba4\u0bbf\u0baf\u0ba9\u0bcd" },
            { "150", "\u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbe" },
            { "151", "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbe" },
            { "154", "\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbe" },
            { "dzg", "\u0b9f\u0b9a\u0bbe\u0b95\u0bbe" },
            { "155", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbe" },
            { "ug", "\u0b89\u0baf\u0bcd\u0b95\u0bc1\u0bb0\u0bcd" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0baa\u0bb4\u0bc8\u0baf \u0b87\u0ba4\u0bcd\u0ba4\u0bbe\u0bb2\u0bbf" },
            { "Zyyy", "\u0baa\u0bca\u0ba4\u0bc1" },
            { "uk", "\u0b89\u0b95\u0bcd\u0bb0\u0bc8\u0ba9\u0bbf\u0baf\u0ba9\u0bcd" },
            { "type.ca.coptic", "\u0b95\u0bbe\u0baa\u0bcd\u0b9f\u0bbf\u0b95\u0bcd \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "ur", "\u0b89\u0bb0\u0bc1\u0ba4\u0bc1" },
            { "xal", "\u0b95\u0bb2\u0bcd\u0bae\u0bbf\u0b95\u0bcd" },
            { "zen", "\u0b9c\u0bc6\u0ba9\u0b95\u0bbe" },
            { "uz", "\u0b89\u0bb8\u0bcd\u0baa\u0bc6\u0b95\u0bcd" },
            { "kha", "\u0b95\u0bbe\u0bb8\u0bbf" },
            { "nds_NL", "\u0bb2\u0bcb \u0b9a\u0bbe\u0b95\u0bcd\u0bb8\u0ba9\u0bcd" },
            { "Sylo", "\u0b9a\u0bbf\u0bb2\u0bcb\u0b9f\u0bbf \u0ba8\u0b95\u0bcd\u0bb0\u0bbf" },
            { "ve", "\u0bb5\u0bc6\u0ba9\u0bcd\u0b9f\u0bbe" },
            { "type.ca.roc", "\u0bae\u0bbf\u0ba9\u0bcd\u0b95\u0bcb \u0ba8\u0bbe\u0bb3\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "vi", "\u0bb5\u0bbf\u0baf\u0b9f\u0bcd\u0ba8\u0bbe\u0bae\u0bc0\u0bb8\u0bcd" },
            { "kho", "\u0b95\u0bcb\u0ba4\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd" },
            { "khq", "\u0b95\u0bca\u0baf\u0bcd\u0bb0\u0bbe \u0b9a\u0bc0\u0ba9\u0bc0" },
            { "key.hc", "\u0bae\u0ba3\u0bbf\u0ba8\u0bc7\u0bb0 \u0b9a\u0bc1\u0bb4\u0bb1\u0bcd\u0b9a\u0bbf (12, 24)" },
            { "vo", "\u0b92\u0bb2\u0bbe\u0baa\u0bc2\u0b95\u0bcd" },
            { "syc", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0b9a\u0bbf\u0bb0\u0bbf\u0baf\u0bbe\u0b95\u0bcd" },
            { "Osma", "\u0b92\u0bb8\u0bcd\u0bae\u0bbe\u0ba9\u0bcd\u0baf\u0bbe" },
            { "quc", "\u0b95\u0bc0\u0b9a\u0bc0" },
            { "gaa", "\u0b95\u0bbe" },
            { "wa", "\u0b92\u0bb5\u0bbe\u0bb2\u0bc2\u0ba9\u0bcd" },
            { "gag", "\u0b95\u0bbe\u0b95\u0bcc\u0bb8\u0bcd" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "\u0b95\u0ba9\u0bcd \u0b9a\u0bc0\u0ba9\u0bae\u0bcd" },
            { "Lydi", "\u0bb2\u0bbf\u0b9f\u0bbf\u0baf\u0ba9\u0bcd" },
            { "Xsux", "\u0b9a\u0bc1\u0bae\u0bc6\u0bb0\u0bcb-\u0b85\u0b95\u0bcd\u0b95\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bcd\u0baf\u0bc2\u0ba9\u0bbf\u0b83\u0baa\u0bbe\u0bb0\u0bcd\u0bae\u0bcd" },
            { "wo", "\u0b93\u0bb2\u0bcb\u0b83\u0baa\u0bcd" },
            { "zgh", "\u0bb8\u0bcd\u0b9f\u0bbe\u0ba3\u0bcd\u0b9f\u0bb0\u0bcd\u0b9f\u0bcd \u0bae\u0bca\u0bb0\u0bbe\u0b95\u0bcd\u0b95\u0ba9\u0bcd \u0ba4\u0bae\u0bbe\u0b9a\u0bc8\u0b9f\u0bcd" },
            { "ar_001", "\u0ba8\u0bb5\u0bc0\u0ba9 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0b85\u0bb0\u0baa\u0bbf\u0b95\u0bcd" },
            { "Cans", "\u0baf\u0bc1\u0ba9\u0bbf\u0b83\u0baa\u0bc8\u0b9f\u0bc1 \u0b95\u0ba9\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0b85\u0baa\u0bca\u0bb0\u0bbf\u0b9c\u0bbf\u0ba9\u0bb2\u0bcd \u0b9a\u0bbf\u0bb2\u0baa\u0bbf\u0b95\u0bcd\u0bb8\u0bcd" },
            { "gay", "\u0b95\u0baf\u0bcb" },
            { "Mong", metaValue_mn },
            { "mnc", "\u0bae\u0ba9\u0bcd\u0b9a\u0bc2" },
            { "Latf", "\u0b83\u0baa\u0bcd\u0bb0\u0b95\u0bcd\u0b9f\u0bc2\u0bb0\u0bcd \u0bb2\u0bc6\u0ba4\u0bcd\u0ba4\u0bbf\u0ba9\u0bcd" },
            { "gba", "\u0baa\u0baf\u0bbe" },
            { "mni", "\u0bae\u0ba3\u0bbf\u0baa\u0bcd\u0baa\u0bc1\u0bb0\u0bbf" },
            { "Latn", metaValue_la },
            { "Latg", "\u0b95\u0bc7\u0bb2\u0bbf\u0b95\u0bcd \u0bb2\u0bc6\u0ba4\u0bcd\u0ba4\u0bbf\u0ba9\u0bcd" },
            { "type.nu.hans", "\u0b8e\u0bb3\u0bbf\u0ba4\u0bbe\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f \u0b9a\u0bc0\u0ba9 \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "type.nu.hant", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0b9a\u0bc0\u0ba9 \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "xh", "\u0bb9\u0bcb\u0b9a\u0bbe" },
            { "type.nu.romanlow", "\u0bb0\u0bcb\u0bae\u0ba9\u0bcd \u0b9a\u0bbf\u0bb1\u0bcd\u0bb1\u0bc6\u0bb4\u0bc1\u0ba4\u0bcd\u0ba4\u0bc1 \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "byn", "\u0baa\u0bcd\u0bb2\u0bbf\u0ba9\u0bcd" },
            { "Lyci", "\u0bb2\u0bbf\u0b9a\u0bbf\u0baf\u0ba9\u0bcd" },
            { "osa", "\u0b93\u0b9a\u0bc7\u0b9c\u0bcd" },
            { "Moon", "\u0bae\u0bc2\u0ba9\u0bcd" },
            { "moh", "\u0bae\u0bca\u0bb9\u0bbe\u0b95\u0bcd" },
            { "kkj", "\u0b95\u0b95\u0bcb" },
            { "Syrc", metaValue_syr },
            { "yi", "\u0baf\u0bc6\u0b9f\u0bcd\u0b9f\u0bbf\u0bb7\u0bcd" },
            { "mos", "\u0bae\u0bcb\u0bb8\u0bcd\u0bb8\u0bbf" },
            { "Dsrt", "\u0b9f\u0bc6\u0b9a\u0bb0\u0bbe\u0b9f\u0bcd" },
            { "yo", "\u0baf\u0bcb\u0bb0\u0bc1\u0baa\u0bbe" },
            { "type.nu.traditional", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "es_MX", "\u0bae\u0bc6\u0b95\u0bcd\u0bb8\u0bbf\u0b95\u0ba9\u0bcd \u0bb8\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0bb7\u0bcd" },
            { "Syrj", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bbf\u0bb0\u0bbf\u0baf\u0bbe\u0b95\u0bcd" },
            { "ota", "\u0b93\u0b9f\u0bcd\u0b9f\u0bcb\u0bae\u0bbe\u0ba9\u0bcd \u0ba4\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bbf\u0bb7\u0bcd" },
            { "Syre", "\u0b8e\u0bb8\u0bcd\u0b9f\u0bcd\u0bb0\u0bc6\u0b99\u0bcd\u0b95\u0bc6\u0bb2\u0bcb \u0b9a\u0bbf\u0bb0\u0bbf\u0baf\u0bbe\u0b95\u0bcd" },
            { "vai", metaValue_vai },
            { "za", "\u0b9c\u0bc1\u0bb5\u0bbe\u0b99\u0bcd" },
            { "Cari", "\u0b95\u0bb0\u0bbf\u0baf\u0ba9\u0bcd" },
            { "kln", "\u0b95\u0bb2\u0bbf\u0ba9\u0bcd\u0b9c\u0bbf\u0ba9\u0bcd" },
            { "zh", "\u0b9a\u0bc0\u0ba9\u0bae\u0bcd" },
            { "Bopo", "\u0baa\u0bcb\u0baa\u0bcb\u0bae\u0bcb\u0b83\u0baa\u0bcb" },
            { "Perm", "\u0baa\u0bb4\u0bc8\u0baf \u0baa\u0bc6\u0bb0\u0bcd\u0bae\u0bbf\u0b95\u0bcd" },
            { "key.lb", "\u0bb5\u0bb0\u0bbf \u0bae\u0bc1\u0bb1\u0bbf\u0baa\u0bcd\u0baa\u0bc1 \u0bb8\u0bcd\u0b9f\u0bc8\u0bb2\u0bcd" },
            { "zu", "\u0b9c\u0bc1\u0bb2\u0bc1" },
            { "type.co.phonebook", "\u0ba4\u0bca\u0bb2\u0bc8\u0baa\u0bc7\u0b9a\u0bbf \u0baa\u0bc1\u0ba4\u0bcd\u0ba4\u0b95 \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0b95\u0bbf\u0bae\u0bcd\u0baa\u0bc1\u0ba9\u0bcd\u0ba4\u0bc1" },
            { "type.nu.jpanfin", "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0baf \u0ba8\u0bbf\u0ba4\u0bbf \u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "Cham", "\u0b9a\u0bbe\u0bae\u0bcd" },
            { "gez", "\u0b95\u0bc0\u0b9c\u0bcd" },
            { "Syrn", "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b9a\u0bbf\u0bb0\u0bbf\u0baf\u0bbe\u0b95\u0bcd" },
            { "type.co.reformed", "\u0b9a\u0bc0\u0bb0\u0bcd\u0ba4\u0bbf\u0bb0\u0bc1\u0ba4\u0bcd\u0ba4\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f \u0bb5\u0bb0\u0bbf\u0b9a\u0bc8 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "Tglg", "\u0ba4\u0b95\u0bb2\u0bbe\u0b95\u0bcd" },
            { "Egyd", "\u0b8e\u0b95\u0bbf\u0baa\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bc6\u0bae\u0bcb\u0b9f\u0bcd\u0b9f\u0bbf\u0b95\u0bcd" },
            { "Egyh", "\u0b8e\u0b95\u0bbf\u0baa\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd \u0bb9\u0bc8\u0bb0\u0bc7\u0b9f\u0bcd\u0b9f\u0bbf\u0b95\u0bcd" },
            { "ebu", "\u0b8e\u0bae\u0bcd\u0baa\u0bc1" },
            { "Egyp", "\u0b8e\u0b95\u0bbf\u0baa\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd \u0bb9\u0bc8\u0bb0\u0bcb\u0b95\u0bbf\u0bb3\u0bbf\u0baa\u0bcd\u0bb8\u0bcd" },
            { "Geok", "\u0b9c\u0bbf\u0baf\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bc1\u0b9f\u0bcd\u0b9a\u0bc1\u0bb0\u0bbf" },
            { "zh_Hans", "\u0b8e\u0bb3\u0bbf\u0ba4\u0bbe\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f \u0b9a\u0bc0\u0ba9\u0bae\u0bcd" },
            { "koi", "\u0b95\u0bca\u0bae\u0bbf-\u0baa\u0bc6\u0bb0\u0bcd\u0bae\u0bcd\u0baf\u0bbe\u0b95\u0bcd" },
            { "Hung", "\u0baa\u0bb4\u0bc8\u0baf \u0bb9\u0b99\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0ba9\u0bcd" },
            { "kok", "\u0b95\u0bca\u0b99\u0bcd\u0b95\u0ba3\u0bbf" },
            { "kos", "\u0b95\u0bcb\u0bb8\u0bcd\u0bb0\u0bc8\u0ba9\u0bcd" },
            { "zh_Hant", "\u0baa\u0bbe\u0bb0\u0bae\u0bcd\u0baa\u0bb0\u0bbf\u0baf \u0b9a\u0bc0\u0ba9\u0bae\u0bcd" },
            { "Sund", "\u0b9a\u0bc1\u0ba8\u0bcd\u0ba4\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd" },
            { "kpe", "\u0b95\u0bcd\u0baa\u0bc6\u0bb2\u0bcd\u0bb2\u0bc7" },
            { "type.nu.khmr", "\u0b95\u0bc6\u0bae\u0bc6\u0bb0\u0bcd \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "ilo", "\u0b87\u0bb2\u0bcb\u0b95\u0bcb" },
            { "Cprt", "\u0b9a\u0bc8\u0baa\u0bcd\u0bb0\u0bbf\u0baf\u0bbe\u0b9f\u0bcd" },
            { "mua", "\u0bae\u0bc1\u0ba9\u0bcd\u0b9f\u0bbe\u0b99\u0bcd" },
            { "type.nu.guru", "\u0b95\u0bc1\u0bb0\u0bcd\u0bae\u0bc1\u0b95\u0bbf \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "mul", "\u0baa\u0bb2 \u0bae\u0bca\u0bb4\u0bbf\u0b95\u0bb3\u0bcd" },
            { "cad", "\u0b95\u0bc7\u0b9f\u0bcb" },
            { "key.ms", "\u0b85\u0bb3\u0bb5\u0bc0\u0b9f\u0bcd\u0b9f\u0bc1 \u0bae\u0bc1\u0bb1\u0bc8" },
            { "mus", "\u0b95\u0bcd\u0bb0\u0bc0\u0b95\u0bcd" },
            { "Glag", "\u0b95\u0bcd\u0bb2\u0bbe\u0b95\u0bcb\u0bb2\u0bbf\u0b9f\u0bbf\u0b95\u0bcd" },
            { "gil", "\u0b95\u0bbf\u0bb2\u0bcd\u0baa\u0bc6\u0bb0\u0bcd\u0b9f\u0bc0\u0bb8\u0bcd" },
            { "Cher", "\u0b9a\u0bc6\u0bb0\u0bcb\u0b95\u0bcd\u0b95\u0bbf" },
            { "car", "\u0b95\u0bb0\u0bc0\u0baa\u0bcd" },
            { "type.nu.tamldec", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd \u0b87\u0bb2\u0b95\u0bcd\u0b95\u0b99\u0bcd\u0b95\u0bb3\u0bcd" },
            { "krc", "\u0b95\u0bb0\u0bbe\u0b9a\u0bc7-\u0baa\u0bb2\u0bcd\u0b95\u0bbe\u0bb0\u0bcd" },
            { "inh", "\u0b87\u0b99\u0bcd\u0b95\u0bc1\u0bb7\u0bcd" },
            { "krl", "\u0b95\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd" },
            { "efi", "\u0b8e\u0b83\u0baa\u0bbf\u0b95\u0bcd" },
            { "key.nu", "\u0b8e\u0ba3\u0bcd\u0b95\u0bb3\u0bcd" },
            { "kru", "\u0b95\u0bc1\u0bb0\u0bc1\u0b95\u0bcd" },
            { "ksb", "\u0bb7\u0bae\u0bcd\u0baa\u0bbe\u0bb2\u0bbe" },
            { "Telu", metaValue_te },
            { "ksf", "\u0baa\u0bbe\u0b83\u0baa\u0bbf\u0baf\u0bbe" },
        };
        return data;
    }
}
