/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.shareproject;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.operation.local.management.ShareProjectOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.extension.impl.ISelectProjectNamePageData;
import org.eclipse.team.svn.ui.verifier.AbsolutePathVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.ui.PlatformUI;

public class ShareProjectNameAdvancedModeComposite
extends Composite
implements ISelectProjectNamePageData {
    protected int layoutType;
    protected String rootProjectName;
    protected String projectName;
    protected String selectedName;
    protected boolean managementFoldersEnabled;
    protected Text projectNameField;
    protected Text rootProjectNameField;
    protected Label targetUrlField;
    protected Button managementFoldersEnabledButton;
    protected IRepositoryLocation location;
    protected boolean multiProject;
    protected Button defaultLayoutButton;
    protected Button singleLayoutButton;
    protected Group nameGroup;
    protected Group layoutGroup;
    protected Point savedPosition;
    protected Button multipleLayoutButton;
    protected Button useEmptyNameButton;
    protected IValidationManager validationManager;
    protected List<Control> controls = new ArrayList<Control>();

    public ShareProjectNameAdvancedModeComposite(Composite parent, int style, IValidationManager validationManager) {
        super(parent, style);
        this.validationManager = validationManager;
        this.layoutType = 0;
        this.createControls();
    }

    protected void createControls() {
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        GridData gridData = new GridData();
        this.setLayoutData(gridData);
        this.nameGroup = new Group((Composite)this, 0);
        layout = new GridLayout();
        this.nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this.nameGroup.setLayoutData((Object)data);
        this.nameGroup.setText(SVNUIMessages.SelectProjectNamePage_NameOnRepository);
        this.controls.add((Control)this.nameGroup);
        Button useProjectNameButton = new Button((Composite)this.nameGroup, 16);
        useProjectNameButton.setLayoutData((Object)this.makeGridData());
        useProjectNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShareProjectNameAdvancedModeComposite.this.validationManager.validateContent();
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ShareProjectNameAdvancedModeComposite.this.selectedName = ShareProjectNameAdvancedModeComposite.this.projectName;
                }
                ShareProjectNameAdvancedModeComposite.this.showTargetUrl();
            }
        });
        useProjectNameButton.setText(SVNUIMessages.SelectProjectNamePage_UseProjectName);
        useProjectNameButton.setSelection(true);
        this.controls.add((Control)useProjectNameButton);
        this.useEmptyNameButton = new Button((Composite)this.nameGroup, 16);
        this.useEmptyNameButton.setLayoutData((Object)this.makeGridData());
        this.useEmptyNameButton.setText(SVNUIMessages.SelectProjectNamePage_UseEmptyName);
        this.useEmptyNameButton.setSelection(false);
        this.controls.add((Control)this.useEmptyNameButton);
        final Button useRedefinedNameButton = new Button((Composite)this.nameGroup, 16);
        useRedefinedNameButton.setLayoutData((Object)this.makeGridData());
        useRedefinedNameButton.setText(SVNUIMessages.SelectProjectNamePage_UseSpecifiedName);
        useRedefinedNameButton.setSelection(false);
        useRedefinedNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShareProjectNameAdvancedModeComposite.this.validationManager.validateContent();
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ShareProjectNameAdvancedModeComposite.this.selectedName = ShareProjectNameAdvancedModeComposite.this.projectNameField.getText();
                    ShareProjectNameAdvancedModeComposite.this.projectNameField.setEditable(true);
                } else {
                    ShareProjectNameAdvancedModeComposite.this.projectNameField.setEditable(false);
                }
                ShareProjectNameAdvancedModeComposite.this.showTargetUrl();
            }
        });
        this.controls.add((Control)useRedefinedNameButton);
        this.projectNameField = new Text((Composite)this.nameGroup, 2052);
        this.projectNameField.setLayoutData((Object)this.makeGridData());
        this.projectNameField.setEditable(false);
        this.projectNameField.addModifyListener(e -> {
            this.selectedName = this.projectNameField.getText();
            this.showTargetUrl();
        });
        CompositeVerifier verifier = new CompositeVerifier();
        String name = SVNUIMessages.SelectProjectNamePage_ProjectName;
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new ResourceNameVerifier(name, true));
        verifier.add(new AbsolutePathVerifier(name));
        this.validationManager.attachTo((Control)this.projectNameField, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return useRedefinedNameButton.getSelection();
            }
        });
        this.controls.add((Control)this.projectNameField);
        this.layoutGroup = new Group((Composite)this, 0);
        layout = new GridLayout();
        this.layoutGroup.setLayout((Layout)layout);
        data = new GridData(768);
        this.layoutGroup.setLayoutData((Object)data);
        this.layoutGroup.setText(SVNUIMessages.SelectProjectNamePage_ProjectLayout);
        this.controls.add((Control)this.layoutGroup);
        this.defaultLayoutButton = new Button((Composite)this.layoutGroup, 16);
        data = this.makeGridData();
        this.defaultLayoutButton.setLayoutData((Object)data);
        this.defaultLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ShareProjectNameAdvancedModeComposite.this.layoutType = 0;
                }
                ShareProjectNameAdvancedModeComposite.this.validationManager.validateContent();
                ShareProjectNameAdvancedModeComposite.this.showTargetUrl();
                ShareProjectNameAdvancedModeComposite.this.enableManagementFoldersEnabledButton();
            }
        });
        this.defaultLayoutButton.setText(SVNUIMessages.SelectProjectNamePage_RepositoryLocationLayout);
        this.defaultLayoutButton.setSelection(true);
        this.controls.add((Control)this.defaultLayoutButton);
        this.singleLayoutButton = new Button((Composite)this.layoutGroup, 16);
        data = this.makeGridData();
        this.singleLayoutButton.setLayoutData((Object)data);
        this.singleLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ShareProjectNameAdvancedModeComposite.this.layoutType = 1;
                }
                ShareProjectNameAdvancedModeComposite.this.validationManager.validateContent();
                ShareProjectNameAdvancedModeComposite.this.showTargetUrl();
                ShareProjectNameAdvancedModeComposite.this.enableManagementFoldersEnabledButton();
            }
        });
        this.singleLayoutButton.setText(SVNUIMessages.SelectProjectNamePage_SingleProjectLayout);
        this.controls.add((Control)this.singleLayoutButton);
        this.multipleLayoutButton = new Button((Composite)this.layoutGroup, 16);
        data = this.makeGridData();
        this.multipleLayoutButton.setLayoutData((Object)data);
        this.multipleLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ShareProjectNameAdvancedModeComposite.this.layoutType = 2;
                    ShareProjectNameAdvancedModeComposite.this.rootProjectName = ShareProjectNameAdvancedModeComposite.this.rootProjectNameField.getText();
                }
                ShareProjectNameAdvancedModeComposite.this.rootProjectNameField.setEditable(button.getSelection());
                ShareProjectNameAdvancedModeComposite.this.validationManager.validateContent();
                ShareProjectNameAdvancedModeComposite.this.showTargetUrl();
                ShareProjectNameAdvancedModeComposite.this.enableManagementFoldersEnabledButton();
            }
        });
        this.multipleLayoutButton.setText(SVNUIMessages.SelectProjectNamePage_MultiProjectLayout);
        this.controls.add((Control)this.multipleLayoutButton);
        this.rootProjectNameField = new Text((Composite)this.layoutGroup, 2052);
        this.rootProjectNameField.setLayoutData((Object)this.makeGridData());
        this.rootProjectNameField.setEditable(false);
        this.rootProjectNameField.addModifyListener(e -> {
            this.rootProjectName = this.rootProjectNameField.getText();
            this.showTargetUrl();
        });
        verifier = new CompositeVerifier();
        name = SVNUIMessages.SelectProjectNamePage_RootName;
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new ResourceNameVerifier(name, true));
        verifier.add(new AbsolutePathVerifier(name));
        this.validationManager.attachTo((Control)this.rootProjectNameField, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return ShareProjectNameAdvancedModeComposite.this.multipleLayoutButton.getSelection();
            }
        });
        this.controls.add((Control)this.rootProjectNameField);
        Label label = new Label((Composite)this.layoutGroup, 258);
        label.setLayoutData((Object)this.makeGridData());
        this.controls.add((Control)label);
        this.managementFoldersEnabledButton = new Button((Composite)this.layoutGroup, 32);
        this.managementFoldersEnabledButton.setLayoutData((Object)new GridData());
        this.managementFoldersEnabledButton.setSelection(true);
        this.managementFoldersEnabled = true;
        this.managementFoldersEnabledButton.setText(SVNUIMessages.SelectProjectNamePage_UseRecommended);
        this.managementFoldersEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShareProjectNameAdvancedModeComposite.this.managementFoldersEnabled = ((Button)e.widget).getSelection();
                ShareProjectNameAdvancedModeComposite.this.showTargetUrl();
            }
        });
        this.controls.add((Control)this.managementFoldersEnabledButton);
        label = new Label((Composite)this.layoutGroup, 64);
        data = this.makeGridData();
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this, 2);
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.SelectProjectNamePage_Hint);
        this.controls.add((Control)label);
        Composite urlComposite = new Composite((Composite)this.layoutGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        urlComposite.setLayout((Layout)layout);
        data = new GridData(768);
        urlComposite.setLayoutData((Object)data);
        this.controls.add((Control)urlComposite);
        label = new Label(urlComposite, 0);
        label.setLayoutData((Object)new GridData());
        label.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage());
        this.controls.add((Control)label);
        this.targetUrlField = new Label(urlComposite, 4);
        this.targetUrlField.setLayoutData((Object)this.makeGridData());
        this.projectNameField.setEditable(true);
        this.targetUrlField.setBackground(this.projectNameField.getBackground());
        this.controls.add((Control)this.targetUrlField);
        label.setBackground(this.projectNameField.getBackground());
        urlComposite.setBackground(this.projectNameField.getBackground());
        this.projectNameField.setEditable(false);
        this.useEmptyNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShareProjectNameAdvancedModeComposite.this.validationManager.validateContent();
                ShareProjectNameAdvancedModeComposite.this.selectedName = "";
                Button button = (Button)e.widget;
                if (button.getSelection() && ShareProjectNameAdvancedModeComposite.this.multipleLayoutButton.getSelection()) {
                    ShareProjectNameAdvancedModeComposite.this.multipleLayoutButton.setSelection(false);
                    ShareProjectNameAdvancedModeComposite.this.rootProjectNameField.setEditable(false);
                    ShareProjectNameAdvancedModeComposite.this.defaultLayoutButton.setSelection(true);
                }
                ShareProjectNameAdvancedModeComposite.this.showTargetUrl();
                ShareProjectNameAdvancedModeComposite.this.enableMultipleLayoutButton();
                ShareProjectNameAdvancedModeComposite.this.enableManagementFoldersEnabledButton();
            }
        });
    }

    @Override
    public void setProjectsAndLocation(IProject[] projects, IRepositoryLocation location, boolean multiProject) {
        this.multiProject = multiProject;
        this.location = location;
        if (this.multiProject) {
            this.projectName = "";
            this.selectedName = "";
            this.savedPosition = this.layoutGroup.getLocation();
            this.layoutGroup.setLocation(this.nameGroup.getLocation());
            this.nameGroup.setVisible(false);
            this.defaultLayoutButton.setSelection(true);
        } else {
            this.selectedName = this.projectName = projects[0].getName();
            if (this.savedPosition != null) {
                this.nameGroup.setVisible(true);
                this.layoutGroup.setLocation(this.savedPosition);
                this.savedPosition = null;
            }
        }
        this.projectNameField.setText(this.projectName);
        this.rootProjectNameField.setText(this.projectName);
        this.showTargetUrl();
    }

    protected GridData makeGridData() {
        GridData data = new GridData(772);
        data.widthHint = 200;
        data.horizontalSpan = 1;
        return data;
    }

    protected void showTargetUrl() {
        String targetUrl = ShareProjectOperation.getTargetUrl((IRepositoryLocation)this.location, (int)this.layoutType, (String)this.selectedName, (String)this.rootProjectName, (boolean)this.isManagementFoldersEnabled());
        this.showTargetUrlImpl(targetUrl);
    }

    protected void showTargetUrlImpl(String targetUrl) {
        if (this.targetUrlField != null) {
            this.targetUrlField.setText(targetUrl);
        }
    }

    @Override
    public boolean isManagementFoldersEnabled() {
        return this.layoutType == 0 ? true : this.managementFoldersEnabled;
    }

    @Override
    public int getLayoutType() {
        return this.layoutType;
    }

    @Override
    public ShareProjectOperation.IFolderNameMapper getSelectedNames() {
        return this.multiProject ? null : project -> this.selectedName;
    }

    @Override
    public String getRootProjectName() {
        return this.rootProjectName;
    }

    public boolean isMultiProject() {
        return this.multiProject;
    }

    @Override
    public void save() {
    }

    @Override
    public void validateContent() {
        this.validationManager.validateContent();
    }

    @Override
    public IRepositoryLocation getRepositoryLocation() {
        return this.location;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.controls != null && !this.controls.isEmpty()) {
            for (Control control : this.controls) {
                if (enabled) {
                    if (control == this.multipleLayoutButton) {
                        this.enableMultipleLayoutButton();
                        continue;
                    }
                    if (control == this.managementFoldersEnabledButton) {
                        this.enableManagementFoldersEnabledButton();
                        continue;
                    }
                    if (control == this.singleLayoutButton) {
                        this.enableSingleLayoutButton();
                        continue;
                    }
                    control.setEnabled(enabled);
                    continue;
                }
                control.setEnabled(enabled);
            }
        }
    }

    protected void enableMultipleLayoutButton() {
        this.multipleLayoutButton.setEnabled(!this.useEmptyNameButton.getSelection());
    }

    protected void enableSingleLayoutButton() {
        this.singleLayoutButton.setEnabled(!this.multiProject);
    }

    protected void enableManagementFoldersEnabledButton() {
        if (this.defaultLayoutButton.getSelection()) {
            this.managementFoldersEnabledButton.setEnabled(false);
        } else if (this.singleLayoutButton.getSelection()) {
            this.managementFoldersEnabledButton.setEnabled(true);
        } else if (this.multipleLayoutButton.getSelection()) {
            this.managementFoldersEnabledButton.setEnabled(true);
        }
        if (this.useEmptyNameButton.getSelection() && this.multipleLayoutButton.getSelection()) {
            this.managementFoldersEnabledButton.setEnabled(false);
        }
    }
}

