/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import java.io.File;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class ExistingResourceVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_DOES_NOT_EXIST;
    protected static String ERROR_MESSAGE_IS_NOT_A_FILE;
    protected static String ERROR_MESSAGE_IS_NOT_A_DIRECTORY;
    protected boolean checkNodeType;
    protected boolean files;

    public ExistingResourceVerifier(String fieldName) {
        super(fieldName);
        this.init();
        this.checkNodeType = false;
    }

    public ExistingResourceVerifier(String fieldName, boolean files) {
        super(fieldName);
        this.init();
        this.files = files;
        this.checkNodeType = true;
    }

    @Override
    protected String getErrorMessageImpl(Control input) {
        File currentFile = new File(this.getText(input));
        if (!currentFile.exists()) {
            return ERROR_MESSAGE_DOES_NOT_EXIST;
        }
        if (this.checkNodeType && this.files && !currentFile.isFile()) {
            return ERROR_MESSAGE_IS_NOT_A_FILE;
        }
        if (this.checkNodeType && !this.files && !currentFile.isDirectory()) {
            return ERROR_MESSAGE_IS_NOT_A_DIRECTORY;
        }
        return null;
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        return null;
    }

    private void init() {
        ERROR_MESSAGE_DOES_NOT_EXIST = BaseMessages.format((String)SVNUIMessages.Verifier_ExistingResource_NotExists, (Object[])new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_IS_NOT_A_FILE = BaseMessages.format((String)SVNUIMessages.Verifier_ExistingResource_IsNotAFile, (Object[])new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_IS_NOT_A_DIRECTORY = BaseMessages.format((String)SVNUIMessages.Verifier_ExistingResource_IsNotADir, (Object[])new String[]{"$FIELD_NAME$"});
    }
}

