/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;

public abstract class AbstractFormattedVerifier
extends AbstractVerifier {
    public static final String FIELD_NAME = "$FIELD_NAME$";
    protected Map<String, String> placeHolders = new HashMap<String, String>();

    public AbstractFormattedVerifier(String fieldName) {
        this.setPlaceHolder(FIELD_NAME, fieldName.replace(":", ""));
    }

    public void setPlaceHolder(String placeHolder, String value) {
        this.placeHolders.put(placeHolder, value);
    }

    public String getPlaceHolder(String placeHolder) {
        return this.placeHolders.get(placeHolder);
    }

    @Override
    protected String getErrorMessage(Control input) {
        return this.getFormattedMessage(this.getErrorMessageImpl(input));
    }

    @Override
    protected String getWarningMessage(Control input) {
        return this.getFormattedMessage(this.getWarningMessageImpl(input));
    }

    protected abstract String getErrorMessageImpl(Control var1);

    protected abstract String getWarningMessageImpl(Control var1);

    protected String getFormattedMessage(String message) {
        if (message != null) {
            for (Map.Entry<String, String> entry : this.placeHolders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue() == null ? "" : entry.getValue().toString();
                int idx = ((String)message).indexOf(key);
                if (idx == -1) continue;
                message = ((String)message).substring(0, idx) + value + ((String)message).substring(idx + key.length());
            }
        }
        return message;
    }
}

