/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.action.EditTreeConflictsActionHelper;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class EditTreeConflictsAction
extends AbstractSynchronizeModelAction {
    protected EditTreeConflictsActionHelper actionHelper;

    public EditTreeConflictsAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.actionHelper = new EditTreeConflictsActionHelper((IAction)this, configuration);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (super.updateSelection(selection) && selection.size() == 1) {
            if (selection.getFirstElement() instanceof SyncInfoModelElement) {
                AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)((SyncInfoModelElement)selection.getFirstElement()).getSyncInfo();
                return IStateFilter.SF_TREE_CONFLICTING.accept(syncInfo.getLocalResource());
            }
            if (selection.getFirstElement() instanceof ISynchronizeModelElement) {
                ISynchronizeModelElement element = (ISynchronizeModelElement)selection.getFirstElement();
                return IStateFilter.SF_TREE_CONFLICTING.accept(SVNRemoteStorage.instance().asLocalResource(element.getResource()));
            }
        }
        return false;
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        return this.actionHelper.getOperation();
    }
}

