/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.history.ResourceContentStorage;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.repository.IRepositoryEditorInput;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.model.IResourceTreeNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RepositoryFileEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IRepositoryEditorInput,
IResourceTreeNode {
    private static final Object[] NO_CHILDREN = new Object[0];
    protected ResourceContentStorage storage;
    protected RepositoryFile resource;

    public RepositoryFileEditorInput(IRepositoryFile resource) {
        this.resource = new RepositoryFile(null, (IRepositoryResource)resource);
        this.storage = new ResourceContentStorage((IRepositoryResource)resource);
    }

    public Object[] getChildren(Object o) {
        return NO_CHILDREN;
    }

    @Override
    public void setViewer(RepositoryTreeViewer repositoryTree) {
    }

    @Override
    public IRepositoryResource getRepositoryResource() {
        return this.resource.getRepositoryResource();
    }

    @Override
    public Object getData() {
        return this.getRepositoryResource();
    }

    @Override
    public void refresh() {
        this.resource.refresh();
    }

    public Object getParent(Object o) {
        return this.resource.getParent(o);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.resource.getImageDescriptor(object);
    }

    public String getLabel(Object o) {
        return this.resource.getLabel(o);
    }

    @Override
    public void fetchContents(IProgressMonitor monitor) {
        this.storage.fetchContents(monitor);
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public boolean exists() {
        try {
            return this.resource.getRepositoryResource().exists();
        }
        catch (Exception ex) {
            LoggedOperation.reportError((String)this.getClass().getName(), (Throwable)ex);
            return false;
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return this.getImageDescriptor(this.resource);
    }

    public String getName() {
        return BaseMessages.format((String)SVNUIMessages.RepositoryFileViewer_Name, (Object[])new String[]{this.resource.getRepositoryResource().getName(), String.valueOf(this.resource.getRepositoryResource().getSelectedRevision())});
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        if (adapter == IRepositoryFile.class) {
            return this.resource.getRepositoryResource();
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RepositoryFileEditorInput) {
            return this.resource.equals(((RepositoryFileEditorInput)obj).resource);
        }
        return false;
    }

    public IPath getPath() {
        return this.storage.getTemporaryPath();
    }
}

