/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.IDialogManager;
import org.eclipse.team.svn.ui.panel.IDialogPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.verifier.AbstractVerificationKeyListener;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public abstract class AbstractDialogPanel
implements IDialogPanel,
IValidationManager {
    private AbstractVerificationKeyListener changeListener;
    protected IDialogManager manager;
    protected String dialogTitle;
    protected String dialogDescription;
    protected String defaultMessage;
    protected String imagePath;
    protected String[] buttonNames;
    protected Composite parent;

    public AbstractDialogPanel() {
        this(new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
    }

    public AbstractDialogPanel(String[] buttonNames) {
        this.buttonNames = buttonNames;
        this.changeListener = new VerificationKeyListener();
        this.parent = null;
    }

    @Override
    public void initPanel(IDialogManager manager) {
        this.manager = manager;
    }

    @Override
    public void postInit() {
        this.validateContent();
        this.setMessage(0, null);
    }

    @Override
    public void addListeners() {
        this.changeListener.addListeners();
    }

    @Override
    public void dispose() {
        this.detachAll();
    }

    @Override
    public String getDialogTitle() {
        return this.dialogTitle;
    }

    @Override
    public String getDialogDescription() {
        return this.dialogDescription;
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public String getImagePath() {
        return this.imagePath;
    }

    protected String getDialogID() {
        return this.getClass().getName();
    }

    @Override
    public final Point getPrefferedSize() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        int width = SVNTeamPreferences.getDialogInt(store, this.getDialogID() + ".width");
        int height = SVNTeamPreferences.getDialogInt(store, this.getDialogID() + ".height");
        Point prefSize = this.getPrefferedSizeImpl();
        width = Math.max(width, prefSize.x);
        height = Math.max(height, prefSize.y);
        return new Point(width, height);
    }

    @Override
    public String[] getButtonNames() {
        return this.buttonNames;
    }

    @Override
    public String getHelpId() {
        return null;
    }

    @Override
    public final void createControls(Composite parent) {
        this.parent = parent;
        this.createControlsImpl(parent);
    }

    @Override
    public void buttonPressed(int idx) {
        if (idx == 0) {
            this.saveChanges();
        } else {
            this.cancelChanges();
        }
    }

    @Override
    public boolean isFilledRight() {
        return this.changeListener.isFilledRight();
    }

    @Override
    public void attachTo(Control cmp, AbstractVerifier verifier) {
        this.changeListener.attachTo(cmp, verifier);
    }

    @Override
    public void detachFrom(Control cmp) {
        this.changeListener.detachFrom(cmp);
    }

    @Override
    public void detachAll() {
        this.changeListener.detachAll();
    }

    @Override
    public void validateContent() {
        this.changeListener.validateContent();
    }

    @Override
    public boolean validateControl(Control cmp) {
        return this.changeListener.validateControl(cmp);
    }

    protected void setMessage(int level, String message) {
        this.manager.setMessage(level, message);
    }

    protected void setButtonsEnabled(boolean enabled) {
    }

    protected void retainSize() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        Point size = this.parent.getSize();
        SVNTeamPreferences.setDialogInt(store, this.getDialogID() + ".width", size.x);
        SVNTeamPreferences.setDialogInt(store, this.getDialogID() + ".height", size.y);
    }

    protected final void saveChanges() {
        this.retainSize();
        this.saveChangesImpl();
    }

    protected final void cancelChanges() {
        this.retainSize();
        this.cancelChangesImpl();
    }

    protected Point getPrefferedSizeImpl() {
        return new Point(470, -1);
    }

    protected abstract void saveChangesImpl();

    protected abstract void cancelChangesImpl();

    protected abstract void createControlsImpl(Composite var1);

    @Override
    public boolean canClose() {
        return true;
    }

    public static String makeToBeOperatedMessage(IRepositoryResource[] resources) {
        String message = resources.length == 1 ? SVNUIMessages.RepositoryTreePanel_Message_Single : (resources.length < 5 ? SVNUIMessages.RepositoryTreePanel_Message_UpTo4 : SVNUIMessages.RepositoryTreePanel_Message_Multi);
        return BaseMessages.format((String)message, (Object[])new String[]{FileUtility.getNamesListAsString((Object[])resources)});
    }

    protected class VerificationKeyListener
    extends AbstractVerificationKeyListener {
        @Override
        public void hasError(String errorReason) {
            AbstractDialogPanel.this.setMessage(2, errorReason);
            this.handleButtons();
        }

        @Override
        public void hasWarning(String warningReason) {
            AbstractDialogPanel.this.setMessage(1, warningReason);
            this.handleButtons();
        }

        @Override
        public void hasNoError() {
            AbstractDialogPanel.this.setMessage(0, null);
            this.handleButtons();
        }

        protected void handleButtons() {
            AbstractDialogPanel.this.manager.setButtonEnabled(0, this.isFilledRight());
            AbstractDialogPanel.this.setButtonsEnabled(this.isFilledRight());
        }
    }
}

